<?php
/*
** PPOM Existing Meta Template
*/

/* 
**========== Direct access not allowed =========== 
*/ 
if( ! defined('ABSPATH') ) die('Not Allowed');

$all_forms = PPOM() -> get_product_meta_all();
?>

<div class="text-center ppom-import-export-block ppom-meta-card-block" style="display: none">
	
	<h3><?php _e( 'Import PPOM Meta', 'ppom'); ?></h3>
	
	<form method="post" action="admin-post.php" enctype="multipart/form-data">
		<input type="hidden" name="action" value="ppom_import_meta" />
		<label for="file-upload" class="btn btn-success">
			<span><?php _e( 'Choose a file…', 'ppom'); ?></span>
			<input id="file-upload" type="file" name="ppom_csv" style="display: none;">
		</label>
		<input type="submit" class="btn btn-primary" value="<?php _e( 'Import Meta', 'ppom'); ?>">
	</form>

	<div class="text-right ppom-cancle-import-export-wrap">
		<button class="btn btn-danger ppom-cancle-import-export-btn"><?php _e( 'Cancel', 'ppom'); ?></button>
	</div>

	<div class="clear" ></div>
</div>

<div class="wrapper">
	<h2 class="ppom-heading-style"><?php _e( 'PPOM Meta List', 'ppom'); ?></h2>
</div>


<div class="ppom-existing-meta-wrapper">
	
	<form method="post" action="admin-post.php" enctype="multipart/form-data">
		<input type="hidden" name="action" value="ppom_export_meta" />

		<div class="ppom-product-table-header">
			
			<span class="ppom-product-count-span"><?php _e( 'Select', 'ppom'); ?> "<span id="selected_products_count">0</span>"<?php _e( ' PPOM Meta', 'ppom'); ?></span>
			<a class="btn btn-danger" id="ppom_delete_selected_products_btn"><?php _e( 'Delete', 'ppom' ) ?></a>
			<button class="btn btn-yellow" id="export_selected_products_btn"><?php _e( 'Export', 'ppom'); ?></button>
			<span class="pull-right"><strong><?php echo count($all_forms); ?> <?php _e( 'Items', 'ppom' ); ?></strong></span>
			<span class="clear"></span>
		</div>
		<div class="table-responsive">
			<table id="ppom-meta-table" class="table">
				<thead>
					<tr class="bg-info">
						<th class="ppom-checkboxe-style">
							<label>
								<input type="checkbox" name="allselected" id="ppom-all-select-products-head-btn">
								<span></span>
							</label>
						</th>
						<th><?php _e('Meta ID.', "ppom")?></th>
						<th><?php _e('Name.', "ppom")?></th>
						<th><?php _e('Meta.', "ppom")?></th>
						<th><?php _e('Select Products', "ppom")?></th>
						<th><?php _e('Delete.', "ppom")?></th>
					</tr>
				</thead>
				<tfoot>
					<tr class="bg-info">
						<th class="ppom-checkboxe-style">
							<label>
								<input type="checkbox" name="allselected" id="ppom-all-select-products-foot-btn">
								<span></span>
							</label>
						</th>
						<th><?php _e('Meta ID.', "ppom")?></th>
						<th><?php _e('Name.', "ppom")?></th>
						<th><?php _e('Meta.', "ppom")?></th>
						<th><?php _e('Select Products', "ppom")?></th>
						<th><?php _e('Delete.', "ppom")?></th>
					</tr>
				</tfoot>
				
				<?php 
				
				foreach ($all_forms as $productmeta){
				
					$url_edit     = add_query_arg(array('productmeta_id'=> $productmeta ->productmeta_id, 'do_meta'=>'edit'));
					$url_clone    = add_query_arg(array('productmeta_id'=> $productmeta ->productmeta_id, 'do_meta'=>'clone'));
					$url_products = admin_url( 'edit.php?post_type=product', (is_ssl() ? 'https' : 'http') );
					$product_link = '<a href="'.esc_url($url_products).'">'.__('Products', 'ppom').'</a>';
					?>
					<tr>
						<td class="ppom-meta-table-checkbox-mr ppom-checkboxe-style">
		                	<label>
								<input class="ppom_product_checkbox" type="checkbox" name="ppom_meta[]" value="<?php echo esc_attr($productmeta ->productmeta_id); ?>">
								<span></span>
							</label>
		                </td>

						<td><?php echo $productmeta ->productmeta_id; ?></td>
						<td>
							<a href="<?php echo esc_url($url_edit); ?>">
								<?php echo stripcslashes($productmeta -> productmeta_name)?>
							</a>
						</td>
						<td><?php echo ppom_admin_simplify_meta($productmeta -> the_meta)?></td>
						<td>
							<a class="btn btn-primary ppom-products-modal" data-ppom_id="<?php echo esc_attr($productmeta ->productmeta_id); ?>"><?php _e('Attach to Products', "ppom")?></a>
						</td>
						<td>
							<a id="del-file-<?php echo esc_attr($productmeta -> productmeta_id); ?>" href="#" class="button button-sm ppom-delete-single-product" data-product-id="<?php echo esc_attr($productmeta -> productmeta_id); ?>"><span class="dashicons dashicons-no"></span></a>
							<a href="<?php echo esc_url($url_edit); ?>" title="<?php _e('Edit', "ppom")?>" class="button"><span class="dashicons dashicons-edit"></span></a>
							<a href="<?php echo esc_url($url_clone); ?>" title="<?php _e('Clone', "ppom")?>" class="button"><span class="dashicons dashicons-image-rotate-right"></span></a>
						</td>
					</tr>
				<?php 
				}
				?>
			</table>
		</div>
	</form>
</div>

<!-- Product Modal -->
<div class="modal fade" id="ppom-product-modal">
	<div class="modal-dialog modal-lg">
	    <div class="modal-content">
	        <form id="ppom-product-form">
	            <input type="hidden" name="action" value="ppom_attach_ppoms"/>
	            <input type="hidden" name="ppom_id" id="ppom_id">
	        <div class="modal-header">
	            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
	            <h4 class="modal-title"><?php _e('WooCommerce Products', 'ppom');?></h4>
	        </div>

	        <div class="modal-body">

	        <!-- Dynamic contents -->
	        </div>

	        <div class="modal-footer">
	            <button type="button" class="btn btn-white" data-dismiss="modal"><?php _e('Cancel', 'ppom');?></button>
	            <button type="submit" class="btn btn-info"><?php _e('Save', 'ppom'); ?></button>
	        </div>
	        </form>
	    </div>
	</div>
</div>