<?php

/**
 * ajax class
 *
 * @author bappa
 */
class WCQRCodesAjax {

    /**
     * construct
     */
    function __construct() {
        add_action('wp_ajax_regenerate_qr_code', array($this, 'ajax_regenerate_qr_code'));
        add_action('wp_ajax_regenerate_all_qr_code', array($this, 'ajax_regenerate_all_qr_code'));
        add_action('wp_ajax_woo_wallet_dismiss_pomotion_notice', array($this, 'woo_wallet_dismiss_pomotion_notice'));
    }

    /**
     * regenerate product qr code
     */
    public function ajax_regenerate_qr_code() {
        $post_id = isset($_POST['product_id']) ? $_POST['product_id'] : 0;
        echo regenerate_qr_code($post_id);
        wp_die();
    }

    public function ajax_regenerate_all_qr_code() {
        $args = array(
            'posts_per_page' => -1,
            'post_type' => 'product',
            'post_status' => 'publish',
            'suppress_filters' => true
        );
        $products_array = get_posts($args);
        foreach ($products_array as $product){
            regenerate_qr_code($product->ID);
        }
        wp_die();
    }
    
    public function woo_wallet_dismiss_pomotion_notice(){
        update_option('is_dismiss_wallet_pomotion_notice', true);
        wp_die();
    }

}
