<?php

// PDF Style 1

$pdf = new WPGV_PDF('P','pt',array(595,900));
$pdf->SetAutoPageBreak(0);
$pdf->AddPage();
$pdf->Image($image, 0, 0, 595, 453);
$pdf->SetFont('Arial','',16);
$pdf->SetXY(0, 453);
$pdf->SetFillColor($voucher_bgcolor[0], $voucher_bgcolor[1], $voucher_bgcolor[2]);
$pdf->Cell(595,450,'',0,1,'L',1);

if($formtype == 'item') {
	//Title
	$pdf->SetXY(30, 460);
	$pdf->SetFont('Arial','B',16);
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->SetFontSize(25);
	$pdf->MultiCell(550, 25, wpgv_em(get_the_title($itemid)), 0, 'C');
	
	//Description
	$pdf->SetXY(30, 500);
	$pdf->SetFont('Arial','',12);
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->MultiCell(550, 12, wpgv_em(get_post_meta( $itemid, 'description', true )), 0, 'C');
} else {
	//Voucher
	$pdf->SetXY(30, 480);
	$pdf->SetFont('Arial','B',16);
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->SetFontSize(25);
	$pdf->MultiCell(550,25, wpgv_em($template_options->title),0,'C');
}
//For
$pdf->SetFont('Arial','');
$pdf->SetXY(30, 540);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(12);
$pdf->Cell(0,0,wpgv_em(__('Your Name', 'gift-voucher')),0,1,'L',0);
//For Input
$pdf->SetXY(33, 550);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(85,85,85);
$pdf->SetFontSize(15);
$pdf->Cell(265,30,' '.wpgv_em($for),0,1,'L',1);

if($buyingfor != 'yourself') {
	//From
	$pdf->SetXY(310, 540);
	$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
	$pdf->SetFontSize(12);
	$pdf->Cell(0,0,wpgv_em(__('Recipient Name', 'gift-voucher')),0,1,'L',0);
	//From Input
	$pdf->SetXY(313, 550);
	$pdf->SetFillColor(255,255,255);
	$pdf->SetTextColor(85,85,85);
	$pdf->SetFontSize(15);
	$pdf->Cell(265,30,' '.wpgv_em($from),0,1,'L',1);
}
//Voucher Value
$pdf->SetXY(30, 600);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(12);
$pdf->Cell(0,0,wpgv_em(__('Voucher Value', 'gift-voucher')),0,1,'L',0);
//Voucher Value Input
$pdf->SetXY(33, 610);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(85,85,85);
$pdf->SetFontSize(16);
$pdf->Cell(265,30,' '.wpgv_em($currency),0,1,'L',1);

//Personal Message
$pdf->SetXY(30, 660);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(12);
$pdf->Cell(0,0,wpgv_em(__('Personal Message', 'gift-voucher')),0,1,'L',0);
//Personal Message Input
$pdf->SetXY(33, 670);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(85,85,85);
$pdf->SetFontSize(14);
$pdf->Cell(543,100,'',0,1,'L',1);

$pdf->SetXY(35, 672);
$pdf->MultiCell(543,20,wpgv_em($message),0,1,'L',1);
//Date of Expiry
$pdf->SetXY(30, 790);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(12);
$pdf->Cell(0,0,wpgv_em(__('Date of Expiry', 'gift-voucher')),0,1,'L',0);
//Date of Expiry Input
$pdf->SetXY(33, 800);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(85,85,85);
$pdf->SetFontSize(16);
$pdf->Cell(265,30,' '.wpgv_em($expiry),0,1,'L',1);
//Coupon Code
$pdf->SetXY(310, 790);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(12);
$pdf->Cell(0,0,wpgv_em(__('Coupon Code', 'gift-voucher')),0,1,'L',0);
//Coupon Code Input
$pdf->SetXY(313, 800);
$pdf->SetFillColor(255,255,255);
$pdf->SetTextColor(85,85,85);
$pdf->SetFontSize(16);
$pdf->Cell(265,30,' '.wpgv_em($code),0,1,'L',1);
//Company Details
$pdf->SetXY(30, 860);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(11);
$pdf->Cell(0,0,$setting_options->pdf_footer_url.' | '.wpgv_em($setting_options->pdf_footer_email),0,1,'C',0);
//Terms
$pdf->SetXY(0, 0);
$pdf->SetTextColor($voucher_color[0],$voucher_color[1],$voucher_color[2]);
$pdf->SetFontSize(9);
$pdf->RotatedText(20,850,'* '.wpgv_em(__('Cash payment is not possible. The terms and conditions apply.', 'gift-voucher')),90);

if($preview) {
	//Put the watermark
	$pdf->SetXY(0, 0);
	$pdf->SetFont('Arial','B',55);
	$pdf->SetTextColor(215,215,215);
	$pdf->RotatedText(75,700,wpgv_em($watermark),45);
}