<?php

if( !defined( 'ABSPATH' ) ) exit;  // Exit if accessed directly

		global $wpdb;
		$setting_table_name = $wpdb->prefix . 'giftvouchers_setting';

   		if ( !current_user_can( 'manage_options' ) )
   		{
      		wp_die( 'You are not allowed to be on this page.' );
   		}

   		if ( isset($_POST['company_name']) )
   		{
      		// Check that nonce field
   	  		wp_verify_nonce( $_POST['voucher_settings_verify'], 'voucher_settings_verify' );

		    $is_woocommerce_enable	= sanitize_text_field( $_POST['is_woocommerce_enable'] );
		    $is_style_choose_enable	= sanitize_text_field( $_POST['is_style_choose_enable'] );
		    $company_name 	 		= sanitize_text_field( $_POST['company_name'] );
      		$paypal_email 	 		= sanitize_email( $_POST['paypal_email'] );
      		$sofort_configure_key 	= sanitize_text_field( $_POST['sofort_configure_key'] );
      		$reason_for_payment 	= sanitize_text_field( $_POST['reason_for_payment'] );
      		$sender_name 			= sanitize_text_field( $_POST['sender_name'] );
      		$sender_email 	 		= sanitize_email( $_POST['sender_email'] );
      		$currency_code			= sanitize_text_field($_POST['currency_code']);
      		$currency 		 		= sanitize_text_field( $_POST['currency'] );
      		$paypal 		 		= sanitize_text_field( $_POST['paypal'] );
      		$sofort 		 		= sanitize_text_field( $_POST['sofort'] );
      		$stripe 		 		= sanitize_text_field( $_POST['stripe'] );
      		$stripe_publishable_key = sanitize_text_field( $_POST['stripe_publishable_key'] );
      		$stripe_secret_key 		= sanitize_text_field( $_POST['stripe_secret_key'] );
      		$voucher_bgcolor 		= sanitize_text_field( substr($_POST['voucher_bgcolor'],1) );
      		$voucher_color 			= sanitize_text_field( substr($_POST['voucher_color'],1) );
      		$template_col 			= sanitize_text_field( $_POST['template_col'] );
      		$voucher_min_value		= sanitize_text_field( $_POST['voucher_min_value'] );
      		$voucher_max_value		= sanitize_text_field( $_POST['voucher_max_value'] );
      		$voucher_expiry_type	= sanitize_text_field( $_POST['voucher_expiry_type'] );
      		$voucher_expiry			= sanitize_text_field( $_POST['voucher_expiry'] );
      		$voucher_terms_note		= sanitize_text_field( $_POST['voucher_terms_note'] );
      		$currency_position 		= sanitize_text_field( $_POST['currency_position'] );
      		$test_mode 		 		= sanitize_text_field( $_POST['test_mode'] );
      		$per_invoice 		 	= sanitize_text_field( $_POST['per_invoice'] );
      		$custom_loader 		 	= sanitize_text_field( $_POST['custom_loader'] );
      		$post_shipping 			= sanitize_text_field( $_POST['post_shipping'] );
      		$preview_button 		= sanitize_text_field( $_POST['preview_button'] );
      		$shipping_method 		= sanitize_text_field( $_POST['shipping_method'] );
      		$wpgvtermstext			= $_POST['wpgvtermstext'];
      		$bank_info 		 		= $_POST['bank_info'];
      		$email_subject 		 	= $_POST['email_subject'];
      		$email_body 		 	= $_POST['email_body'];
      		$email_body_per_invoice	= $_POST['email_body_per_invoice'];
      		$recipient_email_subject= $_POST['recipient_email_subject'];
      		$recipient_email_body   = $_POST['recipient_email_body'];
      		$admin_email_subject 	= $_POST['admin_email_subject'];
      		$admin_email_body 		= $_POST['admin_email_body'];
      		$demo_image 			= $_POST['demo_image'];
      		$cancelpagemessage		= $_POST['cancelpagemessage'];
      		$successpagemessage		= $_POST['successpagemessage'];
      		$wpgv_custom_css		= $_POST['wpgv_custom_css'];
      		$pdf_footer_url			= $_POST['pdf_footer_url'];
      		$pdf_footer_email		= $_POST['pdf_footer_email'];

			$voucher_styles = array();
			foreach ($_POST['voucher_style'] as $value) {
				$voucher_styles[] = $value;
			}

		   	$wpdb->update(
				$setting_table_name,
				array( 
					'is_woocommerce_enable'	=> $is_woocommerce_enable,
					'is_style_choose_enable'	=> $is_style_choose_enable,
					'voucher_style'			=> json_encode($voucher_styles),
					'company_name' 			=> $company_name,
					'paypal_email' 			=> $paypal_email,
					'sofort_configure_key' 	=> $sofort_configure_key,
					'reason_for_payment' 	=> $reason_for_payment,
					'sender_name' 			=> $sender_name,
					'sender_email' 			=> $sender_email,
					'paypal'				=> $paypal,
					'sofort'				=> $sofort,
					'stripe'				=> $stripe,
					'stripe_publishable_key'=> $stripe_publishable_key,
					'stripe_secret_key'		=> $stripe_secret_key,
					'currency_code'			=> $currency_code,
					'currency' 				=> $currency,
					'voucher_bgcolor' 		=> $voucher_bgcolor,
					'voucher_color' 		=> $voucher_color,
					'template_col' 			=> $template_col,
					'voucher_min_value' 	=> $voucher_min_value,
					'voucher_max_value' 	=> $voucher_max_value,
					'voucher_expiry_type'	=> $voucher_expiry_type,
					'voucher_expiry' 		=> $voucher_expiry,
					'voucher_terms_note' 	=> $voucher_terms_note,
					'currency_position' 	=> $currency_position,
					'test_mode' 			=> $test_mode,
					'per_invoice' 			=> $per_invoice,
					'bank_info' 			=> $bank_info,
					'custom_loader' 		=> $custom_loader,
					'post_shipping'			=> $post_shipping,
					'shipping_method'		=> $shipping_method,
					'preview_button'		=> $preview_button,
					'pdf_footer_url'		=> $pdf_footer_url,
					'pdf_footer_email'		=> $pdf_footer_email
				),
				array('id'=>1)
			);
    		update_option('wpgv_termstext', $wpgvtermstext);
    		update_option('wpgv_emailsubject', $email_subject);
    		update_option('wpgv_emailbody', stripslashes(wp_filter_post_kses(addslashes($email_body))));
    		update_option('wpgv_emailbodyperinvoice', stripslashes(wp_filter_post_kses(addslashes($email_body_per_invoice))));
    		update_option('wpgv_recipientemailsubject', $recipient_email_subject);
    		update_option('wpgv_recipientemailbody', stripslashes(wp_filter_post_kses(addslashes($recipient_email_body))));
    		update_option('wpgv_adminemailsubject', $admin_email_subject);
    		update_option('wpgv_adminemailbody', stripslashes(wp_filter_post_kses(addslashes($admin_email_body))));
    		update_option('wpgv_demoimageurl', $demo_image);
    		update_option('wpgv_successpagemessage', $successpagemessage);
    		update_option('wpgv_cancelpagemessage', $cancelpagemessage);
    		update_option('wpgv_custom_css', $wpgv_custom_css);
			if($stripe && !get_option('wpgv_stripesuccesspage')) {
				$stripeSuccessPage = array(
      				'post_title'    => 'Stripe Payment Success Page',
      				'post_content'  => '[wpgv_stripesuccesspage]',
      				'post_status'   => 'publish',
      				'post_author'   => get_current_user_id(),
      				'post_type'     => 'page',
      				'comment_status' => 'closed',
      				'ping_status'    => 'closed',
    			);
    			$stripeSuccessPage_id = wp_insert_post( $stripeSuccessPage, '' );
    			update_option('wpgv_stripesuccesspage', $stripeSuccessPage_id);
			}
			$settype = 'updated';
			$setmessage = __('Your Settings Saved Successfully.', 'gift-voucher');
			add_settings_error(
    	    	'wooenc_settings_updated',
	        	esc_attr( 'settings_updated' ),
        		$setmessage,
        		$settype
	    	);
   		}
		$wpgv_termstext = get_option('wpgv_termstext') ? get_option('wpgv_termstext') : 'I hereby accept the terms and conditions, the revocation of the privacy policy and confirm that all information is correct.';
		$wpgv_custom_css = get_option('wpgv_custom_css') ? get_option('wpgv_custom_css') : '';
		$stripepageurl = get_option('wpgv_stripesuccesspage') ? get_page_link(get_option('wpgv_stripesuccesspage')) : '';
		$emailsubject = get_option('wpgv_emailsubject') ? get_option('wpgv_emailsubject') : 'Order Confirmation - Your Order with {company_name} (Voucher Order No: {order_number} ) has been successfully placed!';
		$emailbody = get_option('wpgv_emailbody') ? get_option('wpgv_emailbody') : '<p>Dear <strong>{customer_name}</strong>,</p><p>Order successfully placed.</p><p>We are pleased to confirm your order no {order_number}</p><p>Thank you for shopping with <strong>{company_name}</strong>!</p><p>You can download the voucher from {pdf_link}.</p><p>- For any clarifications please feel free to email us at {sender_email}.</p><p><strong>Warm Regards, <br /></strong> <strong>{company_name}<br />{website_url}</strong></p>';
		$emailbodyperinvoice = get_option('wpgv_emailbodyperinvoice') ? get_option('wpgv_emailbodyperinvoice') : '<p>Dear <strong>{customer_name}</strong>,</p><p>Order successfully placed.</p><p>We are pleased to confirm your order no {order_number}</p><p>Thank you for shopping with <strong>{company_name}</strong>!</p><p>You can download the voucher from {pdf_link}.</p><p>You will pay us directly into bank. Our bank details are below:</p><p><strong>Account Number: </strong>XXXXXXXXXXXX<br /><strong>Bank Code: </strong>XXXXXXXX</p><p>- For any clarifications please feel free to email us at {sender_email}.</p><p><strong>Warm Regards, <br /></strong> <strong>{company_name}<br />{website_url}</strong></p>';
		$recipientemailsubject = get_option('wpgv_recipientemailsubject') ? get_option('wpgv_recipientemailsubject') : 'Gift Voucher - Your have received voucher from {company_name}';
		$recipientemailbody = get_option('wpgv_recipientemailbody') ? get_option('wpgv_recipientemailbody') : '<p>Dear <strong>{recipient_name}</strong>,</p><p>You have received gift voucher from <strong>{customer_name}</strong>.</p><p>You can download the voucher from {pdf_link}.</p><p>- For any clarifications please feel free to email us at {sender_email}.</p><p><strong>Warm Regards, <br /></strong> <strong>{company_name}<br />{website_url}</strong></p>';
		$adminemailsubject = get_option('wpgv_adminemailsubject') ? get_option('wpgv_adminemailsubject') : 'New Voucher Order Received from {customer_name}  (Order No: {order_number})!';
		$adminemailbody = get_option('wpgv_adminemailbody') ? get_option('wpgv_adminemailbody') : '<p>Hello, New Voucher Order received.</p><p><strong>Order Id:</strong> {order_number}</p><p><strong>Name:</strong> {customer_name}<br /><strong>Email:</strong> {customer_email}<br /><strong>Address:</strong> {customer_address}<br /><strong>Postcode:</strong> {customer_postcode}</p>';
		$demoimageurl = get_option('wpgv_demoimageurl') ? get_option('wpgv_demoimageurl') : WPGIFT__PLUGIN_URL.'/assets/img/demo.png';
		$cancelpagemessage = get_option('wpgv_cancelpagemessage') ? get_option('wpgv_cancelpagemessage') : 'You cancelled your order. Please place your order again from <a href="'.get_site_url().'/gift-voucher">here</a>.';
		$successpagemessage = get_option('wpgv_successpagemessage') ? get_option('wpgv_successpagemessage') : 'We have got your order! <br>E-Mail Sent Successfully to %s';
		$options = $wpdb->get_row( "SELECT * FROM $setting_table_name WHERE id = 1" );
		$voucher_styles = $options->voucher_style ? json_decode($options->voucher_style) : [''];
		?>
		<div class="wrap wpgiftv-settings">
			<h1><?php echo __( 'Settings', 'gift-voucher' ); ?></h1>
			<hr>
			<?php settings_errors(); ?>
		<div class="image-banner" style="margin-bottom: 10px;">
			<a href="https://www.codemenschen.at/wordpress-gift-voucher-plugin#purchase" target="_blank"><img src="<?php echo WPGIFT__PLUGIN_URL.'/assets/img/banner1.png'; ?>" style="width: 100%;"></a>
		</div>
	<div class="wpgiftv-row">
		<div class="wpgiftv-col75">
			<div class="white-box">

		<h2 class="nav-tab-wrapper">
			<a class="nav-tab nav-tab-active" href="#general"><?php echo __( 'General Settings', 'gift-voucher' ) ?></a>
			<a class="nav-tab" href="#payment"><?php echo __( 'Payment Settings', 'gift-voucher' ) ?></a>
			<a class="nav-tab" href="#email"><?php echo __( 'Email Settings', 'gift-voucher' ) ?></a>
			<a class="nav-tab" href="#custom"><?php echo __( 'Custom CSS', 'gift-voucher' ) ?></a>
		</h2>
			<form method="post" name="voucher-settings" id="voucher-settings" action="<?php echo admin_url( 'edit.php' ); ?>?post_type=wpgv_voucher_product&page=voucher-setting">
				<input type="hidden" name="action" value="save_voucher_settings_option" />
				<?php $nonce = wp_create_nonce( 'voucher_settings_verify' ); ?>
				<input type="hidden" name="voucher_settings_verify" value="<?php echo($nonce); ?>">
				<table class="form-table tab-content tab-content-active" id="general">
					<tbody>
						<tr><th colspan="2" style="padding-bottom:0;padding-top: 0;"><h3><?php echo __( 'General Settings', 'gift-voucher' ); ?></h3></th></tr>
						<tr>
							<th scope="row">
								<label for="is_woocommerce_enable"><?php echo __( 'WooCommerce', 'gift-voucher' ); ?></label>
								<p class="description">If enable then customers can redeem their vouchers on WooCommerce checkout</p>
							</th>
							<td>
								<select name="is_woocommerce_enable" id="is_woocommerce_enable" class="regular-text">
									<option value="1" <?php echo ($options->is_woocommerce_enable == 1) ? 'selected' : ''; ?>>Enable</option>
									<option value="0" <?php echo (!$options->is_woocommerce_enable) ? 'selected' : ''; ?>>Disable</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="is_style_choose_enable"><?php echo __( 'Can customers choose voucher styles?', 'gift-voucher' ); ?></label>
								<p class="description">If enable then customers can choose the voucher styles from bottom styles you enabled</p>
							</th>
							<td>
								<select name="is_style_choose_enable" id="is_style_choose_enable" class="regular-text">
									<option value="1" <?php echo ($options->is_style_choose_enable == 1) ? 'selected' : ''; ?>>Yes</option>
									<option value="0" <?php echo (!$options->is_style_choose_enable) ? 'selected' : ''; ?>>No</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="voucher_style"><?php echo __( 'Voucher Style', 'gift-voucher' ); ?> (Can select multiple)</label>
								<p class="description">Demo: <a href="<?= WPGIFT__PLUGIN_URL.'/assets/img/style1.png' ?>" target="_blank">Style 1</a>, <a href="<?= WPGIFT__PLUGIN_URL.'/assets/img/style2.png' ?>" target="_blank">Style 2</a>, <a href="<?= WPGIFT__PLUGIN_URL.'/assets/img/style3.png' ?>" target="_blank">Style 3</a></p>
							</th>
							<td>
								<select name="voucher_style[]" id="voucher_style" multiple="multiple" class="regular-text">
									<option value="0" <?php echo in_array(0, $voucher_styles) ? 'selected' : ''; ?>>Style 1</option>
									<option value="1" <?php echo in_array(1, $voucher_styles) ? 'selected' : ''; ?>>Style 2</option>
									<option value="2" <?php echo in_array(2, $voucher_styles) ? 'selected' : ''; ?>>Style 3</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="company_name"><?php echo __( 'Company Name', 'gift-voucher' ); ?> <span class="description">(required)</span></label>
							</th>
							<td>
								<input name="company_name" type="text" id="company_name" value="<?php echo esc_html( stripslashes($options->company_name) ); ?>" class="regular-text" aria-required="true" required="required">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="currency_code"><?php echo __( 'Currency Code', 'gift-voucher'  ); ?> <span class="description">(required)</span></label>
							</th>
							<td>
								<input name="currency_code" type="text" id="currency_code" value="<?php echo esc_html( $options->currency_code ); ?>" class="regular-text" aria-required="true" required="required">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="currency"><?php echo __( 'Currency Symbol', 'gift-voucher'  ); ?> <span class="description">(required)</span></label>
							</th>
							<td>
								<input name="currency" type="text" id="currency" value="<?php echo esc_html( $options->currency ); ?>" class="regular-text" aria-required="true" required="required">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="currency_position"><?php echo __( 'Currency Position', 'gift-voucher' ); ?> </label>
							</th>
							<td>
								<select name="currency_position" id="currency_position">
									<option value="Left" <?php echo ($options->currency_position == 'Left') ? 'selected' : ''; ?>>Left</option>
									<option value="Right" <?php echo ($options->currency_position == 'Right') ? 'selected' : ''; ?>>Right</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="voucher_bgcolor"><?php echo __( 'Voucher Background Color', 'gift-voucher' ); ?> <span class="description">(required)</span></label>
							</th>
							<td>
								<input name="voucher_bgcolor" type="text" id="voucher_bgcolor" value="#<?php echo esc_html( $options->voucher_bgcolor ); ?>" class="regular-text" aria-required="true">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="voucher_color"><?php echo __( 'Voucher Text Color', 'gift-voucher' ); ?> <span class="description">(required)</span></label>
							</th>
							<td>
								<input name="voucher_color" type="text" id="voucher_color" value="#<?php echo esc_html( $options->voucher_color ); ?>" class="regular-text" aria-required="true">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="template_col"><?php echo __( 'Templates Columns', 'gift-voucher'  ); ?></label>
								<p class="description"><?php echo __( 'How many templates show in a row. (Gift Voucher Shortcode)', 'gift-voucher'  ); ?></p>
							</th>
							<td>
								<select name="template_col" id="template_col">
									<option value="3" <?php echo ($options->template_col == 3) ? 'selected' : ''; ?>>3</option>
									<option value="4" <?php echo ($options->template_col == 4) ? 'selected' : ''; ?>>4</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="voucher_min_value"><?php echo __( 'Minimum Voucher Value', 'gift-voucher'  ); ?></label>
								<p class="description"><?php echo __( 'Leave 0 if no minimum value', 'gift-voucher'  ); ?></p>
							</th>
							<td>
								<input name="voucher_min_value" type="text" id="voucher_min_value" value="<?php echo esc_html( $options->voucher_min_value ); ?>" class="regular-text" aria-required="true">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="voucher_max_value"><?php echo __( 'Maximum Voucher Value', 'gift-voucher'  ); ?></label>
							</th>
							<td>
								<input name="voucher_max_value" type="text" id="voucher_max_value" value="<?php echo esc_html( $options->voucher_max_value ); ?>" class="regular-text" aria-required="true">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="voucher_expiry_type"><?php echo __( 'Voucher Expiry Type', 'gift-voucher'  ); ?></label>
								<p class="description"><?php echo __( 'Select the type of voucher expiration?', 'gift-voucher'  ); ?></p>
							</th>
							<td>
								<select name="voucher_expiry_type" id="template_col">
									<option value="days" <?php echo ($options->voucher_expiry_type == 'days') ? 'selected' : ''; ?>>Days</option>
									<option value="fixed" <?php echo ($options->voucher_expiry_type == 'fixed') ? 'selected' : ''; ?>>Fixed Date</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="voucher_expiry"><?php echo __( 'Voucher Expiry Value', 'gift-voucher'  ); ?></label>
								<p class="description"><?php echo __( 'Example: (Days: 60, Fixed Date: 20.05.2018)' ); ?></p>
							</th>
							<td>
								<input name="voucher_expiry" type="text" id="voucher_expiry" value="<?php echo esc_html( $options->voucher_expiry ); ?>" class="regular-text" aria-required="true">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="admin_email_body"><?php echo __( 'Terms and Condition Checkbox Text', 'gift-voucher' ); ?></label>
							</th>
							<td>
								<?php wp_editor( stripslashes($wpgv_termstext), 'wpgvtermstext', array( 'wpautop' => true, 'media_buttons' => false, 'textarea_rows' => 5 ) ); ?>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="voucher_terms_note"><?php echo __( 'Voucher Terms Note', 'gift-voucher'  ); ?></label>
								<p class="description"><?php echo __( 'Terms note in voucher order page', 'gift-voucher'  ); ?></p>
							</th>
							<td>
								<textarea name="voucher_terms_note" id="voucher_terms_note" class="regular-text" aria-required="true" rows="4"><?php echo esc_html( stripslashes($options->voucher_terms_note) ); ?></textarea>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="post_shipping"><?php echo __( 'Post Shipping', 'gift-voucher'  ); ?></label>
							</th>
							<td>
								<select name="post_shipping" id="post_shipping">
									<option value="1" <?php echo ($options->post_shipping == 1) ? 'selected' : ''; ?>>Yes</option>
									<option value="0" <?php echo ($options->post_shipping == 0) ? 'selected' : ''; ?>>No</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="shipping_method"><?php echo __( 'Shipping Method for Post Shipping', 'gift-voucher'  ); ?></label>
								<p class="description">Method Format -> value : name </p>
							</th>
							<td>
								<textarea name="shipping_method" type="text" id="shipping_method" class="regular-text" rows="4"><?php echo esc_html( stripslashes($options->shipping_method) ); ?></textarea>
								<p class="description"><?php echo __( 'Multiple methods seperate by comma(,)', 'gift-voucher' ); ?></p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="preview_button"><?php echo __( 'Voucher preview Button', 'gift-voucher' ); ?></label>
								<p class="description">If enable then preview button will show in the voucher booking forms</p>
							</th>
							<td>
								<select name="preview_button" id="preview_button">
									<option value="1" <?php echo ($options->preview_button == 1) ? 'selected' : ''; ?>>Enable</option>
									<option value="0" <?php echo ($options->preview_button == 0) ? 'selected' : ''; ?>>Disable</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="demo_image"><?php echo __( 'Add Your Custom Demo Image', 'gift-voucher'  ); ?></label>
								<p class="description">Default Image - check <a href="<?= WPGIFT__PLUGIN_URL.'/assets/img/demo.png' ?>" target="_blank">here</a></p>
							</th>
							<td>
								<input name="demo_image" type="text" id="demo_image" value="<?php echo esc_html( $demoimageurl ); ?>" class="regular-text">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="custom_loader"><?php echo __( 'Add Your Custom Loader URL', 'gift-voucher'  ); ?></label>
								<p class="description">Default - check <a href="<?= WPGIFT__PLUGIN_URL.'/assets/img/loader.gif' ?>" target="_blank">here</a></p>
							</th>
							<td>
								<input name="custom_loader" type="text" id="custom_loader" value="<?php echo esc_html( $options->custom_loader ); ?>" class="regular-text">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="successpagemessage"><?php echo __( 'Successful Page Message', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'Message appear after payment successful.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<?php wp_editor( stripslashes($successpagemessage), 'successpagemessage', array('wpautop' => false, 'media_buttons' => false, 'textarea_rows' => 5 ) ); ?>
								<p>%s - <?php echo __('Display the email address of the customer', 'gift-voucher'); ?></p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="cancelpagemessage"><?php echo __( 'Order Cancellation Message', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'Message appear after order cancelled', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<?php wp_editor( stripslashes($cancelpagemessage), 'cancelpagemessage', array('wpautop' => false, 'media_buttons' => false, 'textarea_rows' => 5 ) ); ?>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="pdf_footer_url"><?php echo __( 'Website URL on PDF in Footer', 'gift-voucher'  ); ?></label>
							</th>
							<td>
								<input name="pdf_footer_url" type="text" id="pdf_footer_url" value="<?php echo esc_html( $options->pdf_footer_url ); ?>" class="regular-text">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="pdf_footer_email"><?php echo __( 'Email on PDF in Footer', 'gift-voucher'  ); ?></label>
							</th>
							<td>
								<input name="pdf_footer_email" type="text" id="pdf_footer_email" value="<?php echo esc_html( $options->pdf_footer_email ); ?>" class="regular-text">
							</td>
						</tr>
					</tbody>
				</table>
				<table id="payment" class="form-table tab-content">
					<tbody>
						<tr><th colspan="2" style="padding-bottom:0"><h3><?php echo __( 'Payment Settings', 'gift-voucher'  ); ?></h3></th></tr>
						<tr>
							<th scope="row">
								<label for="paypal"><?php echo __( 'Paypal Enable', 'gift-voucher'  ); ?></label>
							</th>
							<td>
								<select name="paypal" id="paypal">
									<option value="1" <?php echo ($options->paypal == 1) ? 'selected' : ''; ?>>Yes</option>
									<option value="0" <?php echo ($options->paypal == 0) ? 'selected' : ''; ?>>No</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="paypal_email"><?php echo __( 'Paypal Email', 'gift-voucher'  ); ?></label>
							</th>
							<td>
								<input name="paypal_email" type="email" id="paypal_email" value="<?php echo esc_html( $options->paypal_email ); ?>" class="regular-text" aria-describedby="paypal-description">
								<p class="description" id="paypal-description"><?php echo __( 'This address is used for paypal payment.', 'gift-voucher' ); ?></p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="test_mode"><?php echo __( 'Paypal Testmode', 'gift-voucher'  ); ?></label>
							</th>
							<td>
								<select name="test_mode" id="test_mode">
									<option value="1" <?php echo ($options->test_mode == 1) ? 'selected' : ''; ?>>Yes</option>
									<option value="0" <?php echo ($options->test_mode == 0) ? 'selected' : ''; ?>>No</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="stripe"><?php echo __( 'Stripe Enable', 'gift-voucher'  ); ?></label>
							</th>
							<td>
								<select name="stripe" id="stripe">
									<option value="1" <?php echo ($options->stripe == 1) ? 'selected' : ''; ?>>Yes</option>
									<option value="0" <?php echo ($options->stripe == 0) ? 'selected' : ''; ?>>No</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="stripe_publishable_key"><?php echo __( 'Stripe Publishable key', 'gift-voucher'  ); ?></label>
								<p class="description"><?php echo __( 'Collect the Publishable API key from below link.', 'gift-voucher' ); ?><br><a href="https://dashboard.stripe.com/account/apikeys" target="_blank">Click Here</a></p>
							</th>
							<td>
								<input name="stripe_publishable_key" type="text" id="stripe_publishable_key" value="<?php echo esc_html( $options->stripe_publishable_key ); ?>" class="regular-text">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="stripe_secret_key"><?php echo __( 'Stripe Secret Key', 'gift-voucher'  ); ?></label>
								<p class="description"><?php echo __( 'Collect the Secret API key from below link.', 'gift-voucher' ); ?><br><a href="https://dashboard.stripe.com/account/apikeys" target="_blank">Click Here</a></p>
							</th>
							<td>
								<input name="stripe_secret_key" type="text" id="stripe_secret_key" value="<?php echo esc_html( $options->stripe_secret_key ); ?>" class="regular-text">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="stripe_checkoutpage"><?php echo __( 'Stripe Checkout Page', 'gift-voucher'  ); ?></label>
							</th>
							<td>
								<input name="stripe_checkoutpage" type="text" id="stripe_checkoutpage" value="<?php echo $stripepageurl; ?>" class="regular-text" readonly>
								<p class="description"><?php echo __( 'This page is automatically created for you when you enable stripe payment method.', 'gift-voucher' ); ?></p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="sofort"><?php echo __( 'Sofort Enable', 'gift-voucher'  ); ?></label>
							</th>
							<td>
								<select name="sofort" id="sofort">
									<option value="1" <?php echo ($options->sofort == 1) ? 'selected' : ''; ?>>Yes</option>
									<option value="0" <?php echo ($options->sofort == 0) ? 'selected' : ''; ?>>No</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="sofort_configure_key"><?php echo __( 'Sofort Configuration Key', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'Enter your configuration key. you only can create a new configuration key by creating a new Gateway project in your account at sofort.com.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<input name="sofort_configure_key" type="text" id="sofort_configure_key" value="<?php echo esc_html( $options->sofort_configure_key ); ?>" class="regular-text" aria-describedby="paypal-description">
								<p class="description"><?php echo __( 'This key is used for Sofort Payment.', 'gift-voucher' ); ?></p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="reason_for_payment"><?php echo __( 'Reason for Payment', 'gift-voucher'  ); ?></label>
								<p class="description"><?php echo __( 'Reason for payment from Sofort.', 'gift-voucher'  ); ?></p>
							</th>
							<td>
								<input name="reason_for_payment" type="text" id="reason_for_payment" value="<?php echo esc_html( $options->reason_for_payment ); ?>" class="regular-text" aria-describedby="paypal-description">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="per_invoice"><?php echo __( 'Selection Per Invoice', 'gift-voucher'  ); ?></label>
								<p class="description"><?php echo __('With this payment method user don\'t have to pay immediately, They can directly transfer amount to your bank.', 'gift-voucher'  ); ?></p>
							</th>
							<td>
								<select name="per_invoice" id="per_invoice">
									<option value="1" <?php echo ($options->per_invoice == 1) ? 'selected' : ''; ?>>Yes</option>
									<option value="0" <?php echo ($options->per_invoice == 0) ? 'selected' : ''; ?>>No</option>
								</select>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="bank_info"><?php echo __( 'Bank Details', 'gift-voucher'  ); ?></label>
								<p class="description"><?php echo __( 'This details will show to user who would pay as per invoice.', 'gift-voucher'  ); ?></p>
							</th>
							<td>
								<?php wp_editor( stripslashes($options->bank_info), 'bank_info', array( 'wpautop' => false, 'media_buttons' => false, 'textarea_rows' => 5 ) ); ?>
							</td>
						</tr>
					</tbody>
				</table>
				<table id="email" class="form-table tab-content">
					<tbody>
						<tr><th colspan="2" style="padding-bottom:0"><h3><?php echo __( 'Email Settings', 'gift-voucher'  ); ?></h3></th></tr>
						<tr>
							<th scope="row">
								<label for="sender_name"><?php echo __( 'Sender Name', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'For emails send by this plugin.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<input name="sender_name" type="text" id="sender_name" value="<?php echo esc_html( $options->sender_name ); ?>" class="regular-text" aria-describedby="sendername-description">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="sender_email"><?php echo __( 'Sender Email', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'For emails send by this plugin.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<input name="sender_email" type="email" id="sender_email" value="<?php echo esc_html( $options->sender_email ); ?>" class="regular-text" aria-describedby="senderemail-description">
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="email_subject"><?php echo __( 'Buyer Email Subject', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'Subject for emails send to customers.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<?php wp_editor( stripslashes($emailsubject), 'email_subject', array( 'media_buttons' => false, 'textarea_rows' => 5 ) ); ?>
								<p class="description">{company_name} {website_url} {sender_email} {sender_name} {order_number} {order_type} {amount} {customer_name} {recipient_name} {customer_email} {coupon_code} {pdf_link}</p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="email_body"><?php echo __( 'Buyer Email Body', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'Body message for emails send to customers.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<?php wp_editor( stripslashes($emailbody), 'email_body', array( 'wpautop' => false, 'media_buttons' => false ) ); ?>
								<p class="description">{company_name} {website_url} {sender_email} {sender_name} {order_number} {order_type} {amount} {customer_name} {recipient_name} {customer_email} {coupon_code} {pdf_link}</p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="email_body"><?php echo __( 'Buyer Email Body for Per Invoice Selection', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'This email body is used when customer select payment as per invoice.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<?php wp_editor( stripslashes($emailbodyperinvoice), 'email_body_per_invoice', array( 'wpautop' => false, 'media_buttons' => false ) ); ?>
								<p class="description">{company_name} {website_url} {sender_email} {sender_name} {order_number} {order_type} {amount} {customer_name} {recipient_name} {customer_email} {coupon_code} {pdf_link}</p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="email_subject"><?php echo __( 'Recipient Email Subject', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'Subject for emails send to recipient.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<?php wp_editor( stripslashes($recipientemailsubject), 'recipient_email_subject', array( 'media_buttons' => false, 'textarea_rows' => 5 ) ); ?>
								<p class="description">{company_name} {website_url} {sender_email} {sender_name} {order_number} {order_type} {amount} {customer_name} {recipient_name} {customer_email} {coupon_code} {pdf_link}</p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="email_body"><?php echo __( 'Recipient Email Body', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'Body message for emails send to recipient.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<?php wp_editor( stripslashes($recipientemailbody), 'recipient_email_body', array( 'wpautop' => false, 'media_buttons' => false ) ); ?>
								<p class="description">{company_name} {website_url} {sender_email} {sender_name} {order_number} {order_type} {amount} {customer_name} {recipient_name} {customer_email} {coupon_code} {pdf_link}</p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="admin_email_subject"><?php echo __( 'Admin Email Subject', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'Subject for emails send to customers.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<?php wp_editor( $adminemailsubject, 'admin_email_subject', array( 'media_buttons' => false, 'textarea_rows' => 5 ) ); ?>
								<p class="description">{company_name} {website_url} {sender_email} {sender_name} {order_number} {order_type} {amount} {customer_name} {recipient_name} {customer_email} {coupon_code} {pdf_link}</p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for="admin_email_body"><?php echo __( 'Admin Email Body', 'gift-voucher' ); ?></label>
								<p class="description"><?php echo __( 'Body message for emails send to customers.', 'gift-voucher' ); ?></p>
							</th>
							<td>
								<?php wp_editor( stripslashes($adminemailbody), 'admin_email_body', array('wpautop' => false, 'media_buttons' => false ) ); ?>
								<p class="description">{company_name} {website_url} {sender_email} {sender_name} {order_number} {order_type} {amount} {customer_name} {recipient_name} {customer_email} {coupon_code} {pdf_link}</p>
							</td>
						</tr>
					</tbody>
				</table>
				<table id="custom" class="form-table tab-content">
					<tbody>
						<tr><th colspan="2" style="padding-bottom:0"><h3><?php echo __( 'Custom CSS', 'gift-voucher'  ); ?></h3></th></tr>
						<tr>
							<td colspan="2">
								<textarea name="wpgv_custom_css" id="wpgv_custom_css" class="regular-text" aria-required="true" rows="4" style="width: 100%;height: 200px;"><?php echo stripslashes( $wpgv_custom_css ); ?></textarea>
							</td>
						</tr>
					</tbody>
				</table>
				<p class="submit"><?php submit_button( __( 'Save Settings', 'gift-voucher'), 'primary', 'submit', false ); ?></p>
			</form></div></div>

		<div class="wpgiftv-col25">
			<div class="white-box rating-box">
				<h2>Rate Our Plugin</h2>
				<div class="star-ratings">
					<span class="dashicons dashicons-star-filled"></span>
					<span class="dashicons dashicons-star-filled"></span>
					<span class="dashicons dashicons-star-filled"></span>
					<span class="dashicons dashicons-star-filled"></span>
					<span class="dashicons dashicons-star-filled"></span>
				</div>
				<p>Did WordPress Gift Voucher Plugin help you out? Please leave a 5-star review. Thank you!</p>
				<a href="https://wordpress.org/support/plugin/gift-voucher/reviews/#new-post" target="_blank" class="button button-primary">Write a review</a>
			</div>
			<div class="white-box">
				<h2>Having Issues?</h2>
				<p>Need a helping hand? Please ask for help on the <a href="http://www.codemenschen.at/submit-ticket/" target="_blank">Support forum</a>. Be sure to mention your WordPress version and give as much additional information as possible.</p>
				<a href="http://www.codemenschen.at/submit-ticket/?page=tickets&section=create-ticket" class="button button-primary" target="_blank">Submit your question</a>
			</div>
			<div class="white-box">
				<h2>Customization Service</h2>
				<p>We are a European Company. To hire our agency to help you with this plugin installation or any other customization or requirements please contact us through our site <a href="http://www.codemenschen.at/contact-us" target="_blank">contact form</a> or email <a href="mailto:gdpr@codemenschen.at">gdpr@codemenschen.at</a> directly.</p>
				<a href="http://www.codemenschen.at/contact-us" class="button button-primary" target="_blank">Hire Us Now</a>
			</div>
			<div class="image-banner" style="margin-bottom: 10px;">
				<a href="https://www.codemenschen.at/wordpress-gift-voucher-plugin#purchase" target="_blank"><img src="<?php echo WPGIFT__PLUGIN_URL.'/assets/img/banner2.png'; ?>" style="width: 100%;"></a>
			</div>
		</div>
		</div>
		<span class="wpgiftv-disclaimer">Thank you for using <b>WordPress Gift Voucher</b>.</span>
		</div>