// pages/post-list/post-list.js

/**
 * Project: WooCommerce微信小程序
 * Description: 将WooCommerce商城接入微信小程序
 * Author: 幻想小籽
 * Organization: QwqOffice (https://www.qwqoffice.com)
 */

const Zan = require('../../vendor/ZanUI/index');
const app = getApp();

Page(Object.assign({}, Zan.Tab, app.Methods, {
    data: Object.assign({}, app.Variables, {
        NAV_HEIGHT: wx.STATUS_BAR_HEIGHT + wx.DEFAULT_HEADER_HEIGHT + 'px',
        NAV_BAR_HEIGHT: wx.DEFAULT_HEADER_HEIGHT + 'px',
        pageTitle: '资讯',
        posts: [],
        tabSelected: 'lastest'
    }),
    page: 1,
    options: null,
    // 选项卡变更
    handleZanTabChange({
        componentId,
        selectedId
    }) {
        if (componentId == 'category-tab') {
            this.setData({
                tabSelected: selectedId
            });
            if (selectedId == 'lastest') {
                delete this.params.categories;
            } else {
                this.params.categories = selectedId;
            }
            this.onLoad(this.options);
        }
    },
    // 刷新分类
    refreshCategories() {
        app.Util.network.GET({
            url: app.API('post_category'),
            success: data => {
                this.setData({
                    tabList: data
                });
            }
        });
    },
    loadData() {

        if (this.data.bottomStyle == 'nomore' || this.data.bottomStyle == 'empty') {
            if (this.page != 1) {
                wx.showToast({
                    icon: 'none',
                    title: '没有更多了~'
                })
            }
            return;
        }

        if (this.params == undefined) {
            this.params = {};
        }

        app.Util.network.GET({
            url: app.API('post_list'),
            params: Object.assign({}, this.params, {
                page: this.page
            }),
            success: data => {

                if (data.length == 0) {
                    this.setData({
                        bottomStyle: (this.page == 1 ? 'empty' : 'nomore')
                    });
                    if (this.page != 1) {
                        wx.showToast({
                            icon: 'none',
                            title: '没有更多了~'
                        })
                    }
                    return;
                }

                var setdata = {};
                var offset = (this.page - 1) * 10;
                for (var i = 0; i < data.length; i++) {
                    setdata['posts[' + (offset + i) + ']'] = data[i];
                }
                this.setData(setdata);
                this.page++;
            }
        });
    },
    goPostDetail(e) {
        var id = e.currentTarget.dataset.id;
        wx.navigateTo({
            url: '/pages/post-detail/post-detail?id=' + id
        })
    },
    onLoad(options) {
        this.setData({
            posts: [],
            bottomStyle: false
        });
        this.options = options;
        this.page = 1;
        this.loadData();

        if (this.data.tabList == undefined) {
            this.refreshCategories();
        }
    },
    onPullDownRefresh() {
        this.onLoad(this.options);
    },
    onReachBottom() {
        this.refreshCategories();
        this.loadData();
    }
}))