// pages/order-detail/order-detail.js

/**
 * Project: WooCommerce微信小程序
 * Description: 将WooCommerce商城接入微信小程序
 * Author: 幻想小籽
 * Organization: QwqOffice (https://www.qwqoffice.com)
 */

const app = getApp();

Page(Object.assign({}, app.Methods, {
    data: Object.assign({}, app.Variables, {
        NAV_HEIGHT: wx.STATUS_BAR_HEIGHT + wx.DEFAULT_HEADER_HEIGHT + 'px',
        NAV_BAR_HEIGHT: wx.DEFAULT_HEADER_HEIGHT + 'px',
        pageTitle: '订单详情',
        currency: app.data.currency,
        order: null
    }),
    // 取消订单
    cancelOrder(e) {
        app.cancelOrder({
            id: this.options.id,
            success: data => {
                var toast = {};
                if (data.success == true) {
                    toast.title = '取消成功';
                } else {
                    toast.title = '取消失败，请稍后再试';
                    toast.icon = 'none';
                }
                toast.success = () => {
                    setTimeout(() => {
                        this.onPullDownRefresh();
                    }, 1500);
                }
                wx.showToast(toast);
            }
        });
    },
    // 发起支付
    makePayment() {
        app.requestPayment({
            id: this.options.id,
            success: res => {
                wx.showToast({
                    title: '支付成功',
                    success: () => {
                        setTimeout(() => {
                            this.onLoad(this.options);
                        }, 1500);
                    }
                });
            },
            fail: res => {
                if (res.errMsg != 'requestPayment:fail cancel') {
                    wx.showToast({
                        title: res.errMsg,
                        icon: 'none'
                    });
                }
            }
        })
    },
    goProductDetail(e) {
        app.goProductDetail(e);
    },
    goShippingDetail() {
        wx.navigateTo({
            url: '/pages/shipping-detail/shipping-detail?id=' + this.options.id
        })
    },
    // 跳转评价列表
    goOrderReviewList(e) {
        var id = e.currentTarget.dataset.id;
        if (this.data.order.line_items.length == 1) {
            wx.navigateTo({
                url: '/pages/order-review-post/order-review-post?id=' + id + '&itemID=' + this.data.order.line_items[0].id
            })

        } else {
            wx.navigateTo({
                url: '/pages/order-review-list/order-review-list?id=' + id
            })
        }
    },
    onLoad(options) {
        this.setData({
            currentPages: getCurrentPages().length
        });

        this.options = options;
        app.Util.network.GET({
            url: app.API('order_detail') + options.id,
            params: {
                w2w_session: app.data.w2w_session
            },
            success: data => {
                this.setData({
                    order: data,
                    order_status: data.status == 'completed' && data.reviewed ? '已完成' : app.Util.getOrderStatus(data.status),
                    province: app.Util.getStateName(data.billing.state) || ''
                });
            }
        });
    },
    onShow() {

    },
    onPullDownRefresh() {
        this.onLoad(this.options);
    },
    onReachBottom() {

    }
}))