// pages/index/index.js

/**
 * Project: WooCommerce微信小程序
 * Description: 将WooCommerce商城接入微信小程序
 * Author: 幻想小籽
 * Organization: QwqOffice (https://www.qwqoffice.com)
 */

const Zan = require('../../vendor/ZanUI/index');
const app = getApp();
const currentPages = getCurrentPages();

Page(Object.assign({}, Zan.TopTips, Zan.NoticeBar, app.Methods, {
    data: Object.assign({}, app.Variables, {
        NAV_HEIGHT: wx.STATUS_BAR_HEIGHT + wx.DEFAULT_HEADER_HEIGHT + 'px',
        NAV_BAR_HEIGHT: wx.DEFAULT_HEADER_HEIGHT + 'px',
        pageTitle: app.data.name,
        currency: app.data.currency,
        currentPages: currentPages,
        banner: null,
        imgHeights: [],
        imgWidth: 750,
        current: 0,
        lastest_products: null,
        clearSearchShow: false,
        currentPost: 0,
        buyType: app.data.buyType,
        /* W2W Extension, Name: w2w-home-page-modules, Code: indexModules */

/* W2W Extension, Name: w2w-home-page-modules, Code: indexModules */
    }),
    addToCart(e) {
        this.doAddToCart(e);
    },
    goTop() {
        wx.pageScrollTo({
            scrollTop: 0
        })
    },
    // 跳转搜索页
    searchSubmit(e) {

        var search = '';
        // 表单提交
        if (typeof e.detail.value == 'object') {
            search = e.detail.value.search;
        }
        // 输入框完成提交
        else {
            search = e.detail.value;
        }

        if (search == '') {
            wx.showToast({
                title: '请输入搜索内容',
                icon: 'none'
            })
        } else {
            wx.navigateTo({
                url: '/pages/product-list/product-list?mode=search&search=' + search
            })
            this.clearSearch();
        }

    },
    // 清空搜索
    clearSearch() {
        this.setData({
            search: '',
            clearSearchShow: false
        });
    },
    // 搜索输入框输入
    searchInput(e) {
        this.setData({
            clearSearchShow: e.detail.value != ''
        })
    },
    imageLoad(e) {
        var moduleIndex = e.currentTarget.dataset.moduleIndex;
        // 获取图片下标
        var index = e.currentTarget.dataset.index;
        // 获取图片真实宽度
        var imgWidth = e.detail.width,
            imgHeight = e.detail.height,
            // 宽高比  
            ratio = imgWidth / imgHeight;
        // 计算的高度值
        var viewHeight = 750 / ratio;
        var imgHeight = viewHeight;
        var imgHeights = this.data.imgHeights;
        // 把每一张图片的高度记录到数组里
        if (imgHeights[moduleIndex] == undefined) {
            imgHeights[moduleIndex] = [];
        }
        imgHeights[moduleIndex][index] = imgHeight;
        this.setData({
            imgHeights: imgHeights,
            ['current[' + moduleIndex + ']']: 0
        })
    },
    imageChange(e) {
        var moduleIndex = e.currentTarget.dataset.moduleIndex;
        this.setData({
            ['current[' + moduleIndex + ']']: e.detail.current
        });
    },
    // 跳转文章列表页
    goPostList() {
        wx.switchTab({
            url: '/pages/post-list/post-list'
        })
    },
    // 跳转文章详情页
    goPostDetail(e) {
        var id = e.currentTarget.dataset.id;
        wx.navigateTo({
            url: '/pages/post-detail/post-detail?id=' + id
        })
    },
    // 跳转产品详情页
    goProductDetail(e) {
        app.goProductDetail(e);
    },
    loginSuccess() {
        app.refreshOrdersInfo();
    },
    /* W2W Extension, Name: w2w-advanced-coupon, Code: indexCouponEvents */

/* W2W Extension, Name: w2w-advanced-coupon, Code: indexCouponEvents */
    
    setPostInterval(length) {
        if (length == 0) return;
        if (this.timer == undefined) {
            this.timer = setInterval(() => {
                if (this.currentPost == undefined) {
                    this.currentPost = 0;
                }
                this.setData({
                    currentPost: this.currentPost
                });
                this.currentPost++;
                if (this.currentPost >= length) {
                    this.currentPost = 0;
                }
            }, 5000);
        } else {
            this.currentPost = 0;
            this.setData({
                currentPost: this.currentPost
            });
        }
    },
    onLoad() {
        /*
        app.Util.network.POST({
            url: app.API('coupon'),
            params: {
				w2w_session: app.data.w2w_session,
                code: 'qo20186'
            },
            success: data => {
                console.log(data);
            }
        });
        console.log('index onLoad');
        //app.Util.getVideoInfo(this, 'i06464fu5ab');*/

        clearInterval(this.timer);

        app.Util.network.GET({
            url: app.API('index'),
            success: data => {
                this.setData(data);
                if (this.data.contentType == 'module') {
                    for (var i in data.modules) {
                        var module = data.modules[i];
                        if (module.name == 'notice') {
                            this.initZanNoticeBarScroll('noticebar');
                        } else if (module.name == 'posts') {
                            this.setPostInterval(module.data.length);
                        }
                    }
                } else {
                    if (data.notice != null) {
                        this.initZanNoticeBarScroll('noticebar');
                    }
                    if (this.data.posts != undefined) {
                        this.setPostInterval(this.data.posts.length);
                    }
                }

                if (app.data.cart == null) {
                    app.checkLogin({
                        success: () => {
                            app.refreshCart(() => {
                                app.refreshOrdersInfo();
                            });
                        }
                    });
                }
            }
        });
    },
    onPullDownRefresh() {
        this.onLoad();
    },
    onShow() {
        if (app.data.cart != null) {
            app.updateCart(app.data.cart);
        }
    },
    // 页面滚动
    onPageScroll(e) {
        var scrollTop = e.scrollTop;
        if (scrollTop > 1000 && this.data.goTopShow != true) {
            this.setData({
                goTopShow: true
            });
        } else if (scrollTop <= 1000 && this.data.goTopShow != false) {
            this.setData({
                goTopShow: false
            });
        }
    },
    onShareAppMessage() {
        var path = '/pages/index/index';
        if (app.isLoggedIn()) {
            path = path + '?uid=' + app.data.user_id;
        }
        return {
            path: path
        }
    }
}))