// pages/address-list/address-list.js

/**
 * Project: WooCommerce微信小程序
 * Description: 将WooCommerce商城接入微信小程序
 * Author: 幻想小籽
 * Organization: QwqOffice (https://www.qwqoffice.com)
 */

const app = getApp();

Page(Object.assign({}, app.Methods, {
    data: Object.assign({}, app.Variables, {
		/* W2W Extension, Name: w2w-advanced-address, Code: addressListData */
		NAV_HEIGHT: wx.STATUS_BAR_HEIGHT + wx.DEFAULT_HEADER_HEIGHT + 'px',
		NAV_BAR_HEIGHT: wx.DEFAULT_HEADER_HEIGHT + 'px',
		pageTitle: '我的地址',
        isActionPopup: false
        /* W2W Extension, Name: w2w-advanced-address, Code: addressListData */
    }),
    /* W2W Extension, Name: w2w-advanced-address, Code: addressListEvents */
    // 打开操作弹窗
    openActionPopup(e) {
        var index = e.currentTarget.dataset.index;
        this.setData({
            isActionPopup: true,
            selectedAddress: index
        });
    },
    // 关闭操作弹窗
    closeActionPopup() {
        this.setData({
            isActionPopup: false,
            selectedAddress: null
        });
    },
    // 编辑地址
    goEditAddress() {
        var id = this.data.selectedAddress;
        this.closeActionPopup();
        wx.navigateTo({
            url: '/pages/address-edit/address-edit?mode=edit&id=' + id
        })
    },
    // 删除地址
    deleteAddress() {
        app.Util.network.POST({
            url: app.API('delete_address'),
            params: {
                id: this.data.selectedAddress,
                w2w_session: app.data.w2w_session
            },
            success: data => {
                this.closeActionPopup();
                if (data.success == true) {
                    for (var i in data.addresses) {
                        data.addresses[i] = app.Util.addressTransform(data.addresses[i], 'show');
                    }
                    this.setData({
                        addressList: data.addresses
                    });
                }
            }
        });
    },
    // 复制地址
    copyAddress() {
        var id = this.data.selectedAddress,
            address = this.data.addressList[id];
        var str = '收货人：' + address.billing_first_name + '\r\n' +
            '手机号码：' + address.billing_phone + '\r\n' +
            '我的地址：' + address.billing_country + address.billing_state + address.billing_city + address.billing_address_1 + '\r\n' +
            '邮政编码：' + address.billing_postcode;
        wx.setClipboardData({
            data: str,
            success: () => {
                this.closeActionPopup();
                wx.showToast({
                    title: '复制成功'
                })
            }
        })
    },
    goAddAddress() {
        wx.navigateTo({
            url: '/pages/address-edit/address-edit?mode=add'
        })
    },
    // 地址点击
    addressTap(e) {
        if (this.data.mode == 'select') {
            var index = e.currentTarget.dataset.index;
            app.data.address = this.data.ognAddresses[index];
            app.data.addressChange = true;
            wx.setStorage({
                key: 'address',
                data: app.data.address,
                success: () => {
                    wx.navigateBack();
                }
            })
        } else if (this.data.mode == 'manage') {
            this.openActionPopup(e);
        }
    },
    onLoad(options) {
        this.setData({
            mode: options.mode,
			currentPages: getCurrentPages().length
        });
    },
    onShow() {
        app.Util.network.GET({
            url: app.API('get_address'),
            params: {
                w2w_session: app.data.w2w_session
            },
            success: data => {
                var ognAddresses = app.Util.cloneObj(data.addresses);
                for (var i in data.addresses) {
                    data.addresses[i] = app.Util.addressTransform(data.addresses[i], 'show');
                }
                this.setData({
                    ognAddresses: ognAddresses,
                    addressList: data.addresses
                });
            }
        });
    },
    onPullDownRefresh() {
        this.onShow();
    }
    /* W2W Extension, Name: w2w-advanced-address, Code: addressListEvents */
}))