import { Component, OnInit, Input, forwardRef } from '@angular/core';
import { ControlValueAccessor, NG_VALUE_ACCESSOR } from '@angular/forms';
export const EXE_COUNTER_VALUE_ACCESSOR: any = {
  provide: NG_VALUE_ACCESSOR,
  useExisting: forwardRef(() => FormSelectComponent),
  multi: true
};
@Component({
  selector: 'app-form-select',
  templateUrl: './form-select.component.html',
  styleUrls: ['./form-select.component.css'],
  providers: [EXE_COUNTER_VALUE_ACCESSOR]
})
export class FormSelectComponent implements OnInit ,ControlValueAccessor {

  @Input()options:Array<{}>;
  @Input()name:string;
 
  

  selected:any = "";
  
  change($event){
    const index = this.options.indexOf($event[0]);
    this.propagateChange(index);
  }
  writeValue(obj: any): void {
    this.selected = obj;
  }
  propagateChange = (_: any) => { 

  };
  registerOnChange(fn: any): void {
    this.propagateChange = fn;
  }
  registerOnTouched(fn: any): void {
   
  }
  setDisabledState?(isDisabled: boolean): void {
    
  }

  constructor() { }

  ngOnInit() {
  }

}
