import { Component, OnInit, Input, forwardRef } from "@angular/core";
import { ControlValueAccessor, NG_VALUE_ACCESSOR } from "@angular/forms";
import { currentDateFormat } from "src/app/layout/service/util.service";
export const FORM_DATE_ACCESSOR: any = {
  provide: NG_VALUE_ACCESSOR,
  useExisting: forwardRef(() => FormDateComponent),
  multi: true
};
@Component({
  selector: "app-form-date",
  templateUrl: "./form-date.component.html",
  styleUrls: ["./form-date.component.css"],
  providers: [FORM_DATE_ACCESSOR]
})
export class FormDateComponent implements OnInit, ControlValueAccessor {
  @Input() name: string;

  selected: any = "";
  selectedFormated: any = "";
  change($event) {
    this.selectedFormated = currentDateFormat($event, "yyyy-mm-dd");
    this.propagateChange(this.selectedFormated);
  }
  writeValue(obj: any): void {
    this.selected = obj;
  }
  propagateChange = (_: any) => {};
  registerOnChange(fn: any): void {
    this.propagateChange = fn;
  }
  registerOnTouched(fn: any): void {}
  setDisabledState?(isDisabled: boolean): void {}

  constructor() {}

  ngOnInit() {}
}
