import { Injectable } from "@angular/core";

import { Observable } from "rxjs/internal/Observable";
import { URLSearchParams } from "@angular/http";
import { HttpParams, HttpClient, HttpHeaders } from "@angular/common/http";
import { convertModelToUrlData } from "src/app/layout/service/util.service";

const MessageInform = "asset/a/asset/MessageInform/data";
const Warning = "asset/a/asset/warning/data";
const House = "asset/a/asset/house/data";
const AssetType = "asset/a/asset/assetType/data";
const AssetDepreciationRecord = "asset/a/asset/assetDepreciationRecord/data";
const SpecialFaultRecord = "asset/a/asset/specialFaultRecord/data";
const SpecialFault = "asset/a/asset/specialFault/data";
const CheckRecord = "asset/a/asset/checkRecord/data";
const Anlage = "asset/a/asset/anlage/data";
const CustomField = "asset/a/asset/customField/data";
const AuxiliaryFacility = "asset/a/asset/auxiliaryFacility/data";
const BuyApply = "asset/a/asset/buyApply/data";
const BuyContract = "asset/a/asset/buyContract/data";
const BuyPay = "asset/a/asset/buyPay/data";
const Inspect = "asset/a/asset/inspect/data";
const AssetReceive = "asset/a/asset/assetReceive/data";
const FacilityLease = "asset/a/asset/facilityLease/data";
const PropertyChange = "asset/a/asset/propertyChange/data";
const PropertyChangeRecord = "asset/a/asset/propertyChangeRecord/data";
const CheckPlan = "asset/a/asset/checkPlan/data";
const CheckPlanDetails = "asset/a/asset/checkPlan/detail";
const AssetWithdrawing = "asset/a/asset/assetWithdrawing/data";
const AssetStorage = "asset/a/asset/assetStorage/data";
const DiscardedDisposal = "asset/a/asset/discardedDisposal/data";
const AssetsUseRecord = "asset/a/asset/assetsUseRecord/data";
const FacilityRent = "asset/a/asset/facilityRent/data";
const AssessRecord = "asset/a/asset/assessRecord/data";
const HouseLease = "asset/a/asset/houseLease/data";
const Subconractor = "asset/a/asset/subconractor/data";
const RepairPlan = "asset/a/asset/repairPlan/data";
const RepairRecord = "asset/a/asset/repairRecord/data";
const SingleBus = "asset/a/asset/singleBus/data";
const OilWear = "asset/a/asset/oilWear/data";
const FuelStandard = "asset/a/asset/fuelStandard/data";
const InsuranceRegister = "asset/a/asset/insuranceRegister/data";
const AccidentRegister = "asset/a/asset/accidentRegister/data";
const EmployeePapers = "asset/a/asset/employeePapers/data";
const FacilityPapers = "asset/a/asset/facilityPapers/data";
const PapersFile = "asset/a/asset/papersFile/data";
const PapersType = "asset/a/asset/papersType/data";
const RevolvingMaterrial = "asset/a/asset/revolvingMaterrial/data";
const MeterialType = "asset/a/asset/meterialType/data";
const MeterialInspect = "asset/a/asset/meterialInspect/data";
const MaterrialReceive = "asset/a/asset/materrialReceive/data";
const MaterialLease = "asset/a/asset/materialLease/data";
const MaterialRent = "asset/a/asset/materialRent/data";
const MaterialClear = "asset/a/asset/materialClear/data";
const MaterialAmortize = "asset/a/asset/materialAmortize/data";
const Consumable = "asset/a/asset/consumable/data";
const ConsumableInspect = "asset/a/asset/consumableInspect/data";
const ConsumableReceive = "asset/a/asset/consumableReceive/data";
const FixedAssets = "asset/a/asset/assets/data?kindAsset=2";
const QrCode = "asset/a/asset/qrCode/data";
const CheckTask = "asset/a/asset/assets/view/qrCode/";
const CheckSave = "asset/a/asset/checkPlan/save";
const Upload = "asset/a/sys/file/webupload/upload?uploadPath=/asset/checkPlan";
@Injectable({
  providedIn: "root"
})
export class APIService {
  constructor(public http: HttpClient) {}
  basePost(url, param) {
    var form_data = new URLSearchParams();

    for (var key in param) {
      form_data.set(key, param[key]);
    }

    return this.http.post<any>(url, form_data.toString(), {
      headers: new HttpHeaders({
        "Content-Type": "application/x-www-form-urlencoded;charset=utf-8"
      })
    });
  }
  complexPost(url, obj) {
    const formData = convertModelToUrlData(obj);
    return this.http.post<any>(url, formData.toString(), {
      headers: new HttpHeaders({
        "Content-Type": "application/x-www-form-urlencoded;charset=utf-8"
      })
    });
  }

  upload(data: FormData, path: string) {
    return this.http.post<any>(Upload, data, {
      params: { uploadPath: path },
      headers: new HttpHeaders({ "Content-Type": "multipart/form-data;" })
    });
  }

  getCheckTask(id): Observable<any> {
    return this.http.post<any>(CheckTask + id, {});
  }
  getCheckTaskText(id, detailId): Observable<any> {
    return this.http.post<any>(CheckTask + id + "/" + detailId, {});
  }

  addCheckPlan(obj): Observable<any> {
    return this.complexPost(CheckSave, obj);
  }
  getQrCodeList(param): Observable<any> {
    return this.basePost(QrCode, param);
  }
  getFixedAssetsList(param): Observable<any> {
    return this.basePost(FixedAssets, param);
  }
  getMessageInformList(param): Observable<any> {
    return this.basePost(MessageInform, param);
  }
  getWarningList(param): Observable<any> {
    return this.basePost(Warning, param);
  }
  getHouseList(param): Observable<any> {
    return this.basePost(House, param);
  }
  getAssetTypeList(param): Observable<any> {
    return this.basePost(AssetType, param);
  }
  getAssetDepreciationRecordList(param): Observable<any> {
    return this.basePost(AssetDepreciationRecord, param);
  }
  getSpecialFaultRecordList(param): Observable<any> {
    return this.basePost(SpecialFaultRecord, param);
  }
  getSpecialFaultList(param): Observable<any> {
    return this.basePost(SpecialFault, param);
  }
  getCheckRecordList(param): Observable<any> {
    return this.basePost(CheckRecord, param);
  }
  getAnlageList(param): Observable<any> {
    return this.basePost(Anlage, param);
  }
  getCustomFieldList(param): Observable<any> {
    return this.basePost(CustomField, param);
  }
  getAuxiliaryFacilityList(param): Observable<any> {
    return this.basePost(AuxiliaryFacility, param);
  }
  getBuyApplyList(param): Observable<any> {
    return this.basePost(BuyApply, param);
  }
  getBuyContractList(param): Observable<any> {
    return this.basePost(BuyContract, param);
  }
  getBuyPayList(param): Observable<any> {
    return this.basePost(BuyPay, param);
  }
  getInspectList(param): Observable<any> {
    return this.basePost(Inspect, param);
  }
  getAssetReceiveList(param): Observable<any> {
    return this.basePost(AssetReceive, param);
  }
  getFacilityLeaseList(param): Observable<any> {
    return this.basePost(FacilityLease, param);
  }
  getPropertyChangeList(param): Observable<any> {
    return this.basePost(PropertyChange, param);
  }
  getPropertyChangeRecordList(param): Observable<any> {
    return this.basePost(PropertyChangeRecord, param);
  }
  getCheckPlanList(param): Observable<any> {
    return this.basePost(CheckPlan, param);
  }
  getCheckPlanDetails(param): Observable<any> {
    return this.basePost(CheckPlanDetails, param);
  }
  getAssetWithdrawingList(param): Observable<any> {
    return this.basePost(AssetWithdrawing, param);
  }
  getAssetStorageList(param): Observable<any> {
    return this.basePost(AssetStorage, param);
  }
  getDiscardedDisposalList(param): Observable<any> {
    return this.basePost(DiscardedDisposal, param);
  }
  getAssetsUseRecordList(param): Observable<any> {
    return this.basePost(AssetsUseRecord, param);
  }
  getFacilityRentList(param): Observable<any> {
    return this.basePost(FacilityRent, param);
  }
  getAssessRecordList(param): Observable<any> {
    return this.basePost(AssessRecord, param);
  }
  getHouseLeaseList(param): Observable<any> {
    return this.basePost(HouseLease, param);
  }
  getSubconractorList(param): Observable<any> {
    return this.basePost(Subconractor, param);
  }
  getRepairPlanList(param): Observable<any> {
    return this.basePost(RepairPlan, param);
  }
  getRepairRecordList(param): Observable<any> {
    return this.basePost(RepairRecord, param);
  }
  getSingleBusList(param): Observable<any> {
    return this.basePost(SingleBus, param);
  }
  getOilWearList(param): Observable<any> {
    return this.basePost(OilWear, param);
  }
  getFuelStandardList(param): Observable<any> {
    return this.basePost(FuelStandard, param);
  }
  getInsuranceRegisterList(param): Observable<any> {
    return this.basePost(InsuranceRegister, param);
  }
  getAccidentRegisterList(param): Observable<any> {
    return this.basePost(AccidentRegister, param);
  }
  getEmployeePapersList(param): Observable<any> {
    return this.basePost(EmployeePapers, param);
  }
  getFacilityPapersList(param): Observable<any> {
    return this.basePost(FacilityPapers, param);
  }
  getPapersFileList(param): Observable<any> {
    return this.basePost(PapersFile, param);
  }
  getPapersTypeList(param): Observable<any> {
    return this.basePost(PapersType, param);
  }
  getRevolvingMaterrialList(param): Observable<any> {
    return this.basePost(RevolvingMaterrial, param);
  }
  getMeterialTypeList(param): Observable<any> {
    return this.basePost(MeterialType, param);
  }
  getMeterialInspectList(param): Observable<any> {
    return this.basePost(MeterialInspect, param);
  }
  getMaterrialReceiveList(param): Observable<any> {
    return this.basePost(MaterrialReceive, param);
  }
  getMaterialLeaseList(param): Observable<any> {
    return this.basePost(MaterialLease, param);
  }
  getMaterialRentList(param): Observable<any> {
    return this.basePost(MaterialRent, param);
  }
  getMaterialClearList(param): Observable<any> {
    return this.basePost(MaterialClear, param);
  }
  getMaterialAmortizeList(param): Observable<any> {
    return this.basePost(MaterialAmortize, param);
  }
  getConsumableList(param): Observable<any> {
    return this.basePost(Consumable, param);
  }
  getConsumableInspectList(param): Observable<any> {
    return this.basePost(ConsumableInspect, param);
  }
  getConsumableReceiveList(param): Observable<any> {
    return this.basePost(ConsumableReceive, param);
  }
}
