import { NgModule } from "@angular/core";
import { Routes, RouterModule, PreloadAllModules } from "@angular/router";

// layout
import { LayoutDefaultComponent } from "../layout/default/default.component";
import { LayoutFullScreenComponent } from "../layout/fullscreen/fullscreen.component";
import { LayoutPassportComponent } from "../layout/passport/passport.component";
import { AuthGuardService } from "../auth-guard.service";
import { UserLoginComponent } from "../layout/passport/login/login.component";
import { environment } from "src/environments/environment";
import { ExceptionComponent } from "./exception/exception.component";

const routes: Routes = [
  {
    path: "admin",
    component: LayoutFullScreenComponent,
    children: [
      {
        path: "",
        redirectTo: "home",
        pathMatch: "full"
      },
      {
        path: "home",
        component: LayoutDefaultComponent,
        canActivate: [AuthGuardService]
      },
      // 盘点
      {
        path: "check",
        loadChildren: "./check/check.module#CheckModule",
        canActivate: [AuthGuardService]
      },

      //  消息中心
      {
        path: "message",
        loadChildren: "./message/message.module#MessageModule",
        canActivate: [AuthGuardService]
      },

      // 资产
      {
        path: "assets",
        loadChildren: "./assets/assets.module#AssetsModule",
        canActivate: [AuthGuardService]
      },
      // 资产信息
      {
        path: "assets-info",
        loadChildren:
          "./assets/assets-info/assets-info.module#AssetsInfoModule",
        canActivate: [AuthGuardService]
      },
      // 资产使用
      {
        path: "assets-used",
        loadChildren:
          "./assets/assets-used/assets-used.module#AssetsUsedModule",
        canActivate: [AuthGuardService]
      },
      // 周转材料
      {
        path: "lowCostMaterial",
        loadChildren:
          "./assets/lowCostMaterial/lowCostMaterial.module#LowCostMaterialModule",
        canActivate: [AuthGuardService]
      },
      // 证件
      {
        path: "cet",
        loadChildren: "./assets/cet/cet.module#CetModule",
        canActivate: [AuthGuardService]
      },
      // 证件
      {
        path: "lease",
        loadChildren: "./lease/lease.module#LeaseModule",
        canActivate: [AuthGuardService]
      },
      // // 其他资产
      {
        path: "others",
        loadChildren: "./assets/others/other.module#OtherModule",
        canActivate: [AuthGuardService]
      },
      // 单机车
      {
        path: "single",
        loadChildren: "./assets/single/single.module#SingleModule",
        canActivate: [AuthGuardService]
      },
      //
      // 统计
      {
        path: "data",
        loadChildren: "./data/data.module#DataModule",
        canActivate: [AuthGuardService]
      },

      // 我的
      {
        path: "user",
        loadChildren: "./user/user.module#UserModule",
        canActivate: [AuthGuardService]
      }
    ]
  },
  {
    path: "",
    redirectTo: "admin/home",
    pathMatch: "full"
  },
  {
    path: "admin/home",
    component: LayoutDefaultComponent
  },
  // passport
  {
    path: "passport",
    component: LayoutPassportComponent,
    children: [
      {
        path: "login",
        component: UserLoginComponent,
        data: { title: "登录", titleI18n: "app.login.login" }
      }
    ]
  },
  { path: "exception/:type", component: ExceptionComponent },
  { path: "**", redirectTo: "exception/404" }
];

@NgModule({
  imports: [
    RouterModule.forRoot(routes, {
      useHash: environment.useHash,
      // NOTICE: If you use `reuse-tab` component and turn on keepingScroll you can set to `disabled`
      // Pls refer to https://ng-alain.com/components/reuse-tab
      scrollPositionRestoration: "top",
      preloadingStrategy: PreloadAllModules
    })
  ],
  exports: [RouterModule]
})
export class RouteRoutingModule {}
