import { Component, OnInit } from '@angular/core';
import { FormGroup ,FormControl} from '@angular/forms';
import { Router,ActivatedRoute } from '@angular/router';
const extra = {
  '2017/07/15': { info: 'Disable', disable: true }
};

const now = new Date();
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 5)] = { info: 'Disable', disable: true };
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 6)] = { info: 'Disable', disable: true };
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 7)] = { info: 'Disable', disable: true };
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 8)] = { info: 'Disable', disable: true };

for (let key in extra) {
  if (extra.hasOwnProperty(key)) {
    let info = extra[key];
    const date = new Date(key);
    if (!Number.isNaN(+date) && !extra[+date]) {
      extra[+date] = info;
    }
  }
}

@Component({
  selector: 'app-agent',
  templateUrl: './agent.component.html',
  styleUrls: ['./agent.component.less']
})
export class  AgentComponent implements OnInit {
  constructor(private router:Router,private activatedRoute:ActivatedRoute) { }
    
      renderFooter: Function;
      search:any={};
      currentDateKey:string="";
  
 
  state: any = {
    en: false,
    date: null,
    show: false,
    pickTime: false,
    now: new Date(),
    type: 'range',
    enterDirection: '',
    rowSize: 'normal',
    showShortcut: false,
    infinite: true,
    defaultValue: undefined,
    minDate: new Date(+now - 5184000000),
    maxDate: new Date(+now + 31536000000),
    onSelect: undefined,
    getDateExtra: date => {
      return extra[+date];
    }
  };
 
    ngOnInit() {
    this.renderFooter = this.bindRenderFooter.bind(this);
  }
   bindRenderFooter() {
    return  '';
  }
  doSearch(search){
   console.log(search);
  }
  onReset(){
    this.search={};
  }
  goDetail(){
this.router.navigate(['../agentDetail'], {relativeTo: this.activatedRoute});
  }
   showDate(key:string) {
    this.currentDateKey=key;
    this.initPara();
    this.state.show = true;
  }
  triggerConfirm(value) {

     this.search[this.currentDateKey+"0"]=value.startDate;
     this.search[this.currentDateKey+"1"]=value.endDate;
     this.search[this.currentDateKey]=value.startDate.toLocaleDateString() + " ~ " + value.endDate.toLocaleDateString();
    this.triggerCancel();
  }
   triggerCancel() {
    this.state.show = false;
  }

initPara() {
    this.state = {
      ...this.state,
      ...{
        show: false,
        date: null,
        pickTime: false,
        now: new Date(),
        type: 'range',
        rowSize: 'normal',
        infinite: true,
        enterDirection: '',
        onSelect: undefined,
        showShortcut: false,
        defaultValue: undefined,
        minDate: new Date(+now - 5184000000),
        maxDate: new Date(+now + 31536000000),
        getDateExtra: date => {
          return extra[+date];
        }
      }
    };
  }
}
