
import { NgModule } from "@angular/core";
import { Routes, RouterModule } from '@angular/router';

 import {  ProcessComponent } from "./tran/process/process.component";
import {  ProcessDetailComponent } from "./tran/process/detail/process.component";
import {  AgentComponent } from "./tran/agent/agent.component";
import {  AgentDetailComponent } from "./tran/agent/detail/agent.component";
import {  DoneComponent } from "./tran/done/done.component";
import {  DoneDetailComponent } from "./tran/done/detail/done.component";
import {  InspecComponent } from "./tran/inspec/inspec.component";
import {  InspecDetailComponent } from "./tran/inspec/detail/inspec.component";
import {  MessageInformComponent } from "./info/messageInform/message-inform.component";
import {  MessageInformDetailComponent } from "./info/messageInform/detail/message-inform.component";
import {  WarningComponent } from "./info/warning/warning.component";
import {  WarningDetailComponent } from "./info/warning/detail/warning.component";



const routes: Routes = [
  {
    "path": "tran",
    "children": [
      {
        "path": "process",
        "component": ProcessComponent,
        "data": {
          "title": "我启动的流程"
        }
      },
      {
        "path": "agent",
        "component": AgentComponent,
        "data": {
          "title": "我的代办流程"
        }
      },
      {
        "path": "done",
        "component": DoneComponent,
        "data": {
          "title": "我的已办流程"
        }
      },
      {
        "path": "inspec",
        "component": InspecComponent,
        "data": {
          "title": "流程监督"
        }
      },
      {
        "path": "processDetail",
        "component": ProcessDetailComponent,
        "data": {
          "title": "我启动的流程详情"
        }
      },
      {
        "path": "agentDetail",
        "component": AgentDetailComponent,
        "data": {
          "title": "我的代办流程详情"
        }
      },
      {
        "path": "doneDetail",
        "component": DoneDetailComponent,
        "data": {
          "title": "我的已办流程详情"
        }
      },
      {
        "path": "inspecDetail",
        "component": InspecDetailComponent,
        "data": {
          "title": "流程监督详情"
        }
      }
    ]
  },
  {
    "path": "info",
    "children": [
      {
        "path": "messageInform",
        "component": MessageInformComponent,
        "data": {
          "title": "消息通知"
        }
      },
      {
        "path": "warning",
        "component": WarningComponent,
        "data": {
          "title": "预警中心"
        }
      },
      {
        "path": "messageInformDetail",
        "component": MessageInformDetailComponent,
        "data": {
          "title": "消息通知详情"
        }
      },
      {
        "path": "warningDetail",
        "component": WarningDetailComponent,
        "data": {
          "title": "预警中心详情"
        }
      }
    ]
  },
  {
    "children": []
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class MessageRoutingModule {}
