import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";
import { FacilityRentComponent } from "./facilityRent/facility-rent.component";
import { AssessRecordComponent } from "./assessRecord/assess-record.component";
import { HouseLeaseComponent } from "./houseLease/house-lease.component";
import { SubconractorComponent } from "./subconractor/subconractor.component";
import { FacilityRentDetailComponent } from "./facilityRent/detail/facility-rent.component";
import { AssessRecordDetailComponent } from "./assessRecord/detail/assess-record.component";
import { HouseLeaseDetailComponent } from "./houseLease/detail/house-lease.component";
import { SubconractorDetailComponent } from "./subconractor/detail/subconractor.component";

const routes: Routes = [
  {
    path: "facilityRent",
    component: FacilityRentComponent,
    data: {
      title: "外租设备"
    }
  },
  {
    path: "assessRecord",
    component: AssessRecordComponent,
    data: {
      title: "租入设备考核"
    }
  },
  {
    path: "houseLease",
    component: HouseLeaseComponent,
    data: {
      title: "房屋租赁"
    }
  },
  {
    path: "subconractor",
    component: SubconractorComponent,
    data: {
      title: "分包商及租入特种设备"
    }
  },
  {
    path: "facilityRentDetail",
    component: FacilityRentDetailComponent,
    data: {
      title: "外租设备详情"
    }
  },
  {
    path: "assessRecordDetail",
    component: AssessRecordDetailComponent,
    data: {
      title: "租入设备考核详情"
    }
  },
  {
    path: "houseLeaseDetail",
    component: HouseLeaseDetailComponent,
    data: {
      title: "房屋租赁详情"
    }
  },
  {
    path: "subconractorDetail",
    component: SubconractorDetailComponent,
    data: {
      title: "分包商及租入特种设备详情"
    }
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class LeaseRoutingModule {}
