import { Component, Input, OnChanges } from "@angular/core";
import { CODEMESSAGE } from "src/app/layout/default.interceptor";
import { Location } from "@angular/common";
import { ActivatedRoute, Router } from "@angular/router";

@Component({
  selector: "exception",
  template: `
    <Result
      [message]="message1"
      [title]="type"
      [buttonText]="'返回上一页'"
      [buttonType]="'primary'"
      (onButtonClick)="clickCallback()"
    >
      <ng-template #message1>
        <div>{{ message }}</div>
      </ng-template>
    </Result>
  `,
  styles: [
    `
      /deep/ Result {
        height: 100vh;
        box-sizing: border-box;
      }

      /deep/ .am-result-title {
        font-size: 100px !important;
        font-family: serif;
        color: #bcbcbc !important;
        margin-top: 0 !important;
      }
    `
  ]
})
export class ExceptionComponent {
  type: string;
  message = "";
  constructor(
    private location: Location,
    private routeInfo: ActivatedRoute,
    private router: Router
  ) {
    this.type = routeInfo.snapshot.params["type"];
    if (this.type) {
      this.message = CODEMESSAGE[this.type];
      console.log(CODEMESSAGE["403"]);
      console.log(this.message + "----------------");
    }
  }
  clickCallback() {
    this.router.navigateByUrl("/admin/home");
  }
}
