import { Component, OnInit, OnDestroy, AfterViewInit } from "@angular/core";
import { Router } from "@angular/router";
import { Toast } from "ng-zorro-antd-mobile";
import { BarcodeScanner } from "@ionic-native/barcode-scanner/ngx";
@Component({
  selector: "app-qr-scan",
  templateUrl: "./qr-scan.component.html",
  styleUrls: ["./qr-scan.component.scss"]
})
export class QrScanComponent implements OnInit, OnDestroy, AfterViewInit {
  constructor(
    private router: Router,
    private toast: Toast,
    private barcodeScanner: BarcodeScanner
  ) {}
  ngOnInit(): void {
    // let options: ZBarOptions = {
    //   flash: "off",
    //   drawSight: false
    // };

    // this.zbar
    //   .scan(options)
    //   .then(result => {
    //     console.log(result); // Scanned code
    //     const id = result.match(/(\w+)$/g)[0];
    //     console.log(id);
    //     this.loadingToast(id);
    //   })
    //   .catch(error => {
    //     console.log(error); // Error message
    //     this.showToast();
    //   });
    this.barcodeScanner
      .scan()
      .then(result => {
        console.log("Barcode data", result);
        const id = result.text.match(/(\w+)$/g)[0];
        console.log(id);
        this.loadingToast(id);
      })
      .catch(err => {
        console.log("Error", err);
        this.showToast();
      });
  }
  ngAfterViewInit(): void {}
  showToast() {
    const toast = Toast.show("扫描出错", 0);
    setTimeout(() => {
      Toast.hide();
    }, 3000);
  }
  loadingToast(id) {
    const toast = Toast.loading("Loading...", 1000, () => {
      console.log("Load complete !!!");
      this.router.navigate(["/admin/assets-used/checkPlanAdd", id]);
    });
  }
  ngOnDestroy() {}
}
