import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";
import { SingleBusComponent } from "./singleBus/single-bus.component";
import { OilWearComponent } from "./oilWear/oil-wear.component";
import { FuelStandardComponent } from "./fuelStandard/fuel-standard.component";
import { SingleBusDetailComponent } from "./singleBus/detail/single-bus.component";
import { OilWearDetailComponent } from "./oilWear/detail/oil-wear.component";
import { FuelStandardDetailComponent } from "./fuelStandard/detail/fuel-standard.component";

const routes: Routes = [
  {
    path: "singleBus",
    component: SingleBusComponent,
    data: {
      title: "单机车核算"
    }
  },
  {
    path: "oilWear",
    component: OilWearComponent,
    data: {
      title: "燃料消耗记录"
    }
  },
  {
    path: "fuelStandard",
    component: FuelStandardComponent,
    data: {
      title: "机械设备燃料核算标准"
    }
  },
  {
    path: "singleBusDetail",
    component: SingleBusDetailComponent,
    data: {
      title: "单机车核算详情"
    }
  },
  {
    path: "oilWearDetail",
    component: OilWearDetailComponent,
    data: {
      title: "燃料消耗记录详情"
    }
  },
  {
    path: "fuelStandardDetail",
    component: FuelStandardDetailComponent,
    data: {
      title: "机械设备燃料核算标准详情"
    }
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class SingleRoutingModule {}
