import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";
import { InvestmentComponent } from "./investment/investment.component";
import { LandComponent } from "./land/land.component";
import { SoftAssetComponent } from "./softAsset/soft-asset.component";
import { PatternComponent } from "./pattern/pattern.component";
import { InvestmentDetailComponent } from "./investment/detail/investment.component";
import { LandDetailComponent } from "./land/detail/land.component";
import { SoftAssetDetailComponent } from "./softAsset/detail/soft-asset.component";
import { PatternDetailComponent } from "./pattern/detail/pattern.component";

const routes: Routes = [
  {
    path: "investment",
    component: InvestmentComponent,
    data: {
      title: "投资管理"
    }
  },
  {
    path: "land",
    component: LandComponent,
    data: {
      title: "土地"
    }
  },
  {
    path: "softAsset",
    component: SoftAssetComponent,
    data: {
      title: "软件"
    }
  },
  {
    path: "pattern",
    component: PatternComponent,
    data: {
      title: "专利"
    }
  },
  {
    path: "investmentDetail",
    component: InvestmentDetailComponent,
    data: {
      title: "投资管理详情"
    }
  },
  {
    path: "landDetail",
    component: LandDetailComponent,
    data: {
      title: "土地详情"
    }
  },
  {
    path: "softAssetDetail",
    component: SoftAssetDetailComponent,
    data: {
      title: "软件详情"
    }
  },
  {
    path: "patternDetail",
    component: PatternDetailComponent,
    data: {
      title: "专利详情"
    }
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class OtherRoutingModule {}
