import { Component, OnInit } from "@angular/core";
import { FormGroup, FormControl } from "@angular/forms";
import { Router, ActivatedRoute } from "@angular/router";
import { APIService } from "src/app/service/layout/service/api.service";
import { capitalize } from "src/app/layout/service/util.service";
const extra = {
  "2017/07/15": { info: "Disable", disable: true }
};

const now = new Date();
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 5)] = {
  info: "Disable",
  disable: true
};
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 6)] = {
  info: "Disable",
  disable: true
};
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 7)] = {
  info: "Disable",
  disable: true
};
extra[+new Date(now.getFullYear(), now.getMonth(), now.getDate() + 8)] = {
  info: "Disable",
  disable: true
};

for (let key in extra) {
  if (extra.hasOwnProperty(key)) {
    let info = extra[key];
    const date = new Date(key);
    if (!Number.isNaN(+date) && !extra[+date]) {
      extra[+date] = info;
    }
  }
}

@Component({
  selector: "app-meterial-type",
  templateUrl: "./meterial-type.component.html",
  styleUrls: ["./meterial-type.component.less"]
})
export class MeterialTypeComponent implements OnInit {
  constructor(
    private router: Router,
    private activatedRoute: ActivatedRoute,
    private api: APIService
  ) {}

  renderFooter: Function;
  renderHeader: Function;
  search: any = {};
  table: any = { rows: [] };
  currentDateKey: string = "";

  state: any = {
    en: false,
    date: null,
    show: false,
    pickTime: false,
    now: new Date(),
    type: "range",
    enterDirection: "",
    rowSize: "normal",
    showShortcut: false,
    infinite: true,
    defaultValue: undefined,
    minDate: new Date(+now - 5184000000),
    maxDate: new Date(+now + 31536000000),
    onSelect: undefined,
    getDateExtra: date => {
      return extra[+date];
    }
  };

  ngOnInit() {
    this.renderFooter = this.bindRenderFooter.bind(this);
    this.renderHeader = this.bindRenderHeader.bind(this);
    this.loadData(this.search);
  }
  bindRenderFooter() {
    return " ";
  }
  bindRenderHeader() {
    return "搜索";
  }
  doSearch(search) {
    this.loadData(search);
  }
  inputChange($event, key, orgKey) {
    console.log($event);
    var index = this[key + "Dic"].indexOf($event[0]);
    this.search[orgKey] = index;
  }
  onReset() {
    this.search = {};
  }
  goDetail(id) {
    this.router.navigate(["../meterialTypeDetail", { id: id }], {
      relativeTo: this.activatedRoute
    });
  }
  showDate(key: string) {
    this.currentDateKey = key;
    this.initPara();
    this.state.show = true;
  }
  triggerConfirm(value) {
    this.search[
      `begin${capitalize(this.currentDateKey)}`
    ] = value.startDate.toLocaleDateString().replace(/\//g, "-");
    this.search[
      `end${capitalize(this.currentDateKey)}`
    ] = value.endDate.toLocaleDateString().replace(/\//g, "-");
    this.search[this.currentDateKey] =
      value.startDate.toLocaleDateString() +
      " ~ " +
      value.endDate.toLocaleDateString();
    this.triggerCancel();
  }
  triggerCancel() {
    this.state.show = false;
  }
  loadData(search) {
    this.api.getMeterialTypeList(search).subscribe(data => {
      this.table = data;
    });
  }
  initPara() {
    this.state = {
      ...this.state,
      ...{
        show: false,
        date: null,
        pickTime: false,
        now: new Date(),
        type: "range",
        rowSize: "normal",
        infinite: true,
        enterDirection: "",
        onSelect: undefined,
        showShortcut: false,
        defaultValue: undefined,
        minDate: new Date(+now - 5184000000),
        maxDate: new Date(+now + 31536000000),
        getDateExtra: date => {
          return extra[+date];
        }
      }
    };
  }
}
