import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";
import { RevolvingMaterrialComponent } from "./revolvingMaterrial/revolving-materrial.component";
import { MeterialTypeComponent } from "./meterialType/meterial-type.component";
import { MeterialInspectComponent } from "./meterialInspect/meterial-inspect.component";
import { MaterrialReceiveComponent } from "./materrialReceive/materrial-receive.component";
import { MaterialLeaseComponent } from "./materialLease/material-lease.component";
import { MaterialRentComponent } from "./materialRent/material-rent.component";
import { MaterialClearComponent } from "./materialClear/material-clear.component";
import { MaterialAmortizeComponent } from "./materialAmortize/material-amortize.component";
import { RevolvingMaterrialDetailComponent } from "./revolvingMaterrial/detail/revolving-materrial.component";
import { MeterialTypeDetailComponent } from "./meterialType/detail/meterial-type.component";
import { MeterialInspectDetailComponent } from "./meterialInspect/detail/meterial-inspect.component";
import { MaterrialReceiveDetailComponent } from "./materrialReceive/detail/materrial-receive.component";
import { MaterialLeaseDetailComponent } from "./materialLease/detail/material-lease.component";
import { MaterialRentDetailComponent } from "./materialRent/detail/material-rent.component";
import { MaterialClearDetailComponent } from "./materialClear/detail/material-clear.component";
import { MaterialAmortizeDetailComponent } from "./materialAmortize/detail/material-amortize.component";
import { ConsumableComponent } from "../lowCost/consumable/consumable.component";
import { ConsumableInspectComponent } from "../lowCost/consumableInspect/consumable-inspect.component";
import { ConsumableReceiveComponent } from "../lowCost/consumableReceive/consumable-receive.component";
import { ConsumableDetailComponent } from "../lowCost/consumable/detail/consumable.component";
import { ConsumableInspectDetailComponent } from "../lowCost/consumableInspect/detail/consumable-inspect.component";
import { ConsumableReceiveDetailComponent } from "../lowCost/consumableReceive/detail/consumable-receive.component";

const routes: Routes = [
  {
    path: "revolvingMaterrial",
    component: RevolvingMaterrialComponent,
    data: {
      title: "周转材料台账"
    }
  },
  {
    path: "meterialType",
    component: MeterialTypeComponent,
    data: {
      title: "周转材料分类"
    }
  },
  {
    path: "meterialInspect",
    component: MeterialInspectComponent,
    data: {
      title: "周转材料验收"
    }
  },
  {
    path: "materrialReceive",
    component: MaterrialReceiveComponent,
    data: {
      title: "周转材料领用"
    }
  },
  {
    path: "materialLease",
    component: MaterialLeaseComponent,
    data: {
      title: "周转材料租出"
    }
  },
  {
    path: "materialRent",
    component: MaterialRentComponent,
    data: {
      title: "周转材料租入"
    }
  },
  {
    path: "materialClear",
    component: MaterialClearComponent,
    data: {
      title: "周转材料清理"
    }
  },
  {
    path: "materialAmortize",
    component: MaterialAmortizeComponent,
    data: {
      title: "周转材料核算、摊销"
    }
  },
  {
    path: "revolvingMaterrialDetail",
    component: RevolvingMaterrialDetailComponent,
    data: {
      title: "周转材料台账详情"
    }
  },
  {
    path: "meterialTypeDetail",
    component: MeterialTypeDetailComponent,
    data: {
      title: "周转材料分类详情"
    }
  },
  {
    path: "meterialInspectDetail",
    component: MeterialInspectDetailComponent,
    data: {
      title: "周转材料验收详情"
    }
  },
  {
    path: "materrialReceiveDetail",
    component: MaterrialReceiveDetailComponent,
    data: {
      title: "周转材料领用详情"
    }
  },
  {
    path: "materialLeaseDetail",
    component: MaterialLeaseDetailComponent,
    data: {
      title: "周转材料租出详情"
    }
  },
  {
    path: "materialRentDetail",
    component: MaterialRentDetailComponent,
    data: {
      title: "周转材料租入详情"
    }
  },
  {
    path: "materialClearDetail",
    component: MaterialClearDetailComponent,
    data: {
      title: "周转材料清理详情"
    }
  },
  {
    path: "materialAmortizeDetail",
    component: MaterialAmortizeDetailComponent,
    data: {
      title: "周转材料核算、摊销详情"
    }
  },
  {
    path: "consumable",
    component: ConsumableComponent,
    data: {
      title: "低值易耗台账"
    }
  },
  {
    path: "consumableInspect",
    component: ConsumableInspectComponent,
    data: {
      title: "低值易耗验收"
    }
  },
  {
    path: "consumableReceive",
    component: ConsumableReceiveComponent,
    data: {
      title: "低值易耗领用"
    }
  },
  {
    path: "consumableDetail",
    component: ConsumableDetailComponent,
    data: {
      title: "低值易耗台账详情"
    }
  },
  {
    path: "consumableInspectDetail",
    component: ConsumableInspectDetailComponent,
    data: {
      title: "低值易耗验收详情"
    }
  },
  {
    path: "consumableReceiveDetail",
    component: ConsumableReceiveDetailComponent,
    data: {
      title: "低值易耗领用详情"
    }
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class LowCostMaterialRoutingModule {}
