import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";
import { EmployeePapersComponent } from "./employeePapers/employee-papers.component";
import { FacilityPapersComponent } from "./facilityPapers/facility-papers.component";
import { PapersFileComponent } from "./papersFile/papers-file.component";
import { PapersTypeComponent } from "./papersType/papers-type.component";
import { EmployeePapersDetailComponent } from "./employeePapers/detail/employee-papers.component";
import { FacilityPapersDetailComponent } from "./facilityPapers/detail/facility-papers.component";
import { PapersFileDetailComponent } from "./papersFile/detail/papers-file.component";
import { PapersTypeDetailComponent } from "./papersType/detail/papers-type.component";

const routes: Routes = [
  {
    path: "cet",
    children: [
      {
        path: "employeePapers",
        component: EmployeePapersComponent,
        data: {
          title: "人员证件"
        }
      },
      {
        path: "facilityPapers",
        component: FacilityPapersComponent,
        data: {
          title: "设备证件"
        }
      },
      {
        path: "papersFile",
        component: PapersFileComponent,
        data: {
          title: "用户证件附件(待删)"
        }
      },
      {
        path: "papersType",
        component: PapersTypeComponent,
        data: {
          title: "证件类型(待删)"
        }
      },
      {
        path: "employeePapersDetail",
        component: EmployeePapersDetailComponent,
        data: {
          title: "人员证件详情"
        }
      },
      {
        path: "facilityPapersDetail",
        component: FacilityPapersDetailComponent,
        data: {
          title: "设备证件详情"
        }
      },
      {
        path: "papersFileDetail",
        component: PapersFileDetailComponent,
        data: {
          title: "用户证件附件(待删)详情"
        }
      },
      {
        path: "papersTypeDetail",
        component: PapersTypeDetailComponent,
        data: {
          title: "证件类型(待删)详情"
        }
      }
    ]
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class CetRoutingModule {}
