import { Component, OnInit } from "@angular/core";
import { Router, ActivatedRoute } from "@angular/router";
import { switchMap } from "rxjs/operators";
import { Modal } from "ng-zorro-antd-mobile";
import { APIService } from "src/app/service/layout/service/api.service";

@Component({
  selector: "app-check-plan-detail",
  templateUrl: "./check-plan.component.html",
  styleUrls: ["./check-plan.component.less"]
})
export class CheckPlanDetailComponent implements OnInit {
  constructor(
    private router: ActivatedRoute,
    private _modal: Modal,
    private api: APIService
  ) {}
  data: any = {};
  detail: any = {};
  id = null;
  ngOnInit() {
    this.router.params
      .pipe(
        switchMap(param => {
          this.id = param.id;
          return this.api.getCheckTask(param.id);
        })
      )
      .subscribe((data: any) => {
        this.data = data;

        if (data.success) {
          Modal.operation(
            data.body.checkList.map(c => ({
              text: c.name,
              onPress: () =>
                this.api
                  .getCheckTaskText(this.id, c.id)
                  .subscribe(data => (this.detail = data))
            }))
          );
        }
      });
  }
}
