import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";
import { BuyApplyComponent } from "./buyApply/buy-apply.component";
import { BuyContractComponent } from "./buyContract/buy-contract.component";
import { BuyPayComponent } from "./buyPay/buy-pay.component";
import { InspectComponent } from "./inspect/inspect.component";
import { AssetRegisterComponent } from "./assetRegister/asset-register.component";
import { AssetReceiveComponent } from "./assetReceive/asset-receive.component";
import { FacilityLeaseComponent } from "./facilityLease/facility-lease.component";
import { PropertyChangeComponent } from "./propertyChange/property-change.component";
import { PropertyChangeRecordComponent } from "./propertyChangeRecord/property-change-record.component";
import { CheckPlanComponent } from "./checkPlan/check-plan.component";
import { AssetWithdrawingComponent } from "./assetWithdrawing/asset-withdrawing.component";
import { AssetStorageComponent } from "./assetStorage/asset-storage.component";
import { DiscardedDisposalComponent } from "./discardedDisposal/discarded-disposal.component";
import { AssetsUseRecordComponent } from "./assetsUseRecord/assets-use-record.component";
import { BuyApplyDetailComponent } from "./buyApply/detail/buy-apply.component";
import { BuyContractDetailComponent } from "./buyContract/detail/buy-contract.component";
import { BuyPayDetailComponent } from "./buyPay/detail/buy-pay.component";
import { InspectDetailComponent } from "./inspect/detail/inspect.component";
import { AssetRegisterDetailComponent } from "./assetRegister/detail/asset-register.component";
import { AssetReceiveDetailComponent } from "./assetReceive/detail/asset-receive.component";
import { FacilityLeaseDetailComponent } from "./facilityLease/detail/facility-lease.component";
import { PropertyChangeDetailComponent } from "./propertyChange/detail/property-change.component";
import { PropertyChangeRecordDetailComponent } from "./propertyChangeRecord/detail/property-change-record.component";
import { CheckPlanDetailComponent } from "./checkPlan/detail/check-plan.component";
import { AssetWithdrawingDetailComponent } from "./assetWithdrawing/detail/asset-withdrawing.component";
import { AssetStorageDetailComponent } from "./assetStorage/detail/asset-storage.component";
import { DiscardedDisposalDetailComponent } from "./discardedDisposal/detail/discarded-disposal.component";
import { AssetsUseRecordDetailComponent } from "./assetsUseRecord/detail/assets-use-record.component";
import { Modal } from "ng-zorro-antd-mobile";
import { CheckAddComponent } from "./checkPlan/check-add/check-add.component";

const routes: Routes = [
  {
    path: "buyApply",
    component: BuyApplyComponent,
    data: {
      title: "采购申请管理"
    }
  },
  {
    path: "buyContract",
    component: BuyContractComponent,
    data: {
      title: "采购合同管理"
    }
  },
  {
    path: "buyPay",
    component: BuyPayComponent,
    data: {
      title: "采购支付管理"
    }
  },
  {
    path: "inspect",
    component: InspectComponent,
    data: {
      title: "资产验收"
    }
  },
  {
    path: "assetRegister",
    component: AssetRegisterComponent,
    data: {
      title: "注册资产"
    }
  },
  {
    path: "assetReceive",
    component: AssetReceiveComponent,
    data: {
      title: "资产领用"
    }
  },
  {
    path: "facilityLease",
    component: FacilityLeaseComponent,
    data: {
      title: "设备租出"
    }
  },
  {
    path: "propertyChange",
    component: PropertyChangeComponent,
    data: {
      title: "资产人员变更"
    }
  },
  {
    path: "propertyChangeRecord",
    component: PropertyChangeRecordComponent,
    data: {
      title: "资产产权变更"
    }
  },
  {
    path: "checkPlan",
    component: CheckPlanComponent,
    data: {
      title: "资产盘点"
    }
  },
  {
    path: "assetWithdrawing",
    component: AssetWithdrawingComponent,
    data: {
      title: "资产退库"
    }
  },
  {
    path: "assetStorage",
    component: AssetStorageComponent,
    data: {
      title: "资产封存/启封"
    }
  },
  {
    path: "discardedDisposal",
    component: DiscardedDisposalComponent,
    data: {
      title: "资产处置"
    }
  },
  {
    path: "assetsUseRecord",
    component: AssetsUseRecordComponent,
    data: {
      title: "资产使用记录"
    }
  },
  {
    path: "buyApplyDetail",
    component: BuyApplyDetailComponent,
    data: {
      title: "采购申请管理详情"
    }
  },
  {
    path: "buyContractDetail",
    component: BuyContractDetailComponent,
    data: {
      title: "采购合同管理详情"
    }
  },
  {
    path: "buyPayDetail",
    component: BuyPayDetailComponent,
    data: {
      title: "采购支付管理详情"
    }
  },
  {
    path: "inspectDetail",
    component: InspectDetailComponent,
    data: {
      title: "资产验收详情"
    }
  },
  {
    path: "assetRegisterDetail",
    component: AssetRegisterDetailComponent,
    data: {
      title: "注册资产详情"
    }
  },
  {
    path: "assetReceiveDetail",
    component: AssetReceiveDetailComponent,
    data: {
      title: "资产领用详情"
    }
  },
  {
    path: "facilityLeaseDetail",
    component: FacilityLeaseDetailComponent,
    data: {
      title: "设备租出详情"
    }
  },
  {
    path: "propertyChangeDetail",
    component: PropertyChangeDetailComponent,
    data: {
      title: "资产人员变更详情"
    }
  },
  {
    path: "propertyChangeRecordDetail",
    component: PropertyChangeRecordDetailComponent,
    data: {
      title: "资产产权变更详情"
    }
  },
  {
    path: "checkPlanDetail",
    component: CheckPlanDetailComponent,
    data: {
      title: "资产盘点详情"
    }
  },
  {
    path: "checkPlanAdd/:id",
    component: CheckAddComponent,
    data: {
      title: "资产盘点添加"
    }
  },
  {
    path: "assetWithdrawingDetail",
    component: AssetWithdrawingDetailComponent,
    data: {
      title: "资产退库详情"
    }
  },
  {
    path: "assetStorageDetail",
    component: AssetStorageDetailComponent,
    data: {
      title: "资产封存/启封详情"
    }
  },
  {
    path: "discardedDisposalDetail",
    component: DiscardedDisposalDetailComponent,
    data: {
      title: "资产处置详情"
    }
  },
  {
    path: "assetsUseRecordDetail",
    component: AssetsUseRecordDetailComponent,
    data: {
      title: "资产使用记录详情"
    }
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
  providers: [Modal]
})
export class AssetsUsedRoutingModule {}
