import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";
import { RepairPlanComponent } from "./repair/repairPlan/repair-plan.component";
import { RepairPlanDetailComponent } from "./repair/repairPlan/detail/repair-plan.component";
import { RepairRecordComponent } from "./repair/repairRecord/repair-record.component";
import { RepairRecordDetailComponent } from "./repair/repairRecord/detail/repair-record.component";
import { InsuranceRegisterComponent } from "./insurance/insuranceRegister/insurance-register.component";
import { InsuranceRegisterDetailComponent } from "./insurance/insuranceRegister/detail/insurance-register.component";
import { AccidentRegisterComponent } from "./insurance/accidentRegister/accident-register.component";
import { AccidentRegisterDetailComponent } from "./insurance/accidentRegister/detail/accident-register.component";

const routes: Routes = [
  {
    path: "repair",
    children: [
      {
        path: "repairPlan",
        component: RepairPlanComponent,
        data: {
          title: "维修保养计划(待删)"
        }
      },
      {
        path: "repairRecord",
        component: RepairRecordComponent,
        data: {
          title: "维修保养记录(待删)"
        }
      },
      {
        path: "repairPlanDetail",
        component: RepairPlanDetailComponent,
        data: {
          title: "维修保养计划(待删)详情"
        }
      },
      {
        path: "repairRecordDetail",
        component: RepairRecordDetailComponent,
        data: {
          title: "维修保养记录(待删)详情"
        }
      }
    ]
  },
  {
    path: "insurance",
    children: [
      {
        path: "insuranceRegister",
        component: InsuranceRegisterComponent,
        data: {
          title: "保险登记"
        }
      },
      {
        path: "accidentRegister",
        component: AccidentRegisterComponent,
        data: {
          title: "出险登记"
        }
      },
      {
        path: "insuranceRegisterDetail",
        component: InsuranceRegisterDetailComponent,
        data: {
          title: "保险登记详情"
        }
      },
      {
        path: "accidentRegisterDetail",
        component: AccidentRegisterDetailComponent,
        data: {
          title: "出险登记详情"
        }
      }
    ]
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class AssetsRoutingModule {}
