import { NgModule } from "@angular/core";
import { SharedModule } from "src/app/shared";
import { AssetsInfoRoutingModule } from "./assets-info-routing.module";
import { FixedAssetsComponent } from "./fixed-assets/fixed-assets.component";
import { FixedAssetsDetailComponent } from "./fixed-assets/detail/fixed-assets.component";
import { FixedAssets2Component } from "./fixed-assets-2/fixed-assets-2.component";
import { FixedAssets2DetailComponent } from "./fixed-assets-2/detail/fixed-assets-2.component";
import { HouseComponent } from "./house/house.component";
import { HouseDetailComponent } from "./house/detail/house.component";

import { AssetTypeComponent } from "./assetType/asset-type.component";
import { AssetTypeDetailComponent } from "./assetType/detail/asset-type.component";
import { DepreciaComponent } from "./deprecia/deprecia.component";
import { DepreciaDetailComponent } from "./deprecia/detail/deprecia.component";
import { AssetDepreciationRecordComponent } from "./assetDepreciationRecord/asset-depreciation-record.component";
import { AssetDepreciationRecordDetailComponent } from "./assetDepreciationRecord/detail/asset-depreciation-record.component";
import { SpecialFaultRecordComponent } from "./specialFaultRecord/special-fault-record.component";
import { SpecialFaultRecordDetailComponent } from "./specialFaultRecord/detail/special-fault-record.component";
import { SpecialFaultComponent } from "./specialFault/special-fault.component";
import { SpecialFaultDetailComponent } from "./specialFault/detail/special-fault.component";
import { CheckRecordComponent } from "./checkRecord/check-record.component";
import { CheckRecordDetailComponent } from "./checkRecord/detail/check-record.component";
import { AnlageComponent } from "./anlage/anlage.component";
import { AnlageDetailComponent } from "./anlage/detail/anlage.component";
import { CustomFieldComponent } from "./customField/custom-field.component";
import { CustomFieldDetailComponent } from "./customField/detail/custom-field.component";
import { AuxiliaryFacilityComponent } from "./auxiliaryFacility/auxiliary-facility.component";
import { AuxiliaryFacilityDetailComponent } from "./auxiliaryFacility/detail/auxiliary-facility.component";
import { QrCodeComponent } from "./qrCode/qr-code.component";

const COMPONENT = [
  FixedAssetsComponent,
  FixedAssetsDetailComponent,
  FixedAssets2Component,
  FixedAssets2DetailComponent,
  HouseComponent,
  HouseDetailComponent,
  QrCodeComponent,

  AssetTypeComponent,
  AssetTypeDetailComponent,
  DepreciaComponent,
  DepreciaDetailComponent,
  AssetDepreciationRecordComponent,
  AssetDepreciationRecordDetailComponent,
  SpecialFaultRecordComponent,
  SpecialFaultRecordDetailComponent,
  SpecialFaultComponent,
  SpecialFaultDetailComponent,
  CheckRecordComponent,
  CheckRecordDetailComponent,
  AnlageComponent,
  AnlageDetailComponent,
  CustomFieldComponent,
  CustomFieldDetailComponent,
  AuxiliaryFacilityComponent,
  AuxiliaryFacilityDetailComponent
];

@NgModule({
  declarations: [...COMPONENT],
  imports: [SharedModule, AssetsInfoRoutingModule]
})
export class AssetsInfoModule {}
