import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";
import { FixedAssetsComponent } from "./fixed-assets/fixed-assets.component";
import { FixedAssets2Component } from "./fixed-assets-2/fixed-assets-2.component";
import { HouseComponent } from "./house/house.component";

import { AssetTypeComponent } from "./assetType/asset-type.component";
import { DepreciaComponent } from "./deprecia/deprecia.component";
import { AssetDepreciationRecordComponent } from "./assetDepreciationRecord/asset-depreciation-record.component";
import { SpecialFaultRecordComponent } from "./specialFaultRecord/special-fault-record.component";
import { SpecialFaultComponent } from "./specialFault/special-fault.component";
import { CheckRecordComponent } from "./checkRecord/check-record.component";
import { AnlageComponent } from "./anlage/anlage.component";
import { CustomFieldComponent } from "./customField/custom-field.component";
import { AuxiliaryFacilityComponent } from "./auxiliaryFacility/auxiliary-facility.component";
import { FixedAssetsDetailComponent } from "./fixed-assets/detail/fixed-assets.component";
import { FixedAssets2DetailComponent } from "./fixed-assets-2/detail/fixed-assets-2.component";
import { HouseDetailComponent } from "./house/detail/house.component";
import { AssetTypeDetailComponent } from "./assetType/detail/asset-type.component";
import { DepreciaDetailComponent } from "./deprecia/detail/deprecia.component";
import { AssetDepreciationRecordDetailComponent } from "./assetDepreciationRecord/detail/asset-depreciation-record.component";
import { SpecialFaultRecordDetailComponent } from "./specialFaultRecord/detail/special-fault-record.component";
import { SpecialFaultDetailComponent } from "./specialFault/detail/special-fault.component";
import { CheckRecordDetailComponent } from "./checkRecord/detail/check-record.component";
import { AnlageDetailComponent } from "./anlage/detail/anlage.component";
import { CustomFieldDetailComponent } from "./customField/detail/custom-field.component";
import { AuxiliaryFacilityDetailComponent } from "./auxiliaryFacility/detail/auxiliary-facility.component";
import { QrCodeComponent } from "./qrCode/qr-code.component";


const routes: Routes = [
  {
    path: "fixed-assets",
    component: FixedAssetsComponent,
    data: {
      title: "固定资产台账"
    }
  },
  {
    path: "fixed-assets-2",
    component: FixedAssets2Component,
    data: {
      title: "类固定资产台账"
    }
  },
  {
    path: "house",
    component: HouseComponent,
    data: {
      title: "房屋"
    }
  },
  {
    path: "qrcode",
    component: QrCodeComponent,
    data: {
      title: "资产二维码"
    }
  },
  {
    path: "assetType",
    component: AssetTypeComponent,
    data: {
      title: "资产分类"
    }
  },
  {
    path: "deprecia",
    component: DepreciaComponent,
    data: {
      title: "一键折旧"
    }
  },
  {
    path: "assetDepreciationRecord",
    component: AssetDepreciationRecordComponent,
    data: {
      title: "资产折旧记录"
    }
  },
  {
    path: "specialFaultRecord",
    component: SpecialFaultRecordComponent,
    data: {
      title: "特种设备事故记录"
    }
  },
  {
    path: "specialFault",
    component: SpecialFaultComponent,
    data: {
      title: "特种设备运行故障"
    }
  },
  {
    path: "checkRecord",
    component: CheckRecordComponent,
    data: {
      title: "车辆/特种设备检定"
    }
  },
  {
    path: "anlage",
    component: AnlageComponent,
    data: {
      title: "附件表"
    }
  },
  {
    path: "customField",
    component: CustomFieldComponent,
    data: {
      title: "自定义字段"
    }
  },
  {
    path: "auxiliaryFacility",
    component: AuxiliaryFacilityComponent,
    data: {
      title: "附属设备及配件"
    }
  },
  {
    path: "fixed-assetsDetail",
    component: FixedAssetsDetailComponent,
    data: {
      title: "固定资产台账详情"
    }
  },
  {
    path: "fixed-assets-2Detail",
    component: FixedAssets2DetailComponent,
    data: {
      title: "类固定资产台账详情"
    }
  },
  {
    path: "houseDetail",
    component: HouseDetailComponent,
    data: {
      title: "房屋详情"
    }
  },
  // {
  //   path: "buildingDetail",
  //   component: BuildingDetailComponent,
  //   data: {
  //     title: "构(筑)物信息详情"
  //   }
  // },
  {
    path: "assetTypeDetail",
    component: AssetTypeDetailComponent,
    data: {
      title: "资产分类详情"
    }
  },
  {
    path: "depreciaDetail",
    component: DepreciaDetailComponent,
    data: {
      title: "一键折旧详情"
    }
  },
  {
    path: "assetDepreciationRecordDetail",
    component: AssetDepreciationRecordDetailComponent,
    data: {
      title: "资产折旧记录详情"
    }
  },
  {
    path: "specialFaultRecordDetail",
    component: SpecialFaultRecordDetailComponent,
    data: {
      title: "特种设备事故记录详情"
    }
  },
  {
    path: "specialFaultDetail",
    component: SpecialFaultDetailComponent,
    data: {
      title: "特种设备运行故障详情"
    }
  },
  {
    path: "checkRecordDetail",
    component: CheckRecordDetailComponent,
    data: {
      title: "车辆/特种设备检定详情"
    }
  },
  {
    path: "anlageDetail",
    component: AnlageDetailComponent,
    data: {
      title: "附件表详情"
    }
  },
  {
    path: "customFieldDetail",
    component: CustomFieldDetailComponent,
    data: {
      title: "自定义字段详情"
    }
  },
  {
    path: "auxiliaryFacilityDetail",
    component: AuxiliaryFacilityDetailComponent,
    data: {
      title: "附属设备及配件详情"
    }
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class AssetsInfoRoutingModule {}
