const REGEX_CHINESE = /([\u4e00-\u9fff]|[\u3400-\u4dbf]|[\u{20000}-\u{2a6df}]|[\u{2a700}-\u{2b73f}]|[\u{2b740}-\u{2b81f}]|[\u{2b820}-\u{2ceaf}]|[\uf900-\ufaff]|[\u3300-\u33ff]|[\ufe30-\ufe4f]|[\uf900-\ufaff]|[\u{2f800}-\u{2fa1f}])+/gu;
/**
 Returns the Capitalized form of a string

 ```javascript
 'innerHTML'.capitalize()         // 'InnerHTML'
 'action_name'.capitalize()       // 'Action_name'
 'css-class-name'.capitalize()    // 'Css-class-name'
 'my favorite items'.capitalize() // 'My favorite items'
 ```

 @method capitalize
 @param {String} str The string to capitalize.
 @return {String} The capitalized string.
 */
export function capitalize(str) {
  return str.charAt(0).toUpperCase() + str.substr(1);
}

export function currentDateFormat(
  date,
  format: string = "yyyy-mm-dd HH:MM"
): any {
  const pad = (n: number): string => (n < 10 ? `0${n}` : n.toString());
  return format
    .replace("yyyy", date.getFullYear())
    .replace("mm", pad(date.getMonth() + 1))
    .replace("dd", pad(date.getDate()))
    .replace("HH", pad(date.getHours()))
    .replace("MM", pad(date.getMinutes()))
    .replace("ss", pad(date.getSeconds()));
}

export function extractChinese(str: string) {
  var result = str.match(REGEX_CHINESE);
  return result.join("");
}

// export function convertModelToFormData(data = {}, form = null, namespace = '') {
//     let files = {};
//     let model = {};
//     for (let propertyName in data) {
//         if (data.hasOwnProperty(propertyName) && data[propertyName] instanceof File) {
//             files[propertyName] = data[propertyName]
//         } else {
//             model[propertyName] = data[propertyName]
//         }
//     }

//     model = JSON.parse(JSON.stringify(model))
//     let formData = form || new FormData();

//     for (let propertyName in model) {
//         if (!model.hasOwnProperty(propertyName) || !model[propertyName]) continue;
//         let formKey = namespace ? `${namespace}[${propertyName}]` : propertyName;
//         if (model[propertyName] instanceof Date)
//             formData.append(formKey, model[propertyName].toISOString());
//         else if (model[propertyName] instanceof File) {
//             formData.append(formKey, model[propertyName]);
//         }
//         else if (model[propertyName] instanceof Array) {
//             model[propertyName].forEach((element, index) => {
//                 const tempFormKey = `${formKey}[${index}]`;
//                 if (typeof element === 'object') convertModelToFormData(element, formData, tempFormKey);
//                 else formData.append(tempFormKey, element.toString());
//             });
//         }
//         else if (typeof model[propertyName] === 'object' && !(model[propertyName] instanceof File))
//             convertModelToFormData(model[propertyName], formData, formKey);
//         else {
//             formData.append(formKey, model[propertyName].toString());
//         }
//     }

//     for (let propertyName in files) {
//         if (files.hasOwnProperty(propertyName)) {
//             formData.append(propertyName, files[propertyName]);
//         }
//     }
//     return formData;
// }

export function convertModelToUrlData(data = {}, form = null, namespace = "") {
  let files = {};
  let model = {};
  for (let propertyName in data) {
    if (
      data.hasOwnProperty(propertyName) &&
      data[propertyName] instanceof File
    ) {
      files[propertyName] = data[propertyName];
    } else {
      model[propertyName] = data[propertyName];
    }
  }

  model = JSON.parse(JSON.stringify(model));
  let formData = form || new URLSearchParams();

  for (let propertyName in model) {
    if (!model.hasOwnProperty(propertyName) || !model[propertyName]) continue;
    let formKey = namespace ? `${namespace}[${propertyName}]` : propertyName;
    if (model[propertyName] instanceof Date)
      formData.append(formKey, model[propertyName].toISOString());
    else if (model[propertyName] instanceof File) {
      formData.append(formKey, model[propertyName]);
    } else if (model[propertyName] instanceof Array) {
      model[propertyName].forEach((element, index) => {
        const tempFormKey = `${formKey}[${index}]`;
        if (typeof element === "object")
          convertModelToUrlData(element, formData, tempFormKey);
        else formData.append(tempFormKey, element.toString());
      });
    } else if (
      typeof model[propertyName] === "object" &&
      !(model[propertyName] instanceof File)
    )
      convertModelToUrlData(model[propertyName], formData, formKey);
    else {
      formData.append(formKey, model[propertyName].toString());
    }
  }

  for (let propertyName in files) {
    if (files.hasOwnProperty(propertyName)) {
      formData.append(propertyName, files[propertyName]);
    }
  }
  return formData;
}
