import { Component } from '@angular/core';
import {Location} from '@angular/common';
import { Title } from '@angular/platform-browser';
import { Router, ActivatedRoute, NavigationEnd } from '@angular/router';
@Component({
  selector: 'layout-fullscreen',
  templateUrl: './fullscreen.component.html',
  host: {
    '[class.alain-fullscreen]': 'true',
  },
})
export class LayoutFullScreenComponent {
  title = 'navbar';
  constructor(titleService:Title, router:Router, activatedRoute:ActivatedRoute,private _location:Location) {
    router.events.subscribe(event => {
      if(event instanceof NavigationEnd) {
        this.title = this.getTitle(router.routerState, router.routerState.root).join('-');
        titleService.setTitle(this.title);
      }
    });
  }
   // collect that title data properties from all child routes
  // there might be a better way but this worked for me
  getTitle(state, parent) {
    var data = [];
    if(parent && parent.snapshot.data && parent.snapshot.data.title) {
      data.push(parent.snapshot.data.title);
    }

    if(state && parent) {
      data.push(... this.getTitle(state, state.firstChild(parent)));
    }
    return data;
  }
  onLeftClick() {
   this._location.back();
  }
}
