import { Component, OnInit } from "@angular/core";

@Component({
  selector: "app-tabbar",
  templateUrl: "./tabbar.component.html",
  styleUrls: ["./tabbar.component.less"]
})
export class TabbarComponent implements OnInit {
  hidden: boolean = false;
  fullScreen: boolean = false;
  topFlag: boolean = false;
  tintColor: string = "#108ee9";
  unselectedTintColor: string = "#888";
  selectedIndex: number = 0;
  tabbarStyle: object = {
    position: "fixed",
    height: "100%",
    width: "100%",
    top: 0
  };
  constructor() {
    if (sessionStorage.getItem("tabIndex")) {
      this.selectedIndex = JSON.parse(sessionStorage.getItem("tabIndex"));
    }
  }

  ngOnInit() {}

  showTabBar(event) {
    event.preventDefault();
    this.hidden = !this.hidden;
  }

  showNextTabBar(event) {
    event.preventDefault();
    const PANE_COUNT = 4;
    if (this.selectedIndex == PANE_COUNT - 1) {
      this.selectedIndex = 0;
    } else {
      this.selectedIndex++;
    }
  }

  showFullScreen(event) {
    event.preventDefault();
    this.fullScreen = !this.fullScreen;
  }

  changePosition(event) {
    event.preventDefault();
    this.topFlag = !this.topFlag;
  }

  tabBarTabOnPress(pressParam: any) {
    console.log("onPress Params: ", pressParam);
    this.selectedIndex = pressParam.index;
    sessionStorage.setItem("tabIndex", JSON.stringify(this.selectedIndex));
  }
}
