import { Component, OnInit } from "@angular/core";
import { Router } from "@angular/router";
@Component({
  selector: "app-message",
  templateUrl: "./message.component.html",
  styleUrls: ["./message.component.less"]
})
export class MessageComponent implements OnInit {
  data = [
    {
      id: 1,
      title: "事务管理中心",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-process'></i>",
          text: "我启动的流程",
          link: "/admin/message/tran/process"
        },
        {
          icon: "<i class='iconfont icon-agent'></i>",
          text: "我的代办流程",
          link: "/admin/message/tran/agent"
        },
        {
          icon: "<i class='iconfont icon-done'></i>",
          text: "我的已办流程",
          link: "/admin/message/tran/done"
        },
        {
          icon: "<i class='iconfont icon-inspec'></i>",
          text: "流程监督",
          link: "/admin/message/tran/inspec"
        }
      ]
    },
    {
      id: 2,
      title: "信息中心",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-messageInform'></i>",
          text: "消息通知",
          link: "/admin/message/info/messageInform"
        },
        {
          icon: "<i class='iconfont icon-warning'></i>",
          text: "预警中心",
          link: "/admin/message/info/warning"
        }
      ]
    },
    {
      id: 3,
      expend: false,
      children: []
    }
  ];
  currentArr = []; // 收起
  remainArr = []; //更多
  constructor(private router: Router) {}

  ngOnInit() {}
  click(event) {
    const url = event.data.link;
    this.router.navigateByUrl(url);
  }
  onExpend(item) {
    item.expend = !item.expend;
    if (item.expend) {
      this.currentArr = item.children.slice(0, 4);
      this.remainArr = item.children;
      this.data[item.id - 1].children = this.currentArr;
    } else {
      this.data[item.id - 1].children = [...this.remainArr];
    }
    console.log(this.data);
  }
}
