import { Component, OnInit } from "@angular/core";
import { Router } from "@angular/router";
import { Toast } from "ng-zorro-antd-mobile";
@Component({
  selector: "app-check",
  templateUrl: "./check.component.html",
  styleUrls: ["./check.component.less"]
})
export class CheckComponent implements OnInit {
  data = [
    {
      id: 1,
      title: "手动盘点",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-manualy'></i>",
          text: "盘点列表",
          link: "/admin/assets-used/checkPlan"
        }
      ]
    },
    {
      id: 2,
      title: "二维码扫描",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-qrcode'></i>",
          text: "二维码扫描",
          link: "/admin/check/qrScan/qrScan"
        }
      ]
    }
  ];
  currentArr = []; // 收起
  remainArr = []; //更多
  constructor(private router: Router, private toast: Toast) {}

  ngOnInit() {}
  // 如果id为2调用扫描，否则跳转
  click(event) {
    const url = event.data.link;
    this.router.navigateByUrl(url);
  }
  onExpend(item) {
    item.expend = !item.expend;
    if (item.expend) {
      this.currentArr = item.children.slice(0, 4);
      this.remainArr = item.children;
      this.data[item.id - 1].children = this.currentArr;
    } else {
      this.data[item.id - 1].children = [...this.remainArr];
    }
    console.log(this.data);
  }

  showToast() {
    const toast = Toast.show("扫描出错", 0);
    setTimeout(() => {
      Toast.hide();
    }, 3000);
  }

  loadingToast(id) {
    const toast = Toast.loading("Loading...", 1000, () => {
      console.log("Load complete !!!");
      this.router.navigate(["/admin/assets-used/checkPlanAdd", id]);
      Toast.hide();
    });
  }
}
