import { Component, OnInit } from "@angular/core";
import { Router } from "@angular/router";
@Component({
  selector: "app-assets",
  templateUrl: "./assets.component.html",
  styleUrls: ["./assets.component.less"]
})
export class AssetsComponent implements OnInit {
  data = [
    {
      id: 1,
      title: "资产信息",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-fixed-assets'></i>",
          text: "固定资产台账",
          link: "/admin/assets-info/fixed-assets"
        },
        {
          icon: "<i class='iconfont icon-fixed-assets-2'></i>",
          text: "类固定资产台账",
          link: "/admin/assets-info/fixed-assets?kindAsset=1"
        },
        {
          icon: "<i class='iconfont icon-house'></i>",
          text: "房屋",
          link: "/admin/assets-info/house"
        },
        {
          icon: "<i class='iconfont icon-building'></i>",
          text: "构(筑)物信息",
          link: "/admin/assets-info/house?houseCard=2"
        },
        {
          icon: "<i class='iconfont icon-qrcode'></i>",
          text: "资产二维码",
          link: "/admin/assets-info/qrcode"
        },
        // {
        //   icon: "<i class='iconfont icon-assetType'></i>",
        //   text: "资产分类",
        //   link: "/admin/assets-info/assetType"
        // },
        // {
        //   icon: "<i class='iconfont icon-deprecia'></i>",
        //   text: "一键折旧",
        //   link: "/admin/assets-info/deprecia"
        // },
        {
          icon: "<i class='iconfont icon-assetDepreciationRecord'></i>",
          text: "资产折旧记录",
          link: "/admin/assets-info/assetDepreciationRecord"
        },
        {
          icon: "<i class='iconfont icon-specialFaultRecord'></i>",
          text: "特种设备事故记录",
          link: "/admin/assets-info/specialFaultRecord"
        },
        {
          icon: "<i class='iconfont icon-specialFault'></i>",
          text: "特种设备运行故障",
          link: "/admin/assets-info/specialFault"
        },
        {
          icon: "<i classs='iconfont icon-checkRecord'></i>",
          text: "车辆/特种设备检定",
          link: "/admin/assets-info/checkRecord"
        },
        {
          icon: "<i class='iconfont icon-anlage'></i>",
          text: "附件表",
          link: "/admin/assets-info/anlage"
        },
        {
          icon: "<i class='iconfont icon-customField'></i>",
          text: "自定义字段",
          link: "/admin/assets-info/customField"
        }
        // {
        //   icon: "<i class='iconfont icon-auxiliaryFacility'></i>",
        //   text: "附属设备及配件",
        //   link: "/admin/assets-info/auxiliaryFacility"
        // }
      ]
    },
    {
      id: 2,
      title: "资产使用",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-buyApply'></i>",
          text: "采购申请管理",
          link: "/admin/assets-used/buyApply"
        },
        {
          icon: "<i class='iconfont icon-buyContract'></i>",
          text: "采购合同管理",
          link: "/admin/assets-used/buyContract"
        },
        {
          icon: "<i class='iconfont icon-buyPay'></i>",
          text: "采购支付管理",
          link: "/admin/assets-used/buyPay"
        },
        {
          icon: "<i class='iconfont icon-inspect'></i>",
          text: "资产验收",
          link: "/admin/assets-used/inspect"
        },
        // {
        //   icon: "<i class='iconfont icon-assetRegister'></i>",
        //   text: "注册资产",
        //   link: "/admin/assets-used/assetRegister"
        // },
        {
          icon: "<i class='iconfont icon-assetReceive'></i>",
          text: "资产领用",
          link: "/admin/assets-used/assetReceive"
        },
        {
          icon: "<i class='iconfont icon-facilityLease'></i>",
          text: "设备租出",
          link: "/admin/assets-used/facilityLease"
        },
        // {
        //   icon: "/null/tmp/img/null-menu.png",
        //   text: "设备内租",
        //   link: "/admin/assets-used/null"
        // },
        // {
        //   icon: "/null/tmp/img/null-menu.png",
        //   text: "资产调遣",
        //   link: "/admin/assets-used/null"
        // },
        // {
        //   icon: "/null/tmp/img/null-menu.png",
        //   text: "资产调拨",
        //   link: "/admin/assets-used/null"
        // },
        {
          icon: "<i class='iconfont icon-propertyChange'></i>",
          text: "资产人员变更",
          link: "/admin/assets-used/propertyChange"
        },
        {
          icon: "<i class='iconfont icon-propertyChangeRecord'></i>",
          text: "资产产权变更",
          link: "/admin/assets-used/propertyChangeRecord"
        },
        {
          icon: "<i class='iconfont icon-checkPlan'></i>",
          text: "资产盘点",
          link: "/admin/assets-used/checkPlan"
        },
        // {
        //   icon: "/null/tmp/img/null-menu.png",
        //   text: "资产盘点抽查记录",
        //   link: "/admin/assets-used/null"
        // },
        {
          icon: "<i class='iconfont icon-assetWithdrawing'></i>",
          text: "资产退库",
          link: "/admin/assets-used/assetWithdrawing"
        },
        {
          icon: "<i class='iconfont icon-assetStorage'></i>",
          text: "资产封存/启封",
          link: "/admin/assets-used/assetStorage"
        },
        {
          icon: "<i class='iconfont icon-discardedDisposal'></i>",
          text: "资产处置",
          link: "/admin/assets-used/discardedDisposal"
        },
        {
          icon: "<i class='iconfont icon-assetsUseRecord'></i>",
          text: "资产使用记录",
          link: "/admin/assets-used/assetsUseRecord"
        }
      ]
    },
    {
      id: 3,
      title: "资产租赁",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-facilityRent'></i>",
          text: "外租设备",
          link: "/admin/lease/facilityRent"
        },
        {
          icon: "<i class='iconfont icon-assessRecord'></i>",
          text: "租入设备考核",
          link: "/admin/lease/assessRecord"
        },
        {
          icon: "<i class='iconfont icon-houseLease'></i>",
          text: "房屋租赁",
          link: "/admin/lease/houseLease"
        },
        {
          icon: "<i class='iconfont icon-subconractor'></i>",
          text: "分包商及租入特种设备",
          link: "/admin/lease/subconractor"
        }
      ]
    },
    {
      id: 4,
      title: "设备维保",
      expend: false,
      children: [
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "保养计划",
          link: "/admin/assets/repair/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "保养记录",
          link: "/admin/assets/repair/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "维修计划",
          link: "/admin/assets/repair/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "维修记录",
          link: "/admin/assets/repair/null"
        },
        {
          icon: "/repairPlan/tmp/img/repairPlan-menu.png",
          text: "维修保养计划(待删)",
          link: "/admin/assets/repair/repairPlan"
        },
        {
          icon: "/repairRecord/tmp/img/repairRecord-menu.png",
          text: "维修保养记录(待删)",
          link: "/admin/assets/repair/repairRecord"
        }
      ]
    },
    {
      id: 5,
      title: "单机车核算",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-singleBus'></i>",
          text: "单机车核算",
          link: "/admin/single/singleBus"
        },
        {
          icon: "<i class='iconfont icon-oilWear'></i>",
          text: "燃料消耗记录",
          link: "/admin/single/oilWear"
        },
        {
          icon: "<i class='iconfont icon-fuelStandard'></i>",
          text: "机械设备燃料核算标准",
          link: "/admin/assets/fuelStandard"
        }
      ]
    },
    {
      id: 6,
      title: "资产保险",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-insuranceRegister'></i>",
          text: "保险登记",
          link: "/admin/assets/insurance/insuranceRegister"
        },
        {
          icon: "<i class='iconfont icon-accidentRegister'></i>",
          text: "出险登记",
          link: "/admin/assets/insurance/accidentRegister"
        }
      ]
    },
    {
      id: 7,
      title: "证件管理",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-employeePapers'></i>",
          text: "人员证件",
          link: "/admin/cet/employeePapers"
        },
        {
          icon: "<i class='iconfont icon-facilityPapers'></i>",
          text: "设备证件",
          link: "/admin/cet/facilityPapers"
        },
        {
          icon: "/papersFile/tmp/img/papersFile-menu.png",
          text: "用户证件附件(待删)",
          link: "/admin/cet/papersFile"
        },
        {
          icon: "/papersType/tmp/img/papersType-menu.png",
          text: "证件类型(待删)",
          link: "/admin/cet/papersType"
        }
      ]
    },
    {
      id: 8,
      title: "搅拌站配比",
      expend: false,
      children: [
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "配比标准",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "配比记录",
          link: "/admin/assets/undefined/null"
        }
      ]
    },
    {
      id: 9,
      title: "周转材料",
      expend: false,
      children: [
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "采购记录",
          link: "/admin/lowCostMaterial/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "采购合同",
          link: "/admin/lowCostMaterial/null"
        },
        {
          icon: "<i class='iconfont icon-revolvingMaterrial'></i>",
          text: "周转材料台账",
          link: "/admin/lowCostMaterial/revolvingMaterrial"
        },
        {
          icon: "<i class='iconfont icon-meterialType'></i>",
          text: "周转材料分类",
          link: "/admin/lowCostMaterial/meterialType"
        },
        {
          icon: "<i class='iconfont icon-meterialInspect'></i>",
          text: "周转材料验收",
          link: "/admin/lowCostMaterial/meterialInspect"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "周转材料入库",
          link: "/admin/lowCostMaterial/null"
        },
        {
          icon: "<i class='iconfont icon-materrialReceive'></i>",
          text: "周转材料领用",
          link: "/admin/lowCostMaterial/materrialReceive"
        },
        {
          icon: "<i class='iconfont icon-materialLease'></i>",
          text: "周转材料租出",
          link: "/admin/lowCostMaterial/materialLease"
        },
        {
          icon: "<i class='iconfont icon-materialRent'></i>",
          text: "周转材料租入",
          link: "/admin/lowCostMaterial/materialRent"
        },
        {
          icon: "<i class='iconfont icon-materialClear'></i>",
          text: "周转材料清理",
          link: "/admin/lowCostMaterial/materialClear"
        },
        {
          icon: "<i class='iconfont icon-materialAmortize'></i>",
          text: "周转材料核算、摊销",
          link: "/admin/lowCostMaterial/materialAmortize"
        }
      ]
    },
    {
      id: 10,
      title: "低值易耗",
      expend: false,
      children: [
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "低值易耗采购",
          link: "/admin/lowCostMaterial/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "低值易耗合同",
          link: "/admin/lowCostMaterial/null"
        },
        {
          icon: "<i class='iconfont icon-consumable'></i>",
          text: "低值易耗台账",
          link: "/admin/lowCostMaterial/consumable"
        },
        {
          icon: "<i class='iconfont icon-consumableInspect'></i>",
          text: "低值易耗验收",
          link: "/admin/lowCostMaterial/consumableInspect"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "低值易耗注册",
          link: "/admin/lowCostMaterial/null"
        },
        {
          icon: "<i class='iconfont icon-consumableReceive'></i>",
          text: "低值易耗领用",
          link: "/admin/lowCostMaterial/consumableReceive"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "低值易耗盘点",
          link: "/admin/lowCostMaterial/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "低值易耗入库统计",
          link: "/admin/lowCostMaterial/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "低值易耗出库统计",
          link: "/admin/lowCostMaterial/null"
        }
      ]
    },
    {
      id: 11,
      title: "资产资料管理",
      expend: false,
      children: [
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "设备档案信息",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "房屋档案信息",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "土地档案信息",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "其他",
          link: "/admin/assets/undefined/null"
        }
      ]
    },
    {
      id: 12,
      title: "合同管理",
      expend: false,
      children: [
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "设备采购合同",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "物资采购合同",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "维修合同",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "保养合同",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "设备租赁合同",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "材料合同",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "车辆合同",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "房屋合同",
          link: "/admin/assets/undefined/null"
        },
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "合同单统计",
          link: "/admin/assets/undefined/null"
        }
      ]
    },
    {
      id: 13,
      title: "仓库管理",
      expend: false,
      children: [
        {
          icon: "/null/tmp/img/null-menu.png",
          text: "仓库管理",
          link: "/admin/assets/undefined/null"
        }
      ]
    },
    {
      id: 14,
      title: " 其他资产",
      expend: false,
      children: [
        {
          icon: "<i class='iconfont icon-investment'></i>",
          text: "投资管理",
          link: "/admin/others/investment"
        },
        {
          icon: "<i class='iconfont icon-land'></i>",
          text: "土地",
          link: "/admin/others/land"
        },
        {
          icon: "<i class='iconfont icon-softAsset'></i>",
          text: "软件",
          link: "/admin/others/softAsset"
        },
        {
          icon: "<i class='iconfont icon-pattern'></i>",
          text: "专利",
          link: "/admin/others/pattern"
        },
        {
          icon: "/undefined/tmp/img/undefined-menu.png",
          link: "/admin/others/undefined"
        }
      ]
    }
  ];
  currentArr = []; // 收起
  remainArr = []; //更多

  state = {
    height: Number(localStorage.getItem("refHeight"))
  };
  dtPullToRefreshStyle = { height: this.state.height + "px" };

  constructor(private router: Router) {
    console.log(this.state);
  }

  ngOnInit() {}
  click(event) {
    const url = event.data.link;
    this.router.navigateByUrl(url);
  }
  onExpend(item) {
    item.expend = !item.expend;
    if (item.expend) {
      this.currentArr = item.children.slice(0, 4);
      this.remainArr = item.children;
      this.data[item.id - 1].children = this.currentArr;
    } else {
      this.data[item.id - 1].children = [...this.remainArr];
    }
    console.log(this.data);
  }
  pullToRefresh(event) {}
}
