import { Injectable } from "@angular/core";
import { Router, CanActivate } from "@angular/router";

@Injectable({
  providedIn: "root"
})
export class AuthGuardService implements CanActivate {
  constructor(public router: Router) {}
  canActivate(): boolean {
    if (!localStorage.getItem("_token")) {
      this.router.navigateByUrl("passport/login");
      return false;
    }
    return true;
  }
}
