import { NgModule, APP_INITIALIZER } from "@angular/core";
import { BrowserModule } from "@angular/platform-browser";
import { RouteReuseStrategy } from "@angular/router";

import { IonicModule, IonicRouteStrategy } from "@ionic/angular";
import { SplashScreen } from "@ionic-native/splash-screen/ngx";
import { StatusBar } from "@ionic-native/status-bar/ngx";

import { AppComponent } from "./app.component";
import { BrowserAnimationsModule } from "@angular/platform-browser/animations";
import { FormsModule } from "@angular/forms";
import {
  HttpClientModule,
  HTTP_INTERCEPTORS,
  HttpClientJsonpModule
} from "@angular/common/http";
import { RoutesModule } from "./routes/routes.module";
import { DefaultInterceptor } from "./layout/default.interceptor";
import { StartupService } from "./layout/service/startup.service";
import { LayoutModule } from "./layout/layout.module";
import { AntMobileModule } from "./ant-mobile.module";
import { SharedModule } from "./shared";
import { SimpleInterceptor } from "@delon/auth";
import { CordovaModule } from "./cordova.module";
const INTERCEPTOR_PROVIDES = [
  { provide: HTTP_INTERCEPTORS, useClass: SimpleInterceptor, multi: true },
  { provide: HTTP_INTERCEPTORS, useClass: DefaultInterceptor, multi: true }
];
// #region Startup Service

export function StartupServiceFactory(
  startupService: StartupService
): Function {
  return () => startupService.load();
}
const APPINIT_PROVIDES = [
  StartupService,
  {
    provide: APP_INITIALIZER,
    useFactory: StartupServiceFactory,
    deps: [StartupService],
    multi: true
  }
];
@NgModule({
  declarations: [AppComponent],
  entryComponents: [],
  imports: [
    BrowserModule,
    IonicModule.forRoot(),
    BrowserAnimationsModule,
    FormsModule,
    HttpClientModule,
    HttpClientJsonpModule,
    SharedModule,
    LayoutModule,
    RoutesModule,
    AntMobileModule,
    CordovaModule
  ],
  providers: [
    ...APPINIT_PROVIDES,
    ...INTERCEPTOR_PROVIDES,
    StatusBar,
    SplashScreen,
    { provide: RouteReuseStrategy, useClass: IonicRouteStrategy }
  ],
  bootstrap: [AppComponent]
})
export class AppModule {}
