import { Component } from "@angular/core";

import { Platform } from "@ionic/angular";
import { SplashScreen } from "@ionic-native/splash-screen/ngx";
import { StatusBar } from "@ionic-native/status-bar/ngx";
import VConsole from "vconsole";
const vConsole = new VConsole();
@Component({
  selector: "app-root",
  templateUrl: "app.component.html"
})
export class AppComponent {
  constructor(
    private platform: Platform,
    private splashScreen: SplashScreen,
    private statusBar: StatusBar
  ) {
    this.initializeApp();
  }

  initializeApp() {
    this.platform.ready().then(() => {
      this.statusBar.styleDefault();
      this.splashScreen.hide();
      this.setLocalData();
    });
  }

  setLocalData() {
    localStorage.setItem("screenWidht", JSON.stringify(window.screen.width));
    localStorage.setItem("screenHeight", JSON.stringify(window.screen.height));
    localStorage.setItem(
      "refHeight",
      JSON.stringify(window.screen.height - 95)
    );
  }
}
