import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { SimpleGuard } from '@delon/auth';
import { environment } from '@env/environment';
// layout
import { AppDefaultComponent } from '../layout/default/default.component';
import { LayoutFullScreenComponent } from '../layout/fullscreen/fullscreen.component';
import { LayoutPassportComponent } from '../layout/passport/passport.component';
// dashboard pages
// passport pages
import { UserLoginComponent } from './passport/login/login.component';
// single pages
import { CallbackComponent } from './callback/callback.component';
import { HomeComponent } from './home/home.component';

const routes: Routes = [
  {
    path: 'admin',
    component: AppDefaultComponent,
    children: [
      // 数据分析与展示
      {
        path: 'data-view',
        loadChildren: './data-view/data-view.module#DataViewModule',
      },
      // 文件资料
      {
        path: 'file',
        loadChildren: './file/file.module#FileModule',
      },
      // 固定资产
      {
        path: 'fixed-assets',
        loadChildren: './fixed-assets/fixed-assets.module#FixedAssetsModule',
      },
      // 闲置共享
      {
        path: 'idle-shared',
        loadChildren: './idle-shared/idle-shared.module#IdleSharedModule',
      },
      // 无形资产
      {
        path: 'intangible-assets',
        loadChildren: './intangible-assets/intangible-assets.module#IntangibleAssetsModule',
      },
      // 产权管理
      {
        path: 'property-management',
        loadChildren: './property-management/property-management.module#PropertyManagementModule',
      },
      // 周转材料低值易耗
      {
        path: 'revolving-material',
        loadChildren: './revolving-material/revolving-material.module#RevolvingMaterialModule',
      },
      // 系统设置
      {
        path: 'settings',
        loadChildren: './settings/settings.module#SettingsModule',
      },
      // 用户中心
      {
        path: 'user',
        loadChildren: './user/user.module#UserModule',
      },
    ],
  },
  {
    path: '',
    component: AppDefaultComponent,
    canActivate: [SimpleGuard],
    canActivateChild: [SimpleGuard],
    children: [
      { path: '', redirectTo: 'home', pathMatch: 'full' },
      { path: 'home', redirectTo: 'home', pathMatch: 'full' },
      { path: 'home', component: HomeComponent },
      {
        path: 'widgets',
        loadChildren: './widgets/widgets.module#WidgetsModule',
      },

      { path: 'extras', loadChildren: './extras/extras.module#ExtrasModule' },
      // Exception
      { path: 'exception', loadChildren: './exception/exception.module#ExceptionModule' },
    ],
  },
  // passport
  {
    path: 'passport',
    component: LayoutPassportComponent,
    children: [
      {
        path: 'login',
        component: UserLoginComponent,
        data: { title: '登录', titleI18n: 'app.login.login' },
      },
    ],
  },
  // 单页不包裹Layout
  { path: 'callback/:type', component: CallbackComponent },
  { path: '**', redirectTo: 'exception/404' },
];

@NgModule({
  imports: [
    RouterModule.forRoot(routes, {
      useHash: environment.useHash,
      // NOTICE: If you use `reuse-tab` component and turn on keepingScroll you can set to `disabled`
      // Pls refer to https://ng-alain.com/components/reuse-tab
      scrollPositionRestoration: 'top',
    }),
  ],
  exports: [RouterModule],
})
export class RouteRoutingModule {}
