import { NgModule } from "@angular/core";
import { RevolvingMaterialRoutingModule } from "./revolving-material-routing.module";


// 周转材料
import { StandComponent } from "./revolve/stand/stand.component";
import { CheckRecordComponent } from "./revolve/check-record/check-record.component";
import { ReceiveRecordComponent } from "./revolve/receive-record/receive-record.component";
import { LeaseComponent } from "./revolve/lease/lease.component";
import { CategoryComponent } from "./revolve/category/category.component";
import { RentComponent } from "./revolve/rent/rent.component";
import { ClearComponent } from "./revolve/clear/clear.component";
import { MarketComponent } from "./revolve/market/market.component";

// 仓库管理
import { GoodsConsumeComponent } from "./warehouse/goods-consume/goods-consume.component";

// 低值易耗
import { ReceiveComponent } from "./consumable/receive/receive.component";
import { ConsumeCheckRecordComponent } from "./consumable/check-record/check-record.component";
import { ConsumeStandComponent } from "./consumable/stand/stand.component";
import { SharedModule } from '@shared';

@NgModule({
  declarations: [
    StandComponent,
    CheckRecordComponent,
    ReceiveRecordComponent,
    LeaseComponent,
    CategoryComponent,
    RentComponent,
    ClearComponent,
    MarketComponent,
    GoodsConsumeComponent,
    ReceiveComponent,
    ConsumeCheckRecordComponent,
    ConsumeStandComponent
  ],
  imports: [SharedModule, RevolvingMaterialRoutingModule]
})
export class RevolvingMaterialModule {}
