import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";

// 周转材料
import { StandComponent } from "./revolve/stand/stand.component";
import { CheckRecordComponent } from "./revolve/check-record/check-record.component";
import { ReceiveRecordComponent } from "./revolve/receive-record/receive-record.component";
import { LeaseComponent } from "./revolve/lease/lease.component";
import { CategoryComponent } from "./revolve/category/category.component";
import { RentComponent } from "./revolve/rent/rent.component";
import { ClearComponent } from "./revolve/clear/clear.component";
import { MarketComponent } from "./revolve/market/market.component";

// 低值易耗

import { ReceiveComponent } from "./consumable/receive/receive.component";
import { ConsumeStandComponent } from "./consumable/stand/stand.component";
import { ConsumeCheckRecordComponent } from "./consumable/check-record/check-record.component";

// 仓库管理
import { GoodsConsumeComponent } from "./warehouse/goods-consume/goods-consume.component";

const routes: Routes = [
  {
    path: "revolve",
    children: [
      { path: "stand", component: StandComponent }, // 周转材料台账
      { path: "check-record", component: CheckRecordComponent }, // 周转材料验收记录
      { path: "receive-record", component: ReceiveRecordComponent }, // 周转材料领用记录
      { path: "lease", component: LeaseComponent }, // 周转材料租出
      { path: "category", component: CategoryComponent }, // 周转材料分类
      { path: "rent", component: RentComponent }, // 周转材料租入
      { path: "clear", component: ClearComponent }, // 周转材料清理
      { path: "market", component: MarketComponent } // 周转材料核算与推销
    ]
  },
  {
    path: "consume",
    children: [
      { path: "stand", component: ConsumeStandComponent }, // 低值易耗台账
      { path: "check-record", component: ConsumeCheckRecordComponent }, // 低值易耗验收记录
      { path: "receive", component: ReceiveComponent } // 低值易耗领用
    ]
  },
  {
    path: "warehouse",
    children: [
      { path: "goods-consume", component: GoodsConsumeComponent } // 物资消耗记录
    ]
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class RevolvingMaterialRoutingModule {}
