import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";

import { FixedAssetsRoutingModule } from "./fixed-assets-routing.module";
import { FixedAssetsComponent } from "./assets-info/fixed-assets/fixed-assets.component";
import { CateFixedAssetsComponent } from "./assets-info/cate-fixed-assets/cate-fixed-assets.component";
import { HouseComponent } from "./assets-info/house/house.component";
import { DepreciateComponent } from "./assets-info/depreciate/depreciate.component";
import { DepreciationRecordComponent } from "./assets-info/depreciation-record/depreciation-record.component";
import { AssetsNatureComponent } from "./assets-info/assets-nature/assets-nature.component";
import { PlantAccidentComponent } from "./assets-info/plant-accident/plant-accident.component";
import { PlantOperateComponent } from "./assets-info/plant-operate/plant-operate.component";
import { PlantVerifyComponent } from "./assets-info/plant-verify/plant-verify.component";
import { AnlageComponent } from "./assets-info/anlage/anlage.component";
import { CustomComponent } from "./assets-info/custom/custom.component";
import { PartsComponent } from "./assets-info/parts/parts.component";
import { ApplyComponent } from "./assets-use/apply/apply.component";
import { ContractComponent } from "./assets-use/contract/contract.component";
import { PayComponent } from "./assets-use/pay/pay.component";
import { CheckComponent } from "./assets-use/check/check.component";
import { ReceiveComponent } from "./assets-use/receive/receive.component";
import { LeaseComponent } from "./assets-use/lease/lease.component";
import { DispatchComponent } from "./assets-use/dispatch/dispatch.component";
import { AllotComponent } from "./assets-use/allot/allot.component";
import { UseComponent } from "./assets-use/use/use.component";
import { TakeStockComponent } from "./assets-use/take-stock/take-stock.component";
import { PersonalChangeComponent } from "./assets-use/personal-change/personal-change.component";
import { CancelStockComponent } from "./assets-use/cancel-stock/cancel-stock.component";
import { RememberedComponent } from "./assets-use/remembered/remembered.component";
import { PropertyChangeComponent } from "./assets-use/property-change/property-change.component";
import { ScrapComponent } from "./assets-use/scrap/scrap.component";
import { RentComponent } from "./assets-lease/rent/rent.component";
import { AssessComponent } from "./assets-lease/assess/assess.component";
import { SubContractorComponent } from "./assets-lease/sub-contractor/sub-contractor.component";
import { ServicePlanComponent } from "./device-maintain/service-plan/service-plan.component";
import { ServiceRecordComponent } from "./device-maintain/service-record/service-record.component";
import { SingleComponent } from "./single-machine/single/single.component";
import { ConsumeComponent } from "./single-machine/consume/consume.component";
import { InsuranceComponent } from "./assets-insurance/insurance/insurance.component";
import { DangerComponent } from "./assets-insurance/danger/danger.component";
import { StaffComponent } from "./identity-manager/staff/staff.component";
import { DeviceComponent } from "./identity-manager/device/device.component";
import { UserComponent } from "./identity-manager/user/user.component";
import { TypeComponent } from "./identity-manager/type/type.component";
import { VendorComponent } from "./canon/vendor/vendor.component";
import { SharedModule } from '@shared';
import { AssetsCateComponent } from './assets-info/assets-cate/assets-cate.component';
import { AssetsLeaseHouseComponent } from './assets-lease/house/house.component';
import { BusinessComponent } from './single-machine/business/business.component';
import { FixedDetailComponent } from './assets-info/fixed-assets/fixed-detail/fixed-detail.component';

@NgModule({
  declarations: [
    BusinessComponent,
    AssetsLeaseHouseComponent ,
    AssetsCateComponent,
    FixedAssetsComponent,
    CateFixedAssetsComponent,
    HouseComponent,
    DepreciateComponent,
    DepreciationRecordComponent,
    AssetsNatureComponent,
    PlantAccidentComponent,
    PlantOperateComponent,
    PlantVerifyComponent,
    AnlageComponent,
    CustomComponent,
    PartsComponent,
    ApplyComponent,
    ContractComponent,
    PayComponent,
    CheckComponent,
    ReceiveComponent,
    LeaseComponent,
    DispatchComponent,
    AllotComponent,
    UseComponent,
    TakeStockComponent,
    PersonalChangeComponent,
    CancelStockComponent,
    RememberedComponent,
    PropertyChangeComponent,
    ScrapComponent,
    RentComponent,
    AssessComponent,
    SubContractorComponent,
    ServicePlanComponent,
    ServiceRecordComponent,
    SingleComponent,
    ConsumeComponent,
    InsuranceComponent,
    DangerComponent,
    StaffComponent,
    DeviceComponent,
    UserComponent,
    TypeComponent,
    VendorComponent,
    FixedDetailComponent
  ],
  imports: [SharedModule, FixedAssetsRoutingModule]
})
export class FixedAssetsModule {}
