import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';

// 资产信息
import { AnlageComponent } from './assets-info/anlage/anlage.component';
import { AssetsCateComponent } from './assets-info/assets-cate/assets-cate.component';
import { AssetsNatureComponent } from './assets-info/assets-nature/assets-nature.component';
import { CateFixedAssetsComponent } from './assets-info/cate-fixed-assets/cate-fixed-assets.component';
import { CustomComponent } from './assets-info/custom/custom.component';
import { DepreciateComponent } from './assets-info/depreciate/depreciate.component';
import { DepreciationRecordComponent } from './assets-info/depreciation-record/depreciation-record.component';
import { FixedAssetsComponent } from './assets-info/fixed-assets/fixed-assets.component';
import { HouseComponent } from './assets-info/house/house.component';
import { PartsComponent } from './assets-info/parts/parts.component';
import { PlantAccidentComponent } from './assets-info/plant-accident/plant-accident.component';
import { PlantOperateComponent } from './assets-info/plant-operate/plant-operate.component';
import { PlantVerifyComponent } from './assets-info/plant-verify/plant-verify.component';

// 资产保险
import { DangerComponent } from './assets-insurance/danger/danger.component';
import { InsuranceComponent } from './assets-insurance/insurance/insurance.component';

// 资产租凭
import { AssessComponent } from './assets-lease/assess/assess.component';
import { AssetsLeaseHouseComponent } from './assets-lease/house/house.component';
import { RentComponent } from './assets-lease/rent/rent.component';
import { SubContractorComponent } from './assets-lease/sub-contractor/sub-contractor.component';

// 资产使用
import { AllotComponent } from './assets-use/allot/allot.component';
import { ApplyComponent } from './assets-use/apply/apply.component';
import { CancelStockComponent } from './assets-use/cancel-stock/cancel-stock.component';
import { CheckComponent } from './assets-use/check/check.component';
import { ContractComponent } from './assets-use/contract/contract.component';
import { DispatchComponent } from './assets-use/dispatch/dispatch.component';
import { LeaseComponent } from './assets-use/lease/lease.component';
import { PayComponent } from './assets-use/pay/pay.component';
import { PersonalChangeComponent } from './assets-use/personal-change/personal-change.component';
import { PropertyChangeComponent } from './assets-use/property-change/property-change.component';
import { ReceiveComponent } from './assets-use/receive/receive.component';
import { RememberedComponent } from './assets-use/remembered/remembered.component';
import { ScrapComponent } from './assets-use/scrap/scrap.component';
import { TakeStockComponent } from './assets-use/take-stock/take-stock.component';
import { UseComponent } from './assets-use/use/use.component';

// 制造厂商
import { VendorComponent } from './canon/vendor/vendor.component';

// 设备维保
import { ServicePlanComponent } from './device-maintain/service-plan/service-plan.component';
import { ServiceRecordComponent } from './device-maintain/service-record/service-record.component';

// 证件管理
import { DeviceComponent } from './identity-manager/device/device.component';
import { StaffComponent } from './identity-manager/staff/staff.component';
import { TypeComponent } from './identity-manager/type/type.component';
import { UserComponent } from './identity-manager/user/user.component';

// 单机车核算
import { BusinessComponent } from './single-machine/business/business.component';
import { ConsumeComponent } from './single-machine/consume/consume.component';
import { SingleComponent } from './single-machine/single/single.component';
import { FixedDetailComponent } from './assets-info/fixed-assets/fixed-detail/fixed-detail.component';

const routes: Routes = [
  {
    path: 'assets-info',
    children: [
      { path: 'anlage', component: AnlageComponent }, //附属设备及配件
      { path: 'assets-cate', component: AssetsCateComponent }, //资产分类
      { path: 'assets-nature', component: AssetsNatureComponent }, //资产性质
      { path: 'cate-fixed-assets', component: CateFixedAssetsComponent }, //类固定资产台账
      { path: 'custom', component: CustomComponent }, // 自定义字段
      { path: 'depreciate', component: DepreciateComponent }, //一键折旧
      { path: 'depreciation-record', component: DepreciationRecordComponent }, //资产折旧记录
      {
        path: 'fixed-assets',
        component: FixedAssetsComponent,
      }, //固定资产台账
      {
        path: 'fixed-assets/detail/:id',
        component: FixedDetailComponent,
      },
      { path: 'house', component: HouseComponent }, //房屋
      { path: 'parts', component: PartsComponent }, //附件表
      { path: 'plant-accident', component: PlantAccidentComponent }, //特种设备事故记录
      { path: 'plant-operate', component: PlantOperateComponent }, //特种设备运行故障
      { path: 'plant-verify', component: PlantVerifyComponent }, //车辆/特种设备检定
    ],
  }, // 资产信息
  {
    path: 'assets-insurance',
    children: [
      { path: 'danger', component: DangerComponent }, //出险登记
      { path: 'insurance', component: InsuranceComponent }, //保险登记
    ],
  }, // 资产保险
  {
    path: 'assets-lease',
    children: [
      { path: 'assess', component: AssessComponent }, //设备租入
      { path: 'house', component: AssetsLeaseHouseComponent }, //房屋租凭
      { path: 'rent', component: RentComponent }, //租入设备考核记录
      { path: 'sub-contractor', component: SubContractorComponent }, //分包商及租入特种设备管理
    ],
  }, // 资产租凭
  {
    path: 'assets-use',
    children: [
      { path: 'allot', component: AllotComponent }, //资产调拨
      { path: 'apply', component: ApplyComponent }, //采购申请管理
      { path: 'cancel-stock', component: CancelStockComponent }, //资产退库
      { path: 'check', component: CheckComponent }, //验收记录
      { path: 'contract', component: ContractComponent }, //采购合同管理
      { path: 'dispatch', component: DispatchComponent }, //资产调遣
      { path: 'lease', component: LeaseComponent }, //设备租出
      { path: 'pay', component: PayComponent }, //采购支付管理
      { path: 'personal-change', component: PersonalChangeComponent }, //资产人员变更
      { path: 'property-change', component: PropertyChangeComponent }, //资产产权变更
      { path: 'receive', component: ReceiveComponent }, //领用记录
      { path: 'remembered', component: RememberedComponent }, //资产封存
      { path: 'scrap', component: ScrapComponent }, //报废处置
      { path: 'take-stock', component: TakeStockComponent }, //资产盘点计划
      { path: 'use', component: UseComponent }, //资产使用记录
    ],
  }, // 资产使用
  {
    path: 'canon',
    children: [{ path: 'vendor', component: VendorComponent }], //资产分类 //资产分类
  }, // 制造厂商
  {
    path: 'device-maintain',
    children: [
      { path: 'service-plan', component: ServicePlanComponent }, //维修保养计划
      { path: 'service-record', component: ServiceRecordComponent }, //维修保养记录
    ],
  }, // 设备维保
  {
    path: 'identity-manager',
    children: [
      { path: 'device', component: DeviceComponent }, //设备证件
      { path: 'staff', component: StaffComponent }, //员工证件表
      { path: 'type', component: TypeComponent }, //证件类型
      { path: 'user', component: UserComponent }, //用户证件附件
    ],
  }, // 证件管理
  {
    path: 'matching-agitator',
    children: [{ path: '', component: UseComponent }], //资产分类
  }, // 搅拌站配比
  {
    path: 'single-machine',
    children: [
      { path: 'business', component: BusinessComponent }, //机械设备燃料核算标准
      { path: 'consume', component: ConsumeComponent }, //燃料消耗记录
      { path: 'single', component: SingleComponent }, //单机车核算
    ],
  }, // 单机车核算
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class FixedAssetsRoutingModule {}
