import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";
import { DeviceProfileInfoComponent } from "./asset-material-manager/device-profile-info/device-profile-info.component";
import { HouseProfileInfoComponent } from "./asset-material-manager/house-profile-info/house-profile-info.component";
import { LandProfileInfoComponent } from "./asset-material-manager/land-profile-info/land-profile-info.component";
import { OtherInfoComponent } from "./asset-material-manager/other-info/other-info.component";
import { ContractListTotalComponent } from "./contract-manager/contract-list-total/contract-list-total.component";
import { DeviceContractComponent } from "./contract-manager/device-contract/device-contract.component";
import { DeviceLeaseContractComponent } from "./contract-manager/device-lease-contract/device-lease-contract.component";
import { GoodsContractComponent } from "./contract-manager/goods-contract/goods-contract.component";
import { HouseContractComponent } from "./contract-manager/house-contract/house-contract.component";
import { MaintainContractComponent } from "./contract-manager/maintain-contract/maintain-contract.component";
import { ProfileContractComponent } from "./contract-manager/profile-contract/profile-contract.component";
import { UpkeepContractComponent } from "./contract-manager/upkeep-contract/upkeep-contract.component";
import { VehicleContractComponent } from "./contract-manager/vehicle-contract/vehicle-contract.component";

const routes: Routes = [
  {
    // tslint:disable-next-line: quotemark
    path: "asset-material-manager",
    children: [
      { path: "device-profile-info", component: DeviceProfileInfoComponent }, // 设备档案
      { path: "house-profile-info", component: HouseProfileInfoComponent }, //房屋档案信息
      { path: "land-profile-info", component: LandProfileInfoComponent }, //土地档案
      { path: "other-info", component: OtherInfoComponent } // 其他
    ]
  },
  {
    path: "contract-manager",
    children: [
      { path: "contract-list-total", component: ContractListTotalComponent }, //合同单统计
      { path: "device-contract", component: DeviceContractComponent }, //设备采购
      {
        path: "device-lease-contract",
        component: DeviceLeaseContractComponent
      }, //设备租拚
      { path: "goods-contract", component: GoodsContractComponent }, //物资采购
      { path: "house-contract", component: HouseContractComponent }, //房屋合同
      { path: "maintain-contract", component: MaintainContractComponent }, //维修合同
      { path: "profile-contract", component: ProfileContractComponent }, //材料合同
      { path: "upkeep-contract", component: UpkeepContractComponent }, // 保养合同
      { path: "vehicle-contract", component: VehicleContractComponent } // 车辆合同
    ]
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class FileRoutingModule {}
