import { NgModule } from '@angular/core';
import { SharedModule } from '@shared';

import { AppDefaultComponent } from './default/default.component';
import { LayoutFullScreenComponent } from './fullscreen/fullscreen.component';

const COMPONENTS = [AppDefaultComponent, LayoutFullScreenComponent, TabbarComponent];

// passport
import { LayoutPassportComponent } from './passport/passport.component';
import { TabbarComponent } from './default/tabbar/tabbar.component';
import { MessageComponent } from './default/message/message.component';
import { AssetsComponent } from './default/assets/assets.component';
import { TotalComponent } from './default/total/total.component';
import { UserComponent } from './default/user/user.component';
import { InventoryComponent } from './default/inventory/inventory.component';
const PASSPORT = [LayoutPassportComponent];

@NgModule({
  imports: [SharedModule],
  declarations: [...COMPONENTS, ...PASSPORT, MessageComponent, AssetsComponent, TotalComponent, UserComponent, InventoryComponent],
  exports: [...COMPONENTS, ...PASSPORT],
})
export class LayoutModule {}
