import { Injectable, Inject } from '@angular/core';
import { _HttpClient } from '@delon/theme';
import { DA_SERVICE_TOKEN, ITokenService } from '@delon/auth';

@Injectable({
  providedIn: 'root',
})
export class ListService {
  constructor(@Inject(DA_SERVICE_TOKEN) private tokenService: ITokenService, private http: _HttpClient) {}
  private url = `asset/a/asset/assets/data;`;
  /**
   *获取资产台账列表
   *
   * @param {number} kindAsset  1为类固定 2固定
   * @returns
   * @memberof ListService
   */
  getKindAssetList(kindAsset: number) {
    return this.http.get(this.url, { kindAsset }, { responseType: 'json' });
  }
}
