
import { Component, OnDestroy, Inject, Optional, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { NzMessageService, NzModalService } from 'ng-zorro-antd';
import { HttpClient, HttpParams } from '@angular/common/http';
import { DefaultService } from '../api';




@Component({
  selector: 'passport-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.less'],

})
export class LoginComponent implements OnInit {
  validateForm: FormGroup;
  error: boolean;

  submitForm(): void {
    for (const i in this.validateForm.controls) {
      this.validateForm.controls[i].markAsDirty();
      this.validateForm.controls[i].updateValueAndValidity();
    }
    if(this.validateForm.valid){
       let urlParams:URLSearchParams = new URLSearchParams();
       

        this.http.get(`${this.s.basePath}/user/login/${this.validateForm.value.userName}/${this.validateForm.value.password}`).subscribe(res=>{
          if((res as any).code==1){
            location.href = "./#/home";
          }else{
            this.error=true;
          }
        });
    }
  }

  constructor(private fb: FormBuilder,private http:HttpClient,private s:DefaultService) {}

  ngOnInit(): void {
    this.validateForm = this.fb.group({
      userName: [null, [Validators.required]],
      password: [null, [Validators.required]],
      remember: [true]
    });
  }
}
