/**
 * 智慧监控平台文档
 * 简单优雅的风格
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */
/* tslint:disable:no-unused-variable member-ordering */

import { Inject, Injectable, Optional }                      from '@angular/core';
import { HttpClient, HttpHeaders, HttpParams,
         HttpResponse, HttpEvent }                           from '@angular/common/http';
import { CustomHttpUrlEncodingCodec }                        from '../encoder';



import { Camera } from '../model/camera';
import { Course } from '../model/course';
import { Project } from '../model/project';
import { ResultBeanCamera } from '../model/resultBeanCamera';
import { ResultBeanCourse } from '../model/resultBeanCourse';
import { ResultBeanListCamera } from '../model/resultBeanListCamera';
import { ResultBeanListCourse } from '../model/resultBeanListCourse';
import { ResultBeanListProject } from '../model/resultBeanListProject';
import { ResultBeanListScetion } from '../model/resultBeanListScetion';
import { ResultBeanProject } from '../model/resultBeanProject';
import { ResultBeanScetion } from '../model/resultBeanScetion';
import { ResultBeandouble } from '../model/resultBeandouble';
import { ResultBeanint } from '../model/resultBeanint';
import { Scetion } from '../model/scetion';

import { BASE_PATH, COLLECTION_FORMATS }                     from '../variables';
import { Configuration }                                     from '../configuration';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';

//import {environment} from '../../../environments';
@Injectable()
export class DefaultService {

    public basePath = 'https://localhost:443';
   // public basePath = 'http://192.168.19.199:8081';
     // public basePath = environment.prod? 'http://localhost:8081':'http://192.168.19.199:8081';
    public defaultHeaders = new HttpHeaders();
    public configuration = new Configuration();

    constructor(protected httpClient: HttpClient, @Optional()@Inject(BASE_PATH) basePath: string, @Optional() configuration: Configuration) {
       if(environment.production){
        this.basePath="./";
       }else{
           this.basePath = "http://localhost";
       }
        // if (basePath) {
        //     this.basePath = basePath;
        // }
        // if (configuration) {
        //     this.configuration = configuration;
        //     this.basePath = basePath || configuration.basePath || this.basePath;
        // }
    }

    /**
     * @param consumes string[] mime-types
     * @return true: consumes contains 'multipart/form-data', false: otherwise
     */
    private canConsumeForm(consumes: string[]): boolean {
        const form = 'multipart/form-data';
        for (const consume of consumes) {
            if (form === consume) {
                return true;
            }
        }
        return false;
    }


    /**
     * 新增
     * 
     * @param coordinate 
     * @param delFlag 
     * @param id 
     * @param name 
     * @param section 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public addcameraUsingPOST(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanint>;
    public addcameraUsingPOST(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanint>>;
    public addcameraUsingPOST(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanint>>;
    public addcameraUsingPOST(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {






        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (coordinate !== undefined && coordinate !== null) {
            queryParameters = queryParameters.set('coordinate', <any>coordinate);
        }
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }
        if (section !== undefined && section !== null) {
            queryParameters = queryParameters.set('section', <any>section);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json'
        ];

        return this.httpClient.post<ResultBeanint>(`${this.basePath}/camera/add`,
            null,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 新增
     * 
     * @param delFlag 
     * @param id 
     * @param lineStyle 
     * @param lineWidth 
     * @param mark 
     * @param name 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public addcourseUsingPOST1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanint>;
    public addcourseUsingPOST1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanint>>;
    public addcourseUsingPOST1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanint>>;
    public addcourseUsingPOST1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {







        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (lineStyle !== undefined && lineStyle !== null) {
            queryParameters = queryParameters.set('lineStyle', <any>lineStyle);
        }
        if (lineWidth !== undefined && lineWidth !== null) {
            queryParameters = queryParameters.set('lineWidth', <any>lineWidth);
        }
        if (mark !== undefined && mark !== null) {
            queryParameters = queryParameters.set('mark', <any>mark);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json'
        ];

        return this.httpClient.post<ResultBeanint>(`${this.basePath}/course/add`,
            null,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 新增
     * 
     * @param capital 
     * @param coordinate 
     * @param course 
     * @param delFlag 
     * @param id 
     * @param lineStyle 
     * @param lineWidth 
     * @param mileage 
     * @param name 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public addprojectUsingPOST2(capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanint>;
    public addprojectUsingPOST2(capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanint>>;
    public addprojectUsingPOST2(capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanint>>;
    public addprojectUsingPOST2(capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {










        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (capital !== undefined && capital !== null) {
            queryParameters = queryParameters.set('capital', <any>capital);
        }
        if (coordinate !== undefined && coordinate !== null) {
            queryParameters = queryParameters.set('coordinate', <any>coordinate);
        }
        if (course !== undefined && course !== null) {
            queryParameters = queryParameters.set('course', <any>course);
        }
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (lineStyle !== undefined && lineStyle !== null) {
            queryParameters = queryParameters.set('lineStyle', <any>lineStyle);
        }
        if (lineWidth !== undefined && lineWidth !== null) {
            queryParameters = queryParameters.set('lineWidth', <any>lineWidth);
        }
        if (mileage !== undefined && mileage !== null) {
            queryParameters = queryParameters.set('mileage', <any>mileage);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json'
        ];

        return this.httpClient.post<ResultBeanint>(`${this.basePath}/project/add`,
            null,
            {
                
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 新增
     * 
     * @param coordinate 
     * @param delFlag 
     * @param id 
     * @param lineStyle 
     * @param lineWidth 
     * @param mileage 
     * @param name 
     * @param project 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public addUsingPOST3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanint>;
    public addUsingPOST3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanint>>;
    public addUsingPOST3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanint>>;
    public addUsingPOST3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {









        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (coordinate !== undefined && coordinate !== null) {
            queryParameters = queryParameters.set('coordinate', <any>coordinate);
        }
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (lineStyle !== undefined && lineStyle !== null) {
            queryParameters = queryParameters.set('lineStyle', <any>lineStyle);
        }
        if (lineWidth !== undefined && lineWidth !== null) {
            queryParameters = queryParameters.set('lineWidth', <any>lineWidth);
        }
        if (mileage !== undefined && mileage !== null) {
            queryParameters = queryParameters.set('mileage', <any>mileage);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }
        if (project !== undefined && project !== null) {
            queryParameters = queryParameters.set('project', <any>project);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json'
        ];

        return this.httpClient.post<ResultBeanint>(`${this.basePath}/scetion/add`,
            null,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 删除
     * 
     * @param id id
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public deleteUsingDELETE(id?: number, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanCamera>;
    public deleteUsingDELETE(id?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanCamera>>;
    public deleteUsingDELETE(id?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanCamera>>;
    public deleteUsingDELETE(id?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {


        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.delete<ResultBeanCamera>(`${this.basePath}/camera/delete`,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 删除
     * 
     * @param id id
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public deleteUsingDELETE1(id?: number, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanCourse>;
    public deleteUsingDELETE1(id?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanCourse>>;
    public deleteUsingDELETE1(id?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanCourse>>;
    public deleteUsingDELETE1(id?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {


        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.delete<ResultBeanCourse>(`${this.basePath}/course/delete`,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 删除
     * 
     * @param id id
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public deleteUsingDELETE2(id?: number, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanProject>;
    public deleteUsingDELETE2(id?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanProject>>;
    public deleteUsingDELETE2(id?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanProject>>;
    public deleteUsingDELETE2(id?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {


        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.delete<ResultBeanProject>(`${this.basePath}/project/delete`,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 删除
     * 
     * @param id id
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public deleteUsingDELETE3(id?: number, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanScetion>;
    public deleteUsingDELETE3(id?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanScetion>>;
    public deleteUsingDELETE3(id?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanScetion>>;
    public deleteUsingDELETE3(id?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {


        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.delete<ResultBeanScetion>(`${this.basePath}/scetion/delete`,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 获取摄像头信息
     * 获取摄像头信息
     * @param id 摄像头id是数字
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public getUsingGET(id: string, observe?: 'body', reportProgress?: boolean): Observable<Camera>;
    public getUsingGET(id: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<Camera>>;
    public getUsingGET(id: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<Camera>>;
    public getUsingGET(id: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling getUsingGET.');
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*',
            'application/json'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<Camera>(`${this.basePath}/camera/get/${encodeURIComponent(String(id))}`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 获取路线信息
     * 获取路线信息
     * @param id 路线id是数字
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public getUsingGET1(id: string, observe?: 'body', reportProgress?: boolean): Observable<Course>;
    public getUsingGET1(id: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<Course>>;
    public getUsingGET1(id: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<Course>>;
    public getUsingGET1(id: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling getUsingGET1.');
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*',
            'application/json'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<Course>(`${this.basePath}/course/get/${encodeURIComponent(String(id))}`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 获取项目信息
     * 获取项目信息
     * @param id 项目id是数字
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public getUsingGET2(id: string, observe?: 'body', reportProgress?: boolean): Observable<Project>;
    public getUsingGET2(id: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<Project>>;
    public getUsingGET2(id: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<Project>>;
    public getUsingGET2(id: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling getUsingGET2.');
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*',
            'application/json'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<Project>(`${this.basePath}/project/get/${encodeURIComponent(String(id))}`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 获取标段信息
     * 获取标段信息
     * @param id 标段id是数字
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public getUsingGET3(id: string, observe?: 'body', reportProgress?: boolean): Observable<Scetion>;
    public getUsingGET3(id: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<Scetion>>;
    public getUsingGET3(id: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<Scetion>>;
    public getUsingGET3(id: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (id === null || id === undefined) {
            throw new Error('Required parameter id was null or undefined when calling getUsingGET3.');
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*',
            'application/json'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<Scetion>(`${this.basePath}/scetion/get/${encodeURIComponent(String(id))}`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 获取摄像头列表
     * 
     * @param coordinate 
     * @param delFlag 
     * @param id 
     * @param name 
     * @param section 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public listUsingGET(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanListCamera>;
    public listUsingGET(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanListCamera>>;
    public listUsingGET(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanListCamera>>;
    public listUsingGET(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {






        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (coordinate !== undefined && coordinate !== null) {
            queryParameters = queryParameters.set('coordinate', <any>coordinate);
        }
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }
        if (section !== undefined && section !== null) {
            queryParameters = queryParameters.set('section', <any>section);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<ResultBeanListCamera>(`${this.basePath}/camera/list`,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 获取路线列表
     * 
     * @param delFlag 
     * @param id 
     * @param lineStyle 
     * @param lineWidth 
     * @param mark 
     * @param name 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public listUsingGET1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanListCourse>;
    public listUsingGET1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanListCourse>>;
    public listUsingGET1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanListCourse>>;
    public listUsingGET1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {







        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (lineStyle !== undefined && lineStyle !== null) {
            queryParameters = queryParameters.set('lineStyle', <any>lineStyle);
        }
        if (lineWidth !== undefined && lineWidth !== null) {
            queryParameters = queryParameters.set('lineWidth', <any>lineWidth);
        }
        if (mark !== undefined && mark !== null) {
            queryParameters = queryParameters.set('mark', <any>mark);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<ResultBeanListCourse>(`${this.basePath}/course/list`,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 获取项目列表(高速公路或普通干线)
     * 
     * @param mark mark是数字1高速2普通
     * @param capital 
     * @param coordinate 
     * @param course 
     * @param delFlag 
     * @param id 
     * @param lineStyle 
     * @param lineWidth 
     * @param mileage 
     * @param name 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public listUsingGET2(mark: string, capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanListProject>;
    public listUsingGET2(mark: string, capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanListProject>>;
    public listUsingGET2(mark: string, capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanListProject>>;
    public listUsingGET2(mark: string, capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (mark === null || mark === undefined) {
            throw new Error('Required parameter mark was null or undefined when calling listUsingGET2.');
        }










        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (capital !== undefined && capital !== null) {
            queryParameters = queryParameters.set('capital', <any>capital);
        }
        if (coordinate !== undefined && coordinate !== null) {
            queryParameters = queryParameters.set('coordinate', <any>coordinate);
        }
        if (course !== undefined && course !== null) {
            queryParameters = queryParameters.set('course', <any>course);
        }
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (lineStyle !== undefined && lineStyle !== null) {
            queryParameters = queryParameters.set('lineStyle', <any>lineStyle);
        }
        if (lineWidth !== undefined && lineWidth !== null) {
            queryParameters = queryParameters.set('lineWidth', <any>lineWidth);
        }
        if (mileage !== undefined && mileage !== null) {
            queryParameters = queryParameters.set('mileage', <any>mileage);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<ResultBeanListProject>(`${this.basePath}/project/list/${encodeURIComponent(String(mark))}`,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 获取标段列表
     * 
     * @param coordinate 
     * @param delFlag 
     * @param id 
     * @param lineStyle 
     * @param lineWidth 
     * @param mileage 
     * @param name 
     * @param project 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public listUsingGET3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanListScetion>;
    public listUsingGET3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanListScetion>>;
    public listUsingGET3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanListScetion>>;
    public listUsingGET3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {









        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (coordinate !== undefined && coordinate !== null) {
            queryParameters = queryParameters.set('coordinate', <any>coordinate);
        }
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (lineStyle !== undefined && lineStyle !== null) {
            queryParameters = queryParameters.set('lineStyle', <any>lineStyle);
        }
        if (lineWidth !== undefined && lineWidth !== null) {
            queryParameters = queryParameters.set('lineWidth', <any>lineWidth);
        }
        if (mileage !== undefined && mileage !== null) {
            queryParameters = queryParameters.set('mileage', <any>mileage);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }
        if (project !== undefined && project !== null) {
            queryParameters = queryParameters.set('project', <any>project);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<ResultBeanListScetion>(`${this.basePath}/scetion/list`,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 统计总投资
     * 
     * @param mark mark是数字1高速2普通
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public totalCapitalUsingGET(mark: string, observe?: 'body', reportProgress?: boolean): Observable<ResultBeandouble>;
    public totalCapitalUsingGET(mark: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeandouble>>;
    public totalCapitalUsingGET(mark: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeandouble>>;
    public totalCapitalUsingGET(mark: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (mark === null || mark === undefined) {
            throw new Error('Required parameter mark was null or undefined when calling totalCapitalUsingGET.');
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<ResultBeandouble>(`${this.basePath}/project/totalCapital/${encodeURIComponent(String(mark))}`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 统计里程数
     * 
     * @param mark mark是数字1高速2普通
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public totalMileageUsingGET(mark: string, observe?: 'body', reportProgress?: boolean): Observable<ResultBeandouble>;
    public totalMileageUsingGET(mark: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeandouble>>;
    public totalMileageUsingGET(mark: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeandouble>>;
    public totalMileageUsingGET(mark: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (mark === null || mark === undefined) {
            throw new Error('Required parameter mark was null or undefined when calling totalMileageUsingGET.');
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<ResultBeandouble>(`${this.basePath}/project/totalMileage/${encodeURIComponent(String(mark))}`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 统计项目个数
     * 
     * @param mark mark是数字1高速2普通
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public totalUsingGET(mark: string, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanint>;
    public totalUsingGET(mark: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanint>>;
    public totalUsingGET(mark: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanint>>;
    public totalUsingGET(mark: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {

        if (mark === null || mark === undefined) {
            throw new Error('Required parameter mark was null or undefined when calling totalUsingGET.');
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
        ];

        return this.httpClient.get<ResultBeanint>(`${this.basePath}/project/total/${encodeURIComponent(String(mark))}`,
            {
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 修改
     * 
     * @param coordinate 
     * @param delFlag 
     * @param id 
     * @param name 
     * @param section 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public updateUsingPUT(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanCamera>;
    public updateUsingPUT(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanCamera>>;
    public updateUsingPUT(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanCamera>>;
    public updateUsingPUT(coordinate?: string, delFlag?: number, id?: number, name?: string, section?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {






        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (coordinate !== undefined && coordinate !== null) {
            queryParameters = queryParameters.set('coordinate', <any>coordinate);
        }
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }
        if (section !== undefined && section !== null) {
            queryParameters = queryParameters.set('section', <any>section);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json'
        ];

        return this.httpClient.put<ResultBeanCamera>(`${this.basePath}/camera/update`,
            null,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 修改
     * 
     * @param delFlag 
     * @param id 
     * @param lineStyle 
     * @param lineWidth 
     * @param mark 
     * @param name 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public updateUsingPUT1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanCourse>;
    public updateUsingPUT1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanCourse>>;
    public updateUsingPUT1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanCourse>>;
    public updateUsingPUT1(delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mark?: number, name?: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {







        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (lineStyle !== undefined && lineStyle !== null) {
            queryParameters = queryParameters.set('lineStyle', <any>lineStyle);
        }
        if (lineWidth !== undefined && lineWidth !== null) {
            queryParameters = queryParameters.set('lineWidth', <any>lineWidth);
        }
        if (mark !== undefined && mark !== null) {
            queryParameters = queryParameters.set('mark', <any>mark);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json'
        ];

        return this.httpClient.put<ResultBeanCourse>(`${this.basePath}/course/update`,
            null,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 修改
     * 
     * @param capital 
     * @param coordinate 
     * @param course 
     * @param delFlag 
     * @param id 
     * @param lineStyle 
     * @param lineWidth 
     * @param mileage 
     * @param name 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public updateUsingPUT2(capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanProject>;
    public updateUsingPUT2(capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanProject>>;
    public updateUsingPUT2(capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanProject>>;
    public updateUsingPUT2(capital?: number, coordinate?: string, course?: number, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {










        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (capital !== undefined && capital !== null) {
            queryParameters = queryParameters.set('capital', <any>capital);
        }
        if (coordinate !== undefined && coordinate !== null) {
            queryParameters = queryParameters.set('coordinate', <any>coordinate);
        }
        if (course !== undefined && course !== null) {
            queryParameters = queryParameters.set('course', <any>course);
        }
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (lineStyle !== undefined && lineStyle !== null) {
            queryParameters = queryParameters.set('lineStyle', <any>lineStyle);
        }
        if (lineWidth !== undefined && lineWidth !== null) {
            queryParameters = queryParameters.set('lineWidth', <any>lineWidth);
        }
        if (mileage !== undefined && mileage !== null) {
            queryParameters = queryParameters.set('mileage', <any>mileage);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json'
        ];

        return this.httpClient.put<ResultBeanProject>(`${this.basePath}/project/update`,
            null,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

    /**
     * 修改
     * 
     * @param coordinate 
     * @param delFlag 
     * @param id 
     * @param lineStyle 
     * @param lineWidth 
     * @param mileage 
     * @param name 
     * @param project 
     * @param observe set whether or not to return the data Observable as the body, response or events. defaults to returning the body.
     * @param reportProgress flag to report request and response progress.
     */
    public updateUsingPUT3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe?: 'body', reportProgress?: boolean): Observable<ResultBeanScetion>;
    public updateUsingPUT3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe?: 'response', reportProgress?: boolean): Observable<HttpResponse<ResultBeanScetion>>;
    public updateUsingPUT3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe?: 'events', reportProgress?: boolean): Observable<HttpEvent<ResultBeanScetion>>;
    public updateUsingPUT3(coordinate?: string, delFlag?: number, id?: number, lineStyle?: string, lineWidth?: number, mileage?: number, name?: string, project?: number, observe: any = 'body', reportProgress: boolean = false ): Observable<any> {









        let queryParameters = new HttpParams({encoder: new CustomHttpUrlEncodingCodec()});
        if (coordinate !== undefined && coordinate !== null) {
            queryParameters = queryParameters.set('coordinate', <any>coordinate);
        }
        if (delFlag !== undefined && delFlag !== null) {
            queryParameters = queryParameters.set('delFlag', <any>delFlag);
        }
        if (id !== undefined && id !== null) {
            queryParameters = queryParameters.set('id', <any>id);
        }
        if (lineStyle !== undefined && lineStyle !== null) {
            queryParameters = queryParameters.set('lineStyle', <any>lineStyle);
        }
        if (lineWidth !== undefined && lineWidth !== null) {
            queryParameters = queryParameters.set('lineWidth', <any>lineWidth);
        }
        if (mileage !== undefined && mileage !== null) {
            queryParameters = queryParameters.set('mileage', <any>mileage);
        }
        if (name !== undefined && name !== null) {
            queryParameters = queryParameters.set('name', <any>name);
        }
        if (project !== undefined && project !== null) {
            queryParameters = queryParameters.set('project', <any>project);
        }

        let headers = this.defaultHeaders;

        // to determine the Accept header
        let httpHeaderAccepts: string[] = [
            '*/*'
        ];
        const httpHeaderAcceptSelected: string | undefined = this.configuration.selectHeaderAccept(httpHeaderAccepts);
        if (httpHeaderAcceptSelected != undefined) {
            headers = headers.set('Accept', httpHeaderAcceptSelected);
        }

        // to determine the Content-Type header
        const consumes: string[] = [
            'application/json'
        ];

        return this.httpClient.put<ResultBeanScetion>(`${this.basePath}/scetion/update`,
            null,
            {
                params: queryParameters,
                withCredentials: this.configuration.withCredentials,
                headers: headers,
                observe: observe,
                reportProgress: reportProgress
            }
        );
    }

}
