import { Component, OnInit } from '@angular/core';
import { DynamicScriptLoaderService } from '../dynamic-script.service';
declare var WebControl;
declare var JSEncrypt;
declare var $;
const width=1500;
const height =700;
@Component({
  selector: 'app-video',
  templateUrl: './video.component.html',
  styleUrls: ['./video.component.less']
})
export class VideoComponent implements OnInit {

  constructor(private dynamicScriptLoader: DynamicScriptLoaderService) { }
  oWebControl = null;
  pubKey = null;
  initCount = 0;
  nodeItems = [{
    id: '0',
    name: '高速公路(67/92)',
    children: [
      {
        id: '1',
        name: '东二环高速(8/8)',
        item: {
          phrase: 'I am the batman'
        },
        children: [
          {
            id: '5',
            name: '第一分部(16/17)',
            item: {
              phrase: 'I am the villain of this story'
            },
            children: [
              {
                id: "6",
                name: "第一分部_001_一分部拌合站入口"
              },
              {
                id: "6",
                name: "第一分部_002_一分部拌合站"
              }, {
                id: "6",
                name: "第一分部_003_一分部钢筋棚1"
              }
             
            ]
          }
        ]
      },
      {
        id: '2',
        name: '第二分部(16/17)',
        item: {
          phrase: 'Man of steel'
        }
      },
      {
        id: '2',
        name: '第三分部(16/17)',
        item: {
          phrase: 'Man of steel'
        }
      }
     


    ]
  },
  {
    id: '2',
    name: '普通干线(16/17)',
    children: [
      {
        id: '4',
        name: 'G207(8/8)',
        item: {
          phrase: 'Why so serius'
        },
        children: [
          {
            id: '5',
            name: '第一分部(16/17)',
            item: {
              phrase: 'I am the villain of this story'
            },
            children: [
              {
                id: "6",
                name: "第一分部_001_一分部拌合站入口"
              },
              {
                id: "6",
                name: "第一分部_002_一分部拌合站"
              }, {
                id: "6",
                name: "第一分部_003_一分部钢筋棚1"
              },
              {
                id: "6",
                name: "第一分部_004_一分部钢筋棚2"
              },
              {
                id: "6",
                name: "第一分部_005_一分部化验室院"
              },
              {
                id: "6",
                name: "第一分部_006_一分部项目部3"
              }
            ]
          }
        ]
      },

    ]
  },
  {
    id: "6",
    name: "演示demo"
  }];
  cams = Array(16);
  ngOnInit() {
    this.dynamicScriptLoader.load('jquery', 'jsencrypt', 'jswebcontrol').then(() => {
     this.startVideo();
    });
  }
  preview() {
    var cameraIndexCode  ="862edc0a09734e83a69101f69f840e0d";     //获取输入的监控点编号值，必填
    var streamMode = 0;                                     //主子码流标识：0-主码流，1-子码流
    var transMode = 1;                                      //传输协议：0-UDP，1-TCP
    var gpuMode = 0;                                        //是否启用GPU硬解，0-不启用，1-启用
    var wndId = -1;                                         //播放窗口序号（在2x2以上布局下可指定播放窗口）

    cameraIndexCode = cameraIndexCode.replace(/(^\s*)/g, "");
    cameraIndexCode = cameraIndexCode.replace(/(\s*$)/g, "");

    this.oWebControl.JS_RequestInterface({
        funcName: "startPreview",
        argument: JSON.stringify({
            cameraIndexCode:cameraIndexCode,                //监控点编号
            streamMode: streamMode,                         //主子码流标识
            transMode: transMode,                           //传输协议
            gpuMode: gpuMode,                               //是否开启GPU硬解
            wndId:wndId                                     //可指定播放窗口
        })
    })
  }
  preview2() {
    var cameraIndexCode  ="bb44edc4e843421da68f33699e7203f2";     //获取输入的监控点编号值，必填
    var streamMode = 0;                                     //主子码流标识：0-主码流，1-子码流
    var transMode = 1;                                      //传输协议：0-UDP，1-TCP
    var gpuMode = 0;                                        //是否启用GPU硬解，0-不启用，1-启用
    var wndId = 2;                                         //播放窗口序号（在2x2以上布局下可指定播放窗口）

    cameraIndexCode = cameraIndexCode.replace(/(^\s*)/g, "");
    cameraIndexCode = cameraIndexCode.replace(/(\s*$)/g, "");

    this.oWebControl.JS_RequestInterface({
        funcName: "startPreview",
        argument: JSON.stringify({
            cameraIndexCode:cameraIndexCode,                //监控点编号
            streamMode: streamMode,                         //主子码流标识
            transMode: transMode,                           //传输协议
            gpuMode: gpuMode,                               //是否开启GPU硬解
            wndId:wndId                                     //可指定播放窗口
        })
    })
  }
  startVideo() {
   	// 监听resize事件，使插件窗口尺寸跟随DIV窗口变化
	 $(window).resize(function () { 
    if (oWebControl != null) {
        oWebControl.JS_Resize(1500, 700);
        setWndCover();
    }
});

// 监听滚动条scroll事件，使插件窗口跟随浏览器滚动而移动
$(window).scroll(function () {
    if (oWebControl != null) {
        oWebControl.JS_Resize(1500, 700);
        setWndCover();
    }
});


// 设置窗口裁剪，当因滚动条滚动导致窗口需要被遮住的情况下需要JS_CuttingPartWindow部分窗口
function setWndCover() {
    var iWidth = $(window).width();
    var iHeight = $(window).height();
    var oDivRect = $("#playWnd").get(0).getBoundingClientRect();

    var iCoverLeft = (oDivRect.left < 0) ? Math.abs(oDivRect.left): 0;
    var iCoverTop = (oDivRect.top < 0) ? Math.abs(oDivRect.top): 0;
    var iCoverRight = (oDivRect.right - iWidth > 0) ? Math.round(oDivRect.right - iWidth) : 0;
    var iCoverBottom = (oDivRect.bottom - iHeight > 0) ? Math.round(oDivRect.bottom - iHeight) : 0;

    iCoverLeft = (iCoverLeft > 1500) ? 1500 : iCoverLeft;
    iCoverTop = (iCoverTop > 700) ? 700 : iCoverTop;
    iCoverRight = (iCoverRight > 1500) ? 1500 : iCoverRight;
    iCoverBottom = (iCoverBottom > 700) ? 700 : iCoverBottom;

oWebControl.JS_RepairPartWindow(0, 0, 1001, 700);    // 多1个像素点防止还原后边界缺失一个像素条
    if (iCoverLeft != 0) {
  oWebControl.JS_CuttingPartWindow(0, 0, iCoverLeft, 700);
    }
    if (iCoverTop != 0) {
        oWebControl.JS_CuttingPartWindow(0, 0, 1001, iCoverTop);    // 多剪掉一个像素条，防止出现剪掉一部分窗口后出现一个像素条
    }
    if (iCoverRight != 0) {
        oWebControl.JS_CuttingPartWindow(1500 - iCoverRight, 0, iCoverRight, 700);
    }
    if (iCoverBottom != 0) {
        oWebControl.JS_CuttingPartWindow(0, 700 - iCoverBottom, 1500, iCoverBottom);
    }
}
    let pubKey = null;
     //RSA加密
  function setEncrypt(value) {
    var encrypt = new JSEncrypt();
    encrypt.setPublicKey(pubKey);
    return encrypt.encrypt(value);
  }
     //初始化
  function init(oWebControl) {
     //获取公钥
  function getPubKey(oWebControl, callback) {
    oWebControl.JS_RequestInterface({
      funcName: "getRSAPubKey",
      argument: JSON.stringify({
        keyLength: 1024
      })
    }).then(function (oData) {
      console.log(oData);
      if (oData.responseMsg.data) {
        pubKey = oData.responseMsg.data;
        callback()
      }
    })
  }
    getPubKey(oWebControl, function () {

      ////////////////////////////////// 请自行修改以下变量值	////////////////////////////////////		
      var appkey = "29359046";                           //综合安防管理平台提供的appkey，必填
      var secret = setEncrypt("zRjsouOfWQQW5Yl4Ddgl");   //综合安防管理平台提供的secret，必填
      var ip = "192.168.19.175";                           //综合安防管理平台IP地址，必填
      var playMode = 0;                                  //初始播放模式：0-预览，1-回放
      var port = 443;                                    //综合安防管理平台端口，若启用HTTPS协议，默认443
      var snapDir = "D:\\SnapDir";                       //抓图存储路径
      var videoDir = "D:\\VideoDir";                     //紧急录像或录像剪辑存储路径
      var layout = "4x6";                                //playMode指定模式的布局
      var enableHTTPS = 1;                               //是否启用HTTPS协议与综合安防管理平台交互，是为1，否为0
      var encryptedFields = 'secret';					   //加密字段，默认加密领域为secret
      var showToolbar = 1;                               //是否显示工具栏，0-不显示，非0-显示
      var showSmart = 1;                                 //是否显示智能信息（如配置移动侦测后画面上的线框），0-不显示，非0-显示
      var buttonIDs = "0,16,256,257,258,259,260,512,513,514,515,516,517,768,769";  //自定义工具条按钮
      ////////////////////////////////// 请自行修改以上变量值	////////////////////////////////////

      oWebControl.JS_RequestInterface({
        funcName: "init",
        argument: JSON.stringify({
          appkey: appkey,                            //API网关提供的appkey
          secret: secret,                            //API网关提供的secret
          ip: ip,                                    //API网关IP地址
          playMode: playMode,                        //播放模式（决定显示预览还是回放界面）
          port: port,                                //端口
          snapDir: snapDir,                          //抓图存储路径
          videoDir: videoDir,                        //紧急录像或录像剪辑存储路径
          layout: layout,                            //布局
          enableHTTPS: enableHTTPS,                  //是否启用HTTPS协议
          encryptedFields: encryptedFields,          //加密字段
          showToolbar: showToolbar,                  //是否显示工具栏
          showSmart: showSmart,                      //是否显示智能信息
          buttonIDs: buttonIDs                       //自定义工具条按钮
        })
      }).then(function (oData) {
        var cameraIndexCode  ="862edc0a09734e83a69101f69f840e0d";     //获取输入的监控点编号值，必填
        var streamMode = 0;                                     //主子码流标识：0-主码流，1-子码流
        var transMode = 1;                                      //传输协议：0-UDP，1-TCP
        var gpuMode = 0;                                        //是否启用GPU硬解，0-不启用，1-启用
        var wndId = -1;                                         //播放窗口序号（在2x2以上布局下可指定播放窗口）
    
        cameraIndexCode = cameraIndexCode.replace(/(^\s*)/g, "");
        cameraIndexCode = cameraIndexCode.replace(/(\s*$)/g, "");
    
        // oWebControl.JS_RequestInterface({
        //     funcName: "startPreview",
        //     argument: JSON.stringify({
        //         cameraIndexCode:cameraIndexCode,                //监控点编号
        //         streamMode: streamMode,                         //主子码流标识
        //         transMode: transMode,                           //传输协议
        //         gpuMode: gpuMode,                               //是否开启GPU硬解
        //         wndId:wndId                                     //可指定播放窗口
        //     })
        // })
        oWebControl.JS_Resize(1500, 700);  // 初始化后resize一次，规避firefox下首次显示窗口后插件窗口未与DIV窗口重合问题
      });
    });
  }
    let oWebControl = new WebControl({
      szPluginContainer: "playWnd",                       // 指定容器id
      iServicePortStart: 15900,                           // 指定起止端口号，建议使用该值
      iServicePortEnd: 15909,
      szClassId: "23BF3B0A-2C56-4D97-9C03-0CB103AA8F11",   // 用于IE10使用ActiveX的clsid
      cbConnectSuccess: function () {                     // 创建WebControl实例成功											
        oWebControl.JS_StartService("window", {         // WebControl实例创建成功后需要启动服务
          dllPath: "./VideoPluginConnect.dll"         // 值"./VideoPluginConnect.dll"写死 
        }).then(function () {                           // 启动插件服务成功
          oWebControl.JS_SetWindowControlCallback({   // 设置消息回调
            cbIntegrationCallBack: function (msg) { console.log(msg) }
          });

          oWebControl.JS_CreateWnd("playWnd", 900, 700).then(function () { //JS_CreateWnd创建视频播放窗口，宽高可设定
            init(oWebControl);  // 创建播放实例成功后初始化
          });
        }, function () { // 启动插件服务失败
        });
      },
      cbConnectError: function () { // 创建WebControl实例失败
        oWebControl = null;
        console.log("插件未启动，正在尝试启动，请稍候...");
        WebControl.JS_WakeUp("VideoWebPlugin://"); // 程序未启动时执行error函数，采用wakeup来启动程序
        this.initCount++;
        if (this.initCount < 3) {
          setTimeout(function () {
            this.initPlugin();
          }, 3000)
        } else {
          console.log("插件启动失败，请检查插件是否安装！");
        }
      },
      cbConnectClose: function (bNormalClose) {
        // 异常断开：bNormalClose = false
        // JS_Disconnect正常断开：bNormalClose = true	
        console.log("cbConnectClose");
        oWebControl = null;
      }
    });
    this.oWebControl = oWebControl;
  }
 
  ngOnDestory(){
    if (this.oWebControl != null){
			this.oWebControl.JS_HideWnd();   // 先让窗口隐藏，规避可能的插件窗口滞后于浏览器消失问题 
            this.oWebControl.JS_Disconnect().then(function(){  // 断开与插件服务连接成功
			}, 
			function() {  // 断开与插件服务连接失败
			});
        }
  }
  back(){
    if (this.oWebControl != null){
			this.oWebControl.JS_HideWnd();   // 先让窗口隐藏，规避可能的插件窗口滞后于浏览器消失问题 
            this.oWebControl.JS_Disconnect().then(function(){  // 断开与插件服务连接成功
			}, 
			function() {  // 断开与插件服务连接失败
			});
        }
        history.back();
  }

 
}
