import { Injectable } from '@angular/core';
import { Point } from 'angular2-baidu-map';
declare var mapv;
declare var map;
@Injectable({
  providedIn: 'root'
})
export class SelfMapService {

  
  constructor() { 

  }

  
/**
 * 转换为平滑点
 * @param points 点
 */
  toPoints(points: Array<Point>,cursiveLength:number,cursive:boolean) {

    if (!points) {
      return []
    }
    if(cursive){
      var newPoints = this.getCurvePoints(points,{count:cursiveLength});
      return newPoints.map(p => {
        return new window.BMap.Point(p[0], p[1])
      })
    }else{
      return points.map(p => {
        return new window.BMap.Point(p[0], p[1])
      })
    }
  }

/**
 * 将线进行动画效果
 * @param data 线的数据：例如：[{
                                    geometry: {
                                        type: 'LineString',
                                        coordinates: [[cityCenter1.lng, cityCenter1.lat], [cityCenter2.lng, cityCenter2.lat]]
                                    },
                                    count: 100 * Math.random()
                                }]
 */
  animationLine(points:Array<Point>){
    // var randomCount = 500;

    // var node_data = {
    //     "0":{"x":108.154518, "y":36.643346},
    //     "1":{"x":121.485124, "y":31.235317},
    // };

    // var edge_data = [
    //     {"source":1, "target":"0"}
    // ]

    // var citys = ["北京","天津","上海","重庆","石家庄","太原","呼和浩特","哈尔滨","长春","沈阳","济南","南京","合肥","杭州","南昌","福州","郑州","武汉","长沙","广州","南宁","西安","银川","兰州","西宁","乌鲁木齐","成都","贵阳","昆明","拉萨","海口"];

    // // 构造数据
    // for (var i = 1; i < randomCount; i++) {
    //     var cityCenter = mapv.utilCityCenter.getCenterByCityName(citys[(Math.random() * citys.length)]);
    //     node_data[i] = {
    //         x: cityCenter.lng - 5 + Math.random() * 10,
    //         y: cityCenter.lat - 5 + Math.random() * 10,
    //     }
    //     edge_data.push(
    //         {"source": ~~(i * Math.random()), "target": '0'}
    //     );
    // }

    // var fbundling = mapv.utilForceEdgeBundling()
    //                 .nodes(node_data)
    //                 .edges(edge_data);

    // var results = fbundling();  
   // var points = [{"lng":112.801023,"lat":38.053938},{"lng":112.81942,"lat":37.987989},{"lng":112.857364,"lat":37.853174},{"lng":112.842991,"lat":37.793431}];
    var data = [];
    var timeData = [];

    
         var coordinates = [];
        for (var j = 0; j < points.length; j++) {
             coordinates.push([points[j].lng, points[j].lat]);
             timeData.push({
                 geometry: {
                    type: 'Point',
                    coordinates: [points[j].lng, points[j].lat]
               },
               count: 1,
                time: j
             });
        }
        data.push({
            geometry: {
               type: 'LineString',
               coordinates: coordinates
            }
         });
    

     var dataSet = new mapv.DataSet(data);

    var options = {
        strokeStyle: 'rgba(55, 50, 250, 0.3)',
        globalCompositeOperation: 'lighter',
        shadowColor: 'rgba(55, 50, 250, 0.5)',
        shadowBlur: 10,
        methods: {
            click: function (item) {
            }
        },
        lineWidth: 5.0,
        draw: 'simple'
    }
  //   var options = {
  //     strokeStyle: 'rgba(0,57,255,0.5)',
  //     coordType: 'bd09mc',
  //     // globalCompositeOperation: 'lighter',
  //     shadowColor: 'rgba(53,57,255,0.2)',
  //     shadowBlur: 3,
  //     lineWidth: 3.0,
  //     draw: 'simple'
  // }


    var mapvLayer1 = new mapv.baiduMapLayer(map, dataSet, options);

     var dataSet2 = new mapv.DataSet(timeData);

     var options2 = {
        fillStyle: 'rgba(200, 200, 50, 1)',
        globalCompositeOperation: 'lighter',
        size: 2.5,
        animation: {
            type: 'time',
            stepsRange: {
                start: 0,
                end: 100
            },
            trails: 20,
            duration: 2,
        },
        draw: 'simple'
    }

     var mapvLayer2 = new mapv.baiduMapLayer(map, dataSet2, options2);

  }
  /**
  * 根据弧线的坐标节点数组
  */
 getCurvePoints (points, options) {
  options = options || {};
  var curvePoints = [];
  for (var i = 0; i < points.length - 1; i++) {
    //TODO:获取拐角的两个点
    var p = this.getCurveByTwoPoints(points[i], points[i + 1], options.count);
    if (p && p.length > 0) {
      curvePoints = curvePoints.concat(p);
    }
  }
  return curvePoints;
}

/**
 * 根据两点获取曲线坐标点数组
 * @param Point 起点
 * @param Point 终点
 */
 getCurveByTwoPoints (obj1, obj2, count) {
  console.info(obj1, obj2)
  if (!obj1 || !obj2) {
    return null;
  }

  var B1 = function (x) {
    return 1 - 2 * x + x * x;
  };
  var B2 = function (x) {
    return 2 * x - 2 * x * x;
  };
  var B3 = function (x) {
    return x * x;
  };

  var curveCoordinates = [];

  var count = count || 40; // 曲线是由一些小的线段组成的，这个表示这个曲线所有到的折线的个数
  var isFuture = false;
  var t, h, h2, lat3, lng3, j, t2;
  var LnArray = [];
  var i = 0;
  var inc = 0;

  if (typeof (obj2) == "undefined") {
    if (typeof (curveCoordinates) != "undefined") {
      curveCoordinates = [];
    }
    return;
  }

  var lat1 = parseFloat(obj1.lat);
  var lat2 = parseFloat(obj2.lat);
  var lng1 = parseFloat(obj1.lng);
  var lng2 = parseFloat(obj2.lng);

  // 计算曲线角度的方法
  if (lng2 > lng1) {
    if (parseFloat((lng2 - lng1) as any) > 180) {
      if (lng1 < 0) {
        lng1 = parseFloat((180 + 180 + lng1) as any);
        lng2 = parseFloat((180 + 180 + lng2) as any);
      }
    }
  }
  // 此时纠正了 lng1 lng2
  j = 0;
  t2 = 0;
  // 纬度相同
  if (lat2 == lat1) {
    t = 0;
    h = lng1 - lng2;
    // 经度相同
  } else if (lng2 == lng1) {
    t = Math.PI / 2;
    h = lat1 - lat2;
  } else {
    t = Math.atan((lat2 - lat1) / (lng2 - lng1));
    h = (lat2 - lat1) / Math.sin(t);
  }
  if (t2 == 0) {
    t2 = (t + (Math.PI / 5));
  }
  h2 = h / 2;
  lng3 = h2 * Math.cos(t2) + lng1;
  lat3 = h2 * Math.sin(t2) + lat1;

  for (i = 0; i < count + 1; i++) {
    var x = lng1 * B1(inc) + lng3 * B2(inc) + lng2 * B3(inc);
    var y = lat1 * B1(inc) + lat3 * B2(inc) + lat2 * B3(inc);
    var lng1_src = obj1.lng;
    var lng2_src = obj2.lng;

    curveCoordinates.push([
      (lng1_src < 0 && lng2_src > 0) ? x - 360 : x, y
    ]);
    inc = inc + (1 / count);
  }
  return curveCoordinates;
}

}
