import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { MainComponent } from './main/main.component';
import { VideoComponent } from './video/video.component';
import { BaiduMapModule } from 'angular2-baidu-map';
import { FormsModule } from '@angular/forms';
import { ModalComponent } from './modal/modal.component';
import { ApiModule } from './api';
import { HttpClientModule } from '@angular/common/http';
import { ColorPickerModule } from 'ngx-color-picker';
import {WebcamModule} from 'ngx-webcam';
import { TreeNgxModule } from 'tree-ngx';

@NgModule({
  declarations: [
    AppComponent,
    MainComponent,
    VideoComponent,
    ModalComponent
  ],
  imports: [
   
    
    HttpClientModule,
    BrowserModule,
    AppRoutingModule,
    ColorPickerModule,
    FormsModule,
    ApiModule,
    TreeNgxModule,
    WebcamModule,
    BaiduMapModule.forRoot({ ak: 'KhQqnL3owyAzqjr4zCGbWiiHwPFmKTD6' })
  ],
  providers: [],
  bootstrap: [AppComponent]
})
export class AppModule { }
