/*
Navicat MySQL Data Transfer

Source Server         : mysql5.5
Source Server Version : 50528
Source Host           : localhost:3306
Source Database       : supervise

Target Server Type    : MYSQL
Target Server Version : 50528
File Encoding         : 65001

Date: 2019-08-02 10:06:10
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `t_camera`
-- ----------------------------
DROP TABLE IF EXISTS `t_camera`;
CREATE TABLE `t_camera` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `section_id` int(64) DEFAULT NULL COMMENT '标段名称',
  `camera_name` text COMMENT '摄像头名称(位置)',
  `coordinate` text COMMENT '坐标',
  `del_flag` varchar(64) DEFAULT NULL COMMENT '逻辑删除标记（0：显示；1：隐藏）',
  `camera_url` varchar(255) DEFAULT NULL,
  `cameraIndex_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `section_id_fk` (`section_id`),
  CONSTRAINT `section_id_fk` FOREIGN KEY (`section_id`) REFERENCES `t_section` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='摄像头';

-- ----------------------------
-- Records of t_camera
-- ----------------------------
INSERT INTO `t_camera` VALUES ('1', null, '视频2@DS-7716N-K4(C38670741)', null, '0', null, 'bb44edc4e843421da68f33699e7203f2');
INSERT INTO `t_camera` VALUES ('2', null, '视频1@DS-7716N-K4(C38670741)', null, '0', null, '862edc0a09734e83a69101f69f840e0d');

-- ----------------------------
-- Table structure for `t_course`
-- ----------------------------
DROP TABLE IF EXISTS `t_course`;
CREATE TABLE `t_course` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(64) DEFAULT NULL COMMENT '路线名称',
  `line_style` varchar(64) DEFAULT NULL COMMENT '绘线样式',
  `line_width` int(11) DEFAULT NULL COMMENT '线宽',
  `mark` int(11) DEFAULT NULL COMMENT '标识（1、高速公路2、普通干线）',
  `del_flag` varchar(64) DEFAULT NULL COMMENT '逻辑删除标记（0：显示；1：隐藏）',
  `coordinate` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8 COMMENT='路线';

-- ----------------------------
-- Records of t_course
-- ----------------------------
INSERT INTO `t_course` VALUES ('67', '东二环', '#c61414', '5', '1', '0', '[[112.92187791298784,38.04671110328035],[112.91828469094793,38.04011817045279],[112.91785350430314,38.03613938689108],[112.91799723318474,38.031023487729286],[112.90994841581534,38.01806159725598],[112.90807994035457,38.010670010623706],[112.90419926055147,38.00555231801986],[112.90448671831466,37.992927136050724],[112.90233078509071,37.98758067779861],[112.899025020814,37.983485252544575],[112.89571925653728,37.98052730205618],[112.88838908357586,37.97620392737104],[112.88508331929914,37.97222164452961],[112.88149009725923,37.96698745574845],[112.87775314633772,37.96391503924325],[112.87142907554747,37.96152529233128],[112.85878093396698,37.95776981730611],[112.85375042311111,37.95572129475978],[112.849869743308,37.95207933464019],[112.84728262343927,37.94764044955351],[112.8377965172539,37.92669436950139],[112.83305346416121,37.92225393810825],[112.82356735797585,37.91667455128009],[112.8212676958703,37.91394163465928],[112.82026159369913,37.910866981070996],[112.82069278034392,37.90779219789664],[112.82816668218693,37.88922686558903],[112.82859786883172,37.882733579786155],[112.83118498870046,37.87601185124736],[112.83075380205567,37.87134045525007],[112.83104125981886,37.866212969453244],[112.83046634429247,37.86188281233714],[112.82845413995013,37.857780321549804],[112.82629820672618,37.85424743662923],[112.82471718902862,37.84889080155844],[112.82198634027829,37.8443316540606],[112.81436870955368,37.83156452886595],[112.81192531856654,37.8247240808735],[112.81293142073771,37.8187951753541],[112.81508735396166,37.811953533719446],[112.81537481172485,37.80807631963579],[112.81465616731687,37.804084855386165],[112.81666837165922,37.79918075861874],[112.8176744738304,37.79473257293061],[112.8172432871856,37.791082577809],[112.81580599836964,37.78401019480063]]');
INSERT INTO `t_course` VALUES ('68', '平远堡', '#19a61c', '5', '1', '0', '[[114.0774289260944,40.683244291615786],[114.08777740556934,40.68280660882735],[114.12284725267888,40.69331019628933],[114.13836997189131,40.695935832455895],[114.15331777557734,40.69506063198721],[114.17861405873832,40.69331019628933]]');
INSERT INTO `t_course` VALUES ('69', 'S45', '#19a61c', '5', '1', '0', '[[114.15734218426203,40.69418541993167],[114.14986828241902,40.678429621634045],[114.14584387373432,40.67098807866577],[114.13836997189131,40.66573472083409],[114.12514691478442,40.656102481598836],[114.11077402662478,40.65084794210225],[114.10387504030815,40.64471711893429],[114.10387504030815,40.63683379795585],[114.10847436451924,40.62456898926704],[114.10904928004562,40.60178546441555],[114.12284725267888,40.5540022865412],[114.1222723371525,40.5465467638598],[114.11594826636225,40.535142581685854],[114.11249877320394,40.51847141120989],[114.10330012478177,40.50399042523348],[114.09640113846514,40.490823157706366],[114.0814533347791,40.47721424518396],[114.06075637582921,40.46491993408427],[114.03488517714185,40.45701525049669],[113.97796854002964,40.45042729808207],[113.95094751028951,40.44383869469849],[113.91990207186467,40.44120307107867],[113.90092985949393,40.43637082394239],[113.8900064644926,40.429780831898576],[113.87218408317464,40.424947757382135],[113.85551153290945,40.414401652557096],[113.84976237764559,40.40077713451274],[113.85148712422475,40.383632663634906],[113.85148712422475,40.371760837594394],[113.84343830685535,40.35021028697031],[113.8164172771152,40.323372348943465],[113.8089433752722,40.315891006605824],[113.79916981132364,40.308408828720424],[113.78997116290145,40.295643185189164],[113.78134743000567,40.290360138774325],[113.76237521763494,40.282434788646015],[113.75375148473914,40.268783379106324],[113.74570266736974,40.260415013188904],[113.73995351210588,40.251164552718556],[113.73765385000034,40.24808078265526],[113.72558062394624,40.24191281768295],[113.70890807368104,40.231337845602944],[113.68706128367837,40.22120193538795],[113.67096364893958,40.20445229981929],[113.64854194341052,40.19739857342462],[113.64106804156751,40.19122595606893],[113.63186939314534,40.18240694894052],[113.6255453223551,40.166088739244714],[113.62439549130232,40.15329602647062],[113.61807142051208,40.1307926044021],[113.6128971807746,40.1153447325426],[113.60772294103712,40.106957263383926],[113.60254870129965,40.10121786801157],[113.59220022182471,40.09636107535221],[113.580701911297,40.08973761316704],[113.56920360076927,40.06986332842474],[113.56632902313734,40.04556459596342],[113.55713037471517,40.0216991624785],[113.55713037471517,39.997383124206884],[113.56977851629566,39.981462444353134],[113.58415140445531,39.973058355439825],[113.59507479945664,39.95934418449168],[113.60599819445797,39.931464906290074],[113.59852429261495,39.90933034473803],[113.59564971498303,39.89073173984551],[113.58702598208724,39.88010168118735],[113.57092834734843,39.859279670851976],[113.56287952997903,39.840224166309035],[113.56747885419011,39.81761653994632],[113.56862868524289,39.78346924939972],[113.5761025870859,39.76394883845904],[113.58242665787616,39.75818037643985],[113.58702598208724,39.75108006223651],[113.58760089761363,39.7315503940857],[113.6008239547205,39.712015147117484],[113.60714802551074,39.69425099112328],[113.61519684288015,39.68492296393344],[113.62324566024955,39.67825930954726],[113.63129447761895,39.660042013937634]]');
INSERT INTO `t_course` VALUES ('70', 'G55', '#19a61c', '5', '1', '0', '[[113.1443410267701,40.38934797606155],[113.16273832361445,40.375718347201136],[113.17883595835326,40.34625126781519],[113.19148409993375,40.32821277225938],[113.20470715704062,40.3150107937509],[113.21735529862111,40.292121200498954],[113.22942852467521,40.27715070157355],[113.24150175072931,40.259534071868615],[113.25300006125704,40.24940241573755],[113.2748468512597,40.2357442862654],[113.2874949928402,40.22825316519201],[113.29611872573598,40.20930130763533],[113.30474245863176,40.19695769096535],[113.30646720521092,40.19254870746101],[113.303592627579,40.179320023423315],[113.30819195179008,40.17005839750189],[113.32428958652889,40.16300106549179],[113.33751264363576,40.158148720748194],[113.35016078521625,40.14358958935087],[113.36568350442867,40.134323049768994],[113.38350588574663,40.12196568227571],[113.40477776022291,40.11622756338524],[113.41800081732978,40.10784020396935],[113.42260014154087,40.091503933278325],[113.42260014154087,40.073838653136],[113.41972556390894,40.062353743659706],[113.41512623969786,40.05307604579464],[113.41800081732978,40.04556459596342],[113.42260014154087,40.03451683059814],[113.42260014154087,40.03319097750975]]');
INSERT INTO `t_course` VALUES ('71', 'S5501', '#19a61c', '5', '1', '0', '[[113.30186788099984,40.17976102145011],[113.28979465494574,40.17490988425906],[113.28174583757632,40.15373719493917],[113.27312210468054,40.14623693812459],[113.26909769599584,40.13520563222754],[113.2587492165209,40.125496589759855],[113.25759938546813,40.10784020396935],[113.25644955441535,40.09945180201872],[113.2507003991515,40.091503933278325],[113.23977700415016,40.087088046371754],[113.2219546228322,40.0844383756238],[113.21620546756834,40.07958037593612],[113.20700681914616,40.076047065807174],[113.19665833967122,40.06456253167799],[113.19665833967122,40.05175055645092],[113.20585698809339,40.04468084113145],[113.20873156572532,40.03937806964312],[113.20873156572532,40.02258321752807],[113.21563055204196,40.014626306429],[113.22137970730581,40.0004783776066],[113.2300034402016,39.997383124206884],[113.24322649730847,40.00003620720793],[113.25702446994174,39.99649874011755],[113.26737294941668,39.9907499621447],[113.28347058415548,39.981462444353134],[113.29784347231514,39.97748168999133]]');
INSERT INTO `t_course` VALUES ('72', 'G55', '#19a61c', '5', '1', '0', '[[113.29726855678875,40.03098116462853],[113.3150909381067,40.01904692805373],[113.30876686731646,40.011089601308264],[113.30129296547345,40.0026891863073],[113.29784347231514,39.992076646506014],[113.29784347231514,39.983673873549655],[113.29784347231514,39.97792400757477],[113.29726855678875,39.96332600366561],[113.29266923257767,39.95005236416678],[113.28347058415548,39.93633354193838],[113.27714651336524,39.923497294969856],[113.27024752704861,39.90578814562599],[113.26047396310005,39.88940307336789],[113.24437632836124,39.87655795912338],[113.23517767993907,39.86548263799848],[113.22137970730581,39.85529175063921],[113.20873156572532,39.84509933777959],[113.19953291730315,39.83180259379879],[113.18056070493242,39.80475787853128],[113.16906239440469,39.7874613732692],[113.15296475966589,39.77415338572073],[113.14549085782288,39.76661104126149],[113.13456746282154,39.754186540484056],[113.11674508150358,39.74220363198065],[113.10467185544948,39.73021862264102],[113.0914487983426,39.71112704880231],[113.0793755722885,39.685811402211804],[113.06327793754969,39.67115069712493],[113.04430572517896,39.64448683311524],[113.03108266807209,39.632929271999274],[113.01728469543882,39.611142422824926],[113.00463655385833,39.600913558315085],[112.98278976385566,39.58178594333322]]');
INSERT INTO `t_course` VALUES ('73', 'G55', '#19a61c', '5', '1', '0', '[[113.3150909381067,40.019931017741285],[113.3191153467914,40.01904692805373],[113.32084009337056,40.02700331958308],[113.32658924863443,40.02037305825532],[113.33866247468853,40.02037305825532],[113.3518855317954,40.02258321752807],[113.37028282863976,40.024351292988804],[113.39212961864241,40.02523531339987],[113.42260014154087,40.03363293142591]]');
INSERT INTO `t_course` VALUES ('74', 'S30云州', '#19a61c', '5', '1', '0', '[[113.42317505706725,40.03451683059814],[113.45364557996571,40.034074882455386],[113.48124152523224,40.030539193392265],[113.5025133997085,40.0274453139124],[113.51228696365708,40.027887305355115],[113.52780968286949,40.03098116462853],[113.55080630392493,40.03186509844105],[113.56460427655819,40.0274453139124],[113.58242665787616,40.02567731927554],[113.60714802551074,40.02700331958308],[113.62784498446064,40.02700331958308],[113.65716567630632,40.031423132978134],[113.6859114526256,40.03098116462853],[113.69970942525887,40.0287712795807],[113.7273053705254,40.03098116462853],[113.7554762313183,40.04070380148752],[113.77789793684735,40.04512271999089],[113.79916981132364,40.04468084113145],[113.81756710816798,40.047332070984474],[113.84688780001366,40.04644833924777],[113.88080781607043,40.05086688245342],[113.91300308554804,40.04821579117343],[113.9348498755507,40.03937806964312],[113.96417056739638,40.04158760828299]]');
INSERT INTO `t_course` VALUES ('75', 'S30左云', '#19a61c', '5', '1', '0', '[[113.25072959408057,40.2507687642594],[113.23865636802647,40.245922747728734],[113.22600822644597,40.24416047319625],[113.21565974697103,40.24019518643023],[113.2001370277586,40.238873372154615],[113.19036346381004,40.23711091266082],[113.18058989986149,40.23270456163062],[113.17254108249209,40.23138259996853],[113.1472447993311,40.230501277744466],[113.13229699564508,40.22873859861824],[113.0989518951147,40.22212814009887],[113.06043255484684,40.221687419746246],[113.04088542694971,40.217280057287],[113.0167389748415,40.21551703139293],[112.99949150904993,40.21551703139293],[112.98511862089029,40.211990840903724],[112.96729623957232,40.20714202702282],[112.9483240272016,40.19964771787677],[112.93740063220025,40.19523891066548],[112.91727858877675,40.183774659742724],[112.9029057006171,40.17936481241723],[112.88048399508806,40.169662131366664],[112.86496127587563,40.15422316623668],[112.8500134721896,40.14495808861438],[112.84541414797852,40.13878066251279],[112.84253957034659,40.13083742566777],[112.83621549955633,40.12024498752381],[112.82816668218693,40.1074435719323],[112.82586702008139,40.103911719524774],[112.8172432871856,40.09905512068538],[112.80057073692042,40.09508127991734],[112.79194700402462,40.092873489531826],[112.78332327112884,40.086691292395464],[112.7729747916539,40.08050852929577],[112.76837546744281,40.0778586004324],[112.7482534240193,40.07476688538071],[112.73388053585965,40.07079161528072],[112.72870629612218,40.068141305284726],[112.72065747875277,40.06195684441253],[112.71260866138337,40.054446381157945],[112.70226018190843,40.051795430213],[112.68501271611684,40.048260667281184],[112.67293949006275,40.045167598151046],[112.65684185532395,40.042958176451094],[112.64476862926983,40.04649321652834],[112.63039574111019,40.045609473830396],[112.61257335979222,40.050911756801916],[112.58670216110487,40.050911756801916],[112.56600520215497,40.055330008376615],[112.55048248294256,40.05709722816919],[112.53898417241483,40.055330008376615],[112.5320851860982,40.054446381157945],[112.5200119600441,40.054004563218015],[112.4993150010942,40.053562742391065],[112.48034278872348,40.050911756801916],[112.46367023845828,40.04781880892338],[112.44814751924586,40.04737694767862],[112.43779903977092,40.050911756801916],[112.42457598266404,40.05974797124523],[112.41710208082102,40.06504914558547],[112.41077801003078,40.07079161528072],[112.40732851687247,40.07520856762172]]');
INSERT INTO `t_course` VALUES ('76', 'G59', '#19a61c', '5', '1', '0', '[[112.30729321528132,40.23975458456167],[112.31879152580903,40.22212814009887],[112.32626542765206,40.215076267695345],[112.33086475186315,40.204497072087186],[112.33431424502146,40.194357114551444],[112.34408780897002,40.18597947506408],[112.36018544370882,40.18245173588048],[112.37628307844763,40.176277747390714],[112.37915765607956,40.165692449750296],[112.37973257160594,40.14937018921084],[112.38433189581703,40.137015579643275],[112.38835630450173,40.1149481446147],[112.39812986845028,40.08713289667461],[112.40502885476693,40.08006688170385],[112.40675360134608,40.076091923441545]]');
INSERT INTO `t_course` VALUES ('77', 'G59朔州', '#19a61c', '5', '1', '0', '[[112.40560377029331,40.07830026246156],[112.40042953055584,40.07211673130011],[112.39583020634474,40.068141305284726],[112.39410545976558,40.06018975165299],[112.39123088213366,40.05709722816919],[112.38260714923787,40.05312091867708],[112.37053392318377,40.045609473830396],[112.35846069712966,40.038539116537606],[112.35558611949773,40.03235194767999],[112.35558611949773,40.02395417068637],[112.36363493686714,40.01467120481825],[112.37283358528931,40.00671336380306],[112.37915765607956,39.997428034028424],[112.38663155792257,39.98637241050039],[112.39065596660727,39.97398797079196],[112.39295562871281,39.96425575243356],[112.38663155792257,39.94301697382222],[112.3935305442392,39.911589092105054],[112.38605664239618,39.88634773400742],[112.39065596660727,39.871730032935304],[112.3975549529239,39.86242622426865],[112.39985461502945,39.845144348390576],[112.40272919266138,39.8389395282471],[112.42170140503211,39.82874466824903],[112.43090005345428,39.82386832645987],[112.43664920871815,39.81766156871332],[112.44067361740285,39.8101240317538],[112.43952378635008,39.801698739764525],[112.43779903977092,39.79593346666621],[112.44009870187647,39.78706286445002],[112.43779903977092,39.77907833661146],[112.4389488708237,39.7644376100309],[112.42860039134874,39.74402408761525],[112.42917530687512,39.73603452756007],[112.42515089819042,39.72804403383457],[112.41997665845295,39.72316049472401],[112.41307767213632,39.71694457705381],[112.40732851687247,39.712060245552564],[112.40272919266138,39.70539923165756],[112.39180579766004,39.68230269799879],[112.38433189581703,39.674305929105174],[112.37628307844763,39.66719690655847],[112.3653596834463,39.6631977573182],[112.35846069712966,39.657865195398635],[112.35328645739219,39.65297664927685],[112.35386137291857,39.63564172304176],[112.34408780897002,39.628528691233235],[112.33488916054785,39.62141492219287],[112.32569051212568,39.60940876529658],[112.31879152580903,39.602293015105964],[112.30269389107023,39.5978452969199],[112.29694473580638,39.58939383913514],[112.29407015817445,39.57871682789584],[112.29349524264806,39.57827191644021],[112.28774608738419,39.568038158396384],[112.28429659422588,39.56180816877184],[112.2871711718578,39.55068178398626],[112.28487150975226,39.539108435418484],[112.27912235448841,39.532430618493365],[112.26647421290792,39.52441638339265],[112.26187488869684,39.519963627643484],[112.263599635276,39.5106119038348],[112.26877387501347,39.5021497268625],[112.2716484526454,39.495022877382404],[112.2716484526454,39.48433122201488],[112.28199693212034,39.47363790937031],[112.28832100291058,39.46650811362004],[112.29751965133276,39.45759483325522],[112.2998193134383,39.450017640211655],[112.2957949047536,39.43708992165091],[112.29521998922722,39.42951047920784],[112.30154406001746,39.41925461638228],[112.30614338422855,39.409443237003856],[112.31016779291325,39.400076530972136],[112.31246745501879,39.39516965502376],[112.31074270843963,39.38535485930399],[112.30959287738686,39.37509244849133],[112.31764169475626,39.36616737666146],[112.32339085002012,39.359919142118],[112.32626542765206,39.355902122355936],[112.32684034317845,39.34920657195018],[112.32511559659928,39.34072461290563],[112.32799017423122,39.33313461203823],[112.33891356923255,39.32331102485546],[112.34753730212833,39.31393266664547],[112.35386137291857,39.30678640014168],[112.35616103502412,39.29651235309763],[112.35788578160327,39.285789987575505],[112.35616103502412,39.28400276573464]]');
INSERT INTO `t_course` VALUES ('78', '朔州至神池', '#670a72', '5', '1', '0', '[[112.35443628844496,39.28310913757323],[112.3527115418658,39.26121165737981],[112.34638747107556,39.250930869357035],[112.33488916054785,39.2393072789762],[112.31706677922988,39.226787394547316],[112.29234541159529,39.21158165024953],[112.27394811475094,39.20218820834286],[112.24980166264272,39.195030450128755],[112.21933113974428,39.1838449811403],[112.19518468763607,39.172657717418225],[112.17506264421256,39.158335401194364],[112.15264093868352,39.14132383216526],[112.13884296605025,39.12833853000039],[112.12964431762808,39.11848600075676],[112.1204456692059,39.10818414389394]]');
INSERT INTO `t_course` VALUES ('79', 'S59五寨', '#19a61c', '5', '1', '0', '[[112.1204456692059,39.108632082285965],[112.11527142946844,39.0956407036877],[112.1089473586782,39.08802394582995],[112.10147345683517,39.08309501351379],[112.09457447051854,39.079061992444224],[112.092274808413,39.072787942121636],[112.09112497736022,39.06113464230624],[112.08710056867552,39.05172094573972],[112.07847683577974,39.04499610213113],[112.06525377867285,39.03961576248776],[112.04628156630213,39.03199290751597],[112.03133376261609,39.02392074570227],[112.01581104340367,39.01629618396078],[111.99338933787462,39.010016510694264],[111.97959136524136,39.002839052888966],[111.9657933926081,38.99566086087041],[111.95027067339568,38.99296884958159],[111.93474795418327,38.99296884958159],[111.92784896786664,38.98713580428216],[111.9169255728653,38.97546825977569],[111.90600217786397,38.966491906494014],[111.89622861391541,38.95616768234811],[111.89507878286264,38.944943979333075],[111.8887547120724,38.935514684101406],[111.89047945865155,38.92653322759267],[111.88932962759878,38.917101464236744],[111.88473030338768,38.909465301416425],[111.87898114812383,38.90497305400179],[111.86575809101696,38.90272682281698],[111.84908554075176,38.89688628641666],[111.83356282153935,38.89014660411976],[111.81229094706306,38.88789990006509],[111.8025173831145,38.88610248523864],[111.77147194468967,38.87531703343604],[111.76744753600497,38.85778715411055],[111.7622732962675,38.84789658172449],[111.75192481679255,38.833957512607526],[111.74905023916062,38.81596754927857],[111.73812684415928,38.80832042710947],[111.72835328021073,38.80202217558193],[111.7134054765247,38.80337184816519],[111.70593157468168,38.80472149497272],[111.69845767283866,38.80427161556753],[111.68983393994287,38.80157227899294],[111.68293495362624,38.802921960168064],[111.67546105178323,38.79977266399775],[111.66223799467635,38.79482348649129],[111.64556544441116,38.79122386701933],[111.63751662704176,38.78132396845819],[111.63004272519873,38.775023311398144],[111.61452000598632,38.77097259264055],[111.60877085072246,38.77097259264055],[111.60877085072246,38.77097259264055]]');
INSERT INTO `t_course` VALUES ('80', 'S40河曲', '#19a61c', '4', '1', '0', '[[112.11785854933717,39.11131965236545],[112.10061108354559,39.10415256921217],[112.08566327985956,39.09160840578099],[112.07531480038462,39.083543112618045],[112.05576767248749,39.079061992444224],[112.04081986880146,39.07368426945832],[112.03047138932651,39.072787942121636],[112.0189730787988,39.07726946402732],[111.99942595090168,39.07726946402732],[111.98332831616287,39.07995823943551],[111.96033169510743,39.07995823943551],[111.93848490510477,39.082646911539946],[111.9085892977327,39.090712308011724],[111.89709098720499,39.10146472360619],[111.87754385930786,39.11042380715287],[111.85684690035798,39.12565161435024],[111.83385027930254,39.13102534231268],[111.81315332035264,39.14714404598553],[111.79360619245553,39.14983013487995],[111.7786583887695,39.156992533312255],[111.77290923350563,39.16325902902042],[111.7579614298196,39.16504935300433],[111.74761295034466,39.168629863153505],[111.73496480876416,39.173105242424285],[111.72461632928922,39.18831938411126],[111.7131180187615,39.19905677958783],[111.70966852560319,39.20353020615916],[111.70851869455042,39.22052660783559],[111.70621903244488,39.226787394547316],[111.6889715666533,39.23483615020796],[111.6809227492839,39.23662463618639],[111.6728739319145,39.23573039894232],[111.66252545243954,39.23483615020796],[111.65332680401737,39.24109565005007],[111.64527798664797,39.241989818350994],[111.63837900033134,39.24824867471229],[111.62918035190916,39.25540096393511],[111.61653221032867,39.27327846921568],[111.60158440664264,39.280428184125924],[111.60043457558987,39.29561888585784],[111.60043457558987,39.30276630191495],[111.59353558927323,39.30723306335293],[111.594685420326,39.317058926881394],[111.59123592716769,39.32331102485546],[111.57513829242889,39.32688339933821],[111.56708947505949,39.34384966591978],[111.54294302295128,39.34920657195018],[111.52914505031802,39.35545577245248],[111.51534707768475,39.35813382875037],[111.50269893610427,39.36527480622657],[111.48775113241824,39.36705993559619],[111.47165349767943,39.37063005633235],[111.4567056939934,39.36973754339885],[111.43945822820181,39.36527480622657],[111.42910974872687,39.364382224291624],[111.41761143819916,39.36973754339885],[111.39691447924926,39.37241504769785],[111.383116506616,39.38133931447802],[111.37621752029936,39.38133931447802],[111.36586904082442,39.38044693955465],[111.35437073029671,39.37687732484972],[111.34862157503285,39.37241504769785],[111.33367377134681,39.371522557765374],[111.3221754608191,39.36705993559619],[111.28308120502486,39.37687732484972],[111.27043306344437,39.37776974577752],[111.25548525975833,39.37776974577752],[111.23133880765013,39.38401637024024],[111.2278893144918,39.39293914184171],[111.22558965238626,39.39650792842614],[111.21064184870023,39.40186076322938],[111.20834218659469,39.40721318393182],[111.20604252448915,39.42594339514046]]');
INSERT INTO `t_course` VALUES ('81', 'G1812保德', '#19a61c', '4', '1', '0', '[[111.6073335619065,38.77277294072178],[111.61078305506481,38.77907379822164],[111.60618373085373,38.78447408652145],[111.59698508243156,38.78987396246571],[111.58893626506215,38.80067247722318],[111.5785877855872,38.80877028073832],[111.57283863032335,38.81236900666147],[111.56823930611226,38.81056966661286],[111.55904065769009,38.819565908584885],[111.54524268505682,38.819565908584885],[111.52339589505416,38.816867156290726],[111.5176467397903,38.81416830088357],[111.5095979224209,38.818666335943966],[111.48775113241824,38.82406359992978],[111.47050366662666,38.82406359992978],[111.4567056939934,38.816867156290726],[111.44750704557121,38.81146934236543],[111.43485890399073,38.80966997940379],[111.42336059346302,38.80517137151389],[111.40956262082975,38.80517137151389],[111.39576464819649,38.80337184816519],[111.38196667556323,38.80067247722318],[111.36471920977165,38.80337184816519],[111.34977140608562,38.81146934236543],[111.3382730955579,38.82136501949503],[111.33252394029404,38.82766154676949],[111.32792461608295,38.833957512607526],[111.32102562976632,38.83485689046563],[111.3141266434497,38.832158722516134],[111.3060778260803,38.829460451442344],[111.29457951555257,38.83125931028304],[111.28308120502486,38.83755495528883],[111.27848188081377,38.84654775987275],[111.277332049761,38.861832897684934],[111.277332049761,38.86902475766728],[111.27273272554991,38.882507518034245],[111.26698357028606,38.890595936333476],[111.25433542870556,38.904074570125964],[111.24743644238893,38.91126212013081],[111.23593813186122,38.91395726221682],[111.22328999028072,38.91575396628295],[111.21524117291132,38.91844893639386],[111.20719235554192,38.92473679869718],[111.2037428623836,38.931024099175985],[111.19454421396144,38.935514684101406],[111.171547592906,38.93641276668675],[111.15659978921995,38.937310837805335],[111.1428018165867,38.94090300761074],[111.12900384395344,38.945392961856925],[111.12095502658404,38.95078052852489],[111.11635570237294,38.95706550117987],[111.11060654710909,38.95975888886438],[111.09680857447583,38.96245217333121],[111.07841127763147,38.966043058722754],[111.07151229131485,38.966043058722754],[111.06231364289268,38.9651453545784],[111.05081533236496,38.971429042734556],[111.03356786657338,38.975917047331905],[111.01862006288735,38.97860971245174],[111.00712175235962,38.97860971245174],[110.99332377972637,38.97412187990225]]');
INSERT INTO `t_course` VALUES ('82', 'S59离石', '#19a61c', '4', '1', '0', '[[111.60503389980096,38.77097259264055],[111.58893626506215,38.77367309758241],[111.5578908266373,38.77997387490674],[111.53144471242356,38.77997387490674],[111.51419724663198,38.771872772407804],[111.49694978084041,38.76467101358434],[111.49005079452378,38.753867001039936],[111.48775113241824,38.74846437636365],[111.47740265294328,38.74576290943157],[111.46245484925726,38.74126023552373],[111.45095653872954,38.73045265018877],[111.44290772136013,38.71603997167097],[111.43485890399073,38.70793155201559],[111.42681008662133,38.7016243623075],[111.41071245188252,38.69711888337803],[111.39461481714372,38.690810732103735],[111.38771583082709,38.68179811448043],[111.38886566187986,38.669178526941025],[111.38771583082709,38.66196632691686],[111.38196667556323,38.658359952244844],[111.36816870292996,38.653851726420875],[111.3509212371384,38.63671785928156],[111.34057275766345,38.62499230707688],[111.29113002239426,38.58619401429933],[111.29227985344703,38.56452995698224],[111.27618221870823,38.54827759122168],[111.26353407712773,38.52750528818054],[111.25318559765279,38.52389209635371],[111.24973610449447,38.51847196564763],[111.23133880765013,38.516665163957214],[111.21409134185855,38.508533990494165],[111.20259303133084,38.50401627181788],[111.20144320027806,38.48142339218637],[111.20489269343638,38.47148026222124],[111.20604252448915,38.46696020057768],[111.19224455185588,38.464248026463345],[111.1795964102754,38.464248026463345],[111.16234894448382,38.462439853251695],[111.14510147869224,38.46153574950547],[111.11865536447849,38.464248026463345],[111.10255772973969,38.46334394557101],[111.09680857447583,38.456110887067645],[111.10140789868692,38.424457658325004],[111.10140789868692,38.40998294987739],[111.09565874342306,38.401839641346236],[111.09910823658137,38.388265404605576],[111.11520587132017,38.38374008799305],[111.12440451974236,38.37468859827955],[111.12210485763681,38.36110922263864],[111.12785401290067,38.34933835233579],[111.13360316816453,38.339376878115175],[111.13705266132284,38.32760244586992],[111.1347529992173,38.31310818869427],[111.13935232342838,38.302235578294095],[111.13820249237561,38.28320455567146],[111.1347529992173,38.26870135121245],[111.1347529992173,38.24966146274313],[111.13590283027007,38.236965408760426],[111.14510147869224,38.2278954299393],[111.1347529992173,38.21428832310566],[111.13245333711176,38.1997712474382],[111.13245333711176,38.18797397389103],[111.11290620921463,38.177082472562965],[111.09680857447583,38.1734516072688],[111.08760992605366,38.16255791690627],[111.07036246026207,38.1516625849354],[111.0611638118399,38.14439811835454],[111.04966550131219,38.140765611500036],[111.03011837341506,38.138949289684085],[111.01747023183458,38.13168354651138],[111.00942141446517,38.12078356409897],[111.00252242814854,38.108973397937895],[111.00137259709577,38.09897867625262],[110.99677327288468,38.08443843813795],[110.98872445551528,38.069895283451665],[110.97722614498757,38.05898600364466],[110.96802749656538,38.05443998628738],[110.9714769897237,38.04261900854658],[110.9760763139348,38.025338732730624],[110.96802749656538,37.99804571722982],[110.96112851024876,37.98803571081944],[110.95192986182659,37.975293710501134],[110.95192986182659,37.96254947918238],[110.95767901709044,37.95435558105366],[110.95882884814321,37.937054324486546],[110.96227834130153,37.923392536038214],[110.96572783445984,37.91337226414203],[110.9634281723543,37.90335061565391],[110.96572783445984,37.894238831653134],[110.95652918603767,37.886037253489974],[110.95882884814321,37.88056902287215],[110.95767901709044,37.87327741179305],[110.95192986182659,37.8678082258166],[110.94273121340441,37.85686862565856],[110.9473305376155,37.850486436025456],[110.95307969287936,37.84045615519166],[110.95307969287936,37.828600413250626],[110.95307969287936,37.81583054248533],[110.95422952393213,37.79119664290905],[110.95767901709044,37.787546471628964],[110.97032715867093,37.77385670990295],[110.98527496235697,37.766554458198435],[110.99447361077914,37.76016439141482],[111.00597192130685,37.75103475881376],[111.01402073867627,37.74190399009584],[111.02666888025675,37.736424983565996],[111.04391634604832,37.73916453795098],[111.06346347394545,37.73551177605141],[111.07496178447316,37.727292397246224],[111.08186077078979,37.712677896530366],[111.08071093973702,37.69897416150149],[111.08416043289533,37.687095524325706],[111.08071093973702,37.675214968169534],[111.08071093973702,37.675214968169534],[111.08186077078979,37.66150424986934],[111.0899095881592,37.64870527491376],[111.08875975710643,37.63681852032632],[111.08186077078979,37.62950264101748],[111.06576313605099,37.618527460161054],[111.05541465657605,37.60297649000137],[111.05081533236496,37.59108235903384],[111.0531149944705,37.57644079649751],[111.05426482552328,37.56637303765407],[111.06691296710376,37.558134759547734],[111.07611161552593,37.55447300771241],[111.07611161552593,37.54531783421389],[111.0772614465787,37.534330129032845],[111.0692126292093,37.52425663146954],[111.06346347394545,37.51876141815218],[111.05656448762882,37.51234982006314],[111.05771431868159,37.50227332923447],[111.0692126292093,37.50135721659275]]');
INSERT INTO `t_course` VALUES ('83', 'S2005', '#19a61c', '4', '1', '0', '[[111.08416043289533,37.687095524325706],[111.09565874342306,37.677956805288176],[111.10485739184523,37.677956805288176],[111.11980519553126,37.68344017296463],[111.13245333711176,37.67430099975571],[111.14395164763947,37.668816950849155],[111.15315029606164,37.665160691181285],[111.16694826869491,37.66698884372109],[111.18649539659202,37.66333249323046],[111.19224455185588,37.657847626919086],[111.20144320027806,37.652362351934514],[111.211791679753,37.65144809970634],[111.22099032817518,37.65510504050974],[111.23018897659735,37.66059011116015],[111.24398694923062,37.66059011116015],[111.25433542870556,37.659675961098635],[111.25778492186387,37.65601924733141],[111.2646839081805,37.65510504050974],[111.27963171186654,37.65144809970634],[111.28308120502486,37.643219318850505],[111.29802900871088,37.63773295416609],[111.3060778260803,37.62675899901188],[111.31297681239693,37.62675899901188],[111.31987579871355,37.61578340960762],[111.3221754608191,37.60480618611011],[111.32447512292464,37.593827328676376],[111.32332529187187,37.58559211342505],[111.31757613660801,37.57918631069143],[111.31642630555524,37.564542388584286],[111.29457951555257,37.55081107440895],[111.277332049761,37.539824185748564],[111.26813340133883,37.53158294758729],[111.25203576660002,37.52608827853317]]');
INSERT INTO `t_course` VALUES ('84', 'G20', '#19a61c', '4', '1', '0', '[[110.71276500285005,37.449120059771154],[110.71276500285005,37.44453609645733],[110.723113482325,37.44086872185372],[110.73346196179995,37.44086872185372],[110.74381044127489,37.43353342879844],[110.75760841390816,37.42986551035871],[110.7679568933831,37.42894850242561],[110.7840545281219,37.423446216919636],[110.79555283864963,37.423446216919636],[110.8047514870718,37.419777800010706],[110.81969929075782,37.42161203112184],[110.83234743233832,37.42161203112184],[110.8415460807605,37.423446216919636],[110.85534405339375,37.417943523587],[110.8656925328687,37.415192023991985],[110.87719084339642,37.42161203112184],[110.88523966076582,37.423446216919636],[110.90133729550462,37.42252912968494],[110.91513526813789,37.42803148316344],[110.92433391656006,37.43628424866833],[110.93123290287669,37.442702431816485],[110.9392817202461,37.4463697157755],[110.95078003077381,37.453703739806706],[110.95997867919598,37.4601204159268],[110.96687766551261,37.45645381184962],[110.97492648288203,37.45920378190566],[110.98642479340974,37.46103703861571],[110.99562344183191,37.46287024999643],[111.000222766043,37.470202642210715],[111.00942141446517,37.47295210229466],[111.01862006288735,37.48119987052488],[111.0324180355206,37.48394892258607],[111.04161668394278,37.485781567287034],[111.06001398078713,37.485781567287034],[111.07266212236762,37.50227332923447],[111.08416043289533,37.505937666435244],[111.09910823658137,37.510517832855705],[111.11175637816186,37.5150977158426],[111.12440451974236,37.51143383212814],[111.13360316816453,37.50685372239347],[111.14165198553393,37.50868580029891],[111.14510147869224,37.51601365842693],[111.15774962027274,37.52242493905101],[111.171547592906,37.52608827853317],[111.18419573448648,37.527919880241164],[111.20144320027806,37.52975143659278],[111.21524117291132,37.53158294758729],[111.23133880765013,37.53158294758729],[111.24168728712507,37.53341441322393],[111.24973610449447,37.52700408505667],[111.2646839081805,37.50960182224593],[111.27388255660269,37.49952495730018],[111.29572934660534,37.488530449326895],[111.31067715029138,37.482116232546446],[111.32792461608295,37.479367112478705],[111.36011988556056,37.46745308012733],[111.37391785819382,37.46287024999643],[111.39806431030203,37.4555371325004],[111.42106093135747,37.454620441819394],[111.44750704557121,37.442702431816485],[111.46360468031003,37.4417855825003],[111.48315180820714,37.43353342879844],[111.5015491050515,37.42803148316344],[111.5095979224209,37.42528035740336],[111.51649690873752,37.4115231992783],[111.51649690873752,37.398680885579694],[111.52684538821248,37.36840093473286],[111.53029488137079,37.35830487747864],[111.52799521926525,37.35187940048711],[111.53604403663465,37.3445353189418],[111.5417931918985,37.33719051288901],[111.55214167137345,37.33719051288901],[111.5624901508484,37.33627236119289],[111.57513829242889,37.32617194546431],[111.58548677190383,37.32158039465689],[111.59123592716769,37.316070160193036],[111.59583525137879,37.29861839658469],[111.59583525137879,37.286675362519475],[111.60618373085373,37.27748711206658],[111.61078305506481,37.26921671935297],[111.6314800140147,37.263702615138016],[111.64872747980628,37.25634984271328],[111.6682746077034,37.24807710842441],[111.68667190454775,37.23704537093792],[111.70736886349765,37.237964744598415],[111.71541768086705,37.2407227977233],[111.72576616034199,37.24164212614574],[111.7372644708697,37.24899634636616],[111.74071396402802,37.26002631941902],[111.74416345718635,37.27105466359129],[111.75451193666129,37.279324852668125],[111.77060957140009,37.28943161702803],[111.77750855771671,37.30045561671087],[111.7947560235083,37.31147798690796],[111.80855399614155,37.31790695028529],[111.81660281351097,37.32525365793951],[111.83500011035531,37.32984498237719],[111.85109774509412,37.33719051288901],[111.8602963935163,37.346371407252605],[111.8798435214134,37.35279735973593],[111.89594115615222,37.35830487747864],[111.90973912878547,37.36472979969967],[111.92238727036596,37.37023643431253],[111.94193439826309,37.37574266129475],[111.95458253984357,37.38400123741609],[111.96838051247684,37.39501124534749],[111.98677780932118,37.4041850061464],[111.99712628879614,37.41610920185147],[112.01437375458771,37.43995184987685],[112.02357240300988,37.45187030178663],[112.03047138932651,37.468369612154895],[112.04426936195978,37.48303258323354],[112.05576767248749,37.48944672067007],[112.07301513827908,37.50227332923447],[112.0879629419651,37.51326579666061],[112.11440905617886,37.51876141815218],[112.14315483249815,37.52242493905101],[112.1696009467119,37.52608827853317],[112.18799824355625,37.534330129032845],[112.20754537145336,37.54623340259902],[112.21674401987555,37.55996556741304],[112.22364300619218,37.570034199677536],[112.26618675514473,37.62035677045611],[112.29033320725294,37.6285881050314],[112.3328769562055,37.63590407513661],[112.35242408410261,37.63956178779538],[112.37082138094696,37.65510504050974],[112.39151833989685,37.665160691181285],[112.41566479200506,37.677956805288176],[112.43981124411327,37.68983691862023],[112.45130955464099,37.696233107871855],[112.46510752727424,37.70171511292638],[112.46855702043256,37.71176439369373],[112.46855702043256,37.72089891096533],[112.47775566885474,37.73551177605141],[112.48120516201305,37.74738258765563],[112.48580448622414,37.755599717134444],[112.48580448622414,37.755599717134444],[112.51110076938512,37.75194777320059],[112.52719840412392,37.75012173306576],[112.53639705254609,37.75012173306576],[112.5524946872849,37.75651267471411],[112.56744249097093,37.7638159263226],[112.59043911202637,37.766554458198435],[112.61458556413457,37.77111845073674],[112.64103167834833,37.77385670990295],[112.6548296509816,37.7765948667987],[112.662878468351,37.77842024791106],[112.67667644098425,37.7765948667987],[112.69507373782861,37.77294396821082],[112.71347103467295,37.77203121515538],[112.73646765572839,37.77294396821082],[112.7560147836255,37.7765948667987],[112.7767117425754,37.77294396821082],[112.78821005310311,37.77476944023171],[112.80315785678916,37.77842024791106],[112.81120667415856,37.78207087376914],[112.81695582942241,37.78389611851344],[112.82845413995013,37.788459031496274],[112.84915109890002,37.79393415203622],[112.86869822679714,37.80214606568015],[112.88019653732486,37.81309385172887],[112.88479586153595,37.82404000090295],[112.89169484785258,37.83954424325882],[112.89399450995812,37.85960367921782],[112.89514434101089,37.865073479299205],[112.90204332732752,37.866896655016475],[112.91239180680248,37.866896655016475],[112.92274028627742,37.86598507284396],[112.93768808996344,37.870542869982],[112.94688673838563,37.87418890298424],[112.95378572470226,37.886948585450455],[112.96068471101889,37.894238831653134],[112.97103319049383,37.90061719989605],[112.980231838916,37.90517283594678],[112.98943048733818,37.90517283594678],[113.00437829102421,37.90243948844368],[113.01472677049915,37.89788368175795],[113.02622508102688,37.89788368175795],[113.03887322260736,37.899706038558804],[113.04807187102953,37.90152834985769],[113.08371663366546,37.91701615865817],[113.09981426840427,37.91701615865817],[113.11821156524861,37.91337226414203],[113.13085970682911,37.90790608106577],[113.14580751051514,37.90335061565391],[113.16075531420117,37.89697248629451],[113.1722536247289,37.891505074637024],[113.17110379367612,37.88421455544652],[113.17800277999275,37.881480423076454],[113.18950109052047,37.88056902287215],[113.1964000768371,37.88421455544652],[113.21364754262868,37.88421455544652],[113.23089500842025,37.878746188342625],[113.25389162947569,37.87692330831914],[113.28263740579499,37.87418890298424],[113.30103470263933,37.87418890298424],[113.31713233737814,37.87692330831914],[113.33552963422248,37.87418890298424],[113.35277710001407,37.86871978524431],[113.37807338317504,37.87145439529184],[113.37807338317504,37.87145439529184],[113.3918713558083,37.87145439529184],[113.40336966633602,37.87510038280238],[113.41141848370542,37.87236590922889],[113.42176696318037,37.86598507284396],[113.42981578054977,37.86051534099437],[113.44246392213026,37.86051534099437],[113.4528124016052,37.86051534099437],[113.4574117258163,37.865073479299205],[113.46661037423847,37.86325025809321],[113.47465919160787,37.8586920060696],[113.47580902266064,37.850486436025456],[113.47580902266064,37.8450155443068],[113.47810868476618,37.83954424325882],[113.4815581779245,37.83133652423579],[113.49190665739944,37.82677628241697],[113.50340496792717,37.82221575638556],[113.51375344740211,37.8149183236005],[113.51720294056042,37.80670784211644],[113.52870125108814,37.80670784211644],[113.5424992237214,37.80579550956195],[113.55514736530189,37.79849643994031],[113.56549584477683,37.79119664290905],[113.57239483109348,37.78572131780028],[113.58504297267396,37.781158234350684],[113.61378874899326,37.781158234350684],[113.64138469425978,37.78298350182342],[113.6689806395263,37.788459031496274],[113.69197726058174,37.788459031496274],[113.70232574005668,37.79028411713641],[113.71037455742608,37.79210915731663],[113.71727354374272,37.79119664290905],[113.72647219216489,37.787546471628964],[113.7506186442731,37.78663390039693],[113.77131560322299,37.795759101294465],[113.78051425164516,37.80305844370001],[113.79086273112011,37.814006093348326],[113.8035108727006,37.82221575638556],[113.8196085074394,37.827688353518106],[113.83110681796713,37.83316054138132],[113.83685597323098,37.844103689223935],[113.84605462165315,37.84866285093478],[113.8564031011281,37.84866285093478],[113.87020107376136,37.85413346975672],[113.87824989113076,37.865073479299205],[113.89204786376402,37.87692330831914],[113.89894685008066,37.88785990603667],[113.9092953295556,37.894238831653134],[113.91849397797777,37.90335061565391],[113.92654279534717,37.91337226414203],[113.93689127482213,37.92794674997904]]');
INSERT INTO `t_course` VALUES ('85', 'S2003', '#19a61c', '4', '1', '0', '[[113.39072152475553,38.07171333727566],[113.39762051107216,38.05898600364466],[113.40221983528325,38.05625842740108],[113.40336966633602,38.04716576623643],[113.39877034212493,38.03716252348372],[113.39647068001939,38.02260989233044],[113.39302118686108,38.01169350591381],[113.39532084896662,38.00350514010905],[113.39877034212493,37.9953158520943],[113.39532084896662,37.9853054700054],[113.38957169370276,37.97438348224855],[113.38267270738612,37.966190915769964],[113.38267270738612,37.955266059702936],[113.38152287633335,37.93887570284232],[113.36887473475286,37.9069950107356],[113.3677249037001,37.885125910155296],[113.3792232142278,37.87327741179305]]');
INSERT INTO `t_course` VALUES ('86', 'S2001', '#19a61c', '4', '1', '0', '[[112.62953336782061,38.027157902727446],[112.62033471939844,38.01624219951887],[112.61228590202903,38.01169350591381],[112.60193742255409,37.99349588508111],[112.59848792939577,37.97984468102249],[112.59618826729023,37.96892187370209],[112.59158894307915,37.961639091581624],[112.60193742255409,37.9516240768221],[112.60768657781794,37.92976835590872],[112.61228590202903,37.91428325483646],[112.61918488834567,37.90335061565391],[112.6180350572929,37.891505074637024],[112.6260838746623,37.885125910155296],[112.6260838746623,37.87692330831914],[112.62263438150399,37.86142699139917],[112.62263438150399,37.850486436025456],[112.62263438150399,37.83680843924225],[112.62378421255676,37.82312788432833],[112.63988184729556,37.809444771580075],[112.6502303267705,37.796671558875374],[112.6548296509816,37.79210915731663],[112.6548296509816,37.77842024791106]]');
INSERT INTO `t_course` VALUES ('87', 'S56', '#19a61c', '4', '1', '0', '[[112.4754560067492,37.894238831653134],[112.46510752727424,37.898794865846085],[112.44096107516604,37.90243948844368],[112.41221529884675,37.9069950107356],[112.39496783305516,37.909728187597196],[112.37887019831636,37.91428325483646],[112.36162273252478,37.919748960085606],[112.34667492883875,37.92248165911645],[112.33977594252212,37.926125098536616],[112.320228814625,37.92794674997904],[112.29378270041126,37.930679141806074],[112.27883489672521,37.930679141806074],[112.27423557251413,37.93158991632502],[112.26963624830304,37.93523290061462],[112.26503692409196,37.93614361824006],[112.26043759988087,37.93614361824006],[112.25353861356425,37.93614361824006],[112.25123895145869,37.9334114312272],[112.25123895145869,37.93250067946541]]');
INSERT INTO `t_course` VALUES ('88', 'G2003', '#19a61c', '4', '1', '0', '[[112.6134357330818,38.01351301751466],[112.60998623992349,38.025338732730624],[112.59503843623746,38.03170562843633],[112.58009063255142,38.03534360402086],[112.56169333570708,38.03716252348372],[112.54559570096828,38.03716252348372],[112.5283482351767,38.03443412720694],[112.51340043149067,38.02988657231603],[112.50420178306848,38.019880949446375],[112.49730279675185,38.006234697848164],[112.49500313464631,37.99440587427993],[112.49270347254077,37.98803571081944],[112.48695431727691,37.97984468102249],[112.48120516201305,37.97347324261339],[112.4754560067492,37.966190915769964],[112.48005533096028,37.95435558105366],[112.48465465517137,37.946160761089935],[112.4835048241186,37.93158991632502],[112.48005533096028,37.91701615865817],[112.47890549990751,37.90790608106577],[112.47315634464366,37.894238831653134],[112.48005533096028,37.88239181190702],[112.47775566885474,37.866896655016475],[112.47890549990751,37.85413346975672],[112.48695431727691,37.843191822770905],[112.491553641488,37.83772038528402],[112.48580448622414,37.82495210610931],[112.48465465517137,37.808532473125574],[112.48465465517137,37.799408863424134],[112.48235499306583,37.79393415203622],[112.47660583780197,37.78572131780028],[112.47430617569643,37.781158234350684],[112.47660583780197,37.7674672794318],[112.4835048241186,37.75468674819319]]');
INSERT INTO `t_course` VALUES ('89', 'G2003', '#19a61c', '4', '1', '0', '[[112.4835048241186,37.75468674819319],[112.48522957069775,37.75696914924329],[112.4875292328033,37.758795018955595],[112.48982889490884,37.7624466220364]]');
INSERT INTO `t_course` VALUES ('90', '大同古店至王官屯', '#b81313', '5', '1', '1', '[[113.3021845336921,40.18068779695018],[113.32748081685308,40.176277747390714],[113.3470279447502,40.17539570281063],[113.36197574843624,40.174513646674605],[113.38497236949168,40.17274949973499],[113.41486797686373,40.171867408931504],[113.44361375318303,40.166574621442585],[113.47005986739678,40.1639280716998],[113.50800429213825,40.160399176936764],[113.54364905477418,40.15775238453695],[113.56434601372406,40.156870097293975],[113.58504297267396,40.15863466022511],[113.59769111425445,40.160399176936764],[113.62298739741543,40.15775238453695]]');
INSERT INTO `t_course` VALUES ('91', '大同肥村至陈庄', '#b81313', '5', '1', '1', '[[113.29643537842824,39.97752661300256],[113.30563402685041,39.97752661300256],[113.32403132369477,39.97487264865914],[113.35277710001407,39.975757314983326],[113.37577372106949,39.975757314983326],[113.40681915949433,39.97841124469747],[113.43786459791917,39.983718792457594],[113.46431071213293,39.9872569267606],[113.50455479897994,39.990794876362955],[113.54019956161586,39.99610145444461],[113.55744702740743,39.99875458763719]]');
INSERT INTO `t_course` VALUES ('92', 'S36', '#19a61c', '5', '1', '0', '[[113.58619280372673,39.7302637090776],[113.59654128320167,39.7329272242764],[113.61263891794049,39.738253943454744],[113.62183756636266,39.7418048590355],[113.63793520110146,39.744467924685715],[113.65173317373473,39.75156892587713],[113.65978199110413,39.759556670333765],[113.67128030163184,39.7622190443099],[113.69197726058174,39.763993902651045],[113.70232574005668,39.764881314528544],[113.71957320584826,39.77286750262318],[113.73222134742875,39.77641661979388],[113.7506186442731,39.7844014589412],[113.76786611006467,39.79238536414747],[113.78051425164516,39.797707448740255],[113.79891154848951,39.811897644820654],[113.81040985901723,39.81544473256962],[113.8242078316505,39.81544473256962],[113.83340648007267,39.811897644820654],[113.8403054663893,39.80480291578961],[113.85295360796978,39.796820463468734],[113.86215225639197,39.79327240707334],[113.87595022902522,39.78085275684111],[113.88629870850016,39.77819110920196],[113.90239634323898,39.77907833661146],[113.91044516060838,39.78262713095118],[113.92654279534717,39.78972416618602],[113.94723975429707,39.797707448740255],[113.96908654429974,39.80657666723779],[113.97943502377468,39.80923720792251],[113.99323299640794,39.8101240317538],[114.00588113798844,39.81367121175942],[114.01392995535784,39.82342500536145],[114.03347708325495,39.83051779694683],[114.04382556272991,39.834063915942465],[114.06337269062702,39.83140434399583],[114.07832049431306,39.82785808660034],[114.088668973788,39.8260848887037],[114.09901745326295,39.8260848887037],[114.11396525694897,39.82076501822394],[114.1254635674767,39.81544473256962],[114.13581204695164,39.81544473256962],[114.14846018853213,39.80480291578961],[114.16455782327094,39.79859442248075],[114.17950562695697,39.796820463468734],[114.19215376853747,39.79948138469012],[114.20940123432904,39.80568979727949],[114.22089954485675,39.8101240317538],[114.23699717959556,39.8101240317538],[114.25654430749267,39.81367121175942],[114.27379177328426,39.81544473256962],[114.29333890118137,39.812784434056084],[114.32553417065898,39.811897644820654],[114.3496806227672,39.81101084405321],[114.36232876434768,39.81455797793061],[114.37612673698095,39.81810492729277],[114.39452403382529,39.817218207250754],[114.42441964119736,39.82076501822394]]');
INSERT INTO `t_course` VALUES ('93', 'G18灵丘', '#19a61c', '5', '1', '0', '[[113.63103621478483,39.66008714660502],[113.65173317373473,39.65564317218397],[113.66783080847352,39.65386550176696],[113.68622810531788,39.65653199011078],[113.74256982690369,39.641420518519354],[113.76326678585359,39.62986244085464],[113.7747650963813,39.62630571760143],[113.78626340690903,39.602293015105964],[113.80581053480614,39.58805930342008],[113.82650749375604,39.57293275441966],[113.83570614217821,39.56047309758958],[113.83685597323098,39.53821809724463],[113.84605462165315,39.53109497739902],[113.84490479060038,39.519518336240175],[113.8483542837587,39.5106119038348],[113.87710006007799,39.49190464910124],[113.90239634323898,39.47586581950021],[113.91619431587223,39.46606247693172],[113.92194347113609,39.45180058395589],[113.95183907850816,39.43753574531962],[113.98633401009131,39.43575243338671],[114.00933063114675,39.44021062692804],[114.02542826588555,39.44645161464746],[114.0518743800993,39.436644095105855],[114.07372117010196,39.43575243338671],[114.12086424326561,39.43307737919771],[114.13696187800441,39.436644095105855],[114.154209343796,39.441102231119665],[114.17145680958757,39.448234650442004],[114.18525478222082,39.46071461227738],[114.20365207906518,39.46962748988482],[114.21974971380398,39.47943032610036],[114.26574295591486,39.483885700408564],[114.30253754960356,39.465171194924444],[114.32323450855344,39.46160595182133],[114.33703248118671,39.456257741951795],[114.35083045381997,39.445560079491],[114.35427994697828,39.43129395221273],[114.37152741276986,39.42237612699973],[114.39107454066698,39.41345715135487],[114.406022344353,39.41078123433706],[114.41637082382796,39.402752862103846],[114.4267193033029,39.40096865285212],[114.4347681206723,39.40453702534409],[114.44511660014726,39.40810521378809],[114.45891457278051,39.40721318393182],[114.47616203857208,39.40186076322938]]');
INSERT INTO `t_course` VALUES ('94', 'G18平鲁', '#19a61c', '5', '1', '0', '[[113.63103621478483,39.65919837476352],[113.61953790425711,39.657420796516334],[113.61033925583494,39.657420796516334],[113.60114060741276,39.65119890973378],[113.5953914521489,39.645865414606085],[113.58964229688505,39.64408749073238],[113.5792938174101,39.64230952077728],[113.5712450000407,39.64053150474128],[113.5505480410908,39.636975334428584],[113.53789989951032,39.63252986234167],[113.52295209582428,39.623638054210865],[113.50685446108548,39.61741310314096],[113.494206319505,39.607629896855],[113.48615750213558,39.602293015105964],[113.47235952950233,39.5978452969199],[113.45971138792184,39.59161800774448],[113.44361375318303,39.584500414833876],[113.42521645633869,39.57382264354499],[113.41371814581096,39.569373082766155],[113.39302118686108,39.569373082766155],[113.38497236949168,39.57382264354499],[113.36887473475286,39.569373082766155],[113.3516272689613,39.56403322983642],[113.32518115474754,39.561363147923025],[113.3021845336921,39.56314321404653],[113.28838656105884,39.56848313606505],[113.26883943316172,39.58272090144384],[113.26194044684509,39.586279882159445],[113.23779399473688,39.58805930342008],[113.21364754262868,39.587169598547916],[113.19295058367878,39.59250765503418],[113.16995396262335,39.59517652780296],[113.14925700367345,39.59161800774448],[113.13430919998743,39.58894899677589],[113.1147620720903,39.586279882159445],[113.09751460629873,39.58539015425476],[113.08141697155992,39.584500414833876],[113.06531933682112,39.58094134198989],[113.04807187102953,39.577382084892236],[113.03542372944905,39.5800515449891],[113.02277558786857,39.57916173647252],[113.01012744628807,39.57649224182867],[112.99862913576035,39.57649224182867],[112.98598099417987,39.58094134198989],[112.97678234575768,39.584500414833876],[112.96873352838828,39.587169598547916],[112.9641342041772,39.58894899677589],[112.95378572470226,39.586279882159445],[112.93998775206899,39.58183112747482],[112.92963927259404,39.57471252115497],[112.91469146890802,39.57026301795224],[112.87214771995545,39.56759317784899],[112.83535312626675,39.56848313606505],[112.81465616731687,39.569373082766155],[112.80200802573638,39.57026301795224],[112.78706022205034,39.57382264354499],[112.77441208046986,39.57382264354499],[112.73761748678116,39.587169598547916],[112.73301816257008,39.58805930342008],[112.72611917625343,39.586279882159445],[112.71692052783126,39.58805930342008],[112.70772187940909,39.586279882159445],[112.70197272414524,39.58183112747482],[112.64793066466495,39.57560238724955],[112.63758218519001,39.56314321404653],[112.63068319887338,39.559583035741746],[112.61573539518734,39.559583035741746],[112.61573539518734,39.559583035741746],[112.597338098343,39.56492323411169],[112.59043911202637,39.56848313606505],[112.58009063255142,39.572042853779045],[112.56514282886539,39.572042853779045],[112.54789536307382,39.57471252115497],[112.52144924886007,39.5800515449891],[112.50995093833235,39.59517652780296],[112.50190212096294,39.607629896855],[112.49040381043523,39.61474509419001],[112.48120516201305,39.61919171818274],[112.46970685148533,39.61919171818274],[112.45590887885207,39.62541650799025],[112.43291225779663,39.62630571760143],[112.40531631253012,39.62630571760143],[112.38691901568576,39.61741310314096],[112.36967154989419,39.60585098234235],[112.3409257735749,39.60051396238323],[112.32367830778331,39.58983867861526],[112.30643084199174,39.58272090144384],[112.29493253146403,39.5800515449891],[112.27768506567244,39.57916173647252],[112.2592877688281,39.58094134198989],[112.23744097882543,39.58894899677589],[112.2224931751394,39.596066129025566],[112.21674401987555,39.602293015105964],[112.21674401987555,39.60851933683471],[112.20639554040059,39.63252986234167],[112.20869520250614,39.650310022680934],[112.20639554040059,39.6680855747044],[112.1983467230312,39.67786016384097],[112.1983467230312,39.69562857198472],[112.18914807460902,39.70539923165756],[112.17879959513407,39.715168496846495],[112.16270196039527,39.72404843685949],[112.1535033119731,39.7302637090776],[112.14775415670924,39.74713088658954],[112.13970533933983,39.75600667696795],[112.13510601512874,39.763993902651045],[112.1247575356538,39.77375479921003],[112.11440905617886,39.78972416618602],[112.09831142144004,39.79593346666621],[112.0879629419651,39.802142202130945],[112.07761446249016,39.80568979727949],[112.06266665880412,39.80568979727949],[112.03852020669592,39.802142202130945],[112.02932155827374,39.802142202130945],[112.01782324774602,39.80480291578961],[112.00287544406,39.80480291578961],[111.99137713353227,39.80480291578961]]');
INSERT INTO `t_course` VALUES ('95', 'S5901', '#19a61c', '5', '1', '0', '[[112.35587357726092,39.285789987575505],[112.37542070515805,39.28221549791793],[112.39151833989685,39.2750659669035],[112.40416648147735,39.271490925555305],[112.43176242674386,39.269703335922884],[112.44556039937713,39.268809523867326],[112.46165803411593,39.265234160717675],[112.48925397938245,39.262552517683595],[112.50995093833235,39.264340291198764],[112.54099637675718,39.265234160717675],[112.56169333570708,39.269703335922884],[112.56974215307648,39.27774712723539],[112.57549130834033,39.28936429332754],[112.5812404636042,39.297405808842505],[112.58354012570975,39.310806265580794],[112.59043911202637,39.31973846642182],[112.59388860518469,39.34831378302524]]');
INSERT INTO `t_course` VALUES ('96', 'S5512', '#19a61c', '5', '1', '0', '[[112.54559570096828,39.346528170679015],[112.59043911202637,39.346528170679015],[112.60883640887072,39.34474251233809],[112.62493404360953,39.34295680800298],[112.64563100255941,39.34474251233809],[112.662878468351,39.34474251233809],[112.6789761030898,39.34027816526246],[112.7111713725674,39.34295680800298],[112.72726900730622,39.33759941903807],[112.75486495257273,39.33224161614499],[112.77326224941709,39.32777646421605],[112.79510903941974,39.32152476863222],[112.82615447784458,39.31437928387284]]');
INSERT INTO `t_course` VALUES ('97', 'G55', '#19a61c', '5', '1', '0', '[[112.98138166996877,39.583610663896884],[112.97793217681046,39.572042853779045],[112.96643386628274,39.56581322687225],[112.95493555575503,39.555132553789015],[112.9434372452273,39.541779380862735],[112.92848944154127,39.52040891616893],[112.92274028627742,39.50615825597372],[112.9192907931191,39.48834078699589],[112.91009214469693,39.47140992731489],[112.90319315838029,39.464279901409704],[112.89629417206366,39.44021062692804],[112.88594569258872,39.4205924239032],[112.87789687521932,39.40186076322938],[112.87674704416655,39.39204691644009],[112.86294907153328,39.37241504769785],[112.85145076100557,39.35545577245248],[112.84110228153062,39.3384923459443],[112.83075380205567,39.3242041357217],[112.82845413995013,39.31259279771907],[112.8215551536335,39.29829925309242],[112.81465616731687,39.28310913757323],[112.81005684310578,39.269703335922884],[112.81005684310578,39.25271894166308],[112.80660734994747,39.2375188619401],[112.7928093773142,39.218737708229135],[112.78706022205034,39.210687091303406],[112.78821005310311,39.19905677958783],[112.7928093773142,39.18473988470736],[112.79395920836697,39.17042004931767],[112.79855853257806,39.15520200260809],[112.80430768784193,39.13550313318833],[112.81005684310578,39.11400711911905],[112.81005684310578,39.1050484947874],[112.80315785678916,39.098776774681276],[112.7928093773142,39.093400566882124],[112.78706022205034,39.08533548033873],[112.7847605599448,39.071891603307336],[112.77901140468094,39.05665208745524],[112.77211241836432,39.04678945687621],[112.76291376994213,39.010913641293726],[112.75831444573105,38.99835276891565],[112.74681613520333,38.980404765181035],[112.73761748678116,38.96334991188254],[112.73416799362285,38.94090300761074],[112.72726900730622,38.92024552580811],[112.7192201899368,38.90048051998203],[112.7192201899368,38.87981117227575],[112.71807035888403,38.851942892574804],[112.72726900730622,38.82226455776408],[112.73876731783393,38.80247206930698],[112.74911579730887,38.78447408652145],[112.75716461467827,38.76557127352243],[112.75946427678382,38.74035966638969],[112.75831444573105,38.71784171677266],[112.75371512151996,38.69982220507739],[112.7560147836255,38.6808967897653],[112.75141545941442,38.66557251848388],[112.75371512151996,38.643030817237246],[112.75946427678382,38.62048196445503],[112.75486495257273,38.60243773392875],[112.7318683315173,38.57626547242029],[112.70542221730355,38.53473112306635],[112.70197272414524,38.5049198384145],[112.69392390677584,38.48232724452252],[112.68817475151197,38.45791922025317],[112.69047441361751,38.43983383173138],[112.68932458256474,38.416315994644826],[112.69852323098692,38.400029891588794],[112.7111713725674,38.38555024889855],[112.71577069677849,38.37649898757823],[112.7192201899368,38.35658219317964],[112.72151985204235,38.34481058075568],[112.7318683315173,38.33122555357726],[112.7318683315173,38.31310818869427],[112.73531782467562,38.28954878905571],[112.74336664204502,38.27685976314774],[112.75831444573105,38.26235528076075],[112.76291376994213,38.24966146274313],[112.75831444573105,38.23333755410941],[112.74911579730887,38.209752050575105],[112.74566630415056,38.188881524888174],[112.7399171488867,38.169820559557756],[112.73531782467562,38.14984653668287],[112.72726900730622,38.138949289684085],[112.71692052783126,38.12986699674431],[112.70312255519801,38.108064843849554],[112.68012593414257,38.0926176809746],[112.65827914413991,38.06444084858619],[112.63068319887338,38.028067470644615],[112.62953336782061,38.026248323422756]]');
INSERT INTO `t_course` VALUES ('98', 'S5502', '#19a61c', '5', '1', '0', '[[112.73416799362285,38.28954878905571],[112.74566630415056,38.29498625833451],[112.75256529046719,38.302235578294095],[112.75486495257273,38.3103901901736],[112.77326224941709,38.31673202692976],[112.78591039099757,38.326696640405416],[112.80775718100024,38.33394276449729],[112.82845413995013,38.34390499218976],[112.85145076100557,38.345716157905066],[112.87214771995545,38.3556767530348],[112.89284467890535,38.37016242519862],[112.90089349627475,38.381024760985134],[112.90319315838029,38.39098045752918],[112.9112419757497,38.401839641346236],[112.91354163785525,38.410887704825974],[112.90894231364415,38.42536223050599],[112.90894231364415,38.44254693136067],[112.91354163785525,38.45791922025317],[112.91469146890802,38.46967227184634],[112.91239180680248,38.49678732755267]]');
INSERT INTO `t_course` VALUES ('99', 'G1812长城岭', '#19a61c', '5', '1', '0', '[[111.60503389980096,38.77097259264055],[111.6073335619065,38.759269213452235],[111.60963322401204,38.75116574023378],[111.60388406874819,38.74126023552373],[111.59813491348433,38.7331547011002],[111.59123592716769,38.7232466773049],[111.58778643400937,38.71784171677266],[111.59353558927323,38.70432751229691],[111.59583525137879,38.70072328941612],[111.61078305506481,38.69621775325074],[111.62113153453976,38.690810732103735],[111.63262984506748,38.687205822408124],[111.65447663507014,38.66827704199357],[111.66482511454508,38.65655669624598],[111.67747325612558,38.65114665360536],[111.69587055296992,38.64663797005097],[111.70276953928655,38.64393262260455],[111.71541768086705,38.63220826033976],[111.72806582244753,38.62409026143405],[111.73956413297525,38.62138405586079],[111.7499126124502,38.61506917577184],[111.76026109192514,38.609655975245815],[111.78095805087504,38.60875373511904],[111.79130653034998,38.60243773392875],[111.80625433403601,38.60063305920794],[111.8154529824582,38.59521876051563],[111.84534858983025,38.59612117222743],[111.85454723825244,38.59792596133554],[111.88674250773003,38.58980405004151],[111.89594115615222,38.591608999285384],[111.90169031141608,38.59792596133554],[111.90973912878547,38.60424236289356],[111.91778794615487,38.60875373511904],[111.93158591878814,38.609655975245815],[111.93848490510477,38.60604694610176],[111.95573237089634,38.607851483552714],[111.96263135721298,38.60694922054693],[111.9660808503713,38.60243773392875],[111.97527949879347,38.599730704689215],[111.98332831616287,38.599730704689215],[111.9902273024795,38.597023572500746],[111.99597645774335,38.59521876051563],[112.00057578195445,38.59521876051563],[112.00862459932385,38.58980405004151],[112.02012290985157,38.58619401429933],[112.03277105143205,38.58438892780225],[112.04656902406532,38.58438892780225],[112.06036699669858,38.58529147676955],[112.07761446249016,38.58529147676955],[112.10291074565113,38.58529147676955],[112.1328063530232,38.57626547242029],[112.15005381881478,38.57626547242029],[112.16500162250081,38.57536280908191],[112.17305043987021,38.570849320841305],[112.18339891934517,38.570849320841305],[112.19144773671457,38.563627144973026],[112.20639554040059,38.55911291339342],[112.22824233040326,38.551889548235216],[112.23974064093098,38.537440622503155],[112.25468844461702,38.53021506200907],[112.34207560462767,38.48684633477212],[112.3489745909443,38.48865389086929],[112.36162273252478,38.49136513929593],[112.36967154989419,38.49678732755267],[112.37772036726359,38.50040189112695],[112.38346952252745,38.51576174596455],[112.3892186777913,38.522085431846506],[112.4018668193718,38.52931181549892],[112.41566479200506,38.526602007372475],[112.43176242674386,38.520278721610936],[112.44096107516604,38.51756857051828],[112.45130955464099,38.51485831654033],[112.45935837201039,38.51485831654033],[112.4754560067492,38.51214795967918],[112.4835048241186,38.51214795967918],[112.49615296569908,38.521182082444724],[112.50305195201571,38.52840855755605],[112.51455026254344,38.535634300978586],[112.51799975570175,38.54015001903919],[112.52489874201838,38.55098657613364],[112.5283482351767,38.55550132229412],[112.5283482351767,38.563627144973026],[112.54214620780995,38.57536280908191],[112.56169333570708,38.57987601140547],[112.58354012570975,38.58077861755926],[112.6053869157124,38.581681212275925],[112.61918488834567,38.58077861755926],[112.62723370571507,38.5780707647867],[112.63873201624278,38.57536280908191],[112.6548296509816,38.57355744809517],[112.67207711677317,38.569043845490455],[112.6789761030898,38.56452995698224],[112.6870249204592,38.54827759122168],[112.69737339993415,38.537440622503155],[112.71692052783126,38.52931181549892],[112.73876731783393,38.522085431846506],[112.76406360099492,38.51756857051828],[112.79395920836697,38.516665163957214],[112.81810566047518,38.521182082444724],[112.83650295731952,38.51305142339757],[112.85719991626942,38.50582339358051],[112.87329755100824,38.50311269379075],[112.89399450995812,38.49859463219992],[112.91009214469693,38.49678732755267],[112.92274028627742,38.49769098559128],[112.95033623154394,38.501305503445195],[112.9928799804965,38.519375349345204],[113.01242710839361,38.52569871513194],[113.02277558786857,38.538343766115354],[113.02622508102688,38.54737457338222],[113.04462237787122,38.551889548235216],[113.05382102629339,38.56723832439505],[113.07336815419052,38.57626547242029],[113.09751460629873,38.58348636739751],[113.11591190314307,38.58529147676955],[113.12166105840693,38.59070653038244],[113.13200953788188,38.612362626988144],[113.14695734156791,38.61867774732199],[113.16880413157058,38.62679636403968],[113.18145227315107,38.63761974474447],[113.18950109052047,38.65024493978047],[113.19065092157324,38.66827704199357],[113.19984956999541,38.672784352283436],[113.23319467052579,38.67458719628509],[113.24699264315906,38.69171193091158],[113.27458858842557,38.69982220507739],[113.29528554737547,38.69982220507739],[113.31828216843091,38.6808967897653],[113.33322997211694,38.67458719628509],[113.34357845159188,38.669178526941025],[113.42406662528592,38.673685780006785],[113.43901442897194,38.676389994506216],[113.44246392213026,38.68360072957342],[113.45971138792184,38.68900830014863],[113.47465919160787,38.68810706700151],[113.49190665739944,38.69171193091158],[113.50455479897994,38.68630456636854],[113.51490327845488,38.68900830014863],[113.52410192687705,38.69171193091158],[113.53675006845755,38.70522853939822],[113.54594871687972,38.71694084994616],[113.55284770319635,38.72054424855926],[113.56894533793516,38.725048239222694],[113.58044364846288,38.7331547011002],[113.5873426347795,38.744862397551906],[113.60114060741276,38.75296659222289],[113.61493858004603,38.75746852178958],[113.62873655267929,38.76106985930598],[113.63908503215423,38.76737175904028],[113.64368435636533,38.77097259264055],[113.65633249794581,38.771872772407804],[113.6609318221569,38.780873940137866],[113.66783080847352,38.78537409448173],[113.67817928794848,38.78897401177815],[113.69542675374005,38.78717407603903],[113.70347557110945,38.79167382947644],[113.70232574005668,38.80787057061653],[113.70692506426776,38.816867156290726],[113.71267421953162,38.824963103826285],[113.71957320584826,38.832158722516134],[113.7218728679538,38.836655611806364],[113.71842337479549,38.848346183278636],[113.72302269900658,38.85823669263485],[113.72302269900658,38.8699236885901],[113.73222134742875,38.88610248523864],[113.74141999585092,38.899581978786266],[113.75521796848419,38.9292277849411],[113.77936442059239,38.942699023711064]]');
INSERT INTO `t_course` VALUES ('100', 'S45左权', '#19a61c', '5', '1', '0', '[[113.42406662528592,38.67458719628509],[113.42406662528592,38.66557251848388],[113.4160178079165,38.6637694455888],[113.40681915949433,38.66196632691686],[113.3999201731777,38.65295004692563],[113.39762051107216,38.64032533248088],[113.39762051107216,38.63040434067173],[113.40336966633602,38.62138405586079],[113.40221983528325,38.60875373511904],[113.40107000423048,38.59792596133554],[113.39877034212493,38.59070653038244],[113.40451949738879,38.57265475044698],[113.44016426002472,38.49769098559128],[113.44361375318303,38.485942539579945],[113.44131409107749,38.47961565322848],[113.43901442897194,38.47328820688539],[113.43096561160255,38.46967227184634],[113.428665949497,38.46153574950547],[113.42636628739146,38.45520670333534],[113.42636628739146,38.44706853557187],[113.42291679423315,38.43983383173138],[113.41946730107482,38.43350286606115],[113.41716763896927,38.42264847969236],[113.41141848370542,38.412697180455936],[113.41141848370542,38.412697180455936],[113.39072152475553,38.40636381586083],[113.37232422791118,38.39641025501751],[113.36427541054178,38.38464517415582],[113.3596760863307,38.37649898757823],[113.3596760863307,38.36744658432412],[113.35737642422515,38.36020383958246],[113.35507676211961,38.3529603640957],[113.35852625527792,38.34028252376249],[113.36197574843624,38.32397915552278],[113.36542524159455,38.3103901901736],[113.36657507264732,38.3013294532428],[113.36657507264732,38.28954878905571],[113.36427541054178,38.28320455567146],[113.36197574843624,38.27504686258866],[113.36887473475286,38.25872870378568],[113.38037304528058,38.246941067970916],[113.3918713558083,38.24240684853022],[113.40451949738879,38.238779267645256],[113.41256831475819,38.23424453488212],[113.42291679423315,38.21973147378373],[113.43211544265532,38.20340079005127],[113.44361375318303,38.18434365587938],[113.45511206371074,38.17889783680205],[113.47120969844956,38.159834237808724],[113.47005986739678,38.1516625849354],[113.47580902266064,38.14803044283478],[113.48500767108281,38.14621430339178],[113.494206319505,38.14439811835454],[113.49765581266331,38.12895870476515],[113.50340496792717,38.125325422879605],[113.50340496792717,38.110790471929086],[113.50685446108548,38.09352642876726],[113.51720294056042,38.0817118187846],[113.51950260266597,38.07171333727566],[113.54364905477418,38.05898600364466],[113.55629719635466,38.04716576623643],[113.56434601372406,38.039890817264364],[113.57239483109348,38.03625306944648],[113.58044364846288,38.03352463900484],[113.58389314162119,38.01442275623577],[113.58389314162119,38.01533248357053],[113.5873426347795,38.00441500407418],[113.60229043846553,37.99713577356932],[113.60918942478217,37.982575126738986],[113.60918942478217,37.971652729195725],[113.61378874899326,37.963459855401666],[113.61838807320434,37.952534589613165],[113.6241372284682,37.94433956480574],[113.63678537004868,37.937054324486546],[113.6448341874181,37.93432217161029],[113.64943351162918,37.92976835590872],[113.65978199110413,37.91701615865817],[113.65978199110413,37.90790608106577],[113.67013047057907,37.890593799548775],[113.67128030163184,37.86871978524431],[113.68277861215957,37.85139821151466],[113.68277861215957,37.83407253290045],[113.68737793637065,37.81309385172887],[113.68737793637065,37.80123367629415],[113.69657658479282,37.78937157999879],[113.705775233215,37.77476944023171],[113.70692506426776,37.758338555788214],[113.71957320584826,37.740077700026056],[113.72072303690103,37.72911900538384],[113.71957320584826,37.71724524035041],[113.72762202321766,37.69440568200625],[113.74371965795646,37.687095524325706],[113.7586674616425,37.650533836126755],[113.77706475848684,37.63590407513661],[113.78166408269793,37.619442120982704],[113.78511357585624,37.593827328676376],[113.78626340690903,37.557219338601875],[113.79086273112011,37.54348666342116],[113.79086273112011,37.53158294758729],[113.78396374480347,37.52517246067077],[113.77591492743407,37.52517246067077],[113.77131560322299,37.516929589673374],[113.76901594111744,37.510517832855705],[113.76326678585359,37.505937666435244],[113.7586674616425,37.49494411068625],[113.75521796848419,37.48944672067007],[113.74371965795646,37.482116232546446],[113.73222134742875,37.47478501901638],[113.71842337479549,37.44728650843837],[113.70807489532054,37.424363292825795],[113.70347557110945,37.410605964781375],[113.70347557110945,37.398680885579694],[113.69312709163451,37.38950644523269],[113.67817928794848,37.372989598758735],[113.67243013268461,37.36014062615245],[113.67243013268461,37.35279735973593],[113.66208165320967,37.34912545481392],[113.64138469425978,37.346371407252605],[113.63333587689037,37.34178110157262],[113.62183756636266,37.330763213308366],[113.61263891794049,37.32066205054085],[113.59884094530722,37.315151748170614],[113.58504297267396,37.30964103837416],[113.56894533793516,37.297699769548025],[113.5585968584602,37.28391900618092],[113.5424992237214,37.268297730264834],[113.53675006845755,37.25359236641512],[113.52525175792982,37.2407227977233],[113.52525175792982,37.2260120049163],[113.51145378529657,37.21865552290892],[113.49650598161054,37.21497701052582],[113.47695885371341,37.20394038793295],[113.46891003634401,37.19382205370139],[113.46661037423847,37.182782310853696],[113.45971138792184,37.168980343339214],[113.45166257055243,37.15701658116184],[113.43556493581363,37.14413039372983],[113.42061713212759,37.134003978481864],[113.41026865265265,37.120193027249066],[113.40681915949433,37.11374704678781],[113.4079689905471,37.11282614725031],[113.4079689905471,37.11282614725031],[113.4079689905471,37.11282614725031]]');
INSERT INTO `t_course` VALUES ('101', 'S45黎城', '#19a61c', '5', '1', '0', '[[113.40681915949433,37.11558881197387],[113.40566932844156,37.09624802402411],[113.39762051107216,37.08979998781022],[113.40681915949433,37.078744923977425],[113.42061713212759,37.07413816743744],[113.43096561160255,37.06676676979174],[113.4528124016052,37.038195778800855],[113.46776020529124,37.02897701586999],[113.48270800897727,37.01145825675513],[113.49995547476885,37.00869176446145],[113.51605310950765,36.994857779567184],[113.51950260266597,36.99116828814023],[113.5264015889826,36.99116828814023],[113.5390497305631,36.985633712507465],[113.5505480410908,36.98009873070302],[113.55399753424912,36.96902754866533],[113.55974668951298,36.95703193500798],[113.55974668951298,36.94226548600513],[113.5505480410908,36.93211187753052],[113.54479888582695,36.92564977987612],[113.52985108214091,36.919187129695764],[113.51260361634934,36.88594191669727],[113.49880564371608,36.873933110607446],[113.49190665739944,36.864694271354864],[113.48845716424113,36.850833899499435],[113.48730733318835,36.84713737214534],[113.46316088108016,36.83974377660609],[113.45511206371074,36.83234946000219],[113.44821307739412,36.820332157759445],[113.4447635842358,36.811086783682406],[113.44016426002472,36.80184028325783],[113.43556493581363,36.788893290594224],[113.43211544265532,36.78519374442416],[113.4367147668664,36.76206749915045],[113.43211544265532,36.7509644020346],[113.43211544265532,36.74078513902113],[113.428665949497,36.729678935182626],[113.428665949497,36.71857111070533],[113.44016426002472,36.70838751473421],[113.45511206371074,36.70560993407945],[113.46776020529124,36.6972765845321],[113.47005986739678,36.69357258109654],[113.47005986739678,36.68616403421297],[113.46431071213293,36.67782855837976],[113.45396223265797,36.67412360998497],[113.44936290844689,36.67134478058226],[113.44936290844689,36.66300768499865],[113.4447635842358,36.65652264748858],[113.4447635842358,36.64447754441507],[113.44361375318303,36.637990932527146],[113.44361375318303,36.6277965721181],[113.44591341528857,36.608330833808594],[113.45166257055243,36.599986856969544],[113.44936290844689,36.59256922435626],[113.44131409107749,36.56660184610549],[113.43786459791917,36.56103626175262],[113.42981578054977,36.560108625035895],[113.42406662528592,36.556397965816906],[113.42061713212759,36.55268712683971],[113.41831747002205,36.54526490963764],[113.41831747002205,36.538769879818915]]');
INSERT INTO `t_course` VALUES ('102', 'G22下浣', '#19a61c', '5', '1', '0', '[[113.00552812207698,36.298067146784476],[113.01932609471025,36.3027210389213],[113.03427389839628,36.31575044652583],[113.04807187102953,36.329708088559634],[113.06761899892666,36.33901178218508],[113.08026714050715,36.34552370074739],[113.0986644373515,36.34552370074739],[113.11936139630139,36.35017473483493],[113.15385632788454,36.35389536030607],[113.1722536247289,36.35668571168883],[113.1883512594677,36.357615806392864],[113.1964000768371,36.36226611173155],[113.21594720473422,36.36226611173155],[113.22399602210362,36.357615806392864],[113.23894382578966,36.36319613916222],[113.24469298105352,36.377145205048805],[113.25849095368677,36.408753745698455],[113.26194044684509,36.41525977679012],[113.26194044684509,36.42269456777299],[113.26883943316172,36.42919942085988],[113.27458858842557,36.4338454078872],[113.27573841947836,36.43849111439415],[113.27688825053113,36.449639665407304],[113.2780380815839,36.45800001813778],[113.28033774368944,36.466359461756205],[113.28033774368944,36.471003204244845],[113.28378723684776,36.47378931503763],[113.29068622316439,36.47378931503763],[113.29988487158656,36.47378931503763],[113.30678385790318,36.47193191906768],[113.31828216843091,36.471003204244845],[113.33208014106417,36.47286062266532],[113.34587811369742,36.48214704123147],[113.35737642422515,36.49607456409973],[113.36657507264732,36.5072147634776],[113.3792232142278,36.522065847260706],[113.38497236949168,36.53041831843271],[113.39532084896662,36.535986127115606],[113.40566932844156,36.53969777492105],[113.41831747002205,36.538769879818915],[113.43096561160255,36.53691405591607],[113.44936290844689,36.53691405591607],[113.4574117258163,36.53969777492105],[113.47120969844956,36.541553531426324],[113.48730733318835,36.54340924299879],[113.50110530582162,36.541553531426324],[113.51605310950765,36.53691405591607],[113.52755142003537,36.53041831843271],[113.53560023740478,36.52670622133756],[113.54939821003804,36.5239220305851],[113.56319618267129,36.5239220305851]]');
INSERT INTO `t_course` VALUES ('103', 'S76', '#19a61c', '5', '1', '0', '[[113.26998926421449,36.187221874387504],[113.2780380815839,36.189086130111946],[113.28723673000607,36.19095034106803],[113.2941357163227,36.190018241186074],[113.30333436474487,36.18628972973744],[113.30793368895596,36.182561039220786],[113.30908352000873,36.17883216964323],[113.31828216843091,36.179764403824194],[113.33208014106417,36.180696626814175],[113.34242862053911,36.18349322863719],[113.35277710001407,36.18628972973744],[113.37577372106949,36.18628972973744],[113.39302118686108,36.187221874387504],[113.40566932844156,36.192814507254916],[113.42061713212759,36.19374657355961],[113.44246392213026,36.2012027010529],[113.45626189476351,36.196542705317434],[113.60918942478217,36.21424920032913],[113.61493858004603,36.218908132606025],[113.62183756636266,36.23008842809014],[113.62988638373206,36.235677971208574],[113.6448341874181,36.239404109336675],[113.65173317373473,36.24965006532793],[113.66553114636798,36.25244418178341],[113.69197726058174,36.258032112302175],[113.705775233215,36.25896339485503]]');
INSERT INTO `t_course` VALUES ('104', 'S2201', '#19a61c', '5', '1', '0', '[[113.24009365684243,36.36319613916222],[113.25504146052846,36.35947596216497],[113.26424010895063,36.34645392998642],[113.26883943316172,36.33994208989562],[113.27573841947836,36.33808146326475],[113.28838656105884,36.33808146326475],[113.29873504053378,36.33808146326475],[113.3102333510615,36.33342970052023],[113.31943199948368,36.32598629725999],[113.32403132369477,36.32226432662824],[113.32173166158923,36.313889237059996],[113.32058183053645,36.30737465091996],[113.31828216843091,36.30085951568239],[113.31598250632537,36.29899794762223],[113.3148326752726,36.29434383138475],[113.31598250632537,36.286896662774346],[113.31598250632537,36.278517741010084],[113.30908352000873,36.26920676368779],[113.30563402685041,36.262688413061646],[113.29988487158656,36.257100818549056],[113.29643537842824,36.248718670777414],[113.29183605421716,36.24406153003966],[113.29068622316439,36.23381483495839],[113.29068622316439,36.2217033576255],[113.29298588526993,36.22077162714815],[113.29183605421716,36.21238554905206],[113.28953639211161,36.200270724292416],[113.28723673000607,36.18349322863719],[113.28263740579499,36.17044155843912],[113.2734387573728,36.157387695028284],[113.27228892632003,36.145264286878934],[113.26653977105617,36.13220619456389],[113.26653977105617,36.12287764351494],[113.25504146052846,36.11634699231591],[113.25044213631737,36.10701654002473],[113.2412434878952,36.10421718627812],[113.23089500842025,36.102350894537196],[113.22629568420916,36.09581852122622],[113.21594720473422,36.08741895052],[113.21019804947036,36.08088532500284],[113.20444889420651,36.072484144446776],[113.20099940104818,36.06408205846414],[113.18720142841492,36.05848016483486],[113.17800277999275,36.052877868854694],[113.16765430051781,36.05007656999062],[113.15500615893731,36.04260594797722],[113.14120818630406,36.035134610796206],[113.13200953788188,36.032332674986],[113.12396072051247,36.02392626421217],[113.11821156524861,36.02018979116315],[113.10786308577367,36.02299216270798],[113.0986644373515,36.02392626421217],[113.08716612682377,36.024860354544145],[113.07681764734883,36.02018979116315],[113.06301967471558,36.02018979116315],[113.05267119524062,36.01832148760753]]');
INSERT INTO `t_course` VALUES ('105', 'G22吉县', '#19a61c', '5', '1', '0', '[[113.00552812207698,36.29899794762223],[112.99977896681312,36.29248210645721],[112.98943048733818,36.284103789681964],[112.980231838916,36.278517741010084],[112.96528403522997,36.272931289041814],[112.9560853868078,36.26734443380086],[112.93308876575236,36.26455085496053],[112.91814096206633,36.26175717531093],[112.90549282048583,36.26082592635952],[112.89744400311643,36.257100818549056],[112.88824535469426,36.25058144867918],[112.86869822679714,36.245924419931356],[112.84455177468894,36.245924419931356],[112.82040532258073,36.251512820831046],[112.8054575188947,36.25244418178341],[112.78246089783926,36.248718670777414],[112.75831444573105,36.24499298058487],[112.7399171488867,36.239404109336675],[112.71347103467295,36.2375410626683],[112.69622356888138,36.235677971208574],[112.68472525835365,36.23381483495839],[112.66172863729822,36.23288325003714],[112.64563100255941,36.23288325003714],[112.62953336782061,36.23288325003714],[112.61228590202903,36.229156798380416],[112.58239029465697,36.238472591601465],[112.56514282886539,36.24499298058487],[112.55479434939045,36.24499298058487],[112.54214620780995,36.245924419931356],[112.52949806622946,36.245924419931356],[112.51914958675452,36.251512820831046],[112.51455026254344,36.25523819744247],[112.49270347254077,36.258032112302175],[112.48120516201305,36.25430687008924],[112.48120516201305,36.24685584807903],[112.48005533096028,36.24219859535353],[112.47430617569643,36.239404109336675],[112.46510752727424,36.23474640868223],[112.4547590477993,36.23008842809014],[112.44211090621882,36.22449848188133],[112.42831293358554,36.22263507690688],[112.41566479200506,36.2217033576255],[112.40071698831903,36.21983988547496],[112.39266817094962,36.21797636854145],[112.38346952252745,36.21331738028807],[112.37542070515805,36.21238554905206],[112.36967154989419,36.20772622495139],[112.35587357726092,36.209589988175324],[112.34552509778598,36.19933873633852],[112.33632644936381,36.19467862867167],[112.32482813883608,36.189086130111946],[112.31562949041391,36.18349322863719],[112.31332982830837,36.1778999242714],[112.30643084199174,36.17044155843912],[112.30643084199174,36.17044155843912],[112.29838202462234,36.16857685508021],[112.28803354514739,36.17137389333385],[112.27768506567244,36.17137389333385],[112.27078607935582,36.17696766770882],[112.26043759988087,36.176035399955616],[112.25698810672256,36.17137389333385],[112.25008912040592,36.16391490086621],[112.24893928935315,36.16205004085626],[112.23744097882543,36.16391490086621],[112.22824233040326,36.16391490086621],[112.2224931751394,36.164847314087616],[112.21214469566445,36.16764448661625],[112.19719689197842,36.16764448661625],[112.19144773671457,36.17044155843912],[112.18454875039794,36.17230621703858],[112.17879959513407,36.176035399955616],[112.17190060881744,36.17696766770882],[112.16730128460635,36.17883216964323],[112.16500162250081,36.179764403824194],[112.15810263618418,36.1778999242714],[112.14890398776201,36.176035399955616],[112.13510601512874,36.17230621703858],[112.12935685986488,36.166712106962756],[112.12130804249549,36.16577971611984],[112.11095956302054,36.16205004085626],[112.1040605767039,36.159252666925155],[112.09256226617619,36.16205004085626],[112.07876429354293,36.16764448661625],[112.06841581406798,36.16857685508021],[112.0592171656458,36.17044155843912],[112.04886868617086,36.17044155843912],[112.0350707135376,36.16577971611984],[112.02357240300988,36.16764448661625],[112.01667341669325,36.17137389333385],[112.0109242614294,36.17137389333385],[111.96838051247684,36.16205004085626],[111.96148152616021,36.162982476455724],[111.95458253984357,36.17044155843912],[111.93503541194646,36.17230621703858],[111.92123743931319,36.169509212354555],[111.91088895983825,36.17230621703858],[111.89709098720499,36.176035399955616],[111.8798435214134,36.1778999242714],[111.86604554878015,36.1778999242714],[111.8395994345664,36.17883216964323],[111.81430315140541,36.1778999242714],[111.7947560235083,36.18442540686218],[111.77635872666394,36.182561039220786],[111.75336210560852,36.176035399955616],[111.7418637950808,36.17137389333385],[111.73151531560585,36.164847314087616],[111.72576616034199,36.15085994096353],[111.71886717402536,36.13313898815156],[111.70621903244488,36.121011799091534],[111.69587055296992,36.103284045998564],[111.68552207349498,36.091152204860045],[111.67172410086172,36.07808503209217],[111.65677629717568,36.06968354971814],[111.64297832454243,36.05754647677855],[111.62688068980361,36.03887036877905],[111.61423254822313,36.02299216270798],[111.60273423769542,36.00991356862866],[111.58203727874552,35.998701602518004],[111.5578908266373,35.98748802804776],[111.53489420558188,35.97907679182736],[111.51304741557921,35.97907679182736],[111.48200197715437,35.98374981251174],[111.46015518715171,35.98842255401255],[111.43945822820181,35.98468438314704],[111.41876126925193,35.97814215418971],[111.40611312767143,35.97253409386796],[111.39576464819649,35.97066465109836],[111.38081684451046,35.966925631571115],[111.36356937871888,35.96599084877579],[111.34172258871622,35.96505605481527],[111.32792461608295,35.96225160594388],[111.30952731923861,35.95851218447646],[111.2934296844998,35.95664240675673],[111.28768052923594,35.95383765644716],[111.2692832323916,35.961316767323815],[111.26583373923327,35.97066465109836],[111.25433542870556,35.97814215418971],[111.2485862734417,35.991226064898996],[111.24398694923062,36.00337345053576],[111.23708796291399,36.01271630882712],[111.23018897659735,36.02205805003167],[111.22903914554458,36.02859660414744],[111.22443982133349,36.03980428033993],[111.21409134185855,36.04727517054798],[111.19799370711975,36.054745345552234],[111.1795964102754,36.06034750741816],[111.1634987755366,36.06408205846414],[111.15315029606164,36.06874999578623],[111.14165198553393,36.07808503209217],[111.13015367500621,36.07995190521159],[111.11635570237294,36.07901847424133],[111.11290620921463,36.071550624048506],[111.10830688500354,36.06221480529488],[111.10715705395077,36.054745345552234],[111.10255772973969,36.051010347454195],[111.09910823658137,36.04914278135165],[111.08760992605366,36.05194411374225],[111.07841127763147,36.05007656999062],[111.0692126292093,36.04914278135165],[111.0611638118399,36.04914278135165],[111.05196516341773,36.04914278135165],[111.04506617710109,36.04914278135165],[111.03471769762615,36.04820898153741],[111.02321938709844,36.04727517054798],[111.01172107657072,36.04540751504406],[111.00137259709577,36.04260594797722],[110.99562344183191,36.03887036877905],[110.98182546919865,36.03887036877905],[110.96917732761816,36.03887036877905],[110.95767901709044,36.03887036877905],[110.94963019972104,36.037936446044114],[110.94273121340441,36.0332666647628],[110.93238273392946,36.02953063861656],[110.9266335786656,36.03139867403595],[110.9185847612962,36.03700251213525],[110.90708645076849,36.04820898153741],[110.9024871265574,36.054745345552234],[110.85879354655206,36.076218114257635],[110.85534405339375,36.07808503209217],[110.84269591181327,36.076218114257635],[110.8334972633911,36.072484144446776],[110.82659827707445,36.072484144446776],[110.81854945970505,36.07341765366693],[110.80935081128288,36.076218114257635],[110.79440300759686,36.07995190521159],[110.78635419022744,36.08368551730145],[110.77255621759419,36.091152204860045],[110.76220773811924,36.09488528031437],[110.75185925864429,36.09768496950707],[110.74611010338043,36.102350894537196],[110.73461179285272,36.10421718627812],[110.72771280653609,36.10421718627812],[110.71736432706113,36.1079496355759],[110.70586601653342,36.10981579313097],[110.69666736811125,36.10701654002473],[110.6909182128474,36.103284045998564],[110.68976838179462,36.09675175095716],[110.68171956442521,36.09301876494837],[110.67712024021412,36.09208549049443],[110.6621724365281,36.08835228087515],[110.65642328126424,36.08461889237554],[110.65067412600038,36.08181873361498],[110.6414754775782,36.07808503209217],[110.62997716705048,36.07435115170887],[110.61962868757554,36.066882854389576],[110.61617919441723,36.059413841714786],[110.60928020810059,36.054745345552234],[110.59893172862564,36.05381161279139],[110.58283409388685,36.05381161279139],[110.57133578335912,36.05381161279139],[110.55293848651478,36.05661277754594],[110.53684085177598,36.05754647677855],[110.52534254124825,36.0612811619449],[110.51614389282608,36.06408205846414],[110.50809507545668,36.06408205846414],[110.49774659598172,36.05567906713712],[110.49314727177064,36.05194411374225]]');
INSERT INTO `t_course` VALUES ('106', 'S2201', '#19a61c', '5', '1', '0', '[[111.55444133347899,36.25616951359579],[111.57398846137612,36.24685584807903],[111.59123592716769,36.239404109336675],[111.61078305506481,36.23381483495839],[111.62573085875084,36.22636184207061],[111.64067866243688,36.218908132606025],[111.65677629717568,36.21145370662119],[111.66942443875618,36.206794326547914],[111.68207258033667,36.20586241695024],[111.69932004612824,36.20399856417277],[111.7131180187615,36.2030666209932],[111.71541768086705,36.196542705317434],[111.72576616034199,36.192814507254916],[111.73611463981693,36.190018241186074],[111.74071396402802,36.18535757389564],[111.7418637950808,36.173238529553245]]');
INSERT INTO `t_course` VALUES ('107', 'S2211', '#19a61c', '5', '1', '0', '[[111.72001700507813,36.340872386396285],[111.7211668361309,36.32040327406501],[111.7211668361309,36.31109733881026],[111.72691599139476,36.3027210389213],[111.73381497771139,36.29341297452319],[111.74071396402802,36.281310815759554],[111.74301362613357,36.272931289041814],[111.74301362613357,36.262688413061646],[111.73956413297525,36.25430687008924],[111.73496480876416,36.245924419931356],[111.73381497771139,36.23660952253729],[111.72806582244753,36.22543016757417],[111.7131180187615,36.2030666209932]]');
INSERT INTO `t_course` VALUES ('108', 'G2211', '#19a61c', '5', '1', '0', '[[111.82005230666928,36.535058187082576],[111.81430315140541,36.53320227331925],[111.80510450298324,36.53134631462695],[111.79590585456107,36.534130235817074],[111.78555737508613,36.53227429958917],[111.77290923350563,36.53134631462695],[111.7579614298196,36.53134631462695],[111.74301362613357,36.535058187082576],[111.72576616034199,36.53969777492105],[111.71656751191982,36.5424813928292],[111.700469877181,36.54990387964451],[111.67632342507281,36.55268712683971],[111.66367528349231,36.547120531341974],[111.64297832454243,36.547120531341974],[111.6360793382258,36.551759389008964],[111.63033018296193,36.56103626175262],[111.62688068980361,36.564746696264294],[111.61653221032867,36.567529404172085],[111.60618373085373,36.574949464194134],[111.60503389980096,36.585150872446704],[111.59583525137879,36.58700552785517],[111.58433694085106,36.596278130578305],[111.5785877855872,36.599986856969544],[111.56708947505949,36.60369540352324],[111.55674099558453,36.60647669541609],[111.54524268505682,36.60369540352324],[111.52684538821248,36.60184115272651],[111.51419724663198,36.60184115272651],[111.47740265294328,36.59256922435626],[111.47050366662666,36.59256922435626],[111.46705417346834,36.58978742667981],[111.45900535609894,36.58978742667981],[111.45210636978231,36.594423699945715],[111.45210636978231,36.595350920881664],[111.44290772136013,36.59813251625319],[111.43255924188519,36.59813251625319],[111.42221076241024,36.60647669541609],[111.41071245188252,36.61667390014352],[111.4072629587242,36.622235438493384],[111.39576464819649,36.62594290588071],[111.39231515503818,36.635210787339474],[111.36816870292996,36.63984430643171],[111.34747174398008,36.65281666434908],[111.33482360239958,36.65096360530401],[111.3141266434497,36.65374317700294],[111.3060778260803,36.6491105012765],[111.29227985344703,36.6481839323946],[111.2853808671304,36.6491105012765],[111.2692832323916,36.65281666434908],[111.25893475291664,36.65744911515814],[111.2485862734417,36.66300768499865],[111.24513678028339,36.66763951724183],[111.2405374560723,36.66763951724183],[111.23133880765013,36.66393407394163],[111.22328999028072,36.65837557158133],[111.21639100396409,36.654669678410876],[111.20489269343638,36.6518901404494],[111.19224455185588,36.6491105012765],[111.17499708606431,36.64540415827753],[111.17039776185322,36.63891762510156],[111.15774962027274,36.635210787339474],[111.14740114079778,36.635210787339474],[111.13245333711176,36.63335730099503],[111.11980519553126,36.63057698715146],[111.10830688500354,36.625016055897795],[111.0979584055286,36.62316232220403],[111.08301060184256,36.62130854354039],[111.06691296710376,36.620381637345105],[111.05196516341773,36.620381637345105],[111.03126820446784,36.61574693773851],[111.01862006288735,36.609257886143695],[111.0082715834124,36.60554960935892],[111.000222766043,36.60184115272651],[110.9921739486736,36.60276828374496],[110.97722614498757,36.60369540352324],[110.96917732761816,36.609257886143695],[110.96457800340707,36.613892979203726],[110.95422952393213,36.61667390014352],[110.94618070656273,36.62316232220403],[110.934682396035,36.62686974462086],[110.93123290287669,36.62872338837236],[110.9266335786656,36.63891762510156],[110.92433391656006,36.64262428295562],[110.91973459234897,36.6491105012765],[110.91283560603235,36.65652264748858],[110.91168577497957,36.66578681808629],[110.90938611287403,36.672271068297874],[110.9024871265574,36.678754767357134],[110.8978878023463,36.685237915228385],[110.89328847813522,36.691720511875964],[110.88868915392413,36.698202557264224],[110.87489118129088,36.70283225215899],[110.86454270181592,36.728753345039785],[110.86454270181592,36.728753345039785],[110.85534405339375,36.73893421759998],[110.85074472918267,36.75374032828742],[110.84729523602435,36.76391785772862],[110.84614540497158,36.770393758111965],[110.84039624970772,36.77871910509702],[110.83464709444387,36.78334390377508],[110.81165047338843,36.788893290594224],[110.80705114917734,36.79536706283859],[110.79555283864963,36.80184028325783],[110.78290469706913,36.813860514176646],[110.77485587969973,36.81940767104029],[110.75760841390816,36.81940767104029],[110.74496027232766,36.818483173056734],[110.7392111170638,36.816634143296874],[110.72426331337778,36.82218109740416],[110.71506466495559,36.825878841516385],[110.7024165233751,36.826803249381925],[110.69321787495294,36.826803249381925],[110.68746871968908,36.82218109740416],[110.682869395478,36.817558663808896],[110.67941990231967,36.81016218432389],[110.66792159179195,36.80368967344565],[110.66102260547532,36.7999908480202],[110.65527345021147,36.79721661069716],[110.64032564652543,36.798141367733585],[110.62882733599771,36.798141367733585],[110.61847885652277,36.7916678319814],[110.61617919441723,36.79259265658794],[110.60008155967842,36.79074299611353],[110.5885832491507,36.793517469933064],[110.57018595230635,36.7916678319814],[110.551788655462,36.788893290594224],[110.53339135861765,36.79259265658794],[110.52074321703716,36.79536706283859],[110.50924490650945,36.79906611350796],[110.50119608914005,36.80831295181687],[110.49314727177064,36.81201137177743],[110.47245031282075,36.81201137177743],[110.46785098860967,36.81201137177743],[110.45980217124026,36.80738831866855],[110.45175335387086,36.80276498398302],[110.44255470544869,36.7999908480202],[110.4379553812376,36.79536706283859],[110.42185774649879,36.79536706283859]]');
INSERT INTO `t_course` VALUES ('109', 'G2516左权', '#19a61c', '5', '1', '0', '[[111.71426784981428,37.239803457991194],[111.72231666718368,37.22968997452826],[111.73266514665862,37.22141428846944],[111.7372644708697,37.21589665558228],[111.75681159876683,37.210378615641055],[111.76945974034732,37.20761944303166],[111.78900686824444,37.20761944303166],[111.7947560235083,37.20761944303166],[111.82810112403868,37.1901423202864],[111.85339740719967,37.184622381035275],[111.86834521088569,37.18002212080473],[111.89019200088836,37.17634170916055],[111.91203879089102,37.174501435520675],[111.93273574984092,37.177261829026186],[111.9453838914214,37.177261829026186],[111.96378118826576,37.17358128174662],[111.97987882300455,37.17266111666997],[112.00402527511277,37.17634170916055],[112.00977443037662,37.17634170916055],[112.02242257195711,37.17634170916055],[112.04081986880146,37.17266111666997],[112.05576767248749,37.1717409402908],[112.07876429354293,37.17266111666997],[112.08681311091233,37.1717409402908],[112.1040605767039,37.1652993891745],[112.1247575356538,37.15517583284707],[112.13625584618151,37.14505090913915],[112.14890398776201,37.13032130670486],[112.16500162250081,37.11558881197387],[112.1822490882924,37.11190523641665],[112.19489722987288,37.114667935029026],[112.20409587829505,37.11006338086117],[112.21444435776999,37.10269550681178],[112.22479283724495,37.099932367671414],[112.24089047198375,37.099932367671414],[112.25238878251146,37.0971691268778],[112.27078607935582,37.10085342534648],[112.28573388304184,37.10730051280908],[112.29838202462234,37.10361653060183],[112.32252847673054,37.09901129870156],[112.3409257735749,37.0944057844336],[112.44211090621882,37.076902255238394],[112.44326073727159,37.076902255238394],[112.4547590477993,37.08150884239164],[112.45935837201039,37.08795759010409],[112.47430617569643,37.08887879460397],[112.4835048241186,37.092563499666205],[112.49040381043523,37.09624802402411],[112.4996024588574,37.10269550681178],[112.5076512762268,37.10730051280908],[112.51914958675452,37.11098431428691],[112.53064789728224,37.11282614725031],[112.54214620780995,37.11098431428691],[112.55824384254876,37.114667935029026],[112.57319164623479,37.114667935029026],[112.58468995676252,37.10914243613956],[112.62953336782061,37.08335139820373],[112.63988184729556,37.078744923977425],[112.64563100255941,37.078744923977425],[112.6548296509816,37.070452558947885],[112.66057880624545,37.06953112859609],[112.67207711677317,37.06953112859609],[112.68932458256474,37.06953112859609],[112.70542221730355,37.06676676979174],[112.71462086572572,37.06768823401792],[112.72266968309512,37.07413816743744],[112.73071850046453,37.08150884239164],[112.74336664204502,37.08335139820373],[112.75256529046719,37.08887879460397],[112.76291376994213,37.092563499666205],[112.77441208046986,37.09348464769697],[112.78591039099757,37.09624802402411],[112.80200802573638,37.09809021843699],[112.81235650521133,37.10914243613956],[112.81695582942241,37.11650967762224],[112.8296039710029,37.120193027249066],[112.83995245047785,37.120193027249066],[112.85490025416388,37.120193027249066],[112.86984805784991,37.11650967762224],[112.88824535469426,37.12295542085145],[112.90319315838029,37.12203463428111],[112.91814096206633,37.10914243613956],[112.92963927259404,37.10361653060183],[112.95033623154394,37.10730051280908],[112.98253150102154,37.10822148012217],[112.9928799804965,37.10730051280908],[113.01357693944638,37.11098431428691],[113.02277558786857,37.10453754309669],[113.03312406734351,37.10177447172663],[113.04347254681845,37.095326909876015],[113.05037153313508,37.09809021843699],[113.05957018155726,37.09901129870156],[113.06531933682112,37.10545854429625],[113.0699186610322,37.10914243613956],[113.07911730945438,37.11374704678781],[113.09521494419319,37.114667935029026],[113.10901291682644,37.114667935029026],[113.12856004472356,37.11835137502917],[113.14695734156791,37.12295542085145],[113.15270649683177,37.123876196124534],[113.16535463841227,37.12203463428111],[113.17455328683444,37.11835137502917],[113.18145227315107,37.11006338086117],[113.19065092157324,37.10914243613956],[113.20214923210096,37.10822148012217],[113.22514585315639,37.10822148012217],[113.23549433263133,37.11006338086117],[113.25159196737015,37.11282614725031],[113.26653977105617,37.117430531974044],[113.27918791263667,37.120193027249066],[113.29758520948101,37.117430531974044],[113.30448419579764,37.117430531974044],[113.32058183053645,37.114667935029026],[113.33322997211694,37.11650967762224],[113.34127878948634,37.12111383641362],[113.35737642422515,37.12111383641362],[113.37232422791118,37.12203463428111],[113.39072152475553,37.117430531974044],[113.4079689905471,37.11282614725031],[113.40681915949433,37.11190523641665],[113.44016426002472,37.11282614725031],[113.48385784003004,37.11650967762224],[113.55744702740743,37.12571771277857],[113.57469449319902,37.120193027249066],[113.5953914521489,37.11835137502917],[113.61148908688772,37.11558881197387],[113.64943351162918,37.11927220678755],[113.65978199110413,37.11558881197387],[113.6689806395263,37.11558881197387],[113.68047895005402,37.12571771277857],[113.6896775984762,37.131241991596404],[113.69887624689837,37.12847990302775],[113.71037455742608,37.123876196124534],[113.77361526532853,37.11098431428691]]');
INSERT INTO `t_course` VALUES ('110', 'G5霍州', '#19a61c', '5', '1', '0', '[[112.22306809066579,37.569118926186405],[112.2426152185629,37.54348666342116],[112.24606471172122,37.51234982006314],[112.25411352909063,37.49494411068625],[112.26101251540726,37.468369612154895],[112.29435761593764,37.42528035740336],[112.29435761593764,37.41427483480485],[112.29665727804318,37.38858893890867],[112.29090812277933,37.37023643431253],[112.28285930540991,37.36014062615245],[112.27825998119883,37.33351783818744],[112.27366065698774,37.31882532835495],[112.27251082593497,37.304129921172006],[112.27481048804052,37.28851287683979],[112.27251082593497,37.27105466359129],[112.26676167067112,37.25634984271328],[112.26561183961834,37.23612598596816],[112.25411352909063,37.22141428846944],[112.24376504961567,37.20761944303166],[112.22306809066579,37.1901423202864],[112.19777180750481,37.179102034848384],[112.17477518644937,37.15885728427316],[112.15062873434117,37.15057376430022],[112.12533245118018,37.14136877970527],[112.11728363381079,37.136765863681504],[112.08623819538595,37.11282614725031],[112.06669106748882,37.099932367671414],[112.04829377064448,37.08795759010409],[112.03794529116954,37.07598090393029],[112.02759681169458,37.06953112859609],[112.01379883906132,37.06123774732149],[112.00115069748084,37.05755150652651],[111.98850255590034,37.04556997639944],[111.97355475221431,37.03266465649448],[111.95285779326441,37.022523210223106],[111.94480897589501,37.00869176446145],[111.94480897589501,36.996702457579794],[111.94710863800056,36.98378876370178],[111.9494083001061,36.96995020921498],[111.94365914484224,36.954263445756865],[111.93905982063116,36.938573422624465],[111.93905982063116,36.926572970512815],[111.93790998957839,36.911800567257174],[111.93101100326176,36.90256634950722],[111.91606319957572,36.896101726301616],[111.90916421325909,36.88409453205125],[111.904564889048,36.873933110607446],[111.8884672543092,36.862846368268585],[111.88041843693979,36.84621321213794],[111.8677702953593,36.841592243092755],[111.8562719848316,36.826803249381925],[111.84707333640941,36.820332157759445],[111.83902451904001,36.81016218432389],[111.83902451904001,36.800915571270195],[111.83902451904001,36.7916678319814],[111.82292688430121,36.777794111581336],[111.81487806693181,36.76299268406861],[111.81372823587903,36.750039070769894],[111.8194773911429,36.73615775105249],[111.82062722219567,36.72042252732166],[111.82062722219567,36.70283225215899],[111.81602789798458,36.685237915228385],[111.8194773911429,36.669492171407434],[111.81487806693181,36.6491105012765],[111.81027874272071,36.63243054095732],[111.81142857377348,36.611111957091126],[111.81487806693181,36.591641969702984],[111.81487806693181,36.577731801294775],[111.81717772903735,36.56196388723394],[111.82177705324844,36.54990387964451],[111.82177705324844,36.535986127115606],[111.8194773911429,36.51556885185542],[111.80222992535131,36.47286062266532],[111.79993026324577,36.453355489963016],[111.79303127692914,36.43849111439415],[111.79303127692914,36.424553153325625],[111.78038313534866,36.41433037743215],[111.77348414903202,36.40503576684972],[111.76658516271539,36.38923235450663],[111.76658516271539,36.373425700843754],[111.75508685218767,36.352965220755294],[111.733240062185,36.34273294576748],[111.71829225849898,36.33994208989562],[111.7044942858657,36.3362207917952],[111.68034783375751,36.33156891695775],[111.66999935428257,36.33156891695775],[111.64355324006881,36.32598629725999],[111.62630577427723,36.31295861551678],[111.61480746374951,36.298067146784476],[111.60675864638011,36.284103789681964],[111.5906610116413,36.27572456543652],[111.57111388374419,36.26361963961155],[111.55616608005815,36.25616951359579],[111.54236810742489,36.24406153003966],[111.52857013479164,36.23102004660291],[111.52052131742222,36.21797636854145],[111.51132266900005,36.20213466661986],[111.50212402057788,36.18628972973744],[111.4894758789974,36.17230621703858],[111.48257689268075,36.14806216426359],[111.47337824425858,36.123810548950445],[111.46302976478364,36.10701654002473],[111.46302976478364,36.09488528031437],[111.46417959583641,36.08181873361498],[111.45958027162533,36.072484144446776],[111.45153145425593,36.05848016483486],[111.44348263688651,36.0444736705298],[111.43083449530603,36.03139867403595],[111.42163584688386,36.01645313936571],[111.41473686056723,36.0005703752334],[111.41013753635613,35.98561894261489],[111.40553821214505,35.973468798503845],[111.40208871898673,35.959447056589994],[111.38944057740625,35.935136753550424],[111.37679243582576,35.9145606038325],[111.36989344950912,35.898657152547166],[111.35839513898141,35.8818146897098],[111.34919649055924,35.866840577493434],[111.34114767318984,35.844374055878475],[111.33539851792597,35.82377410234856],[111.32045071423994,35.80129527230236],[111.30665274160668,35.75725563640356],[111.29860392423727,35.73194514208127],[111.29975375529004,35.720693427482864],[111.29860392423727,35.71881798582376],[111.29515443107896,35.714129186823236],[111.29055510686787,35.707564400598855],[111.28595578265679,35.696309212200305]]');
INSERT INTO `t_course` VALUES ('111', 'G5河津', '#19a61c', '5', '1', '0', '[[111.2853808671304,35.696309212200305],[111.27158289449714,35.68974294536107],[111.25318559765279,35.683176133107324],[111.24398694923062,35.67660877547964],[111.23133880765013,35.66910255615236],[111.211791679753,35.66159562461354],[111.1956940450142,35.65408798092383],[111.17729674816985,35.65127243095119],[111.16234894448382,35.65127243095119],[111.13935232342838,35.65502647532871],[111.12325468868958,35.65502647532871],[111.10370756079246,35.65878034168182],[111.08646009500089,35.65784189178374],[111.06576313605099,35.65408798092383],[111.04851567025942,35.65221095873495],[111.02436921815121,35.649395342005626],[111.00252242814854,35.649395342005626],[110.98527496235697,35.64751820855681],[110.96457800340707,35.65033389204136],[110.94503087550996,35.65127243095119],[110.91743493024343,35.65127243095119],[110.8978878023463,35.65314947539254],[110.87949050550196,35.65502647532871],[110.85994337760484,35.65502647532871],[110.84729523602435,35.65221095873495],[110.83234743233832,35.65408798092383],[110.81969929075782,35.656903430758796],[110.80590131812457,35.656903430758796],[110.7921033454913,35.65408798092383],[110.77485587969973,35.649395342005626],[110.75875824496093,35.64376380815319],[110.75070942759152,35.63907055733475],[110.74151077916935,35.635315756438125],[110.73001246864163,35.631560777556984],[110.71966398916669,35.62968322137459],[110.7104653407445,35.62498913626262],[110.7024165233751,35.621233667963295],[110.69551753705848,35.61653908233947],[110.68976838179462,35.61184421867437],[110.682869395478,35.60808812756257],[110.67597040916135,35.606210015282706],[110.64492497073651,35.60151453997924],[110.61272970125891,35.60151453997924]]');
INSERT INTO `t_course` VALUES ('112', 'G59临猗', '#19a61c', '5', '1', '0', '[[110.78520435917467,36.08461889237554],[110.78750402128021,36.06594926692503],[110.7840545281219,36.054745345552234],[110.78060503496359,36.04820898153741],[110.77830537285804,36.03139867403595],[110.7760057107525,36.01832148760753],[110.77370604864696,36.0080450193102],[110.78750402128021,35.991226064898996],[110.79555283864963,35.97533817427726],[110.80245182496625,35.96038191753915],[110.81050064233565,35.94916284932561],[110.8208491218106,35.93981239786292],[110.82774810812722,35.93700704476043],[110.83119760128555,35.93046083020291],[110.83464709444387,35.922978772489834],[110.8334972633911,35.91081890540461],[110.8334972633911,35.902399431185756],[110.83004777023278,35.89585032642015],[110.82774810812722,35.88649351417027],[110.82544844602168,35.874327990527114],[110.82199895286337,35.86590460067453],[110.81854945970505,35.859352450667956],[110.81969929075782,35.845310289184376],[110.81854945970505,35.83594745437935],[110.81854945970505,35.82751994979708],[110.8208491218106,35.82002807653737],[110.8208491218106,35.812535489856856],[110.81739962865228,35.808788929002404],[110.81739962865228,35.80129527230236],[110.8208491218106,35.79286405593509],[110.81739962865228,35.79005344988633],[110.81165047338843,35.7844319369182],[110.80590131812457,35.78068403874912],[110.80015216286071,35.77787299812769],[110.78865385233298,35.7666278328977],[110.78635419022744,35.75913016482117],[110.78635419022744,35.753506445896704],[110.78175486601636,35.74600753022282],[110.77945520391081,35.73944539426255],[110.77830537285804,35.734757820174075],[110.77945520391081,35.72913236376258],[110.78635419022744,35.72350650646019],[110.79900233180794,35.71694249962643],[110.81050064233565,35.71037794721056],[110.81969929075782,35.707564400598855],[110.82429861496891,35.70662652946183],[110.82774810812722,35.70287493358456],[110.82889793918001,35.69537120747468],[110.8334972633911,35.686928664035406],[110.83464709444387,35.67660877547964],[110.83119760128555,35.66910255615236],[110.83234743233832,35.65502647532871],[110.83809658760218,35.624050285871576],[110.8415460807605,35.614661170237554],[110.83924641865495,35.6033927634607],[110.83234743233832,35.5968187866822],[110.83234743233832,35.58836573025142],[110.83234743233832,35.57709358748202],[110.83464709444387,35.56675938368427],[110.82889793918001,35.55924275433103],[110.82659827707445,35.55078569606353],[110.82659827707445,35.53950821811609],[110.82659827707445,35.52728914467355],[110.82659827707445,35.51882868620412],[110.81969929075782,35.50942712142518],[110.8128003044412,35.50002444584875],[110.81165047338843,35.486858834132],[110.80935081128288,35.47745349313472],[110.80130199391348,35.46804704175125],[110.79555283864963,35.45769866287808],[110.79325317654408,35.44452605614905],[110.79095351443853,35.43605680299246],[110.78520435917467,35.4209981332899],[110.78290469706913,35.40781946700435],[110.78290469706913,35.39652173652077],[110.76565723127756,35.3767468644426],[110.7599080760137,35.36638664606041],[110.75300908969706,35.351314842224085],[110.74266061022212,35.337182448274405],[110.73806128601103,35.32304756005291],[110.74151077916935,35.30891017797581],[110.74611010338043,35.29005645659608],[110.74955959653875,35.27779916109002],[110.74955959653875,35.26648307278343],[110.74840976548597,35.252335719459886],[110.74611010338043,35.24007266433737],[110.7392111170638,35.22780773789666],[110.7311622996944,35.217428261797814],[110.7311622996944,35.19949692098417],[110.7311622996944,35.18911379221244],[110.7311622996944,35.17967342228915],[110.73001246864163,35.16362225409573],[110.73001246864163,35.148512351689774],[110.73346196179995,35.1419008789675],[110.73346196179995,35.13056566492992],[110.73346196179995,35.11828405274903],[110.74036094811657,35.10033064301745],[110.75415892074983,35.09087987707299],[110.7679568933831,35.07953749895111],[110.78520435917467,35.06062999904127],[110.80245182496625,35.05401132989366],[110.8208491218106,35.04644647370025],[110.84269591181327,35.02753124018437],[110.85304439128821,35.01807196668716],[110.86914202602702,34.99536520490149],[110.87029185707979,34.98022383075271],[110.87489118129088,34.96223977882519],[110.87834067444919,34.944251743024736],[110.88753932287136,34.92815380848767],[110.90363695761017,34.91963008188674],[110.90938611287403,34.91584147217112],[110.90478678866295,34.91299989907587],[110.89673797129353,34.908263723339836],[110.8898389849769,34.90542188555752],[110.88064033655473,34.8987905447611],[110.8737413502381,34.89500096456607],[110.87029185707979,34.89026374122722],[110.86684236392148,34.88078846762749],[110.86684236392148,34.86846896379768],[110.88523966076582,34.81537903936177],[110.88064033655473,34.80399813185479],[110.87259151918533,34.791667025623454],[110.87259151918533,34.77933405831652],[110.86799219497425,34.769845894156774],[110.85879354655206,34.76130560511733],[110.86224303971038,34.74232399282673],[110.86914202602702,34.73188222957109],[110.87489118129088,34.729983584103906],[110.89328847813522,34.71384332063703],[110.90018746445185,34.701498620897425],[110.91513526813789,34.697699877741314]]');
INSERT INTO `t_course` VALUES ('113', 'S5902', '#19a61c', '5', '1', '0', '[[110.90708645076849,34.91678864114435],[110.92893324077114,34.91678864114435],[110.94848036866827,34.92341851512466],[110.96457800340707,34.9319418446205],[110.98067563814588,34.93572970424878],[111.00367225920131,34.94709222402355],[111.03126820446784,34.96413302454433],[111.04161668394278,34.971705565973956],[111.05081533236496,34.9754915718062],[111.06231364289268,34.983063053664424],[111.07266212236762,34.98968752077209],[111.08531026394812,34.99536520490149],[111.09220925026474,35.000096304739614],[111.106007222898,35.005773260197735],[111.12210485763681,35.00861158886743],[111.1347529992173,35.0171259785976],[111.14625130974501,35.02469357409668],[111.15544995816718,35.03131464034432],[111.16119911343105,35.0492833776292],[111.14625130974501,35.05590243346383],[111.1347529992173,35.06441185262263],[111.11750553342571,35.07102967098043],[111.09910823658137,35.07386571309517],[111.09220925026474,35.07386571309517],[111.08301060184256,35.07386571309517],[111.07036246026207,35.07953749895111],[111.06001398078713,35.08898959124371],[111.05196516341773,35.094660316094206],[111.04506617710109,35.10127565881536],[111.03931702183723,35.10694552145554],[111.03471769762615,35.10978030353241],[111.02321938709844,35.115449569182566],[111.00942141446517,35.131510326923596],[111.00137259709577,35.12017365317673],[110.99332377972637,35.114504719214274],[110.98527496235697,35.10789045986986],[110.9760763139348,35.09844057825887],[110.97262682077647,35.09087987707299],[110.9634281723543,35.07953749895111],[110.95767901709044,35.07575635258481],[110.9473305376155,35.06913892098526],[110.93238273392946,35.06062999904127],[110.92318408550729,35.04833775403349],[110.91973459234897,35.037935165386294],[110.91743493024343,35.03226046277209],[110.91743493024343,35.02847710679144],[110.91743493024343,35.02469357409668],[110.91283560603235,35.02374766331238],[110.91168577497957,35.021855808611924],[110.90593661971572,35.021855808611924],[110.8978878023463,35.02374766331238],[110.85419422234098,35.01807196668716]]');
INSERT INTO `t_course` VALUES ('114', 'S75', '#19a61c', '5', '1', '0', '[[111.15832453579912,35.0492833776292],[111.16982284632684,35.04550081696301],[111.17442217053792,35.04550081696301],[111.1755720015907,35.042663780470185],[111.17212250843238,35.040772367575364],[111.17212250843238,35.03888091049539],[111.17212250843238,35.037935165386294],[111.17787166369624,35.03698940923128],[111.18132115685455,35.03698940923128],[111.18132115685455,35.0360436420305],[111.17902149474901,35.03320627415473],[111.17672183264347,35.03131464034432],[111.17902149474901,35.02942296235387],[111.17902149474901,35.026585362532806],[111.17902149474901,35.02280174148407],[111.1836208189601,35.021855808611924],[111.19281946738226,35.02374766331238],[111.19626896054059,35.02374766331238],[111.19741879159336,35.02090986469601],[111.19511912948782,35.01996390973651],[111.1916696363295,35.01901794373352],[111.18707031211841,35.01807196668716],[111.18477065001287,35.01617997946494],[111.19051980527672,35.01428794807083],[111.18936997422395,35.012395872505856],[111.18822014317118,35.00955767634027],[111.18936997422395,35.005773260197735],[111.19281946738226,35.00388098587657],[111.19626896054059,34.99820389792585],[111.19741879159336,34.98022383075271],[111.19856862264614,34.966972810353354],[111.19626896054059,34.95750647140554],[111.19511912948782,34.94330489395854],[111.19396929843505,34.936676641576035],[111.1916696363295,34.9319418446205],[111.19626896054059,34.92341851512466],[111.20201811580445,34.91678864114435],[111.20546760896276,34.90731645510719],[111.20546760896276,34.897843166252535],[111.21351642633216,34.87984087963036],[111.2158160884377,34.86562573681646],[111.21466625738493,34.855199722515415],[111.2158160884377,34.854251836904695],[111.20316794685722,34.84666835527722],[111.20201811580445,34.843824367835595],[111.20201811580445,34.843824367835595]]');
INSERT INTO `t_course` VALUES ('115', 'S87', '#19a61c', '5', '1', '0', '[[110.85246947576182,35.01807196668716],[110.8375216720758,35.012395872505856],[110.82717319260084,35.00955767634027],[110.81337521996758,35.005773260197735],[110.80417657154541,35.00388098587657],[110.7926782610177,35.002934832153976],[110.78347961259551,35.000096304739614],[110.755883667329,34.98779487107919],[110.74783484995959,34.98590217722976],[110.70414126995426,34.98211665706551],[110.68919346626824,34.97643804567093],[110.67654532468774,34.97075903692321],[110.6661968452128,34.966026226119816],[110.65239887257954,34.963186407202656],[110.6374510688935,34.958453154960004],[110.6213534341547,34.95182613834783],[110.60755546152143,34.94614540805737],[110.59490731994094,34.94330489395854],[110.58225917836046,34.94046428056197],[110.56731137467442,34.936676641576035],[110.55466323309393,34.93383579649824],[110.53856559835513,34.93099485213428],[110.52821711888018,34.92625972423461],[110.52016830151078,34.92341851512466],[110.51326931519415,34.92152432056592],[110.50637032887752,34.92152432056592],[110.49602184940257,34.922471423360406],[110.48567336992762,34.91963008188674],[110.47417505939991,34.91394710113674],[110.46612624203051,34.909210980544174],[110.46037708676664,34.90542188555752],[110.45692759360833,34.901632614124225],[110.45232826939724,34.90068526869708],[110.44312962097507,34.89973791224266],[110.4339309725529,34.8959483761549],[110.42588215518349,34.894053541950775],[110.42243266202517,34.8893162634814],[110.41668350676132,34.884578709369194],[110.40978452044469,34.88078846762749],[110.39943604096975,34.874155120139484],[110.39598654781143,34.86941668407922],[110.38793773044202,34.864677972444284],[110.38103874412539,34.858991154746676],[110.3764394199143,34.855199722515415],[110.37413975780876,34.844772374669105],[110.37298992675599,34.83623991647737],[110.36954043359768,34.82770656579288],[110.36494110938659,34.822017169554265],[110.35919195412274,34.8163273767227],[110.35114313675332,34.811585579763836],[110.34654381254224,34.80399813185479],[110.33159600885621,34.77743651356498],[110.3200976983285,34.76225457015578],[110.31319871201185,34.75561158372155],[110.30400006358968,34.74896805793014],[110.30170040148414,34.74706980864474],[110.29595124622028,34.73473011524159],[110.29020209095643,34.72713553337548],[110.28905225990366,34.722388562096526],[110.28215327358703,34.71384332063703],[110.2787037804287,34.70529718805732],[110.2787037804287,34.698649580029524],[110.28675259779811,34.69010186347432],[110.29595124622028,34.67965344456191],[110.30400006358968,34.675853689592124],[110.31204888095908,34.663503270906084]]');
INSERT INTO `t_course` VALUES ('116', 'G3511', '#19a61c', '5', '1', '0', '[[110.57306052993827,35.31739290646141],[110.58685850257154,35.32398996352557],[110.59835681309926,35.3287018146275],[110.60755546152143,35.337182448274405],[110.61790394099638,35.34754644774534],[110.63170191362964,35.35319897293895],[110.64894937942123,35.35885109897372],[110.66044768994894,35.36261896122887],[110.6742456625822,35.36261896122887],[110.69264295942655,35.36544474148642],[110.70529110100703,35.36544474148642],[110.72023890469308,35.36450282582308],[110.72943755311525,35.36167701229822],[110.74208569469573,35.36261896122887],[110.75818332943454,35.36544474148642],[110.77313113312057,35.36827042193988],[110.79037859891214,35.3720378406213],[110.80992572680927,35.3767468644426],[110.82602336154807,35.377688635934895],[110.83867150312857,35.37863039633626],[110.85591896892014,35.38239732702987],[110.86626744839509,35.3852224085892],[110.8777657589228,35.3852224085892],[110.89041390050329,35.38898902871422],[110.90421187313656,35.39463862612701],[110.91111085945319,35.40028782418661],[110.9145603526115,35.40970226676267],[110.92030950787536,35.4153503997513],[110.92490883208644,35.4209981332899],[110.93295764945584,35.42288062236489],[110.94100646682526,35.423821850257234],[110.95250477735297,35.42288062236489],[110.96515291893346,35.42288062236489],[110.97665122946118,35.423821850257234],[110.98699970893612,35.42664546735217],[110.99504852630552,35.425704272750984],[111.00309734367492,35.42476306705264],[111.01114616104432,35.42664546735217],[111.0168953163082,35.43417462464862],[111.0249441336776,35.43605680299246],[111.04334143052193,35.43417462464862],[111.05254007894412,35.430410134782676],[111.06173872736629,35.429468984571415],[111.07668653105232,35.430410134782676],[111.08703501052727,35.42758665085604],[111.09623365894944,35.42758665085604],[111.10428247631884,35.429468984571415],[111.11348112474101,35.429468984571415],[111.12727909737428,35.430410134782676],[111.13992723895477,35.43229240191171],[111.14912588737694,35.43511571936973],[111.15717470474634,35.439821026496936],[111.17327233948515,35.439821026496936],[111.18477065001287,35.44452605614905],[111.19281946738226,35.44828988007846],[111.20316794685722,35.44923080831087],[111.21351642633216,35.45111263147491],[111.22271507475433,35.45581699512479],[111.23076389212375,35.46146186516795],[111.2365130473876,35.46804704175125],[111.24226220265146,35.47180975554322],[111.24801135791532,35.47463167430473],[111.25376051317917,35.47463167430473],[111.26295916160134,35.472750406233686],[111.26985814791799,35.47086909374963],[111.27560730318184,35.472750406233686],[111.28365612055124,35.47463167430473],[111.29515443107896,35.47557229168505],[111.30090358634281,35.47557229168505],[111.30895240371223,35.47745349313472],[111.31355172792331,35.48121576278675],[111.31930088318717,35.48403734843058],[111.32505003845102,35.48497785476926],[111.33309885582042,35.48121576278675],[111.3342486868732,35.48121576278675],[111.34919649055924,35.47557229168505],[111.36184463213972,35.47180975554322],[111.37679243582576,35.47180975554322],[111.39059040845902,35.46804704175125],[111.40668804319782,35.46428415031687],[111.41703652267277,35.46240263798622],[111.42738500214772,35.46240263798622],[111.44233280583374,35.46052108124789],[111.45613077846701,35.45863948010282],[111.47222841320581,35.45863948010282],[111.48027723057521,35.456757834552036],[111.49292537215571,35.45299441023711],[111.50327385163065,35.44828988007846],[111.51477216215837,35.44452605614905],[111.52512064163332,35.44358507241738],[111.54121827637212,35.43511571936973],[111.54811726268875,35.429468984571415],[111.55041692479429,35.429468984571415],[111.56191523532202,35.417233021982135],[111.56881422163865,35.408760872430996],[111.5745633769025,35.40499518415576],[111.57801287006082,35.38710574083605],[111.58606168743022,35.380513883865675],[111.58721151848299,35.36638664606041],[111.60100949111626,35.338124685475215],[111.60215932216903,35.3287018146275],[111.60905830848566,35.322105145496444],[111.61480746374951,35.321162719856304],[111.61595729480229,35.31362291573752],[111.62285628111891,35.31362291573752],[111.62860543638277,35.31173785387967],[111.63550442269941,35.30702500529661],[111.64355324006881,35.30419716316535],[111.6562013816493,35.3013692213021],[111.65965087480761,35.290999247928326],[111.6642501990187,35.28345660705213],[111.67459867849365,35.2796850207235],[111.69069631323245,35.27214131632485],[111.70679394797126,35.26648307278343],[111.71829225849898,35.26176756523086],[111.73094040007946,35.25516538947917],[111.74473837271273,35.24761938127259],[111.75738651429322,35.24101604271069],[111.76888482482093,35.23912927489114],[111.77808347324311,35.2249771045361],[111.78843195271806,35.222146371537505],[111.79648077008746,35.215540940411785],[111.80567941850963,35.211766164805034],[111.81257840482625,35.207047446241795],[111.82292688430121,35.20327227215712],[111.83672485693447,35.20327227215712],[111.84937299851495,35.20327227215712],[111.86547063325376,35.200440775378986],[111.88156826799256,35.19760917899207],[111.89191674746752,35.194777482999754],[111.90571472010078,35.19100173340744],[111.91951269273403,35.18816980501566],[111.93216083431453,35.18439374556969],[111.94250931378947,35.18344970304411],[111.95515745536996,35.178729324437874],[111.96550593484491,35.17495282238649],[111.97470458326708,35.17023194587738],[111.98275340063648,35.16267796816064],[111.99310188011142,35.15890071379526],[112.00115069748084,35.15417889694178],[112.01379883906132,35.15417889694178],[112.02529714958904,35.15134567409079],[112.03794529116954,35.148512351689774],[112.05174326380279,35.146623414785196],[112.06554123643605,35.147567888767796]]');
INSERT INTO `t_course` VALUES ('117', 'S8612在建', '#2767b4', '5', '1', '0', '[[111.80797908061517,35.20799121209198],[111.80567941850963,35.202328450965595],[111.80452958745686,35.196665291395064],[111.80797908061517,35.18911379221244],[111.80912891166794,35.1815615847969],[111.8068292495624,35.17495282238649],[111.81372823587903,35.16645504552402],[111.82062722219567,35.161733671162914],[111.83212553272338,35.15417889694178],[111.8355750258817,35.148512351689774],[111.84247401219832,35.14473443363869],[111.84707333640941,35.14378992647503],[111.85052282956772,35.14001178722056],[111.85282249167328,35.13528886431238],[111.85052282956772,35.13056566492992],[111.84822316746218,35.1248974607471],[111.84707333640941,35.12017365317673],[111.84707333640941,35.115449569182566],[111.85167266062051,35.10978030353241],[111.85397232272605,35.106000571986065],[111.8562719848316,35.102220663558846],[111.85282249167328,35.099385616165236],[111.84592350535664,35.09655046928412],[111.84017435009278,35.095605398216],[111.83327536377615,35.09371522291889],[111.83097570167061,35.08898959124371],[111.83097570167061,35.08426368324916],[111.82982587061784,35.07764694787046]]');
INSERT INTO `t_course` VALUES ('118', 'S75', '#19a61c', '5', '1', '0', '[[111.28595578265679,35.696309212200305],[111.28480595160401,35.683176133107324],[111.28365612055124,35.67285575484623],[111.28480595160401,35.66628754028434],[111.28480595160401,35.655964958607086],[111.28250628949847,35.64657962514397],[111.2813564584457,35.63719317913498],[111.28595578265679,35.6268668036764],[111.28480595160401,35.618416949954785],[111.28480595160401,35.609966195360094],[111.28480595160401,35.600575411558836],[111.28595578265679,35.590244265065586],[111.29400460002618,35.5808511462815],[111.29860392423727,35.57803299385714],[111.30780257265945,35.573335850816406],[111.31930088318717,35.56863842987182],[111.32390020739825,35.561121978357875],[111.32275037634548,35.54984596735472],[111.32390020739825,35.540448069062975],[111.32734970055657,35.53198901052507],[111.33309885582042,35.51976878158351],[111.33769818003151,35.5037856493673],[111.33884801108428,35.49626306462194],[111.33309885582042,35.483096830987186],[111.32275037634548,35.466165618238875],[111.31240189687054,35.45581699512479],[111.30435307950114,35.44546702878113],[111.29860392423727,35.43699787551666],[111.29630426213173,35.429468984571415],[111.29055510686787,35.4209981332899],[111.27790696528739,35.413467733137104],[111.26870831686522,35.40970226676267],[111.26180933054857,35.40593662286661],[111.24916118896809,35.39558018687052],[111.24341203370423,35.38993065601476],[111.23536321633483,35.38710574083605],[111.22271507475433,35.38428072582786],[111.21236659527939,35.380513883865675],[111.20546760896276,35.375805081859475],[111.19281946738226,35.357909105688414],[111.18247098790732,35.33529794061594],[111.17442217053792,35.326817107439496],[111.1594743668519,35.31173785387967],[111.1468262252714,35.3013692213021],[111.1307285905326,35.28062793392313],[111.12382960421597,35.268369198270726],[111.12038011105764,35.25516538947917],[111.11118146263547,35.23818587437217],[111.1019828142133,35.2249771045361],[111.09508382789667,35.215540940411785],[111.09163433473836,35.206103669323085],[111.0812858552634,35.194777482999754],[111.07093737578846,35.18816980501566],[111.06173872736629,35.182505649453134],[111.05483974104966,35.1768410955412],[111.05024041683858,35.16834351782745],[111.03874210631085,35.15512328243597],[111.00884649893878,35.132454977858806]]');
INSERT INTO `t_course` VALUES ('119', 'S80', '#19a61c', '5', '1', '0', '[[111.28480595160401,35.69724720579421],[111.30090358634281,35.69724720579421],[111.31585139002885,35.70006111978432],[111.32964936266211,35.70568864719175],[111.34344733529538,35.707564400598855],[111.3549456458231,35.70568864719175],[111.36874361845635,35.70662652946183],[111.3790920979313,35.70662652946183],[111.38829074635348,35.70568864719175],[111.3951897326701,35.704750753788794],[111.4112873674089,35.70568864719175],[111.42048601583109,35.70662652946183],[111.42853483320049,35.71037794721056],[111.4400331437282,35.716004739826204],[111.45728060951978,35.71975571222065],[111.47107858215304,35.72163113161026],[111.48372672373353,35.720693427482864],[111.49637486531402,35.71788024829232],[111.5055735137362,35.716004739826204],[111.5136223311056,35.714129186823236],[111.52052131742222,35.711315773814285],[111.53201962794995,35.70662652946183],[111.53891861426658,35.70381284925301],[111.55041692479429,35.70006111978432],[111.55961557321648,35.698185188256254],[111.56766439058588,35.69724720579421],[111.58031253216636,35.69724720579421],[111.59755999795794,35.698185188256254],[111.61020813953843,35.69912315958633],[111.62055661901337,35.698185188256254],[111.63435459164664,35.69537120747468],[111.64125357796327,35.692557126508554],[111.6562013816493,35.69537120747468],[111.66654986112424,35.69537120747468],[111.68264749586305,35.69537120747468],[111.68379732691582,35.692557126508554],[111.69874513060185,35.69161907725716],[111.71484276534066,35.69161907725716],[111.72634107586838,35.69349516462867],[111.74243871060719,35.69912315958633],[111.75163735902936,35.70287493358456],[111.77233431797924,35.704750753788794],[111.7907316148236,35.71881798582376],[111.80337975640408,35.726319485221154],[111.81487806693181,35.73100756044443],[111.83097570167061,35.73944539426255],[111.84247401219832,35.74225780507078],[111.84822316746218,35.743195253065345],[111.85512215377882,35.743195253065345],[111.864320802201,35.7413203459387],[111.87466928167593,35.73850790171869],[111.88616759220365,35.73663288321996],[111.89421640957306,35.73663288321996],[111.90226522694246,35.73382027194621],[111.90801438220632,35.73382027194621],[111.91721303062849,35.732882712581905],[111.92641167905067,35.73006996767149],[111.93216083431453,35.72538183676952],[111.94020965168393,35.71881798582376],[111.95055813115887,35.714129186823236],[111.96780559695046,35.704750753788794],[111.98735272484757,35.69724720579421],[112.00919951485024,35.686928664035406],[112.02184765643072,35.684114282534765],[112.02989647380012,35.682237972549814],[112.04024495327508,35.67754700281516],[112.0471439395917,35.67097917775639],[112.05634258801388,35.66628754028434],[112.07359005380546,35.66628754028434],[112.08508836433317,35.668164228657844],[112.09543684380812,35.67379402669806],[112.09888633696643,35.67379402669806],[112.1126843095997,35.66722589003513],[112.11843346486356,35.6653491794056],[112.12533245118018,35.664410807399044],[112.13453109960236,35.66347242426477],[112.14143008591898,35.66347242426477],[112.1494789032884,35.66722589003513],[112.15407822749948,35.66910255615236],[112.16212704486888,35.67379402669806],[112.16902603118551,35.67848521902132],[112.17477518644937,35.682237972549814],[112.18167417276601,35.686928664035406],[112.18972299013541,35.68599054799892],[112.19777180750481,35.684114282534765],[112.20697045592698,35.684114282534765],[112.21961859750748,35.68599054799892],[112.23226673908796,35.685052420832],[112.23801589435182,35.683176133107324],[112.24951420487953,35.67567053701488],[112.25411352909063,35.67191747186565],[112.2713609948822,35.67097917775639],[112.2713609948822,35.67567053701488],[112.27481048804052,35.67754700281516],[112.2794098122516,35.682237972549814],[112.28400913646269,35.68599054799892],[112.287458629621,35.68786676894133],[112.29320778488487,35.688804862716594],[112.3001067712015,35.68974294536107],[112.30125660225427,35.696309212200305],[112.30470609541258,35.69912315958633],[112.31045525067644,35.70099906885008],[112.31390474383475,35.70287493358456],[112.31735423699307,35.704750753788794],[112.32080373015138,35.70850226060273],[112.32540305436247,35.71975571222065],[112.32770271646802,35.72444417718249],[112.33575153383742,35.72725712253729],[112.34265052015405,35.73006996767149],[112.35069933752345,35.732882712581905],[112.35529866173454,35.734757820174075],[112.36449731015672,35.734757820174075],[112.37139629647335,35.734757820174075],[112.3771454517372,35.732882712581905],[112.38174477594829,35.73663288321996],[112.38634410015938,35.73850790171869],[112.39554274858155,35.7413203459387],[112.40359156595096,35.7413203459387],[112.4139400454259,35.74038287566927],[112.42083903174253,35.73569535726536],[112.42888784911193,35.73382027194621],[112.43693666648134,35.73006996767149],[112.44613531490351,35.72913236376258],[112.45648379437846,35.72725712253729],[112.4668322738534,35.72256882460274],[112.47718075332835,35.71975571222065],[112.48522957069775,35.71975571222065],[112.4955780501727,35.71788024829232],[112.51397534701705,35.71319139362075],[112.52662348859754,35.712253589284394],[112.53812179912525,35.712253589284394],[112.55421943386406,35.716004739826204],[112.5726167307084,35.71506696889177],[112.58871436544722,35.71506696889177],[112.59791301386939,35.71506696889177],[112.60251233808047,35.71694249962643],[112.61171098650264,35.71694249962643],[112.61975980387206,35.71788024829232],[112.63125811439977,35.71788024829232],[112.64160659387471,35.716004739826204],[112.65425473545521,35.716004739826204],[112.66230355282461,35.71694249962643],[112.67035237019401,35.71788024829232],[112.68070084966895,35.71975571222065],[112.68989949809112,35.72256882460274],[112.69679848440776,35.7281947487178],[112.70369747072439,35.732882712581905],[112.7071469638827,35.73663288321996],[112.7151957812521,35.73850790171869],[112.72094493651596,35.73757039803779],[112.72899375388538,35.73569535726536],[112.73244324704369,35.73663288321996],[112.74049206441309,35.734757820174075],[112.74854088178249,35.73194514208127],[112.75773953020466,35.73382027194621],[112.76348868546852,35.73382027194621],[112.77383716494347,35.73100756044443],[112.78303581336564,35.726319485221154],[112.78993479968227,35.726319485221154],[112.80258294126277,35.726319485221154],[112.81523108284325,35.72538183676952],[112.82672939337097,35.7281947487178],[112.83937753495147,35.73006996767149],[112.8462765212681,35.7281947487178]]');
INSERT INTO `t_course` VALUES ('120', 'S80', '#19a61c', '5', '1', '0', '[[112.8462765212681,35.7281947487178],[112.8543253386375,35.72350650646019],[112.86352398705966,35.72350650646019],[112.86927314232352,35.71975571222065],[112.87617212864016,35.716004739826204],[112.88422094600956,35.716004739826204],[112.8945694254845,35.71694249962643],[112.90836739811776,35.71319139362075],[112.91641621548717,35.71506696889177],[112.92676469496212,35.71506696889177],[112.93481351233152,35.71037794721056],[112.94631182285924,35.71037794721056],[112.95666030233419,35.716004739826204],[112.96240945759804,35.71694249962643],[112.96930844391467,35.71694249962643],[112.9762074302313,35.71788024829232],[112.98425624760071,35.71788024829232],[112.99460472707565,35.71506696889177],[113.0049532065506,35.71506696889177],[113.01530168602554,35.712253589284394],[113.02909965865881,35.71319139362075],[113.04059796918652,35.716004739826204],[113.05209627971423,35.720693427482864],[113.06934374550582,35.72163113161026],[113.08429154919185,35.720693427482864],[113.09693969077234,35.72256882460274],[113.10498850814174,35.72725712253729],[113.11533698761669,35.73850790171869],[113.12798512919717,35.73944539426255],[113.14638242604153,35.74413268992228],[113.16248006078033,35.75444376023208],[113.17282854025528,35.75819290618212],[113.18087735762468,35.75913016482117],[113.19352549920517,35.75725563640356],[113.2084733028912,35.75913016482117],[113.22457093763,35.76194187390019],[113.23491941710495,35.76194187390019],[113.24641772763268,35.75819290618212],[113.25906586921316,35.75538106342844],[113.26826451763533,35.75538106342844],[113.27401367289919,35.75538106342844],[113.27976282816306,35.75538106342844],[113.29126113869077,35.751631783809366],[113.30275944921848,35.751631783809366],[113.30850860448234,35.7497570771673],[113.32115674606284,35.74600753022282],[113.3269059013267,35.74600753022282],[113.33840421185441,35.7469449336662],[113.34760286027658,35.7469449336662],[113.35795133975154,35.743195253065345],[113.36600015712094,35.74038287566927],[113.38209779185974,35.74788232597147],[113.38554728501806,35.7497570771673],[113.39244627133469,35.74881970713856],[113.395895764493,35.74600753022282],[113.40509441291518,35.74225780507078],[113.41314323028458,35.74413268992228],[113.42349170975953,35.74507011564146],[113.43499002028724,35.74507011564146],[113.44763816186773,35.74881970713856],[113.4568368102899,35.74788232597147],[113.48443275555643,35.73663288321996],[113.49133174187305,35.73006996767149],[113.50053039029524,35.72725712253729],[113.50512971450632,35.71788024829232],[113.51317853187572,35.712253589284394],[113.51892768713958,35.70662652946183],[113.52467684240344,35.701937006783545],[113.53387549082562,35.69724720579421],[113.54192430819502,35.692557126508554],[113.54997312556442,35.68974294536107],[113.55917177398659,35.68974294536107],[113.56837042240878,35.688804862716594],[113.5752694087254,35.688804862716594],[113.57986873293649,35.694433191617435],[113.60516501609747,35.698185188256254]]');
INSERT INTO `t_course` VALUES ('121', 'S86', '#19a61c', '5', '1', '0', '[[112.2713609948822,35.67097917775639],[112.28630879856823,35.66628754028434],[112.29780710909596,35.66159562461354],[112.30700575751813,35.656903430758796],[112.31735423699307,35.656903430758796],[112.32655288541525,35.649395342005626],[112.33345187173188,35.633438289245156],[112.34610001331237,35.6043318585215],[112.35069933752345,35.59587960266487],[112.35414883068177,35.5808511462815],[112.35644849278731,35.57145691578621],[112.37484578963166,35.56018237190169],[112.38059494489552,35.55924275433103],[112.39094342437046,35.54608694138915],[112.40359156595096,35.541387908897924],[112.41164038332036,35.53668859860488],[112.42543835595362,35.53480879670654],[112.44038615963966,35.53668859860488],[112.44613531490351,35.538568356057354],[112.45533396332569,35.533868879090456],[112.46338278069508,35.531049059576034],[112.47258142911727,35.531049059576034],[112.48063024648667,35.532928950363264],[112.4955780501727,35.529169124345806],[112.51052585385874,35.52634913817196],[112.52202416438645,35.524469091838476],[112.53352247491416,35.524469091838476],[112.5438709543891,35.522589001065356],[112.55306960281129,35.51506819359598],[112.55766892702238,35.50848690385145],[112.57491639281395,35.5037856493673],[112.5852648722889,35.49156108819795],[112.59906284492216,35.49156108819795],[112.60826149334433,35.49062065959564],[112.6174601417665,35.49062065959564],[112.63125811439977,35.48873976907445],[112.63585743861086,35.48873976907445],[112.64275642492748,35.49344191208543],[112.65310490440243,35.4990841172019],[112.66805270808847,35.49814377744841],[112.68989949809112,35.487799307155825],[112.70599713282994,35.487799307155825],[112.7151957812521,35.487799307155825],[112.71864527441042,35.487799307155825],[112.73244324704369,35.49062065959564],[112.74509138862418,35.49062065959564],[112.75773953020466,35.487799307155825],[112.77613682704902,35.48873976907445],[112.79223446178781,35.485918350003104]]');
INSERT INTO `t_course` VALUES ('122', 'S8611', '#19a61c', '5', '1', '0', '[[112.45763362543123,35.49344191208543],[112.47143159806448,35.492501505694605],[112.48292990859221,35.49344191208543],[112.49787771227824,35.49438230737036],[112.52202416438645,35.50566618448356],[112.53697196807248,35.50472592247912],[112.54732044754743,35.50566618448356],[112.5565190959696,35.50942712142518]]');
INSERT INTO `t_course` VALUES ('123', 'S65在建', '#1045b2', '5', '1', '0', '[[112.37369595857889,35.561121978357875],[112.3690966343678,35.54984596735472],[112.36449731015672,35.5423277376208],[112.3610478169984,35.53480879670654],[112.35874815489285,35.529169124345806],[112.35414883068177,35.52540912056023],[112.34954950647068,35.51976878158351],[112.34839967541791,35.51506819359598],[112.34839967541791,35.50942712142518],[112.35414883068177,35.50284536514825],[112.3610478169984,35.49344191208543],[112.3656471412095,35.483096830987186],[112.3690966343678,35.46992842085301],[112.37254612752612,35.45487614459646],[112.38059494489552,35.44358507241738],[112.38289460700106,35.4285278232625],[112.38749393121215,35.40499518415576],[112.393243086476,35.38616408025865],[112.39899224173988,35.37297966756647],[112.40359156595096,35.36261896122887],[112.40014207279265,35.34943066715922],[112.39439291752878,35.337182448274405],[112.3851942691066,35.32587473721898],[112.38289460700106,35.31173785387967],[112.38059494489552,35.29477030246002],[112.37829528278998,35.28345660705213],[112.37369595857889,35.27308431814589],[112.37139629647335,35.26648307278343],[112.37254612752612,35.25610859066933],[112.37369595857889,35.245732768479606],[112.38289460700106,35.23158176071242]]');
INSERT INTO `t_course` VALUES ('124', 'S5503', '#19a61c', '5', '1', '0', '[[112.97505759917853,35.649395342005626],[112.96355928865081,35.65033389204136],[112.95666030233419,35.65127243095119],[112.94631182285924,35.64751820855681],[112.9394128365426,35.64564103060568],[112.93481351233152,35.64470242494205],[112.92561486390935,35.64376380815319],[112.91641621548717,35.64376380815319],[112.90606773601222,35.640947891036475],[112.89916874969559,35.63719317913498],[112.88882027022065,35.631560777556984],[112.88537077706233,35.62874442659837],[112.87617212864016,35.62874442659837],[112.86467381811244,35.63062200502752],[112.85317550758472,35.62780562069892],[112.84972601442641,35.621233667963295],[112.84282702810978,35.618416949954785],[112.83017888652928,35.6137221975044],[112.81983040705434,35.6024536572799],[112.81638091389603,35.59400120127328],[112.81178158968494,35.583669198651855],[112.81178158968494,35.575214741382],[112.81063175863217,35.56675938368427],[112.80603243442108,35.55642383493341],[112.80833209652663,35.54702671454985],[112.80833209652663,35.53950821811609],[112.80143311021,35.53010909751623],[112.80028327915723,35.52070886585358],[112.79913344810444,35.51506819359598],[112.79338429284059,35.50472592247912],[112.79338429284059,35.486858834132]]');
INSERT INTO `t_course` VALUES ('125', 'S5512', '#19a61c', '5', '1', '0', '[[112.90491790495945,35.492501505694605],[112.91641621548717,35.486858834132],[112.93251385022597,35.48497785476926],[112.9394128365426,35.48403734843058],[112.95091114707033,35.486858834132],[112.96700878180913,35.48403734843058],[112.97735726128407,35.48121576278675],[112.98655590970625,35.48027521202998],[112.99460472707565,35.47839407720383],[113.00380337549782,35.47839407720383],[113.00955253076168,35.47745349313472],[113.01415185497277,35.47086909374963],[113.01760134813108,35.467106335546326],[113.02335050339495,35.46334339970257],[113.0451972933976,35.43229240191171],[113.05669560392533,35.417233021982135],[113.05554577287255,35.413467733137104],[113.06359459024196,35.40781946700435],[113.06819391445305,35.40217080145677],[113.0819918870863,35.39746327507762],[113.0946400286668,35.38993065601476],[113.11418715656391,35.3767468644426],[113.12108614288054,35.36827042193988],[113.13258445340827,35.36544474148642],[113.13718377761936,35.36073505227875],[113.13603394656658,35.34189352341948]]');
INSERT INTO `t_course` VALUES ('126', 'S5503', '#19a61c', '5', '1', '0', '[[112.79223446178781,35.485918350003104],[112.80258294126277,35.48121576278675],[112.80833209652663,35.48121576278675],[112.8175307449488,35.47839407720383],[112.82672939337097,35.473691045820885],[112.83592804179314,35.46992842085301],[112.84512669021532,35.46804704175125],[112.85547516969027,35.466165618238875],[112.86122432495412,35.466165618238875],[112.87502229758739,35.465224889829024],[112.88882027022065,35.466165618238875],[112.89801891864282,35.47086909374963],[112.90721756706499,35.47745349313472],[112.91181689127609,35.483096830987186],[112.91756604653995,35.486858834132],[112.92216537075103,35.492501505694605],[112.92791452601489,35.4990841172019],[112.93596334338429,35.50566618448356],[112.9394128365426,35.516008333411364],[112.94171249864814,35.524469091838476],[112.94401216075369,35.53480879670654],[112.94401216075369,35.543267555231466],[112.94631182285924,35.55548417290605],[112.94861148496479,35.567698912335764],[112.94976131601756,35.57709358748202],[112.95551047128141,35.58460852720718],[112.95666030233419,35.59494040752853],[112.95666030233419,35.60808812756257],[112.95895996443973,35.620294773082556],[112.96470911970358,35.632499538962904],[112.97045827496744,35.642825180239235],[112.97505759917853,35.649395342005626]]');
INSERT INTO `t_course` VALUES ('127', 'G55泽州', '#19a61c', '5', '1', '0', '[[112.8623741560069,35.46898773685353],[112.86352398705966,35.456757834552036],[112.86582364916521,35.44546702878113],[112.86697348021798,35.44076205462585],[112.86697348021798,35.43511571936973],[112.86697348021798,35.4285278232625],[112.86582364916521,35.42476306705264],[112.85892466284858,35.42005687210751],[112.85547516969027,35.413467733137104],[112.85087584547918,35.40781946700435],[112.84397685916255,35.40405373435042],[112.83707787284592,35.399346318910666],[112.8336283796876,35.393697054290364],[112.82902905547651,35.38616408025865],[112.82672939337097,35.37957214564657],[112.8255795623182,35.37392148342129],[112.8255795623182,35.35979308117054],[112.82442973126543,35.351314842224085],[112.82098023810711,35.34754644774534],[112.82213006915988,35.3400091266194],[112.82213006915988,35.33529794061594],[112.81868057600157,35.3287018146275],[112.82098023810711,35.318335376435044],[112.82442973126543,35.31550793326509],[112.82327990021265,35.30891017797581],[112.81983040705434,35.3013692213021],[112.8175307449488,35.28062793392313],[112.80373277231554,35.269312244399494],[112.79568395494613,35.26271068889338],[112.78993479968227,35.2598812846787],[112.78418564441841,35.25327895387432],[112.7807361512601,35.24761938127259],[112.77843648915456,35.24290276623816],[112.77843648915456,35.22403353794063]]');
INSERT INTO `t_course` VALUES ('128', 'G55武乡', '#19a61c', '5', '1', '0', '[[112.97390776812576,35.649395342005626],[112.97850709233684,35.65502647532871],[112.98080675444238,35.66722589003513],[112.98080675444238,35.67754700281516],[112.97850709233684,35.68786676894133],[112.97735726128407,35.69724720579421],[112.97735726128407,35.70381284925301],[112.97735726128407,35.716004739826204],[112.98080675444238,35.73100756044443],[112.98310641654794,35.74038287566927],[112.97965692338961,35.751631783809366],[112.9762074302313,35.75819290618212],[112.9681586128619,35.7666278328977],[112.96585895075636,35.77599891533678],[112.96585895075636,35.78255801011873],[112.96700878180913,35.78911655891631],[112.96355928865081,35.79942174667631],[112.96700878180913,35.81159886636235],[112.96700878180913,35.82283761261696],[112.97045827496744,35.82751994979708],[112.97850709233684,35.83313838652366],[112.98080675444238,35.84250155581611],[112.98770574075903,35.853735887158585],[112.99115523391734,35.870584373237946],[113.00150371339228,35.882750476912044],[113.00840269970891,35.898657152547166],[113.01875117918385,35.91268977693585],[113.01990101023664,35.922043465054905],[113.03139932076435,35.93794217362304],[113.03024948971158,35.955707501150755],[113.04864678655592,35.973468798503845],[113.04864678655592,35.9828152307091],[113.04634712445038,35.992160546191464],[113.05094644866146,36.00150474483706],[113.053246110767,36.00897929955463],[113.05209627971423,36.01832148760753],[113.04634712445038,36.02579443370375],[113.04059796918652,36.03606856705258],[113.03829830708098,36.0444736705298],[113.03829830708098,36.052877868854694],[113.03829830708098,36.06781643067667],[113.0451972933976,36.07715157876424],[113.04864678655592,36.08461889237554],[113.04864678655592,36.09955137306333],[113.04864678655592,36.10701654002473],[113.04864678655592,36.11634699231591],[113.04979661760869,36.12474344320167],[113.05094644866146,36.13313898815156],[113.05554577287255,36.14246630881264],[113.05209627971423,36.1555226783782],[113.04404746234484,36.162982476455724],[113.03944813813375,36.16857685508021],[113.03599864497544,36.17417083087772],[113.03254915181712,36.182561039220786],[113.02679999655327,36.21238554905206],[113.02220067234218,36.22077162714815],[113.00725286865614,36.231951653918614],[112.99920405128674,36.243130068295834],[112.99575455812843,36.25058144867918],[112.99575455812843,36.258032112302175],[113.00150371339228,36.27572456543652],[113.0049532065506,36.281310815759554],[113.00610303760337,36.297136334741744],[113.00610303760337,36.297136334741744],[113.00265354444505,36.31295861551678],[113.00380337549782,36.3241253343602],[112.9969043891812,36.33808146326475],[112.98770574075903,36.35110490801962],[112.98425624760071,36.36319613916222],[112.97390776812576,36.379934715453544],[112.97275793707298,36.408753745698455],[112.96125962654527,36.4338454078872],[112.95781013338696,36.44313654036728],[112.95321080917587,36.45149760013088],[112.94746165391201,36.4598577508432],[112.94286232970092,36.47471799618451],[112.94056266759537,36.48400419023146],[112.9394128365426,36.49607456409973],[112.9394128365426,36.5072147634776],[112.9394128365426,36.519281488042125],[112.94286232970092,36.53041831843271],[112.93826300548983,36.54340924299879],[112.9313640191732,36.551759389008964],[112.93251385022597,36.56660184610549],[112.93596334338429,36.57402199601979],[112.94056266759537,36.58051403725953],[112.94286232970092,36.58700552785517],[112.94401216075369,36.596278130578305],[112.94056266759537,36.622235438493384],[112.93826300548983,36.62594290588071],[112.93826300548983,36.634284049789116],[112.94056266759537,36.637990932527146],[112.94171249864814,36.64447754441507],[112.94746165391201,36.6518901404494],[112.94861148496479,36.66393407394163],[112.95321080917587,36.680607151565596],[112.95321080917587,36.680607151565596],[112.94976131601756,36.68616403421297],[112.94401216075369,36.69079446039033],[112.94056266759537,36.698202557264224],[112.94056266759537,36.70375815738405],[112.94171249864814,36.70838751473421],[112.94056266759537,36.714868142435144],[112.93596334338429,36.721348218749775],[112.93251385022597,36.726902130991206],[112.92791452601489,36.731530081704875],[112.92101553969826,36.73615775105249],[112.91756604653995,36.743561436735035],[112.91066706022332,36.74726300943599],[112.90146841180113,36.75374032828742],[112.90146841180113,36.76206749915045],[112.89916874969559,36.770393758111965],[112.89916874969559,36.77501906347592],[112.89686908759005,36.77964408735284],[112.89686908759005,36.788893290594224],[112.89801891864282,36.79629184239878],[112.89801891864282,36.80184028325783],[112.89801891864282,36.80738831866855],[112.89571925653728,36.81201137177743],[112.89341959443173,36.815709611520745],[112.89111993232619,36.82495442238574],[112.89111993232619,36.835122413225115],[112.88997010127342,36.8406680154828]]');
INSERT INTO `t_course` VALUES ('129', 'G55榆社', '#19a61c', '5', '1', '0', '[[112.88968264351023,36.84113013069612],[112.89198230561577,36.84713737214534],[112.89255722114216,36.849447722868526],[112.89313213666854,36.855916330237285],[112.8948568832477,36.859612429402254],[112.89658162982685,36.8651562400831],[112.89600671430047,36.87023771014543],[112.90118095403794,36.876242644324684],[112.90348061614348,36.87947587318671],[112.90578027824903,36.88270896397901],[112.90807994035457,36.88825108410131],[112.90980468693374,36.89517816360873],[112.90750502482818,36.900257618916996],[112.91095451798651,36.90487500963792],[112.91267926456567,36.91041550646736],[112.91497892667121,36.91872549068406],[112.91842841982952,36.926572970512815],[112.923602659567,36.93395808965687],[112.92590232167254,36.93718885233693],[112.9276270682517,36.947803242738686],[112.93510097009471,36.95610911653693],[112.94027520983218,36.96441407670782],[112.9483240272016,36.97410204208643],[112.9483240272016,36.97410204208643],[112.9483240272016,36.98425000513411],[112.94774911167521,36.989323474727485],[112.94487453404327,36.9953189533017],[112.9437247029905,36.99993053549539],[112.94487453404327,37.01099718175944],[112.94257487193772,37.02021814560571],[112.94544944956965,37.027133127834055],[112.94544944956965,37.032203711292944],[112.94602436509604,37.03496934017333],[112.94889894272798,37.03911759301044],[112.95062368930714,37.04188296790896],[112.9523484358863,37.04695255801659],[112.95464809799184,37.05340426970583],[112.95752267562376,37.05847308366092],[112.96039725325569,37.06354155608203],[112.96269691536124,37.06860968695273],[112.963846746414,37.07413816743744],[112.96557149299316,37.078284261027335],[112.96844607062509,37.08196948557952],[112.96959590167786,37.08611514722386],[112.9678711550987,37.0902605801782],[112.963846746414,37.092563499666205],[112.96269691536124,37.09348464769697],[112.96039725325569,37.09809021843699],[112.95694776009738,37.10177447172663],[112.95062368930714,37.1063795342004],[112.95062368930714,37.1063795342004],[112.94717419614882,37.10914243613956],[112.94544944956965,37.11328659843109],[112.94544944956965,37.11835137502917],[112.94774911167521,37.12571771277857],[112.94947385825436,37.1280195450473],[112.94659928062244,37.1349246181803],[112.94487453404327,37.139987934557986],[112.94429961851688,37.14597141324889],[112.94544944956965,37.152874833887466],[112.9483240272016,37.15793693836798],[112.9483240272016,37.16483925718931],[112.9523484358863,37.17128084786282],[112.95004877378075,37.17956207923945],[112.94947385825436,37.18738240152912],[112.94947385825436,37.19152224151302],[112.94774911167521,37.200721066332726],[112.95004877378075,37.20623981856843],[112.9523484358863,37.21313768649212],[112.9557979290446,37.21865552290892],[112.96039725325569,37.22371318202998],[112.95177352035991,37.24118246334823],[112.95177352035991,37.24118246334823],[112.94314978746411,37.245778964087165],[112.93797554772664,37.25083478831798],[112.93395113904194,37.25359236641512],[112.92992673035724,37.26002631941902],[112.92590232167254,37.26324308807106],[112.91785350430314,37.26737872986415],[112.91325418009205,37.273352030254486],[112.91037960246013,37.276568224795525],[112.90463044719625,37.279324852668125],[112.90463044719625,37.28391900618092],[112.9029057006171,37.28805350250266],[112.9029057006171,37.290809706095274],[112.9029057006171,37.29494382054489],[112.90405553166987,37.299077705859645],[112.90520536272264,37.30183350210138],[112.90635519377541,37.304589196498966],[112.90348061614348,37.31101875401836],[112.90233078509071,37.31469253791538],[112.90233078509071,37.31652936196018],[112.90003112298517,37.31928451314561],[112.89773146087963,37.32525365793951],[112.89600671430047,37.33214053848196],[112.89428196772131,37.33581328109998],[112.890832474563,37.33948584260553],[112.88508331929914,37.34361725780572],[112.87818433298251,37.34958445283508],[112.86323652929647,37.36014062615245],[112.8620866982437,37.364270895082576],[112.86093686719093,37.36840093473286],[112.86036195166454,37.373448449591905],[112.858062289559,37.3775779797007],[112.858062289559,37.37987206401155],[112.85461279640069,37.383542451695476],[112.85231313429514,37.387212658188375],[112.84828872561044,37.38950644523269],[112.84541414797852,37.39317635727735],[112.84368940139936,37.3959286723942],[112.84426431692575,37.40189167212944],[112.84541414797852,37.4041850061464],[112.84828872561044,37.407854193327765],[112.84828872561044,37.41014734328521],[112.84828872561044,37.41289902978494],[112.84713889455767,37.415192023991985],[112.84656397903129,37.41748494740107],[112.84253957034659,37.42115347759214],[112.84081482376743,37.426197410652215],[112.83966499271466,37.4330749489067],[112.84023990824105,37.4413271535933],[112.84023990824105,37.44453609645733],[112.83909007718827,37.4486616761871],[112.83506566850356,37.453245384551],[112.82701685113416,37.45737047986697],[112.82184261139669,37.45920378190566],[112.81839311823838,37.46332854575879],[112.81264396297452,37.465619982073285],[112.80746972323705,37.468369612154895],[112.80229548349958,37.47432679408607],[112.79827107481486,37.47890891588325],[112.79539649718294,37.4807416852637],[112.79309683507739,37.485781567287034],[112.79194700402462,37.49036298067801],[112.79137208849824,37.49356980143965],[112.79079717297185,37.49540220810057],[112.7884975108663,37.4986088106495],[112.78562293323438,37.50135721659275],[112.78159852454968,37.50456356124129],[112.77872394691775,37.5109758339091],[112.77584936928582,37.51601365842693],[112.7729747916539,37.521051139973395],[112.77010021402197,37.52471454748749],[112.76205139665255,37.52975143659278],[112.74997817059845,37.53341441322393],[112.74480393086098,37.53661936894356],[112.73790494454435,37.539824185748564],[112.73100595822773,37.54623340259902],[112.72065747875277,37.55401527597339],[112.71260866138337,37.559507869700056],[112.70398492848759,37.56316937200714],[112.6953611955918,37.56591537964021],[112.68788729374877,37.56866128518713],[112.67638898322106,37.57232233377816],[112.66948999690443,37.57644079649751],[112.65799168637672,37.58193172278732],[112.64706829137538,37.58833728728258],[112.64131913611152,37.591539861065215],[112.63729472742682,37.59794459168095],[112.63556998084766,37.60251905888253],[112.63269540321573,37.60800804508721],[112.63097065663658,37.61395398583249],[112.62867099453103,37.619899447137946],[112.62349675479356,37.62538713970618],[112.61717268400331,37.63178893132963],[112.61142352873945,37.63681852032632],[112.6056743734756,37.640933383223036],[112.6016499647909,37.64550518353681],[112.59705064057981,37.65144809970634],[112.59187640084234,37.65739053627916],[112.58612724557848,37.66287543664736],[112.5815279213674,37.668359928324534],[112.57347910399798,37.672473028867174],[112.54818282083701,37.68846623424739],[112.53438484820374,37.6925782107181],[112.55163231399533,37.715418336895375],[112.55968113136473,37.7282057069945],[112.56428045557581,37.74099085074104],[112.55968113136473,37.759251479282504]]');
INSERT INTO `t_course` VALUES ('130', 'G2202', '#19a61c', '5', '1', '0', '[[112.81494362508006,37.78389611851344],[112.81954294929115,37.75651267471411],[112.82299244244946,37.73916453795098],[112.82414227350223,37.727292397246224],[112.825292104555,37.71907209837398],[112.83104125981886,37.712677896530366],[112.83449075297717,37.70445596214413],[112.82874159771332,37.696233107871855],[112.82644193560778,37.68892313187711],[112.82414227350223,37.67704287093585],[112.82299244244946,37.66698884372109],[112.8172432871856,37.65876179968493],[112.81149413192175,37.64870527491376],[112.79769615928848,37.63498961859704],[112.79079717297185,37.62401525486563],[112.78274835560245,37.61120976506238],[112.77469953823305,37.60206162492706],[112.76780055191642,37.59199736026022],[112.76320122770532,37.57918631069143],[112.75285274823038,37.56820364135206],[112.74250426875544,37.56088095433227],[112.7321557892805,37.54714895964325],[112.72295714085831,37.5416554472658],[112.70685950611951,37.538908537979474],[112.68731237822239,37.536161526631346],[112.66776525032527,37.53066719775971],[112.64936795348092,37.52700408505667],[112.63556998084766,37.51784550958182],[112.62062217716164,37.50868580029891],[112.60912386663391,37.50502159914015],[112.59302623189511,37.50502159914015],[112.57117944189244,37.50318943053966],[112.55393197610087,37.49952495730018],[112.53553467925651,37.49219546668789],[112.50908856504277,37.482116232546446],[112.48494211293456,37.47386856632234],[112.46884447819575,37.465619982073285],[112.44239836398201,37.46378683868803],[112.42515089819042,37.465619982073285],[112.4102030945044,37.46378683868803],[112.39410545976558,37.4555371325004],[112.37455833186847,37.43720116596544],[112.36191019028797,37.430782506962636],[112.33891356923255,37.42711445257227],[112.32051627238819,37.42161203112184],[112.29636982027999,37.41610920185147]]');
INSERT INTO `t_course` VALUES ('131', 'G5盂县', '#19a61c', '5', '1', '0', '[[112.60826149334433,38.025338732730624],[112.6174601417665,38.026248323422756],[112.62780862124146,38.025338732730624],[112.6381571007164,38.018971279044564],[112.64505608703303,38.01442275623577],[112.65655439756075,38.01260326740732],[112.66805270808847,38.01169350591381],[112.67840118756341,38.01260326740732],[112.69104932914391,38.01806159725598],[112.69449882230222,38.02170025608941],[112.70254763967162,38.02351951718439],[112.71289611914656,38.02351951718439],[112.72209476756873,38.025338732730624],[112.73129341599092,38.03170562843633],[112.74279172651863,38.03352463900484],[112.75888936125743,38.03716252348372],[112.76808800967962,38.04352838286283],[112.78303581336564,38.04807508360657],[112.79108463073504,38.05171223919147],[112.80028327915723,38.05443998628738],[112.81178158968494,38.057167630872634],[112.8255795623182,38.061713477373786],[112.83707787284592,38.06353173623961],[112.8543253386375,38.066259039106264],[112.86927314232352,38.066259039106264],[112.88307111495679,38.062622612502125],[112.89226976337896,38.05898600364466],[112.89916874969559,38.05625842740108],[112.90836739811776,38.052621499613366],[112.9152663844344,38.048984389587226],[112.92101553969826,38.04807508360657],[112.92791452601489,38.04716576623643],[112.94056266759537,38.04807508360657],[112.95666030233419,38.05171223919147],[112.97390776812576,38.05443998628738],[112.99000540286457,38.05625842740108],[113.00725286865614,38.05807682295385],[113.01645151707831,38.062622612502125],[113.03024948971158,38.069895283451665],[113.04059796918652,38.08080292288149],[113.0451972933976,38.0889825758686],[113.04864678655592,38.09897867625262],[113.06359459024196,38.109881940631105],[113.06934374550582,38.11351599745094],[113.08084205603353,38.11351599745094],[113.09119053550847,38.11351599745094],[113.10498850814174,38.11169899183178],[113.11648681866946,38.11169899183178],[113.13258445340827,38.110790471929086],[113.14063327077767,38.110790471929086],[113.15328141235815,38.11624142041287],[113.16707938499142,38.12078356409897],[113.1762780334136,38.12078356409897],[113.18892617499408,38.12260034180046],[113.19812482341625,38.12260034180046],[113.2084733028912,38.11896674081258],[113.21997161341892,38.112607500339095],[113.22687059973555,38.109881940631105],[113.23606924815772,38.108973397937895],[113.24296823447436,38.108064843849554],[113.25216688289653,38.108064843849554],[113.25906586921316,38.108973397937895],[113.26596485552979,38.110790471929086],[113.2694143486881,38.11169899183178],[113.27516350395197,38.11169899183178],[113.28436215237414,38.108973397937895],[113.28896147658523,38.108064843849554],[113.2981601250074,38.10715627836618],[113.30275944921848,38.10715627836618],[113.30735877342957,38.108973397937895],[113.31540759079898,38.108973397937895],[113.32575607027393,38.10715627836618],[113.33265505659055,38.10443051354662],[113.33840421185441,38.10079600092834],[113.34185370501272,38.09625260378272],[113.34875269132937,38.09352642876726],[113.36025100185708,38.09352642876726],[113.36944965027925,38.09170892178831],[113.37864829870142,38.086256127409385],[113.38094796080696,38.08080292288149],[113.38899677817638,38.07353134553294],[113.39244627133469,38.07171333727566],[113.4039445818624,38.068986239452364],[113.41084356817903,38.068986239452364],[113.4200422166012,38.068986239452364],[113.42924086502339,38.06807718406164],[113.43843951344556,38.06716811727958],[113.4487879929205,38.066259039106264],[113.45453714818436,38.066259039106264],[113.46028630344823,38.06444084858619],[113.46603545871208,38.05989517294497],[113.47408427608148,38.057167630872634],[113.48443275555643,38.055349212539305],[113.49478123503138,38.055349212539305],[113.50397988345355,38.057167630872634],[113.51317853187572,38.05898600364466],[113.51892768713958,38.05898600364466],[113.52697650450898,38.05171223919147],[113.53962464608948,38.04352838286283],[113.54307413924779,38.03443412720694],[113.54997312556442,38.027157902727446],[113.56032160503936,38.02170025608941],[113.56952025346155,38.018971279044564],[113.58216839504203,38.01624219951887],[113.58791755030589,38.01715190408072],[113.5994158608336,38.02170025608941],[113.60631484715024,38.026248323422756],[113.6120640024141,38.0326151394146],[113.62126265083627,38.04080022574727],[113.63161113031121,38.04625643747691],[113.64310944083894,38.04716576623643],[113.6569074134722,38.04716576623643],[113.67070538610545,38.04807508360657],[113.68220369663318,38.05080296737975],[113.69140234505535,38.05080296737975],[113.69830133137198,38.052621499613366],[113.70864981084692,38.05898600364466],[113.7419949113773,38.062622612502125],[113.75119355979949,38.065349949541776],[113.7626918703272,38.066259039106264],[113.77648984296046,38.069895283451665],[113.79028781559373,38.072622347100186],[113.80178612612144,38.072622347100186],[113.81098477454361,38.069895283451665],[113.82133325401855,38.06807718406164],[113.83053190244074,38.06807718406164],[113.84088038191568,38.06807718406164],[113.85122886139062,38.072622347100186],[113.86387700297112,38.07534930822285]]');
INSERT INTO `t_course` VALUES ('132', 'S50', '#19a61c', '5', '1', '0', '[[110.54316492256622,38.03443412720694],[110.55351340204116,38.03079610607011],[110.56041238835779,38.0326151394146],[110.5638618815161,38.03534360402086],[110.56961103677996,38.03625306944648],[110.57880968520215,38.039890817264364],[110.58800833362432,38.04080022574727],[110.59375748888817,38.04080022574727],[110.60525579941589,38.03716252348372],[110.61215478573253,38.039890817264364],[110.62020360310193,38.045347097328076],[110.63285174468241,38.048984389587226],[110.64435005521013,38.04807508360657],[110.65124904152677,38.04443774579002],[110.66044768994894,38.04625643747691],[110.67194600047665,38.05080296737975],[110.67999481784605,38.048984389587226],[110.69034329732101,38.04807508360657],[110.70529110100703,38.04807508360657],[110.71333991837643,38.05171223919147],[110.72828772206248,38.05625842740108],[110.7351867083791,38.05807682295385],[110.74093586364296,38.05807682295385],[110.75473383627622,38.05807682295385],[110.76853180890949,38.05625842740108],[110.77083147101503,38.055349212539305],[110.77888028838443,38.05807682295385],[110.78577927470106,38.061713477373786],[110.7926782610177,38.061713477373786],[110.8007270783871,38.05807682295385],[110.8087758957565,38.057167630872634],[110.81912437523144,38.055349212539305],[110.83292234786471,38.05171223919147],[110.83867150312857,38.04807508360657],[110.84787015155074,38.04352838286283],[110.85476913786736,38.03898139739275],[110.86166812418399,38.03534360402086],[110.86856711050063,38.03170562843633],[110.87431626576449,38.02897702717417],[110.88351491418666,38.026248323422756],[110.89041390050329,38.026248323422756],[110.89846271787269,38.028067470644615],[110.90306204208379,38.02897702717417],[110.91111085945319,38.026248323422756],[110.91686001471705,38.02260989233044],[110.92835832524476,38.02170025608941],[110.94445595998357,38.020790608461354],[110.95250477735297,38.018971279044564],[110.9594037636696,38.020790608461354],[110.97320173630285,38.020790608461354],[110.97780106051395,38.01624219951887],[110.9881495399889,38.01624219951887],[110.9961983573583,38.019880949446375],[111.0042471747277,38.02351951718439],[111.00999632999155,38.025338732730624],[111.02034480946651,38.02442913065113],[111.03299295104699,38.02442913065113],[111.05024041683858,38.02442913065113],[111.06978754473569,38.025338732730624],[111.07783636210509,38.02260989233044],[111.08703501052727,38.02442913065113],[111.09738349000222,38.020790608461354],[111.10773196947716,38.019880949446375],[111.12497943526874,38.018971279044564],[111.13187842158537,38.020790608461354],[111.20661744001553,38.01351301751466],[111.22271507475433,38.008964153117184],[111.23076389212375,38.008054346079874],[111.23881270949315,38.00441500407418],[111.2894052758151,37.99713577356932],[111.30320324844836,37.98712564193184],[111.31585139002885,37.984395366966744],[111.32390020739825,37.983485252544575],[111.33194902476765,37.98712564193184],[111.33999784213707,37.98985581444299],[111.3468968284537,37.9953158520943],[111.35264598371755,37.99986557039632],[111.36299446319249,38.00350514010905],[111.37104328056189,38.008964153117184],[111.37679243582576,38.01351301751466],[111.38254159108962,38.020790608461354],[111.38944057740625,38.027157902727446],[111.39289007056456,38.027157902727446],[111.40093888793396,38.02897702717417],[111.40668804319782,38.03352463900484],[111.40783787425059,38.039890817264364],[111.41473686056723,38.04170962284137],[111.41473686056723,38.053530748645365],[111.42048601583109,38.062622612502125],[111.42508534004217,38.066259039106264],[111.4319843263588,38.06807718406164],[111.43428398846434,38.086256127409385],[111.45153145425593,38.0889825758686],[111.46187993373087,38.09443516516624],[111.46992875110027,38.09352642876726],[111.48142706162798,38.09352642876726],[111.49292537215571,38.097161306000096],[111.49982435847234,38.097161306000096],[111.50672334478897,38.09443516516624],[111.51477216215837,38.0926176809746],[111.52512064163332,38.09625260378272],[111.57686303900805,38.114424483167234],[111.58146236321913,38.11624142041287],[111.58836134953576,38.114424483167234],[111.59870982901072,38.114424483167234],[111.60560881532734,38.117149871942026],[111.61020813953843,38.12078356409897],[111.61595729480229,38.123508713556674],[111.62400611217168,38.125325422879605],[111.62860543638277,38.12895870476515],[111.63435459164664,38.12895870476515],[111.64240340901604,38.13077527732641],[111.65735121270207,38.138041111679236],[111.66654986112424,38.14167375531095],[111.67459867849365,38.1453062165724],[111.68034783375751,38.154386571821036],[111.68954648217968,38.1571104561129],[111.69759529954908,38.16074214224117],[111.70219462376016,38.1616500352737],[111.7090936100768,38.16891276912798],[111.71944208955175,38.174359340694124],[111.7251912448156,38.177082472562965],[111.73209023113223,38.17889783680205],[111.74818786587105,38.174359340694124],[111.7619858385043,38.177082472562965],[111.77578381113756,38.18162079764883],[111.79303127692914,38.18434365587938],[111.80797908061517,38.18797397389103],[111.81602789798458,38.192511614851355],[111.82407671535398,38.197956407710585],[111.83327536377615,38.1997712474382],[111.84477367430387,38.20067865019686],[111.85282249167328,38.202493421503476],[111.85857164693714,38.20612282727159],[111.87006995746485,38.209752050575105],[111.8758191127287,38.20884476185558],[111.88156826799256,38.2106593278903],[111.88271809904533,38.216102752285025],[111.8838679300981,38.22426711903784],[111.88501776115088,38.23061654335253],[111.88271809904533,38.236965408760426],[111.88156826799256,38.24512741441729],[111.88616759220365,38.24966146274313],[111.89306657852029,38.25238175484346],[111.90686455115355,38.25510194426972],[111.91606319957572,38.25238175484346],[111.92411201694513,38.251475002218136],[111.93905982063116,38.25419522586934],[111.94825846905333,38.251475002218136],[111.96320627273937,38.25056823818468],[111.97355475221431,38.25056823818468],[111.98505306274203,38.25056823818468],[111.9942517111642,38.24512741441729],[112.00345035958638,38.238779267645256],[112.01839816327241,38.238779267645256],[112.02759681169458,38.23333755410941],[112.06784089854159,38.207030150203735],[112.08738802643872,38.20340079005127],[112.09773650591366,38.2052154929354],[112.10693515433584,38.20430814719527],[112.12188295802187,38.198863833276086],[112.13453109960236,38.197956407710585],[112.14717924118285,38.19160410946455],[112.15637788960503,38.18071315543494],[112.1655765380272,38.17526706271833],[112.17707484855491,38.17072833858681],[112.18512366592432,38.16709715406659],[112.19202265224095,38.16255791690627],[112.19777180750481,38.16074214224117],[112.20697045592698,38.153478587591685],[112.2138694422436,38.1516625849354],[112.2184687664547,38.14984653668287],[112.22881724592965,38.148938495458225],[112.2633121775128,38.117149871942026],[112.2713609948822,38.11624142041287],[112.28055964330437,38.12078356409897],[112.29665727804318,38.125325422879605],[112.31045525067644,38.128050401389],[112.31850406804584,38.128050401389],[112.32195356120415,38.132591804299125],[112.33115220962634,38.138949289684085],[112.3449501822596,38.1434900087383],[112.34839967541791,38.15529454465107],[112.35529866173454,38.1616500352737],[112.36219764805118,38.16891276912798],[112.37139629647335,38.17163610621507],[112.38289460700106,38.16891276912798],[112.39094342437046,38.16346578713878],[112.40014207279265,38.16618932943514],[112.41279021437313,38.1616500352737],[112.4219888627953,38.14984653668287],[112.4300376801647,38.138949289684085],[112.4426858217452,38.133500050689584],[112.46223294964231,38.12441707391641],[112.48063024648667,38.11896674081258],[112.49327838806715,38.11351599745094],[112.49902754333101,38.109881940631105],[112.50247703648932,38.09988734428762],[112.49787771227824,38.09443516516624],[112.49672788122547,38.088073771108704],[112.50017737438378,38.0817118187846],[112.50937602280597,38.077167225344695],[112.51972450228091,38.074440332573865],[112.52317399543922,38.069895283451665],[112.52662348859754,38.06353173623961],[112.53812179912525,38.05807682295385],[112.54962010965298,38.05443998628738],[112.55881875807515,38.04807508360657],[112.55996858912792,38.03625306944648]]');
INSERT INTO `t_course` VALUES ('133', 'S40', '#19a61c', '5', '1', '0', '[[112.11958329591633,39.112215486097405],[112.13108160644404,39.11042380715287],[112.14143008591898,39.112215486097405],[112.15522805855225,39.11400711911905],[112.16327687592165,39.11400711911905],[112.17132569329105,39.1149029184086],[112.18167417276601,39.12027747304384],[112.19202265224095,39.11848600075676],[112.20697045592698,39.11400711911905],[112.2184687664547,39.11311130834863],[112.23226673908796,39.11131965236545],[112.2426152185629,39.106840311497294],[112.24491488066845,39.096984751332826],[112.25411352909063,39.08892007803614],[112.26216234646003,39.08443930221766],[112.27251082593497,39.07637318260188],[112.28170947435714,39.067409737073824],[112.287458629621,39.06113464230624],[112.29895694014873,39.05754862137844],[112.31275491278198,39.0584451438252],[112.32310339225693,39.0584451438252],[112.33345187173188,39.05754862137844],[112.34150068910128,39.051272642915094],[112.34839967541791,39.04409940754542],[112.35184916857622,39.03692543775252],[112.35529866173454,39.029750733572804],[112.3610478169984,39.022575295042714],[112.37369595857889,39.015399122198744],[112.38404443805383,39.00911936862214],[112.38979359331769,39.005530685608534],[112.39784241068709,39.002839052888966],[112.41164038332036,39.002839052888966],[112.42888784911193,39.002839052888966],[112.458783456484,39.01181076042047],[112.46453261174786,39.01181076042047],[112.47718075332835,39.00911936862214],[112.48178007753944,39.004633486174214],[112.49097872596161,39.00373627526766],[112.50247703648932,39.002839052888966],[112.51397534701705,39.00104457371538],[112.52202416438645,38.99386619814925],[112.52892315070308,38.9902767350511],[112.53812179912525,38.984892196272966],[112.54042146123079,38.97860971245174],[112.54042146123079,38.972326666593446],[112.54157129228356,38.966043058722754],[112.5438709543891,38.96155442331102],[112.54732044754743,38.95796330854322],[112.5565190959696,38.95706550117987],[112.56801740649732,38.95706550117987],[112.64505608703303,38.95886110443808],[112.65770422861353,38.96334991188254],[112.69449882230222,38.975917047331905],[112.70369747072439,38.97860971245174],[112.7071469638827,38.97860971245174],[112.71059645704102,38.980404765181035],[112.71059645704102,38.98309725824763],[112.71289611914656,38.987584517280915],[112.7151957812521,38.99117411803243],[112.7232445986215,38.99386619814925],[112.73474290914923,38.99835276891565],[112.74279172651863,39.00373627526766],[112.76233885441575,39.010913641293726],[112.7726873338907,39.012707868074415],[112.7807361512601,39.01988431627667],[112.78418564441841,39.02347226501752],[112.80258294126277,39.029750733572804],[112.82442973126543,39.037822224139155],[112.8382277038987,39.04409940754542],[112.84397685916255,39.05037602865889],[112.85777483179581,39.06561691023948],[112.8704229733763,39.07726946402732],[112.87732195969294,39.08533548033873],[112.90031858074836,39.08892007803614],[112.91066706022332,39.095192682066255],[112.93251385022597,39.11131965236545],[112.95666030233419,39.11938174264095],[112.9681586128619,39.12654726438216],[112.98310641654794,39.13371205128523],[112.99460472707565,39.13371205128523],[113.00380337549782,39.13729416916127],[113.01530168602554,39.142667001493415],[113.02909965865881,39.15251612042143],[113.04174780023929,39.156992533312255],[113.053246110767,39.16057345690945],[113.06474442129473,39.16236384980139],[113.07739256287522,39.166839631048866],[113.08314171813907,39.17400028382233],[113.09119053550847,39.18026525200978],[113.10153901498343,39.18742452649008],[113.1107376634056,39.19279349991622],[113.12798512919717,39.19279349991622],[113.14523259498876,39.19995148787729],[113.15328141235815,39.20353020615916],[113.17052887814974,39.20084618467924],[113.18662651288854,39.19905677958783],[113.2050238097329,39.19995148787729],[113.21767195131338,39.202635543820236],[113.22572076868278,39.20353020615916],[113.23606924815772,39.20621412424874],[113.2533167139493,39.21963216377687],[113.26826451763533,39.22231546148556],[113.28551198342691,39.2232098710767],[113.30390928027126,39.224998655790934],[113.31425775974621,39.224998655790934],[113.32575607027393,39.22231546148556],[113.34185370501272,39.22231546148556],[113.35105235343491,39.22768174669114],[113.36140083290985,39.22947041650973],[113.3717493123848,39.23125904036909],[113.37979812975419,39.23483615020796],[113.38669711607083,39.23573039894232],[113.39934525765132,39.2375188619401],[113.41084356817903,39.2393072789762],[113.42119204765399,39.24288397516115],[113.43499002028724,39.24467225430892],[113.44533849976219,39.245566376646394],[113.46373579660654,39.24914275108521],[113.49478123503138,39.26165861368747],[113.51087886977018,39.2741722238062],[113.52467684240344,39.28132184676881],[113.54192430819502,39.285789987575505],[113.55687211188105,39.286683581254835],[113.57296974661986,39.29204490195094],[113.58561788820035,39.2947254071232],[113.5994158608336,39.29829925309242],[113.60976434030856,39.30365967719357],[113.62126265083627,39.30991298226765],[113.63391079241676,39.31884529807157],[113.64770876505003,39.3242041357217],[113.66380639978883,39.33224161614499],[113.66840572399991,39.33938526135243],[113.69140234505535,39.34295680800298],[113.71324913505802,39.35009934937624],[113.73509592506068,39.353670344090396],[113.75579288401057,39.35634846938454],[113.7707406876966,39.35634846938454],[113.78798815348819,39.364382224291624],[113.80868511243807,39.36795248303071],[113.82363291612411,39.39293914184171],[113.83168173349351,39.39650792842614],[113.83973055086291,39.40186076322938],[113.844329875074,39.41078123433706],[113.844329875074,39.417916782977166],[113.85352852349617,39.42505159536197],[113.86157734086558,39.42772696018357],[113.87077598928775,39.433969075432586],[113.88342413086824,39.43931901123078],[113.89607227244873,39.443776974660096],[113.92021872455693,39.45180058395589]]');
INSERT INTO `t_course` VALUES ('134', 'S86阳城  待建', '#b61e1e', '5', '1', '0', '[[111.13252520155255,35.065593645611116],[111.14919775181774,35.079773814727986],[111.15609673813437,35.082609550173565],[111.15839640023992,35.08402738059633],[111.16472047103017,35.08686296683973],[111.1675950486621,35.08733555487612],[111.1716194573468,35.09017102506807],[111.17449403497872,35.09158872286059],[111.18024319024258,35.09442404383664],[111.18599234550643,35.096786735323995],[111.19231641629668,35.09962187391463],[111.19634082498139,35.10103940590223],[111.20036523366609,35.10292940986193],[111.20438964235079,35.10434688381332],[111.21128862866742,35.10576433289134],[111.21646286840489,35.10765422630271],[111.21933744603682,35.10859915642554],[111.22451168577429,35.10859915642554],[111.23313541867009,35.10859915642554],[111.24118423603949,35.10812669274604],[111.25153271551443,35.10481936960305],[111.25785678630467,35.10292940986193],[111.26303102604214,35.10198441340935],[111.2693550968324,35.10103940590223],[111.27625408314903,35.10056689800328],[111.28775239367674,35.10056689800328],[111.29522629551975,35.09962187391463],[111.29637612657253,35.09962187391463],[111.31304867683772,35.09725926533116],[111.32684664947098,35.09725926533116],[111.34294428420979,35.096786735323995],[111.35329276368473,35.09631420255337],[111.37111514500269,35.09631420255337],[111.37513955368739,35.09962187391463],[111.38433820210957,35.10292940986193],[111.38836261079427,35.10576433289134],[111.3952615971109,35.10812669274604],[111.40101075237476,35.111433880461114],[111.41020940079693,35.11568577994709],[111.41768330263996,35.11710303002274],[111.42975652869406,35.11710303002274],[111.43723043053707,35.11804784958585],[111.44757891001201,35.1189926580923],[111.45390298080227,35.1189926580923],[111.47057553106745,35.123716534770104],[111.49012265896458,35.130801831465064],[111.50334571607145,35.136941918779996],[111.50909487133531,35.140720201809906],[111.51599385765194,35.14402605430283],[111.52806708370605,35.14969291478807],[111.53841556318099,35.152053989136476],[111.54818912712955,35.15394279883987],[111.55968743765727,35.15583156429743],[111.56946100160583,35.15583156429743],[111.57750981897523,35.15677593043369],[111.59648203134597,35.16055328435913],[111.62407797661248,35.168107461209615],[111.63672611819298,35.17235637453552],[111.64994917529985,35.177077126573664],[111.66144748582757,35.178965349938025],[111.67237088082891,35.18038148841628],[111.67754512056638,35.180853529043226],[111.68674376898855,35.180853529043226],[111.69191800872602,35.179909445023085],[111.70226648820096,35.180853529043226],[111.71606446083423,35.18698980545813],[111.72641294030917,35.1926536456415],[111.73216209557303,35.19831708742694],[111.74423532162714,35.20492393260981],[111.75055939241739,35.21105837466162],[111.7580332942604,35.217192349046066],[111.76378244952426,35.2209668700485],[111.76953160478811,35.22568477221744],[111.77470584452558,35.23134588947625],[111.77528076005197,35.230874144927945],[111.80460145189765,35.24927013113031],[111.81494993137261,35.252571529101736],[111.8195492555837,35.25304314630897],[111.82587332637394,35.25398637241743],[111.83392214374334,35.25775916610282],[111.83622180584888,35.260588645077455],[111.84599536979744,35.26624730398226],[111.84944486295575,35.270019521726965],[111.85346927164046,35.271905564138784],[111.86669232874733,35.27662047631711],[111.8758909771695,35.28086366049206],[111.88681437217083,35.28463519142853],[111.89946251375133,35.28793513558943],[111.90693641559434,35.29076355113397],[111.91556014849013,35.294063243238945],[111.92130930375399,35.29642008307138],[111.92878320559701,35.29783415373002],[111.9333825298081,35.30019088275842],[111.93510727638726,35.300662220253564],[111.94373100928304,35.30301886617567],[111.95062999559967,35.306318054113845],[111.95637915086353,35.31150221803052],[111.95982864402184,35.314801056887276],[111.96845237691764,35.32045589335261],[111.97362661665511,35.32422556266187],[111.97880085639258,35.32987973410459],[111.98340018060367,35.33506237404085],[111.98684967376198,35.337418008613895],[111.99489849113138,35.3421290699015],[112.00582188613272,35.346839854031614],[112.01559545008128,35.35249242911821],[112.02824359166176,35.35861560169192],[112.04491614192696,35.36473830577854],[112.06043886113937,35.37133146313449],[112.06503818535046,35.38122018025135],[112.07423683377264,35.388753620155896],[112.08343548219482,35.395815575323084],[112.09493379272253,35.40146469018079],[112.10988159640857,35.41040830523026],[112.11908024483074,35.414644404972094],[112.12942872430568,35.41888028002515],[112.13575279509593,35.42170407189459],[112.14897585220281,35.427821944998044],[112.15472500746667,35.42876311463014],[112.16392365588884,35.43111599015821],[112.17024772667908,35.43205712094825],[112.17887145957486,35.43393934923423],[112.18117112168042,35.43393934923423],[112.18404569931235,35.43440989936937],[112.1897948545762,35.43582153312725],[112.19266943220813,35.43723314191355],[112.21049181352609,35.44570227020482],[112.21566605326356,35.44852511317721],[112.22888911037045,35.45699304267429],[112.23751284326623,35.46498970599181],[112.24728640721479,35.47157459113575],[112.25246064695226,35.47768864019299],[112.26165929537444,35.483802220110796],[112.27200777484938,35.49414720959032],[112.27488235248131,35.49649815615477],[112.28983015616735,35.5077817333816],[112.29960372011591,35.50966217408302],[112.3082274530117,35.514833156906384],[112.31340169274917,35.51765355135762],[112.32490000327688,35.52517411442134],[112.33582339827822,35.53128404835493],[112.34444713117401,35.535983678101445],[112.35364577959618,35.542092781481834],[112.35882001933365,35.54867129084085],[112.36456917459752,35.55336989270956],[112.37376782301969,35.56088707778581]]');
INSERT INTO `t_course` VALUES ('135', 'G3511 拟建', '#711077', '5', '1', '0', '[[110.38664417050765,35.25669808578917],[110.39124349471875,35.25599069112622],[110.3935431568243,35.255047488551696],[110.39498044564026,35.25457588311135],[110.39785502327219,35.25386846975952],[110.39986722761454,35.25363266392456],[110.40389163629924,35.25339685739745],[110.40676621393116,35.25339685739745],[110.4093533337999,35.25363266392456],[110.4130902847214,35.25386846975952],[110.4171146934061,35.25481168617761],[110.42343876419635,35.25669808578917],[110.42947537722341,35.25740547422239],[110.43493707472408,35.2578770630502],[110.44011131446155,35.25929181292073],[110.4458604697254,35.26070653787155],[110.4498848784101,35.26094232294058],[110.45707132248992,35.26282857857242],[110.46282047775378,35.26447901590754],[110.46741980196488,35.26518633581021],[110.47316895722874,35.26636518846938],[110.48093031683494,35.26872284186707],[110.48581709880922,35.27155193456159],[110.48984150749392,35.27320219259467],[110.4947282894682,35.27532390307515],[110.503352022364,35.27697408356644],[110.50852626210147,35.279567155794616],[110.51456287512852,35.281452973885216],[110.52203677697153,35.284753048914084],[110.52606118565623,35.28805298822794],[110.53008559434093,35.29135279182145],[110.53382254526244,35.294416773628555],[110.53957170052631,35.29818766749922],[110.54618322907974,35.302194047980855],[110.55135746881722,35.30502196075595],[110.55969374394981,35.30949928534744],[110.56716764579282,35.31232694047223],[110.57090459671433,35.31491887004982],[110.57377917434627,35.31703947736395]]');

-- ----------------------------
-- Table structure for `t_project`
-- ----------------------------
DROP TABLE IF EXISTS `t_project`;
CREATE TABLE `t_project` (
  `id` int(64) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `course_id` int(64) DEFAULT NULL COMMENT '路线名称',
  `name` varchar(64) DEFAULT NULL COMMENT '项目名称',
  `mileage` double DEFAULT NULL COMMENT '里程',
  `capital` double DEFAULT NULL COMMENT '投资资金',
  `line_style` varchar(64) DEFAULT NULL COMMENT '绘线样式',
  `line_width` int(11) DEFAULT NULL COMMENT '线宽',
  `del_flag` varchar(64) DEFAULT NULL COMMENT '逻辑删除标记（0：显示；1：隐藏）',
  `coordinate` text COMMENT '坐标',
  PRIMARY KEY (`id`),
  KEY `course_id_fk` (`course_id`),
  CONSTRAINT `course_id_fk` FOREIGN KEY (`course_id`) REFERENCES `t_course` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 COMMENT='项目';

-- ----------------------------
-- Records of t_project
-- ----------------------------
INSERT INTO `t_project` VALUES ('35', '67', '太原二环东环', '33.2', null, '#c61414', '5', '0', '[[112.92187791298784,38.04671110328035],[112.91828469094793,38.04011817045279],[112.91785350430314,38.03613938689108],[112.91799723318474,38.031023487729286],[112.90994841581534,38.01806159725598],[112.90807994035457,38.010670010623706],[112.90419926055147,38.00555231801986],[112.90448671831466,37.992927136050724],[112.90233078509071,37.98758067779861],[112.899025020814,37.983485252544575],[112.89571925653728,37.98052730205618],[112.88838908357586,37.97620392737104],[112.88508331929914,37.97222164452961],[112.88149009725923,37.96698745574845],[112.87775314633772,37.96391503924325],[112.87142907554747,37.96152529233128],[112.85878093396698,37.95776981730611],[112.85375042311111,37.95572129475978],[112.849869743308,37.95207933464019],[112.84728262343927,37.94764044955351],[112.8377965172539,37.92669436950139],[112.83305346416121,37.92225393810825],[112.82356735797585,37.91667455128009],[112.8212676958703,37.91394163465928],[112.82026159369913,37.910866981070996],[112.82069278034392,37.90779219789664],[112.82816668218693,37.88922686558903],[112.82859786883172,37.882733579786155],[112.83118498870046,37.87601185124736],[112.83075380205567,37.87134045525007],[112.83104125981886,37.866212969453244],[112.83046634429247,37.86188281233714],[112.82845413995013,37.857780321549804],[112.82629820672618,37.85424743662923],[112.82471718902862,37.84889080155844],[112.82198634027829,37.8443316540606],[112.81436870955368,37.83156452886595],[112.81192531856654,37.8247240808735],[112.81293142073771,37.8187951753541],[112.81508735396166,37.811953533719446],[112.81537481172485,37.80807631963579],[112.81465616731687,37.804084855386165],[112.81666837165922,37.79918075861874],[112.8176744738304,37.79473257293061],[112.8172432871856,37.791082577809],[112.81580599836964,37.78401019480063]]');
INSERT INTO `t_project` VALUES ('36', '67', 'xiaolin测试项目', '2', '122', '#d3e810', '22', '1', '[[112.65562015983024,38.036082611424746],[112.65447032877746,37.98923022487908],[112.69528933115086,37.95782678583674],[112.66999304798989,37.903635406572235],[112.67459237220098,37.87629674882681]]');
INSERT INTO `t_project` VALUES ('42', '69', '小林测试', '11', '1111', 'rgba(139,157,78,0.72)', '8', '0', '[[115.02118195758591,39.28936429332754],[115.65588869871594,38.563627144973026],[115.56390221449419,37.77203121515538],[116.0606292292916,37.22968997452826]]');

-- ----------------------------
-- Table structure for `t_section`
-- ----------------------------
DROP TABLE IF EXISTS `t_section`;
CREATE TABLE `t_section` (
  `id` int(64) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `project_id` int(64) DEFAULT NULL COMMENT '项目名称',
  `name` varchar(64) DEFAULT NULL COMMENT '标段名称',
  `coordinate` longtext COMMENT '坐标',
  `line_style` varchar(64) DEFAULT NULL COMMENT '绘线样式',
  `line_width` int(11) DEFAULT NULL COMMENT '线宽',
  `del_flag` varchar(64) DEFAULT NULL COMMENT '逻辑删除标记（0：显示；1：隐藏）',
  `mileage` double DEFAULT NULL COMMENT '里程',
  PRIMARY KEY (`id`),
  KEY `project_id_fk` (`project_id`),
  CONSTRAINT `project_id_fk` FOREIGN KEY (`project_id`) REFERENCES `t_project` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='标段';

-- ----------------------------
-- Records of t_section
-- ----------------------------
INSERT INTO `t_section` VALUES ('2', '35', '第一分部', null, null, null, '0', null);
INSERT INTO `t_section` VALUES ('3', '35', '第二分部', null, null, null, '0', null);
INSERT INTO `t_section` VALUES ('4', '35', '第三分部', null, null, null, '0', null);

-- ----------------------------
-- Table structure for `t_user`
-- ----------------------------
DROP TABLE IF EXISTS `t_user`;
CREATE TABLE `t_user` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(64) DEFAULT NULL,
  `password` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of t_user
-- ----------------------------
INSERT INTO `t_user` VALUES ('1', '1', '1');

-- ----------------------------
-- Table structure for `t_vcr`
-- ----------------------------
DROP TABLE IF EXISTS `t_vcr`;
CREATE TABLE `t_vcr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) DEFAULT NULL,
  `device_type` varchar(64) DEFAULT NULL,
  `index_code` varchar(64) DEFAULT NULL,
  `del_flag` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `section_fk` (`section_id`),
  CONSTRAINT `section_fk` FOREIGN KEY (`section_id`) REFERENCES `t_section` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of t_vcr
-- ----------------------------
INSERT INTO `t_vcr` VALUES ('2', '2', '东二环', 'c9f967afea88406a904a39eb37034041', '0');
